/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.tsc.aap.client.model;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.springframework.security.core.GrantedAuthority;
import uk.ac.ebi.tsc.aap.client.model.User;

public class Domain
implements Serializable,
GrantedAuthority {
    private static final long serialVersionUID = 1L;
    private String domainName;
    private String domainDesc;
    private String domainReference;
    private Set<User> users = new HashSet<User>();
    private Set<User> managers = new HashSet<User>();

    @Deprecated
    public Domain() {
    }

    public Domain(String domainReference) {
        this(null, null, domainReference);
    }

    public Domain(String domainName, String domainDesc, String domainReference) {
        this.domainName = domainName;
        this.domainDesc = domainDesc;
        this.domainReference = domainReference;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public void setDomainName(String domainName) {
        this.domainName = domainName;
    }

    public String getDomainDesc() {
        return this.domainDesc;
    }

    public void setDomainDesc(String domainDesc) {
        this.domainDesc = domainDesc;
    }

    public String getDomainReference() {
        return this.domainReference;
    }

    public void setDomainReference(String domainReference) {
        this.domainReference = domainReference;
    }

    public Set<User> getUsers() {
        return this.users;
    }

    public Set<User> getManagers() {
        return this.managers;
    }

    public String toString() {
        return "Domain{, domainName='" + this.domainName + '\'' + ", domainDesc='" + this.domainDesc + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Domain domain = (Domain)o;
        if (this.domainName != null ? !this.domainName.equals(domain.domainName) : domain.domainName != null) {
            return false;
        }
        if (this.domainDesc != null ? !this.domainDesc.equals(domain.domainDesc) : domain.domainDesc != null) {
            return false;
        }
        return this.domainReference != null ? this.domainReference.equals(domain.domainReference) : domain.domainReference == null;
    }

    public int hashCode() {
        int result = this.domainName != null ? this.domainName.hashCode() : 0;
        result = 31 * result + (this.domainDesc != null ? this.domainDesc.hashCode() : 0);
        result = 31 * result + (this.domainReference != null ? this.domainReference.hashCode() : 0);
        return result;
    }

    public String getAuthority() {
        return "ROLE_" + this.domainName;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Domain domain = new Domain();

        Builder() {
        }

        public Builder withReference(String reference) {
            this.domain.domainReference = reference;
            return this;
        }

        public Builder withName(String name) {
            this.domain.domainName = name;
            return this;
        }

        public Builder withDescription(String description) {
            this.domain.domainDesc = description;
            return this;
        }

        public Builder withUser(User member) {
            this.domain.users.add(member);
            return this;
        }

        public Builder withUser(String userReference) {
            this.domain.users.add(User.builder().withReference(userReference).build());
            return this;
        }

        public Builder withUsers(Set<User> users) {
            this.domain.users.addAll(users);
            return this;
        }

        public Builder withManager(User manager) {
            this.domain.managers.add(manager);
            return this;
        }

        public Builder withManager(String managerReference) {
            this.domain.managers.add(User.builder().withReference(managerReference).build());
            return this;
        }

        public Builder withManagers(Set<User> managers) {
            this.domain.managers.addAll(managers);
            return this;
        }

        public Domain build() {
            return this.domain;
        }
    }
}

