/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.beam;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import uk.ac.ebi.beam.AbstractFunction;
import uk.ac.ebi.beam.Bond;
import uk.ac.ebi.beam.Edge;
import uk.ac.ebi.beam.Graph;
import uk.ac.ebi.beam.InvalidSmilesException;

final class AddDirectionalLabels
extends AbstractFunction<Graph, Graph> {
    AddDirectionalLabels() {
    }

    public Graph apply(Graph g) throws InvalidSmilesException {
        int u;
        boolean altered;
        ArrayList<Edge> doublebonds = new ArrayList<Edge>();
        for (int u2 = 0; u2 < g.order(); ++u2) {
            int d = g.degree(u2);
            for (int j = 0; j < d; ++j) {
                Edge e = g.edgeAt(u2, j);
                int v = e.other(u2);
                if (v <= u2 || e.bond() != Bond.DOUBLE || g.degree(u2) < 2 || g.degree(v) < 2 || g.degree(u2) + g.degree(v) <= 4) continue;
                doublebonds.add(e);
            }
        }
        if (doublebonds.isEmpty()) {
            return g;
        }
        HashSet remain = new HashSet(doublebonds);
        HashMap<Edge, Edge> replacements = new HashMap<Edge, Edge>();
        HashSet<Edge> completed = new HashSet<Edge>();
        do {
            altered = false;
            for (Edge e : remain) {
                Status status = this.replaceImplWithExpl(g, e, replacements);
                if (status == Status.WAITING) continue;
                completed.add(e);
                altered = true;
            }
            remain.removeAll(completed);
            completed.clear();
        } while (altered && !remain.isEmpty());
        if (remain.size() == doublebonds.size()) {
            return g;
        }
        for (Edge e : remain) {
            int u3 = e.either();
            int v = e.other(u3);
            int d = g.degree(u3);
            for (int j = 0; j < d; ++j) {
                Edge f = g.edgeAt(u3, j);
                if (!this.isDirectional(f, replacements) || !this.safeToClean(g, f.other(u3), replacements)) continue;
                replacements.put(f, new Edge(u3, f.other(u3), Bond.IMPLICIT));
            }
            int d2 = g.degree(v);
            for (int j = 0; j < d2; ++j) {
                Edge f = g.edgeAt(v, j);
                if (!this.isDirectional(f, replacements) || !this.safeToClean(g, f.other(v), replacements)) continue;
                replacements.put(f, new Edge(v, f.other(v), Bond.IMPLICIT));
            }
        }
        Graph h = new Graph(g.order());
        h.addFlags(g.getFlags(-1));
        for (u = 0; u < g.order(); ++u) {
            h.addAtom(g.atom(u));
            h.addTopology(g.topologyOf(u));
        }
        for (u = 0; u < g.order(); ++u) {
            int d = g.degree(u);
            for (int j = 0; j < d; ++j) {
                Edge e = g.edgeAt(u, j);
                if (e.other(u) >= u) continue;
                Edge replacement = (Edge)replacements.get(e);
                if (replacement != null) {
                    e = replacement;
                }
                h.addEdge(e);
            }
        }
        return h.sort((Graph.EdgeComparator)new Graph.CanOrderFirst());
    }

    private boolean isDirectional(Edge f, Map<Edge, Edge> replacements) {
        if (f.bond().directional()) {
            return true;
        }
        Edge g = replacements.get(f);
        return g != null && g.bond().directional();
    }

    boolean safeToClean(Graph g, int v, Map<Edge, Edge> replacements) {
        int d = g.degree(v);
        for (int j = 0; j < d; ++j) {
            Edge e = g.edgeAt(v, j);
            if (e.bond().order() != 2) continue;
            int w = e.other(v);
            int d2 = g.degree(w);
            for (int j2 = 0; j2 < d2; ++j2) {
                Edge f = g.edgeAt(w, j2);
                if (!this.isDirectional(f, replacements)) continue;
                return false;
            }
        }
        return true;
    }

    private Status replaceImplWithExpl(Graph g, Edge e, Map<Edge, Edge> acc) throws InvalidSmilesException {
        Status vstat;
        int u = e.either();
        int v = e.other(u);
        Status ustat = this.replaceImplWithExpl(g, e, u, acc);
        if (ustat == (vstat = this.replaceImplWithExpl(g, e, v, acc))) {
            return ustat;
        }
        if (ustat == Status.INVALID && vstat != Status.WAITING) {
            return Status.INVALID;
        }
        if (vstat == Status.INVALID && ustat != Status.WAITING) {
            return Status.INVALID;
        }
        return Status.WAITING;
    }

    private Status replaceImplWithExpl(Graph g, Edge e, int u, Map<Edge, Edge> acc) throws InvalidSmilesException {
        int v;
        Edge existing;
        Edge implicit = null;
        Edge explicit = null;
        for (Edge f : g.edges(u)) {
            Edge f2 = acc.containsKey(f) ? acc.get(f) : f;
            switch (f2.bond(u)) {
                case SINGLE: 
                case IMPLICIT: 
                case IMPLICIT_AROMATIC: {
                    if (implicit != null) {
                        return Status.WAITING;
                    }
                    implicit = f;
                    break;
                }
                case DOUBLE: 
                case DOUBLE_AROMATIC: {
                    if (f.equals((Object)e)) break;
                    return Status.COMPLETED;
                }
                case UP: 
                case UP_AROMATIC: 
                case DOWN: 
                case DOWN_AROMATIC: {
                    if (explicit != null) {
                        if (acc.containsKey(explicit)) {
                            explicit = acc.get(explicit);
                        }
                        if (f.bond().directional() && explicit.bond(u).inverse() != f.bond(u)) {
                            return Status.INVALID;
                        }
                        if (explicit.bond(u).inverse() != f2.bond(u)) {
                            acc.put(f, f2.inverse());
                            BitSet visited = new BitSet();
                            visited.set(u);
                            this.invertExistingDirectionalLabels(g, visited, acc, f2.other(u));
                        }
                        return Status.COMPLETED;
                    }
                    explicit = f;
                }
            }
        }
        if (implicit == null) {
            return Status.COMPLETED;
        }
        if (explicit == null) {
            return Status.WAITING;
        }
        if (acc.containsKey(explicit)) {
            explicit = acc.get(explicit);
        }
        if ((existing = acc.put(implicit, new Edge(u, v = implicit.other(u), explicit.bond(u).inverse()))) != null && existing.bond(u) != explicit.bond(u).inverse()) {
            throw new InvalidSmilesException("unable to assign explict type for " + implicit);
        }
        return Status.COMPLETED;
    }

    private void invertExistingDirectionalLabels(Graph g, BitSet visited, Map<Edge, Edge> replacement, int u) {
        visited.set(u);
        if (g.topologyOf(u) == null) {
            return;
        }
        for (Edge e : g.edges(u)) {
            int v = e.other(u);
            if (visited.get(v)) continue;
            Edge f = replacement.get(e);
            if (f != null && f.bond().directional()) {
                replacement.put(e, f.inverse());
            } else if (e.bond().directional()) {
                replacement.put(e, e.inverse());
            }
            this.invertExistingDirectionalLabels(g, visited, replacement, v);
        }
    }

    static enum Status {
        COMPLETED,
        WAITING,
        INVALID;

    }
}

