/*
 * Decompiled with CFR 0.152.
 */
package ua.zabelnikov.swipelayout.layout.frame;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.widget.FrameLayout;
import java.util.HashSet;
import java.util.Set;
import ua.zabelnikov.swipelayout.R;
import ua.zabelnikov.swipelayout.layout.SwipeGestureManager;
import ua.zabelnikov.swipelayout.layout.listener.LayoutPositionListener;
import ua.zabelnikov.swipelayout.layout.listener.OnLayoutPercentageChangeListener;
import ua.zabelnikov.swipelayout.layout.listener.OnLayoutSwipedListener;

public class SwipeableLayout
extends FrameLayout {
    private float swipeSpeed;
    private SwipeGestureManager swipeManager;
    private int swipeOrientationMode;
    private final Set<Integer> blocks = new HashSet<Integer>();
    private OnLayoutSwipedListener onLayoutSwipedListener;
    private OnLayoutPercentageChangeListener onLayoutPercentageChangeListener;
    private LayoutPositionListener layoutPositionListener;

    public SwipeableLayout(Context context) {
        super(context);
    }

    public SwipeableLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.inflateAttributes(context, attrs);
    }

    public SwipeableLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.inflateAttributes(context, attrs);
    }

    @TargetApi(value=21)
    public SwipeableLayout(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.inflateAttributes(context, attrs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void inflateAttributes(Context context, AttributeSet attributeSet) {
        this.swipeSpeed = 1.0f;
        this.swipeOrientationMode = 1;
        if (attributeSet != null) {
            TypedArray attributes = context.obtainStyledAttributes(attributeSet, R.styleable.SwipeableLayout);
            try {
                this.swipeSpeed = attributes.getFloat(R.styleable.SwipeableLayout_swipeSpeed, this.swipeSpeed);
                this.swipeOrientationMode = attributes.getInt(R.styleable.SwipeableLayout_swipeOrientation, this.swipeOrientationMode);
            }
            finally {
                attributes.recycle();
            }
        }
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        super.dispatchTouchEvent(ev);
        return this.swipeManager.onTouch((View)this, ev);
    }

    public void initSwipeManager() {
        SwipeGestureManager.Builder builder = new SwipeGestureManager.Builder(this.getContext());
        builder.setSwipeSpeed(this.swipeSpeed);
        builder.setOrientationMode(this.swipeOrientationMode);
        builder.setStartCoordinates(this.getX(), this.getY());
        this.swipeManager = builder.create();
        this.swipeManager.setOnLayoutPercentageChangeListener(this.onLayoutPercentageChangeListener);
        this.swipeManager.setOnSwipedListener(this.onLayoutSwipedListener);
        this.swipeManager.setBlockSet(this.blocks);
        this.swipeManager.setLayoutPositionListener(this.layoutPositionListener);
        this.setOnTouchListener(this.swipeManager);
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        this.initSwipeManager();
    }

    public void addBlock(int orientationMode) {
        if (this.swipeManager != null) {
            this.swipeManager.addBlock(orientationMode);
        } else {
            this.blocks.add(orientationMode);
        }
    }

    public void removeBlock(int orientationMode) {
        if (this.swipeManager != null) {
            this.swipeManager.removeBlock(orientationMode);
        } else {
            this.blocks.remove(orientationMode);
        }
    }

    public void setOnSwipedListener(OnLayoutSwipedListener onLayoutSwipedListener) {
        this.onLayoutSwipedListener = onLayoutSwipedListener;
    }

    public void setOnLayoutPercentageChangeListener(OnLayoutPercentageChangeListener onLayoutPercentageChangeListener) {
        this.onLayoutPercentageChangeListener = onLayoutPercentageChangeListener;
    }

    public void setLayoutPositionListener(LayoutPositionListener layoutPositionListener) {
        this.layoutPositionListener = layoutPositionListener;
    }
}

