/*
 * Decompiled with CFR 0.152.
 */
package ua.zabelnikov.swipelayout.layout;

import android.animation.ObjectAnimator;
import android.view.MotionEvent;
import android.view.View;
import java.util.HashSet;
import java.util.Set;
import ua.zabelnikov.swipelayout.layout.listener.OnLayoutPercentageChangeListener;
import ua.zabelnikov.swipelayout.layout.listener.OnLayoutSwipedListener;

public class SwipeGestureManager
implements View.OnTouchListener {
    private OnLayoutSwipedListener onSwipedListener;
    private OnLayoutPercentageChangeListener onLayoutPercentageChangeListener;
    private final float swipeSpeed;
    private final int orientationMode;
    private final Set<Integer> blocks;
    private int lastYPosition;
    private int lastXPosition;
    private int layoutPosition;

    private SwipeGestureManager(float swipeSpeed, int orientationMode) {
        this.swipeSpeed = swipeSpeed;
        this.orientationMode = orientationMode;
        this.blocks = new HashSet<Integer>();
    }

    public boolean onTouch(View view, MotionEvent event) {
        boolean status;
        switch (this.orientationMode) {
            case 0: {
                status = this.swipeByX(view, event);
                break;
            }
            case 1: {
                status = this.swipeByY(view, event);
                break;
            }
            case 2: {
                status = this.swipeByX(view, event) && this.swipeByY(view, event);
                break;
            }
            default: {
                status = false;
            }
        }
        return status;
    }

    private boolean swipeByY(View view, MotionEvent event) {
        if (!this.blocks.contains(1)) {
            int y = (int)event.getRawY();
            int height = view.getHeight();
            float dif = Math.abs(view.getY()) / (float)(height / 4);
            if (event.getActionMasked() == 0) {
                this.lastYPosition = y;
                this.layoutPosition = (int)view.getY();
            } else if (event.getActionMasked() == 2) {
                int diffY = y - this.lastYPosition;
                view.setY((float)this.layoutPosition + (float)diffY * this.swipeSpeed);
                if (this.onLayoutPercentageChangeListener != null) {
                    this.onLayoutPercentageChangeListener.percentageY(dif > 1.0f ? 1.0f : dif);
                }
            } else if (event.getActionMasked() == 1) {
                if ((double)dif > 1.0) {
                    this.triggerSwipeListener();
                }
                ObjectAnimator animator = ObjectAnimator.ofFloat((Object)view, (String)"y", (float[])new float[]{view.getY(), 0.0f});
                animator.setDuration(300L);
                animator.start();
            }
        }
        return true;
    }

    private boolean swipeByX(View view, MotionEvent event) {
        if (!this.blocks.contains(0)) {
            int x = (int)event.getRawX();
            int width = view.getWidth();
            float dif = Math.abs(view.getX()) / (float)(width / 4);
            if (event.getActionMasked() == 0) {
                this.lastXPosition = x;
                this.layoutPosition = (int)view.getX();
            } else if (event.getActionMasked() == 2) {
                int diffX = x - this.lastXPosition;
                view.setX((float)this.layoutPosition + (float)diffX * this.swipeSpeed);
                if (this.onLayoutPercentageChangeListener != null) {
                    this.onLayoutPercentageChangeListener.percentageX(dif > 1.0f ? 1.0f : dif);
                }
            } else if (event.getActionMasked() == 1) {
                if ((double)dif > 1.0) {
                    this.triggerSwipeListener();
                }
                ObjectAnimator animator = ObjectAnimator.ofFloat((Object)view, (String)"x", (float[])new float[]{view.getX(), 0.0f});
                animator.setDuration(300L);
                animator.start();
            }
        }
        return true;
    }

    public void addBlock(int orientationMode) {
        this.blocks.add(orientationMode);
    }

    public void removeBlock(int orientationMode) {
        this.blocks.remove(orientationMode);
    }

    public void setOnSwipedListener(OnLayoutSwipedListener onSwipedListener) {
        this.onSwipedListener = onSwipedListener;
    }

    public void setOnLayoutPercentageChangeListener(OnLayoutPercentageChangeListener onLayoutPercentageChangeListener) {
        this.onLayoutPercentageChangeListener = onLayoutPercentageChangeListener;
    }

    private void triggerSwipeListener() {
        if (this.onSwipedListener != null) {
            this.onSwipedListener.onLayoutSwiped();
        }
    }

    public abstract class OrientationMode {
        public static final int LEFT_RIGHT = 0;
        public static final int UP_BOTTOM = 1;
        public static final int BOTH = 2;
        public static final int NONE = 3;
    }

    public static class Builder {
        private float mSwipeSpeed;
        private int mOrientationMode;

        public void setSwipeSpeed(float mSwipeSpeed) {
            this.mSwipeSpeed = mSwipeSpeed;
        }

        public void setOrientationMode(int orientationMode) {
            this.mOrientationMode = orientationMode;
        }

        public SwipeGestureManager create() {
            return new SwipeGestureManager(this.mSwipeSpeed, this.mOrientationMode);
        }
    }
}

