/*
 * Decompiled with CFR 0.152.
 */
package ua.pl.mik.perspectivedrawer;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Camera;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.view.InflateException;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.Interpolator;
import android.view.animation.Transformation;
import android.widget.FrameLayout;
import com.nineoldandroids.view.ViewHelper;
import ua.pl.mik.perspectivedrawer.Interpolators;
import ua.pl.mik.perspectivedrawer.PageHolder;
import ua.pl.mik.perspectivedrawer.R;

public class PerspectiveDrawer
extends FrameLayout {
    private static final float MIN_VELOCITY = 140.0f;
    private static final float MINIMUM_SCALE_X = 0.55f;
    private static final float MINIMUM_SCALE_Y = 0.6f;
    private static final boolean HONEY_CAPABLE = Build.VERSION.SDK_INT >= 11;
    private final int mVelocityUnits;
    private final int mTouchSlop;
    private final int mLongPressTimeout;
    private PageHolder mMenuHolder;
    private PageHolder mPageHolder;
    private View mTouchTarget = null;
    private boolean mOpened = false;
    private boolean mAnimating = false;
    private boolean mOpening = false;
    private boolean mTracking = false;
    private MotionEvent mDownEvent;
    private float mCurDegree = 0.0f;
    private int mPageShift;
    private int mMenuShift;
    private boolean mDimmingEnabled = true;
    private static final int CLOSED_ANGLE = 0;
    private int mOpenedAngle = -20;
    private int mAnimationDuration = 300;
    private VelocityTracker mVelocityTracker;
    private int mLeftSwipeArea = 50;
    private Rect mPagePaddings = new Rect();
    private float mRightLimit;
    private float mScaledWidth;
    private float mTranslateDistance;
    private SavedState mSavedState;
    private DrawerListener mListener;

    public PerspectiveDrawer(Context context) {
        this(context, null);
    }

    public PerspectiveDrawer(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public PerspectiveDrawer(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        float density = this.getResources().getDisplayMetrics().density;
        int velocityUnits = 1000;
        this.mVelocityUnits = (int)(1000.0f * density);
        this.mLeftSwipeArea = (int)((float)this.mLeftSwipeArea * density);
        this.mTouchSlop = ViewConfiguration.get((Context)context).getScaledPagingTouchSlop();
        this.mLongPressTimeout = ViewConfiguration.getLongPressTimeout();
        if (!this.isInEditMode()) {
            this.mPageShift = this.getResources().getDimensionPixelSize(R.dimen.animated_drawer_page_shift);
            this.mMenuShift = this.getResources().getDimensionPixelSize(R.dimen.animated_drawer_menu_shift);
            this.mAnimationDuration = this.getResources().getInteger(R.integer.animated_drawer_animation_duration);
            this.mOpenedAngle = -Math.abs(this.getResources().getInteger(R.integer.animated_drawer_angle));
        }
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        if (this.getChildCount() != 2) {
            throw new InflateException("AnimatedDrawer should have 2 childs");
        }
        try {
            this.mMenuHolder = (PageHolder)this.getChildAt(0);
            this.mPageHolder = (PageHolder)this.getChildAt(1);
        }
        catch (ClassCastException e) {
            throw new InflateException("Childs should be PageHolder");
        }
        if (this.mPageHolder.getBackground() != null) {
            this.mPageHolder.getBackground().getPadding(this.mPagePaddings);
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int widthSpec = View.MeasureSpec.makeMeasureSpec((int)(View.MeasureSpec.getSize((int)widthMeasureSpec) + this.mPagePaddings.left + this.mPagePaddings.right), (int)0x40000000);
        int heightSpec = View.MeasureSpec.makeMeasureSpec((int)(View.MeasureSpec.getSize((int)heightMeasureSpec) + this.mPagePaddings.top + this.mPagePaddings.bottom), (int)0x40000000);
        this.mPageHolder.measure(widthSpec, heightSpec);
    }

    private void calculateScaledSizes() {
        Matrix matrix = new Matrix();
        matrix.reset();
        Matrix matrix3d = new Matrix();
        Camera camera = new Camera();
        matrix.preScale(0.55f, 0.6f, (float)(this.mPageHolder.getMeasuredWidth() / 2), (float)(this.mPageHolder.getMeasuredHeight() / 2));
        camera.rotateY((float)this.mOpenedAngle);
        camera.getMatrix(matrix3d);
        matrix3d.preTranslate((float)(-this.mPageHolder.getMeasuredWidth() / 2), (float)(-this.mPageHolder.getMeasuredHeight() / 2));
        matrix3d.postTranslate((float)(this.mPageHolder.getMeasuredWidth() / 2), (float)(this.mPageHolder.getMeasuredHeight() / 2));
        matrix.postConcat(matrix3d);
        float[] pst = new float[]{0.0f, 0.0f};
        matrix.mapPoints(pst);
        float left = pst[0];
        this.mScaledWidth = ((float)(this.mPageHolder.getMeasuredWidth() / 2) - left) * 2.0f;
        this.mTranslateDistance = (float)this.getMeasuredWidth() - ((float)this.getMeasuredWidth() - this.mScaledWidth) / 2.0f - (float)this.mPageShift;
        this.mRightLimit = this.getMeasuredWidth() - this.mPageShift;
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        this.mMenuHolder.layout(0, 0, this.getMeasuredWidth(), this.getMeasuredHeight());
        this.mPageHolder.layout(-this.mPagePaddings.left, -this.mPagePaddings.top, this.getMeasuredWidth() + this.mPagePaddings.right, this.getMeasuredHeight() + this.mPagePaddings.bottom);
        if (this.mSavedState != null) {
            this.mCurDegree = this.mSavedState.currentDegree;
            this.mSavedState = null;
        }
        this.setOpenDegree(this.mCurDegree);
        this.calculateScaledSizes();
    }

    public void toggle() {
        if (this.mOpened) {
            this.close();
        } else {
            this.open();
        }
    }

    public void open() {
        SimpleAnimator a = new SimpleAnimator(this, this.mOpenedAngle);
        a.setDuration(this.mAnimationDuration);
        this.startAnimation(a);
    }

    public void close() {
        SimpleAnimator a = new SimpleAnimator(this, 0.0f);
        a.setDuration(this.mAnimationDuration);
        this.startAnimation(a);
    }

    protected void fling(float velocity) {
        SimpleAnimator a = new SimpleAnimator(this, velocity > 0.0f ? (float)this.mOpenedAngle : 0.0f);
        float rel = velocity > 0.0f ? ((float)this.mOpenedAngle - this.mCurDegree) / (float)this.mOpenedAngle : this.mCurDegree / (float)this.mOpenedAngle;
        int duration = (int)(rel * (float)this.mAnimationDuration);
        a.setDuration(duration);
        a.setInterpolator(Interpolators.Quad.EASE_OUT);
        this.startAnimation(a);
    }

    public float getOpenDegree() {
        return this.mCurDegree;
    }

    @TargetApi(value=11)
    public void setOpenDegree(float degree) {
        if (degree < (float)this.mOpenedAngle) {
            degree = this.mOpenedAngle;
        } else if (degree > 0.0f) {
            degree = 0.0f;
        }
        Interpolator interpolator = HONEY_CAPABLE ? Interpolators.Sine.EASE_IN_OUT : Interpolators.Linear.EASE_NONE;
        float rel = interpolator.getInterpolation(degree / (float)this.mOpenedAngle);
        if (this.mListener != null) {
            this.mListener.onDrawerSlide((View)this, rel);
        }
        float shift = rel * this.mTranslateDistance;
        this.mOpened = degree != 0.0f;
        this.mMenuHolder.setVisibility(this.mOpened ? 0 : 4);
        ViewHelper.setTranslationX((View)this.mPageHolder, (float)shift);
        if (HONEY_CAPABLE) {
            boolean enableAcceleration = this.mCurDegree == 0.0f && degree != 0.0f;
            boolean disableAcceleration = this.mCurDegree != 0.0f && degree == 0.0f;
            float degreeInternal = interpolator.getInterpolation(degree / (float)this.mOpenedAngle) * (float)this.mOpenedAngle;
            if (enableAcceleration) {
                this.post(new Runnable(){

                    @Override
                    public void run() {
                        PerspectiveDrawer.this.mPageHolder.setLayerType(2, null);
                        PerspectiveDrawer.this.mMenuHolder.setLayerType(2, null);
                    }
                });
                if (this.mListener != null) {
                    this.mListener.onDrawerOpened((View)this);
                }
            } else if (disableAcceleration) {
                this.post(new Runnable(){

                    @Override
                    public void run() {
                        PerspectiveDrawer.this.mPageHolder.setLayerType(0, null);
                        PerspectiveDrawer.this.mMenuHolder.setLayerType(0, null);
                    }
                });
                if (this.mListener != null) {
                    this.mListener.onDrawerClosed((View)this);
                }
            }
            this.mPageHolder.setRotationY(degreeInternal);
        }
        float menuShift = (1.0f - rel) * (float)this.mMenuShift;
        ViewHelper.setX((View)this.mMenuHolder, (float)(-menuShift));
        ViewHelper.setAlpha((View)this.mMenuHolder, (float)rel);
        if (this.mDimmingEnabled) {
            int dim = (int)(rel * 160.0f);
            this.mPageHolder.setForegroundColor(this.mOpened ? (dim & 0xFF) << 24 : 0);
        }
        if (HONEY_CAPABLE) {
            float scaleX = 0.55f + 0.45f * (1.0f - rel);
            this.mPageHolder.setScaleX(scaleX);
            float scaleY = 0.6f + 0.39999998f * (1.0f - rel);
            this.mPageHolder.setScaleY(scaleY);
        }
        this.mCurDegree = degree;
    }

    private void dispatchTransformedTouchEvent(View target, MotionEvent event) {
        event.offsetLocation((float)(-target.getLeft()), (float)(-target.getTop()));
        target.dispatchTouchEvent(event);
    }

    public boolean dispatchTouchEvent(MotionEvent event) {
        if (this.mVelocityTracker == null) {
            return true;
        }
        this.mVelocityTracker.addMovement(event);
        switch (event.getAction()) {
            case 0: {
                this.mTouchTarget = this.mOpened ? this.mMenuHolder : this.mPageHolder;
                this.mDownEvent = MotionEvent.obtain((MotionEvent)event);
                this.dispatchTransformedTouchEvent(this.mTouchTarget, event);
                this.mTracking = true;
                break;
            }
            case 2: {
                if (!this.mAnimating) {
                    if (Math.abs(event.getY() - this.mDownEvent.getY()) > (float)(this.mTouchSlop * 3)) {
                        this.mTracking = false;
                    }
                    if (this.mTracking && Math.abs(event.getX() - this.mDownEvent.getX()) > (float)this.mTouchSlop) {
                        if (!this.mOpened && this.mDownEvent.getX() < (float)this.mLeftSwipeArea) {
                            this.mOpening = true;
                        } else if (this.mOpened && this.mDownEvent.getX() > this.mRightLimit) {
                            this.mOpening = false;
                        } else {
                            this.dispatchTransformedTouchEvent(this.mTouchTarget, event);
                            break;
                        }
                        this.mAnimating = true;
                        event.setAction(3);
                    }
                    this.dispatchTransformedTouchEvent(this.mTouchTarget, event);
                    break;
                }
                float pos = this.mOpening ? (event.getX() - this.mDownEvent.getX() - (float)this.mTouchSlop) / this.mRightLimit * (float)this.mOpenedAngle : (this.mRightLimit - this.mDownEvent.getX() + event.getX() + (float)this.mTouchSlop) / this.mRightLimit * (float)this.mOpenedAngle;
                this.setOpenDegree(pos);
                break;
            }
            case 1: 
            case 3: {
                this.mVelocityTracker.computeCurrentVelocity(this.mVelocityUnits);
                float vel = this.mVelocityTracker.getXVelocity();
                if (this.mAnimating) {
                    this.mAnimating = false;
                    if (this.mCurDegree != (float)this.mOpenedAngle && this.mCurDegree != 0.0f) {
                        if (vel > 140.0f) {
                            this.fling(1.0f);
                        } else if (vel < -140.0f) {
                            this.fling(-1.0f);
                        } else if (this.mCurDegree < (float)(this.mOpenedAngle / 2)) {
                            this.fling(1.0f);
                        } else if (this.mCurDegree >= (float)(this.mOpenedAngle / 2)) {
                            this.fling(-1.0f);
                        }
                    }
                } else if (Math.abs(this.mDownEvent.getX() - event.getX()) < (float)this.mTouchSlop && Math.abs(this.mDownEvent.getY() - event.getY()) < (float)this.mTouchSlop && event.getDownTime() - event.getEventTime() < (long)this.mLongPressTimeout && this.mOpened && event.getX() > this.mRightLimit) {
                    this.close();
                } else {
                    this.dispatchTransformedTouchEvent(this.mTouchTarget, event);
                }
                this.mTouchTarget = null;
                this.mDownEvent.recycle();
                this.mDownEvent = null;
                break;
            }
            default: {
                if (this.mTouchTarget == null) break;
                this.dispatchTransformedTouchEvent(this.mTouchTarget, event);
            }
        }
        return true;
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.mVelocityTracker = VelocityTracker.obtain();
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.mVelocityTracker != null) {
            this.mVelocityTracker.recycle();
            this.mVelocityTracker = null;
        }
    }

    public void setDimmingEnabled(boolean enabled) {
        this.mDimmingEnabled = enabled;
        if (enabled) {
            this.setOpenDegree(this.mCurDegree);
        } else {
            this.mPageHolder.setForegroundColor(0);
        }
    }

    public boolean isDimmingEnabled() {
        return this.mDimmingEnabled;
    }

    public void setPage(int resId) {
        this.setPage(PerspectiveDrawer.inflate((Context)this.getContext(), (int)resId, null));
    }

    public void setMenu(int resId) {
        this.setMenu(PerspectiveDrawer.inflate((Context)this.getContext(), (int)resId, null));
    }

    public void setPage(View page) {
        this.setViewInHolder(page, this.mPageHolder);
    }

    public void setMenu(View menu) {
        this.setViewInHolder(menu, this.mMenuHolder);
    }

    private void setViewInHolder(View view, PageHolder holder) {
        holder.removeAllViews();
        FrameLayout.LayoutParams lp = new FrameLayout.LayoutParams(-1, -1);
        holder.addView(view, (ViewGroup.LayoutParams)lp);
    }

    public PageHolder getMenuHolder() {
        return this.mMenuHolder;
    }

    public PageHolder getPageHolder() {
        return this.mPageHolder;
    }

    public int getAnimationDuration() {
        return this.mAnimationDuration;
    }

    public void setAnimationDuration(int animationDuration) {
        this.mAnimationDuration = animationDuration;
    }

    public int getOpenedAngle() {
        return this.mOpenedAngle;
    }

    public void setOpenedAngle(int openedAngle) {
        this.mOpenedAngle = openedAngle;
    }

    public void setListener(DrawerListener listener) {
        this.mListener = listener;
    }

    public boolean isOpened() {
        return this.mOpened;
    }

    public int getMenuShift() {
        return this.mMenuShift;
    }

    public void setMenuShift(int menuShift) {
        this.mMenuShift = menuShift;
    }

    protected Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        SavedState ss = new SavedState(superState);
        ss.currentDegree = this.mCurDegree;
        return ss;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        if (state instanceof SavedState) {
            SavedState ss = (SavedState)state;
            super.onRestoreInstanceState(ss.getSuperState());
            this.mSavedState = ss;
            this.requestLayout();
        } else {
            super.onRestoreInstanceState(state);
        }
    }

    public static interface DrawerListener {
        public void onDrawerSlide(View var1, float var2);

        public void onDrawerOpened(View var1);

        public void onDrawerClosed(View var1);
    }

    private static class SavedState
    extends View.BaseSavedState {
        public float currentDegree;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        public SavedState(Parcel source) {
            super(source);
            this.currentDegree = source.readFloat();
        }

        public void writeToParcel(Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            dest.writeFloat(this.currentDegree);
        }

        public SavedState(Parcelable superState) {
            super(superState);
        }
    }

    private static class SimpleAnimator
    extends Animation {
        private PerspectiveDrawer drawer;
        private float to;
        private float diff;

        SimpleAnimator(PerspectiveDrawer drawer, float to) {
            this.drawer = drawer;
            this.to = to;
        }

        public void initialize(int width, int height, int parentWidth, int parentHeight) {
            super.initialize(width, height, parentWidth, parentHeight);
            this.diff = this.to - this.drawer.getOpenDegree();
        }

        protected void applyTransformation(float interpolatedTime, Transformation t) {
            float curr = this.to - this.diff * (1.0f - interpolatedTime);
            this.drawer.setOpenDegree(curr);
        }
    }
}

