/*
 * Decompiled with CFR 0.152.
 */
package ua.eshcherbinock.reachability;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import ua.eshcherbinock.reachability.abstraction.ReachabilityNotifierType;
import ua.eshcherbinock.reachability.abstraction.ReachabilityObserverType;
import ua.eshcherbinock.reachability.receiver.ReachabilityChangeListener;
import ua.eshcherbinock.reachability.receiver.ReachabilityReceiver;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 \u00182\u00020\u00012\u00020\u0002:\u0002\u0018\u0019B\u000f\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\bH\u0016J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0003\u001a\u00020\u0004H\u0002J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0018\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0015\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\bH\u0016J\b\u0010\u0016\u001a\u00020\fH\u0016J\b\u0010\u0017\u001a\u00020\fH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lua/eshcherbinock/reachability/Reachability;", "Lua/eshcherbinock/reachability/abstraction/ReachabilityNotifierType;", "Lua/eshcherbinock/reachability/receiver/ReachabilityChangeListener;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "mObservers", "", "Lua/eshcherbinock/reachability/abstraction/ReachabilityObserverType;", "mReachabilityStatusReceiver", "Landroid/content/BroadcastReceiver;", "addListener", "", "observer", "getNetworkInformation", "Landroid/net/NetworkInfo;", "isReachable", "", "intent", "Landroid/content/Intent;", "onReachabilityStatusChange", "removeListener", "startNotifier", "stopNotifier", "Companion", "State", "reachability_release"})
public final class Reachability
implements ReachabilityNotifierType,
ReachabilityChangeListener {
    private final BroadcastReceiver mReachabilityStatusReceiver;
    private List<ReachabilityObserverType> mObservers;
    private final Context context;
    private static Reachability sInstance;
    public static final Companion Companion;

    @Override
    public void onReachabilityStatusChange(@NotNull Context context, @NotNull Intent intent) {
        State state;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)intent, (String)"intent");
        boolean bl = this.isReachable(context, intent);
        State newState = state = bl ? State.REACHABLE : State.NOT_REACHABLE;
        Iterable $receiver$iv = this.mObservers;
        for (Object element$iv : $receiver$iv) {
            ReachabilityObserverType it = (ReachabilityObserverType)element$iv;
            it.onReachabilityChange(newState);
        }
    }

    @Override
    public void startNotifier() {
        this.context.registerReceiver(this.mReachabilityStatusReceiver, ReachabilityReceiver.Companion.getREACHABILITY_CHANGED());
    }

    @Override
    public void stopNotifier() {
        this.context.unregisterReceiver(this.mReachabilityStatusReceiver);
    }

    @Override
    public void addListener(@NotNull ReachabilityObserverType observer) {
        Intrinsics.checkParameterIsNotNull((Object)observer, (String)"observer");
        this.mObservers.add(observer);
    }

    @Override
    public void removeListener(@NotNull ReachabilityObserverType observer) {
        Intrinsics.checkParameterIsNotNull((Object)observer, (String)"observer");
        this.mObservers.remove(observer);
    }

    private final boolean isReachable(Context context, Intent intent) {
        NetworkInfo activeNetworkInformation;
        NetworkInfo networkInfo = activeNetworkInformation = this.getNetworkInformation(context);
        return networkInfo != null ? networkInfo.isConnected() : false;
    }

    private final NetworkInfo getNetworkInformation(Context context) {
        Object object = context.getSystemService("connectivity");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.net.ConnectivityManager");
        }
        ConnectivityManager connectivityManager = (ConnectivityManager)object;
        return connectivityManager.getActiveNetworkInfo();
    }

    private Reachability(Context context) {
        List list;
        this.context = context;
        this.mReachabilityStatusReceiver = new ReachabilityReceiver(this);
        Reachability reachability = this;
        reachability.mObservers = list = (List)new ArrayList();
    }

    static {
        Companion = new Companion(null);
    }

    public /* synthetic */ Reachability(@NotNull Context context, DefaultConstructorMarker $constructor_marker) {
        this(context);
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lua/eshcherbinock/reachability/Reachability$State;", "", "(Ljava/lang/String;I)V", "REACHABLE", "NOT_REACHABLE", "reachability_release"})
    public static final class State
    extends Enum<State> {
        public static final /* enum */ State REACHABLE;
        public static final /* enum */ State NOT_REACHABLE;
        private static final /* synthetic */ State[] $VALUES;

        static {
            State[] stateArray = new State[2];
            State[] stateArray2 = stateArray;
            stateArray[0] = REACHABLE = new State();
            stateArray[1] = NOT_REACHABLE = new State();
            $VALUES = stateArray;
        }

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String string) {
            return Enum.valueOf(State.class, string);
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bR\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lua/eshcherbinock/reachability/Reachability$Companion;", "", "()V", "sInstance", "Lua/eshcherbinock/reachability/Reachability;", "getInstance", "Lua/eshcherbinock/reachability/abstraction/ReachabilityNotifierType;", "context", "Landroid/content/Context;", "reachability_release"})
    public static final class Companion {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final ReachabilityNotifierType getInstance(@NotNull Context context) {
            ReachabilityNotifierType reachabilityNotifierType;
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Reachability reachability = sInstance;
            if (reachability != null) {
                reachabilityNotifierType = reachability;
            } else {
                Reachability reachability2;
                Companion companion = this;
                synchronized (companion) {
                    Reachability reachability3 = sInstance;
                    if (reachability3 == null) {
                        Reachability reachability4;
                        Reachability it = reachability4 = new Reachability(context, null);
                        sInstance = it;
                        reachability3 = reachability4;
                    }
                    reachability2 = reachability3;
                }
                reachabilityNotifierType = reachability2;
            }
            return reachabilityNotifierType;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

