/*
 * Decompiled with CFR 0.152.
 */
package viewmodel;

import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.StringsKt;
import logging.Logger;
import org.jetbrains.annotations.NotNull;
import viewmodel.ViewModelConfig;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0004J\b\u0010\u0012\u001a\u00020\u000fH\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0005\u001a\u00060\u0006j\u0002`\u00078DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000b8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0013"}, d2={"Lviewmodel/BaseViewModel;", "", "config", "Lviewmodel/ViewModelConfig;", "(Lviewmodel/ViewModelConfig;)V", "executor", "Ljava/util/concurrent/Executor;", "Lkoncurrent/Executor;", "getExecutor", "()Ljava/util/concurrent/Executor;", "logger", "Llogging/Logger;", "getLogger", "()Llogging/Logger;", "log", "", "msg", "", "onCleared", "viewmodel-core"})
public abstract class BaseViewModel {
    @NotNull
    private final ViewModelConfig config;

    public BaseViewModel(@NotNull ViewModelConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.config = config;
    }

    @NotNull
    protected final Logger getLogger() {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"source", (Object)Reflection.getOrCreateKotlinClass(this.getClass()).getSimpleName())};
        return this.config.getLogger().with(pairArray);
    }

    @NotNull
    protected final Executor getExecutor() {
        return this.config.getExecutor();
    }

    protected final void log(@NotNull String msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        if (StringsKt.contains((CharSequence)msg, (CharSequence)"error", (boolean)true)) {
            this.getLogger().error(msg, new Pair[0]);
        } else if (StringsKt.contains((CharSequence)msg, (CharSequence)"fail", (boolean)true)) {
            this.getLogger().failure(msg, new Pair[0]);
        } else {
            this.getLogger().info(msg, new Pair[0]);
        }
    }

    protected void onCleared() {
    }
}

