/*
 * Decompiled with CFR 0.152.
 */
package viewmodel;

import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.StringsKt;
import live.Live;
import live.LiveBuilders;
import live.MutableLive;
import live.WatchMode;
import logging.Logger;
import org.jetbrains.annotations.NotNull;
import viewmodel.PlatformViewModel;
import viewmodel.ViewModelConfig;
import viewmodel.ViewModelCoreUtilsKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b&\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u000f\b\u0017\u0012\u0006\u0010\u0003\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0004B\u0013\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0004J\b\u0010\u0019\u001a\u00020\u0016H\u0014R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\b\u001a\u00060\tj\u0002`\n8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000e8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001a"}, d2={"Lviewmodel/ViewModel;", "S", "Lviewmodel/PlatformViewModel;", "initial", "(Ljava/lang/Object;)V", "config", "Lviewmodel/ViewModelConfig;", "(Lviewmodel/ViewModelConfig;)V", "executor", "Ljava/util/concurrent/Executor;", "Lkoncurrent/Executor;", "getExecutor", "()Ljava/util/concurrent/Executor;", "logger", "Llogging/Logger;", "getLogger", "()Llogging/Logger;", "ui", "Llive/MutableLive;", "getUi", "()Llive/MutableLive;", "log", "", "msg", "", "onCleared", "viewmodel-core"})
public abstract class ViewModel<S>
extends PlatformViewModel {
    @NotNull
    private final ViewModelConfig<S> config;
    @NotNull
    private final MutableLive<S> ui;

    /*
     * WARNING - void declaration
     */
    public ViewModel(@NotNull ViewModelConfig<? extends S> config) {
        void mode$iv;
        void $this$watch$iv;
        Intrinsics.checkNotNullParameter(config, (String)"config");
        this.config = config;
        this.ui = LiveBuilders.mutableLiveOf(this.config.getInitial());
        Live live = (Live)this.ui;
        WatchMode watchMode = WatchMode.Eagerly;
        Function1 callback$iv = new Function1<S, Unit>(){

            public final void invoke(S it) {
                Object s = it;
                this.log("State at " + (s != null ? ViewModelCoreUtilsKt.getToDetailedString(s) : null));
            }
        };
        boolean $i$f$watch = false;
        $this$watch$iv.watch(callback$iv, (WatchMode)mode$iv);
    }

    public ViewModel(S initial) {
        this(ViewModelConfig.Companion.create$default(ViewModelConfig.Companion, initial, null, null, 6, null));
    }

    @NotNull
    protected final Logger getLogger() {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"source", (Object)Reflection.getOrCreateKotlinClass(this.getClass()).getSimpleName())};
        return this.config.getLogger().with(pairArray);
    }

    @NotNull
    protected final Executor getExecutor() {
        return this.config.getExecutor();
    }

    @NotNull
    public final MutableLive<S> getUi() {
        return this.ui;
    }

    @Override
    protected void onCleared() {
        this.ui.stopAll();
    }

    protected final void log(@NotNull String msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        if (StringsKt.contains((CharSequence)msg, (CharSequence)"error", (boolean)true)) {
            this.getLogger().error(msg, new Pair[0]);
        } else if (StringsKt.contains((CharSequence)msg, (CharSequence)"fail", (boolean)true)) {
            this.getLogger().failure(msg, new Pair[0]);
        } else {
            this.getLogger().info(msg, new Pair[0]);
        }
    }
}

