/*
 * Decompiled with CFR 0.152.
 */
package viewmodel;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.SupervisorKt;
import kotlinx.coroutines.universal.Dispatchers;
import live.Live;
import logging.Logger;
import org.jetbrains.annotations.NotNull;
import viewmodel.PlatformViewModel;
import viewmodel.ViewModelCoreUtilsKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0004\b'\u0018\u0000*\u0006\b\u0000\u0010\u0001 \u0000*\u0004\b\u0001\u0010\u00022\u00020\u0003B\u0019\b\u0007\u0012\u0006\u0010\u0004\u001a\u00028\u0001\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u0013\u001a\u00020\u0014H\u0014J\u0015\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0017J\u0019\u0010\u0018\u001a\u00020\u0019*\u00020\u00062\u0006\u0010\u0016\u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010\u001aJ\u0019\u0010\u001b\u001a\u00020\u0014*\u00020\u00062\u0006\u0010\u0016\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001cR\u0014\u0010\b\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00010\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001d"}, d2={"Lviewmodel/ViewModel;", "I", "S", "Lviewmodel/PlatformViewModel;", "initialState", "scope", "Lkotlinx/coroutines/CoroutineScope;", "(Ljava/lang/Object;Lkotlinx/coroutines/CoroutineScope;)V", "coroutineScope", "getCoroutineScope", "()Lkotlinx/coroutines/CoroutineScope;", "logger", "Llogging/Logger;", "getLogger$viewmodel_core", "()Llogging/Logger;", "ui", "Llive/Live;", "getUi", "()Llive/Live;", "onCleared", "", "post", "i", "(Ljava/lang/Object;)V", "execute", "", "(Lkotlinx/coroutines/CoroutineScope;Ljava/lang/Object;)Ljava/lang/Object;", "start", "(Lkotlinx/coroutines/CoroutineScope;Ljava/lang/Object;)V", "viewmodel-core"})
public abstract class ViewModel<I, S>
extends PlatformViewModel {
    @NotNull
    private final Logger logger;
    @NotNull
    private final Live<S> ui;
    @NotNull
    private final CoroutineScope coroutineScope;

    @JvmOverloads
    public ViewModel(S initialState, @NotNull CoroutineScope scope) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        ViewModel viewModel = this;
        String string = Reflection.getOrCreateKotlinClass(this.getClass()).getSimpleName();
        String source$iv = string == null ? "Anonymous ViewModel" : string;
        boolean $i$f$logger = false;
        this.logger = Logger.Companion.of(source$iv);
        this.ui = new Live(initialState);
        this.coroutineScope = scope;
        this.ui.watch(new Function1<S, Unit>(){

            public final void invoke(S it) {
                Object s = it;
                ViewModelCoreUtilsKt.log(this, Intrinsics.stringPlus((String)"State at ", (Object)(s == null ? null : ViewModelCoreUtilsKt.getToDetailedString(s))));
            }
        });
    }

    public /* synthetic */ ViewModel(Object object, CoroutineScope coroutineScope, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            coroutineScope = CoroutineScopeKt.CoroutineScope((CoroutineContext)SupervisorKt.SupervisorJob$default(null, (int)1, null).plus((CoroutineContext)Dispatchers.INSTANCE.getMain()));
        }
        this(object, coroutineScope);
    }

    @NotNull
    public final Logger getLogger$viewmodel_core() {
        return this.logger;
    }

    @NotNull
    public final Live<S> getUi() {
        return this.ui;
    }

    @NotNull
    public CoroutineScope getCoroutineScope() {
        return this.coroutineScope;
    }

    public void post(I i) {
        ViewModelCoreUtilsKt.log(this, i);
        this.execute(this.getCoroutineScope(), i);
    }

    public void start(@NotNull CoroutineScope $this$start, I i) {
        Intrinsics.checkNotNullParameter((Object)$this$start, (String)"<this>");
        ViewModelCoreUtilsKt.log(this, i);
        this.execute($this$start, i);
    }

    @NotNull
    public abstract Object execute(@NotNull CoroutineScope var1, I var2);

    @Override
    protected void onCleared() {
        this.ui.stopAll();
        CoroutineScopeKt.cancel$default((CoroutineScope)this.getCoroutineScope(), null, (int)1, null);
    }

    @JvmOverloads
    public ViewModel(S initialState) {
        this(initialState, null, 2, null);
    }
}

