/*
 * Decompiled with CFR 0.152.
 */
package identifier;

import identifier.Email;
import identifier.Name;
import identifier.NameGenerator;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0005J\u0006\u0010\f\u001a\u00020\tJ\u001b\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007\u00a2\u0006\u0002\u0010\u0010R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lidentifier/EmailGenerator;", "", "()V", "domains", "", "", "getDomains", "()Ljava/util/List;", "generateFor", "Lidentifier/Email;", "name", "Lidentifier/Name;", "random", "", "size", "", "(I)[Lidentifier/Email;", "identifier-generators"})
public final class EmailGenerator {
    @NotNull
    public static final EmailGenerator INSTANCE = new EmailGenerator();
    @NotNull
    private static final List<String> domains;

    private EmailGenerator() {
    }

    @NotNull
    public final List<String> getDomains() {
        return domains;
    }

    @NotNull
    public final Email generateFor(@NotNull Name name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Pair pair = RangesKt.random((IntRange)new IntRange(1, 10), (Random)((Random)Random.Default)) > 5 ? TuplesKt.to((Object)name.getFirst(), (Object)name.getLast()) : TuplesKt.to((Object)name.getLast(), (Object)name.getFirst());
        String first = (String)pair.component1();
        String last = (String)pair.component2();
        String string = (first + (RangesKt.random((IntRange)new IntRange(1, 10), (Random)((Random)Random.Default)) > 5 ? "." : "") + last).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        String identity = StringsKt.replace$default((String)string, (String)"'", (String)"", (boolean)false, (int)4, null);
        return new Email(identity + '@' + (String)CollectionsKt.random((Collection)domains, (Random)((Random)Random.Default)));
    }

    @NotNull
    public final Email generateFor(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.generateFor(new Name(name));
    }

    @NotNull
    public final Email random() {
        return this.generateFor(NameGenerator.INSTANCE.random());
    }

    @NotNull
    public final Email[] random(int size) {
        int n = 0;
        Email[] emailArray = new Email[size];
        while (n < size) {
            int n2 = n++;
            emailArray[n2] = INSTANCE.random();
        }
        return emailArray;
    }

    static {
        Object[] objectArray = new String[]{"google.com", "yahoo.com", "mail.com", "test.com", "adobe.com", "asoft.co.tz", "bing.net", "microsoft.com"};
        domains = CollectionsKt.listOf((Object[])objectArray);
    }
}

