/*
 * Decompiled with CFR 0.152.
 */
package identifier.internal;

import identifier.Email;
import identifier.InvalidEmailException;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.PublishedApi;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0001\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0096\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0003H\u0016R\u0014\u0010\u0005\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u001c\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\u000bX\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\u000e\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0007\u00a8\u0006\u0018"}, d2={"Lidentifier/internal/EmailImpl;", "Lidentifier/Email;", "value", "", "(Ljava/lang/String;)V", "domain", "getDomain", "()Ljava/lang/String;", "identity", "getIdentity", "parts", "", "getParts", "()[Ljava/lang/String;", "[Ljava/lang/String;", "getValue", "equals", "", "other", "", "hashCode", "", "toString", "Companion", "identifier-core"})
@PublishedApi
public final class EmailImpl
implements Email {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String value;
    @NotNull
    private final String[] parts;
    @NotNull
    private final String identity;
    @NotNull
    private final String domain;

    private EmailImpl(String value2) {
        this.value = value2;
        String[] stringArray = new String[]{"@"};
        Collection $this$toTypedArray$iv = StringsKt.split$default((CharSequence)this.getValue(), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray2 = thisCollection$iv.toArray(new String[0]);
        Intrinsics.checkNotNull((Object)stringArray2, (String)"null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        this.parts = stringArray2;
        this.identity = (String)ArraysKt.first((Object[])this.getParts());
        this.domain = (String)ArraysKt.last((Object[])this.getParts());
    }

    @Override
    @NotNull
    public String getValue() {
        return this.value;
    }

    @Override
    @NotNull
    public String[] getParts() {
        return this.parts;
    }

    @Override
    @NotNull
    public String getIdentity() {
        return this.identity;
    }

    @Override
    @NotNull
    public String getDomain() {
        return this.domain;
    }

    public boolean equals(@Nullable Object other) {
        Object object = other;
        return object instanceof String ? Intrinsics.areEqual((Object)this.getValue(), (Object)other) : (object instanceof Email ? Intrinsics.areEqual((Object)this.getValue(), (Object)((Email)other).getValue()) : false);
    }

    public int hashCode() {
        return this.getValue().hashCode();
    }

    @NotNull
    public String toString() {
        return this.getValue();
    }

    public /* synthetic */ EmailImpl(String value2, DefaultConstructorMarker $constructor_marker) {
        this(value2);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0011\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0086\u0002\u00a8\u0006\u0007"}, d2={"Lidentifier/internal/EmailImpl$Companion;", "", "()V", "invoke", "Lidentifier/internal/EmailImpl;", "value", "", "identifier-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final EmailImpl invoke(@NotNull String value2) {
            IllegalArgumentException cause;
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            String[] stringArray = new String[]{"@"};
            List parts = StringsKt.split$default((CharSequence)value2, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            if (parts.size() != 2) {
                IllegalArgumentException cause2 = new IllegalArgumentException("An email must have exactly two parts, the identifier and the domain");
                throw new InvalidEmailException(value2, cause2);
            }
            String domainPart = (String)CollectionsKt.getOrNull((List)parts, (int)1);
            if (domainPart == null) {
                IllegalArgumentException cause3 = new IllegalArgumentException("an Email must have a domain part");
                throw new InvalidEmailException(value2, cause3);
            }
            if (!StringsKt.contains$default((CharSequence)domainPart, (CharSequence)".", (boolean)false, (int)2, null)) {
                IllegalArgumentException cause4 = new IllegalArgumentException("an email domain must have a top level domain");
                throw new InvalidEmailException(value2, cause4);
            }
            String[] stringArray2 = new String[]{"."};
            String topLevelDomain = (String)CollectionsKt.getOrNull((List)StringsKt.split$default((CharSequence)domainPart, (String[])stringArray2, (boolean)false, (int)0, (int)6, null), (int)1);
            if (topLevelDomain == null) {
                cause = new IllegalArgumentException("an email's top level domain must exist");
                throw new IllegalArgumentException(value2, cause);
            }
            if (topLevelDomain.length() < 2) {
                cause = new IllegalArgumentException("invalid top level domain: " + topLevelDomain);
                throw new IllegalArgumentException(value2, cause);
            }
            return new EmailImpl(value2, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

