/*
 * Decompiled with CFR 0.152.
 */
package docker;

import docker.DockerComposeFileTask;
import java.io.File;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.TaskAction;
import org.gradle.process.ExecSpec;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0014\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u001a\u001a\u00020\u001bH\u0007J\b\u0010\u001c\u001a\u00020\u001bH\u0002J\u0010\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u0006H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0005\u001a\u00020\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001e\u0010\u000b\u001a\u00020\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\b\"\u0004\b\r\u0010\nR \u0010\u000e\u001a\u0004\u0018\u00010\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\b\"\u0004\b\u0010\u0010\nR\u001e\u0010\u0011\u001a\u00020\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\b\"\u0004\b\u0013\u0010\nR\u001e\u0010\u0014\u001a\u00020\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\b\"\u0004\b\u0016\u0010\nR\u001e\u0010\u0017\u001a\u00020\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\b\"\u0004\b\u0019\u0010\n\u00a8\u0006\u001f"}, d2={"Ldocker/DockerStackDeployTask;", "Lorg/gradle/api/DefaultTask;", "composeFileTask", "Ldocker/DockerComposeFileTask;", "(Ldocker/DockerComposeFileTask;)V", "destinationDir", "", "getDestinationDir", "()Ljava/lang/String;", "setDestinationDir", "(Ljava/lang/String;)V", "password", "getPassword", "setPassword", "remote", "getRemote", "setRemote", "stack", "getStack", "setStack", "username", "getUsername", "setUsername", "version", "getVersion", "setVersion", "execute", "", "executeLocally", "executeRemotely", "remoteAddress", "foundation-plugins"})
public class DockerStackDeployTask
extends DefaultTask {
    @Input
    @NotNull
    private String version;
    @Input
    @NotNull
    private String stack;
    @Input
    @Nullable
    private String remote;
    @Input
    @NotNull
    private String username;
    @Input
    @NotNull
    private String password;
    @Input
    @NotNull
    private String destinationDir;
    private final DockerComposeFileTask composeFileTask;

    @NotNull
    public final String getVersion() {
        return this.version;
    }

    public final void setVersion(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.version = string;
    }

    @NotNull
    public final String getStack() {
        return this.stack;
    }

    public final void setStack(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.stack = string;
    }

    @Nullable
    public final String getRemote() {
        return this.remote;
    }

    public final void setRemote(@Nullable String string) {
        this.remote = string;
    }

    @NotNull
    public final String getUsername() {
        return this.username;
    }

    public final void setUsername(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.username = string;
    }

    @NotNull
    public final String getPassword() {
        return this.password;
    }

    public final void setPassword(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.password = string;
    }

    @NotNull
    public final String getDestinationDir() {
        return this.destinationDir;
    }

    public final void setDestinationDir(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.destinationDir = string;
    }

    private final void executeRemotely(String remoteAddress) {
        this.getProject().exec(new Action(this, remoteAddress){
            final /* synthetic */ DockerStackDeployTask this$0;
            final /* synthetic */ String $remoteAddress;

            public final void execute(@NotNull ExecSpec $this$exec) {
                Intrinsics.checkNotNullParameter((Object)$this$exec, (String)"$receiver");
                $this$exec.workingDir((Object)DockerStackDeployTask.access$getComposeFileTask$p(this.this$0).getOutputDir());
                $this$exec.commandLine(new Object[]{"scp", new File(DockerStackDeployTask.access$getComposeFileTask$p(this.this$0).getOutputDir(), DockerStackDeployTask.access$getComposeFileTask$p(this.this$0).getOutputFilename()).getAbsolutePath(), this.this$0.getUsername() + '@' + this.$remoteAddress + ':' + this.this$0.getDestinationDir() + '/' + this.this$0.getVersion() + "/docker-compose.yml"});
            }
            {
                this.this$0 = dockerStackDeployTask;
                this.$remoteAddress = string;
            }
        });
    }

    private final void executeLocally() {
        this.getProject().exec(new Action(this){
            final /* synthetic */ DockerStackDeployTask this$0;

            public final void execute(@NotNull ExecSpec $this$exec) {
                Intrinsics.checkNotNullParameter((Object)$this$exec, (String)"$receiver");
                $this$exec.workingDir((Object)DockerStackDeployTask.access$getComposeFileTask$p(this.this$0).getOutputDir());
                $this$exec.commandLine(new Object[]{"docker", "stack", "deploy", "-c", DockerStackDeployTask.access$getComposeFileTask$p(this.this$0).getOutputFilename(), this.this$0.getStack()});
            }
            {
                this.this$0 = dockerStackDeployTask;
            }
        });
    }

    @TaskAction
    public final void execute() {
        String remoteAddress = this.remote;
        if (remoteAddress == null) {
            this.executeLocally();
        } else {
            this.executeRemotely(remoteAddress);
        }
    }

    @Inject
    public DockerStackDeployTask(@NotNull DockerComposeFileTask composeFileTask) {
        Intrinsics.checkNotNullParameter((Object)((Object)composeFileTask), (String)"composeFileTask");
        this.composeFileTask = composeFileTask;
        this.setGroup("docker");
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        this.version = project.getVersion().toString();
        StringBuilder stringBuilder = new StringBuilder();
        Project project2 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
        this.stack = stringBuilder.append(project2.getName()).append('-').append(this.version).toString();
        this.username = "";
        this.password = "";
        this.destinationDir = "";
    }

    public static final /* synthetic */ DockerComposeFileTask access$getComposeFileTask$p(DockerStackDeployTask $this) {
        return $this.composeFileTask;
    }
}

