/*
 * Decompiled with CFR 0.152.
 */
package docker;

import docker.DockerService;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010!\u001a\u00020\"H\u0007J$\u0010#\u001a\u00020\u00102\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00170%2\u0006\u0010&\u001a\u00020\u0004H\u0002J'\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u00102\u0017\u0010*\u001a\u0013\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u00020\"0+\u00a2\u0006\u0002\b,J\u000e\u0010\u001c\u001a\u00020\"2\u0006\u0010\u001a\u001a\u00020\u001bJ.\u0010-\u001a\u00020\"*\u00020.2\u0006\u0010/\u001a\u0002002\u0012\u00101\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00170%2\u0006\u0010&\u001a\u00020\u0004R\u001c\u0010\u0003\u001a\u00020\u00048GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001e\u0010\t\u001a\u00020\n8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001e\u0010\u000f\u001a\u00020\u00108\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\"\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00170\u00168\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R$\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001a\u001a\u00020\u001b8G@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 \u00a8\u00062"}, d2={"Ldocker/DockerComposeFileTask;", "Lorg/gradle/api/DefaultTask;", "()V", "includeBuild", "", "getIncludeBuild", "()Z", "setIncludeBuild", "(Z)V", "outputDir", "Ljava/io/File;", "getOutputDir", "()Ljava/io/File;", "setOutputDir", "(Ljava/io/File;)V", "outputFilename", "", "getOutputFilename", "()Ljava/lang/String;", "setOutputFilename", "(Ljava/lang/String;)V", "structure", "", "", "getStructure", "()Ljava/util/Map;", "value", "", "version", "getVersion", "()D", "setVersion", "(D)V", "createFile", "", "formatted", "map", "", "excludeBuild", "service", "Ldocker/DockerService;", "name", "builder", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "appendNested", "Ljava/lang/StringBuilder;", "level", "", "obj", "foundation-plugins"})
public class DockerComposeFileTask
extends DefaultTask {
    @Input
    @NotNull
    private final Map<String, Object> structure;
    @OutputDirectory
    @NotNull
    private File outputDir;
    @Input
    @NotNull
    private String outputFilename;
    private boolean includeBuild;

    @NotNull
    public final Map<String, Object> getStructure() {
        return this.structure;
    }

    @NotNull
    public final File getOutputDir() {
        return this.outputDir;
    }

    public final void setOutputDir(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"<set-?>");
        this.outputDir = file;
    }

    @NotNull
    public final String getOutputFilename() {
        return this.outputFilename;
    }

    public final void setOutputFilename(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.outputFilename = string;
    }

    /*
     * WARNING - void declaration
     */
    public final void appendNested(@NotNull StringBuilder $this$appendNested, int level, @NotNull Map<String, ? extends Object> obj, boolean excludeBuild) {
        Intrinsics.checkNotNullParameter((Object)$this$appendNested, (String)"$this$appendNested");
        Intrinsics.checkNotNullParameter(obj, (String)"obj");
        Object object = obj;
        boolean bl = false;
        for (Map.Entry<String, ? extends Object> entry : object.entrySet()) {
            void key;
            Object object2 = entry;
            boolean bl2 = false;
            object = object2.getKey();
            object2 = entry;
            bl2 = false;
            Object value = object2.getValue();
            if (excludeBuild && Intrinsics.areEqual((Object)key, (Object)"build")) continue;
            $this$appendNested.append(StringsKt.repeat((CharSequence)"  ", (int)level));
            $this$appendNested.append((String)key + ':');
            object2 = value;
            if (object2 instanceof String || object2 instanceof Number) {
                $this$appendNested.append("" + ' ' + value + '\n');
                continue;
            }
            if (object2 instanceof Map) {
                $this$appendNested.append("\n");
                Object object3 = value;
                if (object3 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any>");
                }
                this.appendNested($this$appendNested, level + 1, (Map)object3, excludeBuild);
                continue;
            }
            if (!(object2 instanceof List)) continue;
            for (Object items : (List)value) {
                $this$appendNested.append("\n");
                $this$appendNested.append(StringsKt.repeat((CharSequence)"  ", (int)(level + 1)));
                $this$appendNested.append("- " + items);
            }
            $this$appendNested.append("\n");
        }
    }

    private final String formatted(Map<String, ? extends Object> map, boolean excludeBuild) {
        boolean bl = false;
        boolean bl2 = false;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl3 = false;
        boolean bl4 = false;
        StringBuilder $this$buildString = stringBuilder;
        boolean bl5 = false;
        $this$buildString.append("version: " + map.get("version") + "\n\n");
        $this$buildString.append("services:\n");
        Object object = map.get("services");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.List<kotlin.collections.Map<kotlin.String, kotlin.Any>>");
        }
        List services = (List)object;
        for (Map service : services) {
            this.appendNested($this$buildString, 1, service, excludeBuild);
            if (!(Intrinsics.areEqual((Object)service, (Object)((Map)CollectionsKt.lastOrNull((List)services))) ^ true)) continue;
            $this$buildString.append("\n");
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    @Input
    public final boolean getIncludeBuild() {
        return this.includeBuild;
    }

    public final void setIncludeBuild(boolean bl) {
        this.includeBuild = bl;
    }

    @TaskAction
    public final void createFile() {
        File outputFile = new File(this.outputDir, this.outputFilename);
        if (!outputFile.exists()) {
            outputFile.createNewFile();
        }
        FilesKt.writeText$default((File)outputFile, (String)this.formatted(this.structure, !this.includeBuild), null, (int)2, null);
    }

    @Internal
    public final double getVersion() {
        String string = String.valueOf(this.structure.get("version"));
        boolean bl = false;
        return Double.parseDouble(string);
    }

    public final void setVersion(double value) {
        this.version(value);
    }

    public final void version(double value) {
        this.structure.put("version", "" + '\"' + value + '\"');
    }

    @NotNull
    public final DockerService service(@NotNull String name, @NotNull Function1<? super DockerService, Unit> builder) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        DockerService dockerService = new DockerService(name);
        boolean bl = false;
        boolean bl2 = false;
        DockerService it = dockerService;
        boolean bl3 = false;
        builder.invoke((Object)it);
        boolean bl4 = false;
        Object object = this.structure.getOrDefault("services", new ArrayList());
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.MutableList<kotlin.Any>");
        }
        List services = TypeIntrinsics.asMutableList((Object)object);
        services.add(MapsKt.mapOf((Pair)TuplesKt.to((Object)it.getName(), it.getStructure$foundation_plugins())));
        this.structure.put("services", services);
        return dockerService;
    }

    /*
     * WARNING - void declaration
     */
    public DockerComposeFileTask() {
        void $this$apply;
        this.setGroup("docker");
        this.structure = MapsKt.mutableMapOf((Pair[])new Pair[]{TuplesKt.to((Object)"version", (Object)"3.8")});
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        File file = new File(project.getBuildDir(), "docker");
        boolean bl = false;
        boolean bl2 = false;
        File file2 = file;
        DockerComposeFileTask dockerComposeFileTask = this;
        boolean bl3 = false;
        if (!$this$apply.exists()) {
            $this$apply.mkdirs();
        }
        Unit unit = Unit.INSTANCE;
        dockerComposeFileTask.outputDir = file;
        this.outputFilename = "docker-compose.yml";
    }
}

