/*
 * Decompiled with CFR 0.152.
 */
package expect;

import expect.BasicExpectation;
import expect.CollectionExpectation;
import expect.LambdaExpectation;
import expect.internal.BasicExpectationImpl;
import expect.internal.CollectionExpectationImpl;
import expect.internal.LambdaExpectationImpl;
import java.util.Arrays;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000>\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001f\u0010\u0000\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\u0004\b\u0000\u0010\u00022\u0006\u0010\u0003\u001a\u0002H\u0002\u00a2\u0006\u0002\u0010\u0004\u001aD\u0010\u0000\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\u0004\b\u0000\u0010\u00022\u0006\u0010\u0003\u001a\u0002H\u00022\u001d\u0010\u0005\u001a\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00020\u0001\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\b\bH\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\t\u001a+\u0010\u0000\u001a\b\u0012\u0004\u0012\u0002H\u00020\n\"\u0004\b\u0000\u0010\u00022\u0012\u0010\u0003\u001a\n\u0012\u0006\b\u0001\u0012\u0002H\u00020\u000b\"\u0002H\u0002\u00a2\u0006\u0002\u0010\f\u001a \u0010\u0000\u001a\b\u0012\u0004\u0012\u0002H\u00020\n\"\u0004\b\u0000\u0010\u00022\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\u00020\u000e\u001a%\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\u00020\n\"\u0004\b\u0000\u0010\u00022\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u00020\u000b\u00a2\u0006\u0002\u0010\f\u001a \u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u00020\n\"\u0004\b\u0000\u0010\u00022\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\u00020\u000e\u001a\u0012\u0010\u0012\u001a\u00020\u00132\n\u0010\u0014\u001a\u00060\u0015j\u0002`\u0016\u001aE\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00020\n\"\u0004\b\u0000\u0010\u00022\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00020\u000e2\u001d\u0010\u0005\u001a\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00020\n\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\b\bH\u0086\b\u00f8\u0001\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u0018"}, d2={"expect", "Lexpect/BasicExpectation;", "E", "value", "(Ljava/lang/Object;)Lexpect/BasicExpectation;", "builder", "Lkotlin/Function1;", "", "Lkotlin/ExtensionFunctionType;", "(Ljava/lang/Object;Lkotlin/jvm/functions/Function1;)Lexpect/BasicExpectation;", "Lexpect/CollectionExpectation;", "", "([Ljava/lang/Object;)Lexpect/CollectionExpectation;", "collection", "", "expectArray", "array", "expectCollection", "expectFunction", "Lexpect/LambdaExpectation;", "lambda", "Ljava/lang/Runnable;", "Lfunctions/Runnable;", "expectMany", "expect-core"})
@JvmName(name="Expect")
public final class Expect {
    @NotNull
    public static final <E> BasicExpectation<E> expect(E value) {
        return new BasicExpectationImpl<E>(value);
    }

    @NotNull
    public static final <E> CollectionExpectation<E> expect(E ... value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        return new CollectionExpectationImpl(ArraysKt.asList((Object[])value));
    }

    @NotNull
    public static final <E> CollectionExpectation<E> expectArray(@NotNull E[] array) {
        Intrinsics.checkNotNullParameter(array, (String)"array");
        return Expect.expect(Arrays.copyOf(array, array.length));
    }

    @NotNull
    public static final <E> CollectionExpectation<E> expectCollection(@NotNull Collection<? extends E> collection) {
        Intrinsics.checkNotNullParameter(collection, (String)"collection");
        return new CollectionExpectationImpl<E>(collection);
    }

    @NotNull
    public static final <E> CollectionExpectation<E> expect(@NotNull Collection<? extends E> collection) {
        Intrinsics.checkNotNullParameter(collection, (String)"collection");
        return Expect.expectCollection(collection);
    }

    @NotNull
    public static final <E> BasicExpectation<E> expect(E value, @NotNull Function1<? super BasicExpectation<? extends E>, Unit> builder) {
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        boolean $i$f$expect = false;
        BasicExpectation<E> basicExpectation = Expect.expect(value);
        builder.invoke(basicExpectation);
        return basicExpectation;
    }

    @NotNull
    public static final LambdaExpectation expectFunction(@NotNull Runnable lambda) {
        Intrinsics.checkNotNullParameter((Object)lambda, (String)"lambda");
        return new LambdaExpectationImpl((Function0<Unit>)((Function0)new Function0<Unit>((Object)lambda){

            public final void invoke() {
                ((Runnable)this.receiver).run();
            }
        }));
    }

    @NotNull
    public static final <E> CollectionExpectation<E> expectMany(@NotNull Collection<? extends E> value, @NotNull Function1<? super CollectionExpectation<? extends E>, Unit> builder) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        boolean $i$f$expectMany = false;
        CollectionExpectation<? extends E> collectionExpectation = Expect.expectCollection(value);
        builder.invoke(collectionExpectation);
        return collectionExpectation;
    }
}

