/*
 * Decompiled with CFR 0.152.
 */
package tyrantgit.explosionfield;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.widget.ImageView;

public class Utils {
    private static final float DENSITY = Resources.getSystem().getDisplayMetrics().density;
    private static final Canvas sCanvas = new Canvas();

    private Utils() {
    }

    public static int dp2Px(int dp) {
        return Math.round((float)dp * DENSITY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Bitmap createBitmapFromView(View view) {
        Drawable drawable;
        if (view instanceof ImageView && (drawable = ((ImageView)view).getDrawable()) != null && drawable instanceof BitmapDrawable) {
            return ((BitmapDrawable)drawable).getBitmap();
        }
        view.clearFocus();
        Bitmap bitmap = Utils.createBitmapSafely(view.getWidth(), view.getHeight(), Bitmap.Config.ARGB_8888, 1);
        if (bitmap != null) {
            Canvas canvas = sCanvas;
            synchronized (canvas) {
                Canvas canvas2 = sCanvas;
                canvas2.setBitmap(bitmap);
                view.draw(canvas2);
                canvas2.setBitmap(null);
            }
        }
        return bitmap;
    }

    public static Bitmap createBitmapSafely(int width, int height, Bitmap.Config config, int retryCount) {
        try {
            return Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)config);
        }
        catch (OutOfMemoryError e) {
            e.printStackTrace();
            if (retryCount > 0) {
                System.gc();
                return Utils.createBitmapSafely(width, height, config, retryCount - 1);
            }
            return null;
        }
    }
}

