/*
 * Decompiled with CFR 0.152.
 */
package tyrantgit.explosionfield;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ValueAnimator;
import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import tyrantgit.explosionfield.ExplosionAnimator;
import tyrantgit.explosionfield.Utils;

public class ExplosionField
extends View {
    private List<ExplosionAnimator> mExplosions = new ArrayList<ExplosionAnimator>();
    private int[] mExpandInset = new int[2];

    public ExplosionField(Context context) {
        super(context);
        this.init();
    }

    public ExplosionField(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public ExplosionField(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        Arrays.fill(this.mExpandInset, Utils.dp2Px(32));
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        for (ExplosionAnimator explosion : this.mExplosions) {
            explosion.draw(canvas);
        }
    }

    public void expandExplosionBound(int dx, int dy) {
        this.mExpandInset[0] = dx;
        this.mExpandInset[1] = dy;
    }

    public void explode(Bitmap bitmap, Rect bound, long startDelay, long duration) {
        ExplosionAnimator explosion = new ExplosionAnimator(this, bitmap, bound);
        explosion.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                ExplosionField.this.mExplosions.remove(animation);
            }
        });
        explosion.setStartDelay(startDelay);
        explosion.setDuration(duration);
        this.mExplosions.add(explosion);
        explosion.start();
    }

    public void explode(final View view) {
        Rect r = new Rect();
        view.getGlobalVisibleRect(r);
        int[] location = new int[2];
        this.getLocationOnScreen(location);
        r.offset(location[0], -location[1]);
        r.inset(-this.mExpandInset[0], -this.mExpandInset[1]);
        int startDelay = 100;
        ValueAnimator animator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f}).setDuration(150L);
        animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){
            Random random = new Random();

            public void onAnimationUpdate(ValueAnimator animation) {
                view.setTranslationX((this.random.nextFloat() - 0.5f) * (float)view.getWidth() * 0.05f);
                view.setTranslationY((this.random.nextFloat() - 0.5f) * (float)view.getHeight() * 0.05f);
            }
        });
        animator.start();
        view.animate().setDuration(150L).setStartDelay((long)startDelay).scaleX(0.0f).scaleY(0.0f).alpha(0.0f).start();
        this.explode(Utils.createBitmapFromView(view), r, startDelay, ExplosionAnimator.DEFAULT_DURATION);
    }

    public void clear() {
        this.mExplosions.clear();
        this.invalidate();
    }

    public static ExplosionField attach2Window(Activity activity) {
        ViewGroup rootView = (ViewGroup)activity.findViewById(0x1020002);
        ExplosionField explosionField = new ExplosionField((Context)activity);
        rootView.addView((View)explosionField, new ViewGroup.LayoutParams(-1, -1));
        return explosionField;
    }
}

