/*
 * Decompiled with CFR 0.152.
 */
package tyrantgit.widget;

import android.graphics.Matrix;
import android.graphics.Path;
import android.graphics.PathMeasure;
import android.os.Handler;
import android.os.Looper;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import android.view.animation.Transformation;
import java.util.concurrent.atomic.AtomicInteger;
import tyrantgit.widget.AbstractPathAnimator;

public class PathAnimator
extends AbstractPathAnimator {
    private final AtomicInteger mCounter = new AtomicInteger(0);
    private Handler mHandler = new Handler(Looper.getMainLooper());

    public PathAnimator(AbstractPathAnimator.Config config) {
        super(config);
    }

    @Override
    public void start(final View child, final ViewGroup parent) {
        parent.addView(child, new ViewGroup.LayoutParams(this.mConfig.heartWidth, this.mConfig.heartHeight));
        FloatAnimation anim = new FloatAnimation(this.createPath(this.mCounter, (View)parent, 2), this.randomRotation(), (View)parent, child);
        anim.setDuration(this.mConfig.animDuration);
        anim.setInterpolator((Interpolator)new LinearInterpolator());
        anim.setAnimationListener(new Animation.AnimationListener(){

            public void onAnimationEnd(Animation animation) {
                PathAnimator.this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        parent.removeView(child);
                    }
                });
                PathAnimator.this.mCounter.decrementAndGet();
            }

            public void onAnimationRepeat(Animation animation) {
            }

            public void onAnimationStart(Animation animation) {
                PathAnimator.this.mCounter.incrementAndGet();
            }
        });
        anim.setInterpolator((Interpolator)new LinearInterpolator());
        child.startAnimation((Animation)anim);
    }

    private static float scale(double a, double b, double c, double d, double e) {
        return (float)((a - b) / (c - b) * (e - d) + d);
    }

    static class FloatAnimation
    extends Animation {
        private PathMeasure mPm;
        private View mView;
        private float mDistance;
        private float mRotation;

        public FloatAnimation(Path path, float rotation, View parent, View child) {
            this.mPm = new PathMeasure(path, false);
            this.mDistance = this.mPm.getLength();
            this.mView = child;
            this.mRotation = rotation;
            parent.setLayerType(2, null);
        }

        protected void applyTransformation(float factor, Transformation transformation) {
            Matrix matrix = transformation.getMatrix();
            this.mPm.getMatrix(this.mDistance * factor, matrix, 1);
            this.mView.setRotation(this.mRotation * factor);
            float scale = 1.0f;
            if (3000.0f * factor < 200.0f) {
                scale = PathAnimator.scale(factor, 0.0, 0.06666667014360428, 0.2f, 1.1f);
            } else if (3000.0f * factor < 300.0f) {
                scale = PathAnimator.scale(factor, 0.06666667014360428, 0.1f, 1.1f, 1.0);
            }
            this.mView.setScaleX(scale);
            this.mView.setScaleY(scale);
            transformation.setAlpha(1.0f - factor);
        }
    }
}

