/*
 * Decompiled with CFR 0.152.
 */
package tyrantgit.widget;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.widget.ImageView;
import tyrantgit.widget.R;

public class HeartView
extends ImageView {
    private static final Paint sPaint = new Paint(3);
    private int mHeartResId = R.drawable.heart;
    private int mHeartBorderResId = R.drawable.heart_border;
    private static Bitmap sHeart;
    private static Bitmap sHeartBorder;
    private static final Canvas sCanvas;

    public HeartView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public HeartView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public HeartView(Context context) {
        super(context);
    }

    public void setColor(int color) {
        Bitmap heart = this.createHeart(color);
        this.setImageDrawable((Drawable)new BitmapDrawable(this.getResources(), heart));
    }

    public void setColorAndDrawables(int color, int heartResId, int heartBorderResId) {
        if (heartResId != this.mHeartResId) {
            sHeart = null;
        }
        if (heartBorderResId != this.mHeartBorderResId) {
            sHeartBorder = null;
        }
        this.mHeartResId = heartResId;
        this.mHeartBorderResId = heartBorderResId;
        this.setColor(color);
    }

    public Bitmap createHeart(int color) {
        if (sHeart == null) {
            sHeart = BitmapFactory.decodeResource((Resources)this.getResources(), (int)this.mHeartResId);
        }
        if (sHeartBorder == null) {
            sHeartBorder = BitmapFactory.decodeResource((Resources)this.getResources(), (int)this.mHeartBorderResId);
        }
        Bitmap heart = sHeart;
        Bitmap heartBorder = sHeartBorder;
        Bitmap bm = HeartView.createBitmapSafely(heartBorder.getWidth(), heartBorder.getHeight());
        if (bm == null) {
            return null;
        }
        Canvas canvas = sCanvas;
        canvas.setBitmap(bm);
        Paint p = sPaint;
        canvas.drawBitmap(heartBorder, 0.0f, 0.0f, p);
        p.setColorFilter((ColorFilter)new PorterDuffColorFilter(color, PorterDuff.Mode.SRC_ATOP));
        float dx = (float)(heartBorder.getWidth() - heart.getWidth()) / 2.0f;
        float dy = (float)(heartBorder.getHeight() - heart.getHeight()) / 2.0f;
        canvas.drawBitmap(heart, dx, dy, p);
        p.setColorFilter(null);
        canvas.setBitmap(null);
        return bm;
    }

    private static Bitmap createBitmapSafely(int width, int height) {
        try {
            return Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        }
        catch (OutOfMemoryError error) {
            error.printStackTrace();
            return null;
        }
    }

    static {
        sCanvas = new Canvas();
    }
}

