/*
 * Decompiled with CFR 0.152.
 */
package tyrantgit.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import tyrantgit.widget.AbstractPathAnimator;
import tyrantgit.widget.HeartView;
import tyrantgit.widget.PathAnimator;
import tyrantgit.widget.R;

public class HeartLayout
extends RelativeLayout {
    private AbstractPathAnimator mAnimator;

    public HeartLayout(Context context) {
        super(context);
        this.init(null, 0);
    }

    public HeartLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs, 0);
    }

    public HeartLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(attrs, defStyleAttr);
    }

    private void init(AttributeSet attrs, int defStyleAttr) {
        TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.HeartLayout, defStyleAttr, 0);
        this.mAnimator = new PathAnimator(AbstractPathAnimator.Config.fromTypeArray(a));
        a.recycle();
    }

    public AbstractPathAnimator getAnimator() {
        return this.mAnimator;
    }

    public void setAnimator(AbstractPathAnimator animator) {
        this.clearAnimation();
        this.mAnimator = animator;
    }

    public void clearAnimation() {
        for (int i = 0; i < this.getChildCount(); ++i) {
            this.getChildAt(i).clearAnimation();
        }
        this.removeAllViews();
    }

    public void addHeart(int color) {
        HeartView heartView = new HeartView(this.getContext());
        heartView.setColor(color);
        this.mAnimator.start((View)heartView, (ViewGroup)this);
    }

    public void addHeart(int color, int heartResId, int heartBorderResId) {
        HeartView heartView = new HeartView(this.getContext());
        heartView.setColorAndDrawables(color, heartResId, heartBorderResId);
        this.mAnimator.start((View)heartView, (ViewGroup)this);
    }
}

