/*
 * Decompiled with CFR 0.152.
 */
package tyrantgit.widget;

import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Path;
import android.view.View;
import android.view.ViewGroup;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import tyrantgit.widget.R;

public abstract class AbstractPathAnimator {
    private final Random mRandom;
    protected final Config mConfig;

    public AbstractPathAnimator(Config config) {
        this.mConfig = config;
        this.mRandom = new Random();
    }

    public float randomRotation() {
        return this.mRandom.nextFloat() * 28.6f - 14.3f;
    }

    public Path createPath(AtomicInteger counter, View view, int factor) {
        Random r = this.mRandom;
        int x = r.nextInt(this.mConfig.xRand);
        int x2 = r.nextInt(this.mConfig.xRand);
        int y = view.getHeight() - this.mConfig.initY;
        int y2 = counter.intValue() * 15 + this.mConfig.animLength * factor + r.nextInt(this.mConfig.animLengthRand);
        factor = y2 / this.mConfig.bezierFactor;
        x = this.mConfig.xPointFactor + x;
        x2 = this.mConfig.xPointFactor + x2;
        int y3 = y - y2;
        y2 = y - y2 / 2;
        Path p = new Path();
        p.moveTo((float)this.mConfig.initX, (float)y);
        p.cubicTo((float)this.mConfig.initX, (float)(y - factor), (float)x, (float)(y2 + factor), (float)x, (float)y2);
        p.moveTo((float)x, (float)y2);
        p.cubicTo((float)x, (float)(y2 - factor), (float)x2, (float)(y3 + factor), (float)x2, (float)y3);
        return p;
    }

    public abstract void start(View var1, ViewGroup var2);

    public static class Config {
        public int initX;
        public int initY;
        public int xRand;
        public int animLengthRand;
        public int bezierFactor;
        public int xPointFactor;
        public int animLength;
        public int heartWidth;
        public int heartHeight;
        public int animDuration;

        static Config fromTypeArray(TypedArray typedArray) {
            Config config = new Config();
            Resources res = typedArray.getResources();
            config.initX = (int)typedArray.getDimension(R.styleable.HeartLayout_initX, (float)res.getDimensionPixelOffset(R.dimen.heart_anim_init_x));
            config.initY = (int)typedArray.getDimension(R.styleable.HeartLayout_initY, (float)res.getDimensionPixelOffset(R.dimen.heart_anim_init_y));
            config.xRand = (int)typedArray.getDimension(R.styleable.HeartLayout_xRand, (float)res.getDimensionPixelOffset(R.dimen.heart_anim_bezier_x_rand));
            config.animLength = (int)typedArray.getDimension(R.styleable.HeartLayout_animLength, (float)res.getDimensionPixelOffset(R.dimen.heart_anim_length));
            config.animLengthRand = (int)typedArray.getDimension(R.styleable.HeartLayout_animLengthRand, (float)res.getDimensionPixelOffset(R.dimen.heart_anim_length_rand));
            config.bezierFactor = typedArray.getInteger(R.styleable.HeartLayout_bezierFactor, res.getInteger(R.integer.heart_anim_bezier_factor));
            config.xPointFactor = (int)typedArray.getDimension(R.styleable.HeartLayout_xPointFactor, (float)res.getDimensionPixelOffset(R.dimen.heart_anim_x_point_factor));
            config.heartWidth = (int)typedArray.getDimension(R.styleable.HeartLayout_heart_width, (float)res.getDimensionPixelOffset(R.dimen.heart_size_width));
            config.heartHeight = (int)typedArray.getDimension(R.styleable.HeartLayout_heart_height, (float)res.getDimensionPixelOffset(R.dimen.heart_size_height));
            config.animDuration = typedArray.getInteger(R.styleable.HeartLayout_anim_duration, res.getInteger(R.integer.anim_duration));
            return config;
        }
    }
}

