/*
 * Decompiled with CFR 0.152.
 */
package tw.lifehackers.widget;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.AssetManager;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Typeface;
import android.graphics.Xfermode;
import android.os.Build;
import android.os.Handler;
import android.text.TextPaint;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.TypedValue;
import android.view.Gravity;
import android.view.View;
import android.view.animation.Interpolator;
import java.util.HashMap;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tw.lifehackers.widget.EnchantedCharactersViewKt;
import tw.lifehackers.widget.IntermediateState;
import tw.lifehackers.widget.enchantedcharacters.R;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 K2\u00020\u0001:\u0001KB\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007B!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u001c\u0010<\u001a\u00020\u00122\u0006\u0010=\u001a\u00020'2\n\b\u0002\u0010>\u001a\u0004\u0018\u00010'H\u0003J\b\u0010?\u001a\u00020\u0012H\u0002J\u001a\u0010@\u001a\u00020A2\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010B\u001a\u00020A2\u0006\u0010C\u001a\u00020DH\u0014J\u0018\u0010E\u001a\u00020A2\u0006\u0010F\u001a\u00020\t2\u0006\u0010G\u001a\u00020\tH\u0014J\u0018\u0010H\u001a\u00020A2\u0006\u0010>\u001a\u00020'2\u0006\u0010I\u001a\u00020'H\u0002J\b\u0010J\u001a\u00020AH\u0002R$\u0010\f\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\t@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R$\u0010\u0019\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\t@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u000e\"\u0004\b\u001b\u0010\u0010R\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001e\u001a\u0004\u0018\u00010\u001fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u000e\u0010$\u001a\u00020%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010(\u001a\u00020'2\u0006\u0010\u000b\u001a\u00020'@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,R$\u0010-\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\t@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010\u000e\"\u0004\b/\u0010\u0010R\u000e\u00100\u001a\u000201X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u00102\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\u0012@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b3\u00104\"\u0004\b5\u00106R(\u00107\u001a\u0004\u0018\u00010'2\b\u0010\u000b\u001a\u0004\u0018\u00010'@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b8\u0010*\"\u0004\b9\u0010,R\u000e\u0010:\u001a\u00020;X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006L"}, d2={"Ltw/lifehackers/widget/EnchantedCharactersView;", "Landroid/view/View;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "attr", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "value", "animationSteps", "getAnimationSteps", "()I", "setAnimationSteps", "(I)V", "defaultTextSize", "", "fadeInForNonMovingChar", "", "getFadeInForNonMovingChar", "()Z", "setFadeInForNonMovingChar", "(Z)V", "gravity", "getGravity", "setGravity", "intermediateState", "Ltw/lifehackers/widget/IntermediateState;", "interpolator", "Landroid/view/animation/Interpolator;", "getInterpolator", "()Landroid/view/animation/Interpolator;", "setInterpolator", "(Landroid/view/animation/Interpolator;)V", "invalidateRunnable", "Ljava/lang/Runnable;", "isAtMost", "", "text", "getText", "()Ljava/lang/String;", "setText", "(Ljava/lang/String;)V", "textColor", "getTextColor", "setTextColor", "textPaint", "Landroid/text/TextPaint;", "textSize", "getTextSize", "()F", "setTextSize", "(F)V", "typeface", "getTypeface", "setTypeface", "uiHandler", "Landroid/os/Handler;", "getOffsetX", "str", "oldStr", "getOffsetY", "init", "", "onDraw", "canvas", "Landroid/graphics/Canvas;", "onMeasure", "widthMeasureSpec", "heightMeasureSpec", "onTextChanged", "newStr", "updateTextPaint", "Companion", "EnchantedCharactersView_release"})
public final class EnchantedCharactersView
extends View {
    private final float defaultTextSize;
    private TextPaint textPaint;
    private int textColor;
    private float textSize;
    @NotNull
    private String text;
    @Nullable
    private String typeface;
    private boolean fadeInForNonMovingChar;
    private int animationSteps;
    private int gravity;
    @Nullable
    private Interpolator interpolator;
    private boolean isAtMost;
    private final Handler uiHandler;
    private IntermediateState intermediateState;
    private final Runnable invalidateRunnable;
    private static final int DEFAULT_TEXT_COLOR;
    private static final int DEFAULT_NUM_STEPS = 50;
    private static final int DEFAULT_GRAVITY = 0x800003;
    public static final Companion Companion;
    private HashMap _$_findViewCache;

    public final int getTextColor() {
        return this.textColor;
    }

    public final void setTextColor(int value) {
        this.textColor = value;
        this.updateTextPaint();
    }

    public final float getTextSize() {
        return this.textSize;
    }

    public final void setTextSize(float value) {
        this.textSize = value;
        this.updateTextPaint();
    }

    @NotNull
    public final String getText() {
        return this.text;
    }

    public final void setText(@NotNull String value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        if (Intrinsics.areEqual((Object)this.text, (Object)value)) {
            return;
        }
        this.onTextChanged(this.text, value);
        this.text = value;
    }

    @Nullable
    public final String getTypeface() {
        return this.typeface;
    }

    public final void setTypeface(@Nullable String value) {
        this.typeface = value;
        this.updateTextPaint();
    }

    public final boolean getFadeInForNonMovingChar() {
        return this.fadeInForNonMovingChar;
    }

    public final void setFadeInForNonMovingChar(boolean bl) {
        this.fadeInForNonMovingChar = bl;
    }

    public final int getAnimationSteps() {
        return this.animationSteps;
    }

    public final void setAnimationSteps(int value) {
        this.animationSteps = value;
        if (value < 2) {
            throw (Throwable)new IllegalArgumentException("animationSteps should be at least 2");
        }
    }

    public final int getGravity() {
        return this.gravity;
    }

    public final void setGravity(int value) {
        this.gravity = value;
        this.invalidate();
    }

    @Nullable
    public final Interpolator getInterpolator() {
        return this.interpolator;
    }

    public final void setInterpolator(@Nullable Interpolator interpolator) {
        this.interpolator = interpolator;
    }

    private final void init(AttributeSet attr, int defStyleAttr) {
        TypedArray typedArr = this.getContext().obtainStyledAttributes(attr, R.styleable.EnchantedCharactersView, defStyleAttr, 0);
        this.setTextColor(typedArr.getColor(R.styleable.EnchantedCharactersView_textColor, DEFAULT_TEXT_COLOR));
        float textSizeFromAttr = typedArr.getDimension(R.styleable.EnchantedCharactersView_textSize, -1.0f);
        this.setTextSize(textSizeFromAttr < 0.0f ? this.defaultTextSize : textSizeFromAttr);
        this.setTypeface(typedArr.getString(R.styleable.EnchantedCharactersView_typeface));
        String string = typedArr.getString(R.styleable.EnchantedCharactersView_text);
        if (string == null) {
            string = "";
        }
        this.setText(string);
        this.fadeInForNonMovingChar = typedArr.getBoolean(R.styleable.EnchantedCharactersView_fadeInForNonMovingChar, false);
        this.setAnimationSteps(typedArr.getInt(R.styleable.EnchantedCharactersView_animationSteps, 50));
        this.setGravity(typedArr.getInt(R.styleable.EnchantedCharactersView_gravity, 0x800003));
        typedArr.recycle();
        this.setLayerType(2, null);
        this.intermediateState = null;
    }

    private final void updateTextPaint() {
        if (Color.alpha((int)this.textColor) == 0) {
            this.textPaint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.CLEAR));
        } else {
            this.textPaint.setXfermode((Xfermode)null);
        }
        this.textPaint.setColor(this.textColor);
        this.textPaint.setTextSize(this.textSize);
        this.textPaint.setTypeface(this.typeface == null ? null : (Typeface)EnchantedCharactersViewKt.access$tryOrNull((Function0)new Function0<Typeface>(this){
            final /* synthetic */ EnchantedCharactersView this$0;

            public final Typeface invoke() {
                Context context = this.this$0.getContext();
                Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"context");
                return Typeface.createFromAsset((AssetManager)context.getAssets(), (String)this.this$0.getTypeface());
            }
            {
                this.this$0 = enchantedCharactersView;
                super(0);
            }
        }));
        this.invalidate();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        float f;
        this.isAtMost = View.MeasureSpec.getMode((int)widthMeasureSpec) == Integer.MIN_VALUE;
        IntermediateState intermediateState = this.intermediateState;
        if (intermediateState == null) {
            f = this.textPaint.measureText(this.text);
        } else {
            float f2 = this.textPaint.measureText(intermediateState.getOldStr());
            float f3 = this.textPaint.measureText(intermediateState.getNewStr());
            boolean bl = false;
            f = Math.max(f2, f3);
        }
        float textWidth = f;
        this.setMeasuredDimension(View.resolveSizeAndState((int)((int)textWidth + this.getPaddingLeft() + this.getPaddingRight()), (int)widthMeasureSpec, (int)0), View.resolveSizeAndState((int)(EnchantedCharactersViewKt.access$getHeight$p(this.textPaint) + this.getPaddingBottom() + this.getPaddingTop()), (int)heightMeasureSpec, (int)0));
        Log.d((String)"Landice", (String)("measured width = " + ((int)textWidth + this.getPaddingLeft() + this.getPaddingRight())));
    }

    private final float getOffsetY() {
        float f;
        int contentHeight = EnchantedCharactersViewKt.access$getHeight$p(this.textPaint);
        int containerHeight = this.getHeight() - this.getPaddingTop() - this.getPaddingBottom();
        switch (this.gravity & 0xF0) {
            case 80: {
                f = (float)this.getHeight() - (float)this.getPaddingBottom();
                break;
            }
            case 16: {
                f = (float)this.getPaddingTop() + (float)((containerHeight + contentHeight) / 2);
                break;
            }
            default: {
                f = (float)this.getPaddingTop() + (float)contentHeight;
            }
        }
        return f - this.textPaint.getFontMetrics().bottom;
    }

    @SuppressLint(value={"RtlHardcoded"})
    private final float getOffsetX(String str, String oldStr) {
        float f;
        int n;
        int layoutDirection = Build.VERSION.SDK_INT > 17 ? this.getLayoutDirection() : 0;
        int absGravity = Gravity.getAbsoluteGravity((int)this.gravity, (int)layoutDirection);
        float contentWidth = this.textPaint.measureText(str);
        if (this.isAtMost) {
            float f2;
            boolean bl;
            String string = oldStr;
            if (string != null) {
                String string2 = string;
                bl = false;
                boolean bl2 = false;
                String it = string2;
                boolean bl3 = false;
                f2 = this.textPaint.measureText(it);
            } else {
                f2 = 0.0f;
            }
            float f3 = f2;
            bl = false;
            n = (int)Math.max(contentWidth, f3);
        } else {
            n = this.getWidth() - this.getPaddingLeft() - this.getPaddingRight();
        }
        int containerWidth = n;
        switch (absGravity & 0xF) {
            case 5: {
                f = (float)this.getWidth() - contentWidth - (float)this.getPaddingRight();
                break;
            }
            case 1: {
                f = (float)this.getPaddingLeft() + ((float)containerWidth - contentWidth) / (float)2;
                break;
            }
            default: {
                f = this.getPaddingLeft();
            }
        }
        return f;
    }

    static /* synthetic */ float getOffsetX$default(EnchantedCharactersView enchantedCharactersView, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        return enchantedCharactersView.getOffsetX(string, string2);
    }

    private final void onTextChanged(String oldStr, String newStr) {
        this.uiHandler.removeCallbacks(this.invalidateRunnable);
        this.intermediateState = new IntermediateState(oldStr, newStr, this.animationSteps, this.textColor, this.textPaint, this.fadeInForNonMovingChar, this.getOffsetX(newStr, oldStr), this.getOffsetY(), this.interpolator);
        this.requestLayout();
    }

    protected void onDraw(@NotNull Canvas canvas) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        IntermediateState intermediateState = this.intermediateState;
        if (intermediateState == null) {
            this.textPaint.setColor(this.textColor);
            canvas.drawText(this.text, EnchantedCharactersView.getOffsetX$default(this, this.text, null, 2, null), this.getOffsetY(), (Paint)this.textPaint);
        } else {
            intermediateState.drawStep(canvas);
            if (!intermediateState.isFinalStep()) {
                this.uiHandler.post(this.invalidateRunnable);
            } else {
                this.intermediateState = null;
                if (this.isAtMost) {
                    this.requestLayout();
                }
            }
        }
    }

    public EnchantedCharactersView(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context);
        Context context2 = this.getContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context2, (String)"context");
        Resources resources = context2.getResources();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"context.resources");
        this.defaultTextSize = TypedValue.applyDimension((int)2, (float)18.0f, (DisplayMetrics)resources.getDisplayMetrics());
        this.textPaint = new TextPaint();
        this.textColor = DEFAULT_TEXT_COLOR;
        this.textSize = this.defaultTextSize;
        this.text = "";
        this.animationSteps = 50;
        this.gravity = 0x800003;
        this.uiHandler = new Handler();
        this.invalidateRunnable = new Runnable(this){
            final /* synthetic */ EnchantedCharactersView this$0;

            public final void run() {
                this.this$0.invalidate();
            }
            {
                this.this$0 = enchantedCharactersView;
            }
        };
        this.init(null, 0);
    }

    public EnchantedCharactersView(@NotNull Context context, @Nullable AttributeSet attr) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context, attr);
        Context context2 = this.getContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context2, (String)"context");
        Resources resources = context2.getResources();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"context.resources");
        this.defaultTextSize = TypedValue.applyDimension((int)2, (float)18.0f, (DisplayMetrics)resources.getDisplayMetrics());
        this.textPaint = new TextPaint();
        this.textColor = DEFAULT_TEXT_COLOR;
        this.textSize = this.defaultTextSize;
        this.text = "";
        this.animationSteps = 50;
        this.gravity = 0x800003;
        this.uiHandler = new Handler();
        this.invalidateRunnable = new /* invalid duplicate definition of identical inner class */;
        this.init(attr, 0);
    }

    public EnchantedCharactersView(@NotNull Context context, @Nullable AttributeSet attr, int defStyleAttr) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context, attr, defStyleAttr);
        Context context2 = this.getContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context2, (String)"context");
        Resources resources = context2.getResources();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"context.resources");
        this.defaultTextSize = TypedValue.applyDimension((int)2, (float)18.0f, (DisplayMetrics)resources.getDisplayMetrics());
        this.textPaint = new TextPaint();
        this.textColor = DEFAULT_TEXT_COLOR;
        this.textSize = this.defaultTextSize;
        this.text = "";
        this.animationSteps = 50;
        this.gravity = 0x800003;
        this.uiHandler = new Handler();
        this.invalidateRunnable = new /* invalid duplicate definition of identical inner class */;
        this.init(attr, defStyleAttr);
    }

    static {
        Companion = new Companion(null);
        DEFAULT_TEXT_COLOR = Color.parseColor((String)"#FF000000");
    }

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Ltw/lifehackers/widget/EnchantedCharactersView$Companion;", "", "()V", "DEFAULT_GRAVITY", "", "DEFAULT_NUM_STEPS", "DEFAULT_TEXT_COLOR", "EnchantedCharactersView_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

