/*
 * Decompiled with CFR 0.152.
 */
package tw.com.tp6gl4cj86.android_http_tool;

import android.app.Activity;
import android.content.Context;
import com.android.volley.AuthFailureError;
import com.android.volley.NetworkResponse;
import com.android.volley.Response;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.StringRequest;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.json.JSONException;
import org.json.JSONObject;
import tw.com.tp6gl4cj86.android_http_tool.Listener.HttpListener;
import tw.com.tp6gl4cj86.android_http_tool.Listener.HttpListenerAdapter;
import tw.com.tp6gl4cj86.android_http_tool.Request.DataPart;
import tw.com.tp6gl4cj86.android_http_tool.Request.VolleyMultipartRequest;
import tw.com.tp6gl4cj86.android_http_tool.VolleySingleton;

public class HttpTool {
    private static HttpListenerAdapter mStaticHttpListenerAdapter;

    public static void setStaticHttpListenerAdapter(HttpListenerAdapter mStaticHttpListenerAdapter) {
        HttpTool.mStaticHttpListenerAdapter = mStaticHttpListenerAdapter;
    }

    public static void post(Activity activity, String url) {
        HttpTool.post(activity, url, new HashMap<String, String>(), null);
    }

    public static void post(Activity activity, String url, Map<String, String> params) {
        HttpTool.post(activity, url, params, null);
    }

    public static void post(Activity activity, String url, HttpListener httpListener) {
        HttpTool.post(activity, url, new HashMap<String, String>(), httpListener);
    }

    public static void post(Activity activity, String url, Map<String, String> params, HttpListener httpListener) {
        HttpTool.requestJSON(1, activity, url, params, httpListener);
    }

    public static void postWithFile(Activity activity, String url, Map<String, String> params, Map<String, DataPart> fileParams, HttpListener httpListener) {
        HttpTool.requestJSONWithFile(activity, url, params, fileParams, httpListener);
    }

    public static void get(Activity activity, String url) {
        HttpTool.get(activity, url, new HashMap<String, String>(), null);
    }

    public static void get(Activity activity, String url, Map<String, String> params) {
        HttpTool.get(activity, url, params, null);
    }

    public static void get(Activity activity, String url, HttpListener httpListener) {
        HttpTool.get(activity, url, new HashMap<String, String>(), httpListener);
    }

    public static void get(Activity activity, String url, Map<String, String> params, HttpListener httpListener) {
        url = url + "?Olis=Android";
        for (String s : params.keySet()) {
            url = url + "&" + s + "=" + params.get(s);
        }
        HttpTool.requestJSON(0, activity, url, params, httpListener);
    }

    public static void requestJSON(final int method, final Activity activity, final String url, final Map<String, String> params, final HttpListener httpListener) {
        StringRequest stringRequest = new StringRequest(method, url, (Response.Listener)new Response.Listener<String>(){

            public void onResponse(String response) {
                try {
                    HttpTool.httpToolOnSuccessResponse(activity, HttpTool.getSuccessLog(HttpTool.parseMethod(method) + " " + url, params, response), httpListener, new JSONObject(response));
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        }, HttpTool.getErrorListener(activity, httpListener, HttpTool.parseMethod(method) + " " + url, params)){

            protected Map<String, String> getParams() throws AuthFailureError {
                if (params != null) {
                    return params;
                }
                return super.getParams();
            }
        };
        stringRequest.setShouldCache(false);
        VolleySingleton.getInstance((Context)activity).addToRequestQueue(stringRequest);
    }

    public static void requestJSONWithFile(final Activity activity, final String url, final Map<String, String> params, final Map<String, DataPart> fileParams, final HttpListener httpListener) {
        VolleyMultipartRequest multipartRequest = new VolleyMultipartRequest(1, url, (Response.Listener)new Response.Listener<NetworkResponse>(){

            public void onResponse(NetworkResponse response) {
                try {
                    JSONObject json = new JSONObject(new String(response.data));
                    HttpTool.httpToolOnSuccessResponse(activity, HttpTool.getSuccessLog("POST " + url, params, json.toString()), httpListener, json);
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        }, HttpTool.getErrorListener(activity, httpListener, "POST " + url, params)){

            protected Map<String, String> getParams() {
                return params;
            }

            @Override
            protected Map<String, DataPart> getByteData() {
                return fileParams;
            }
        };
        multipartRequest.setShouldCache(false);
        VolleySingleton.getInstance((Context)activity).addToRequestQueue(multipartRequest);
    }

    public static DataPart getDataPart(File file, String mimeType) throws IOException {
        return new DataPart(file.getAbsolutePath(), FileUtils.readFileToByteArray((File)file), mimeType);
    }

    private static String getSuccessLog(String url, Map<String, String> params, String response) {
        return "Url      : " + url + "\nParams   : " + HttpTool.parseParams(params) + "\nResponse : " + response;
    }

    private static void httpToolOnSuccessResponse(Activity activity, String log, HttpListener httpListener, JSONObject jsonResponse) {
        if (!(jsonResponse == null || activity != null && activity.isFinishing())) {
            if (httpListener != null) {
                try {
                    httpListener.onSuccess(jsonResponse, log);
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
            if (mStaticHttpListenerAdapter != null) {
                try {
                    mStaticHttpListenerAdapter.onSuccess(jsonResponse, log);
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private static Response.ErrorListener getErrorListener(final Activity activity, final HttpListener httpListener, final String url, final Map<String, String> params) {
        return new Response.ErrorListener(){

            public void onErrorResponse(VolleyError error) {
                HttpTool.httpToolOnErrorResponse(error, activity, httpListener, url, params);
            }
        };
    }

    private static void httpToolOnErrorResponse(VolleyError error, Activity activity, HttpListener httpListener, String url, Map<String, String> params) {
        if (activity == null || !activity.isFinishing()) {
            int statusCode = error != null && error.networkResponse != null ? error.networkResponse.statusCode : -1;
            String message = error != null ? error.getMessage() : "";
            String body = error != null && error.networkResponse != null && error.networkResponse.data != null ? new String(error.networkResponse.data) : "";
            String log = "Status Code   : " + statusCode;
            log = log + "\nUrl           : " + url;
            log = log + "\nParams        : " + HttpTool.parseParams(params);
            log = log + "\nError message : " + message;
            log = log + "\nError body    : " + body;
            if (httpListener != null) {
                httpListener.onFailure(statusCode, body, log);
            }
            if (mStaticHttpListenerAdapter != null) {
                mStaticHttpListenerAdapter.onFailure(statusCode, body, log);
            }
        }
    }

    private static String parseMethod(int method) {
        switch (method) {
            default: {
                return "GET";
            }
            case 1: {
                return "POST";
            }
            case 2: {
                return "PUT";
            }
            case 7: {
                return "PATCH";
            }
            case 3: 
        }
        return "DELETE";
    }

    private static String parseParams(Map<String, String> params) {
        return params != null ? params.toString() : "";
    }
}

