/*
 * Decompiled with CFR 0.152.
 */
package tw.com.tp6gl4cj86.android_http_tool;

import android.app.Activity;
import android.content.Context;
import com.android.volley.AuthFailureError;
import com.android.volley.DefaultRetryPolicy;
import com.android.volley.NetworkResponse;
import com.android.volley.Response;
import com.android.volley.RetryPolicy;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.StringRequest;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.json.JSONException;
import org.json.JSONObject;
import tw.com.tp6gl4cj86.android_http_tool.Listener.HttpListener;
import tw.com.tp6gl4cj86.android_http_tool.Listener.HttpListenerAdapter;
import tw.com.tp6gl4cj86.android_http_tool.Request.DataPart;
import tw.com.tp6gl4cj86.android_http_tool.Request.VolleyMultipartRequest;
import tw.com.tp6gl4cj86.android_http_tool.VolleySingleton;

public class HttpTool {
    private static HttpListenerAdapter mStaticHttpListenerAdapter;
    private static DefaultRetryPolicy retryPolicy;
    private static int initialTimeoutMs;
    private static int maxNumRetries;
    private static float backoffMultiplier;

    public static void setStaticHttpListenerAdapter(HttpListenerAdapter mStaticHttpListenerAdapter) {
        HttpTool.mStaticHttpListenerAdapter = mStaticHttpListenerAdapter;
    }

    public static void post(Context context, String url) {
        HttpTool.post(context, url, new HashMap<String, String>(), null);
    }

    public static void post(Context context, String url, Map<String, String> params) {
        HttpTool.post(context, url, params, null);
    }

    public static void post(Context context, String url, HttpListener httpListener) {
        HttpTool.post(context, url, new HashMap<String, String>(), httpListener);
    }

    public static void post(Context context, String url, Map<String, String> params, HttpListener httpListener) {
        HttpTool.requestJSON(1, context, url, params, httpListener);
    }

    public static void postWithFile(Context context, String url, Map<String, String> params, Map<String, DataPart> fileParams, HttpListener httpListener) {
        HttpTool.requestJSONWithFile(context, url, params, fileParams, httpListener);
    }

    public static void get(Context context, String url) {
        HttpTool.get(context, url, new HashMap<String, String>(), null);
    }

    public static void get(Context context, String url, Map<String, String> params) {
        HttpTool.get(context, url, params, null);
    }

    public static void get(Context context, String url, HttpListener httpListener) {
        HttpTool.get(context, url, new HashMap<String, String>(), httpListener);
    }

    public static void get(Context context, String url, Map<String, String> params, HttpListener httpListener) {
        url = url + "?Olis=Android";
        for (String s : params.keySet()) {
            url = url + "&" + s + "=" + params.get(s);
        }
        HttpTool.requestJSON(0, context, url, params, httpListener);
    }

    public static void getWithParmas(Context context, String url, HttpListener httpListener) {
        HttpTool.requestJSON(0, context, url, null, httpListener);
    }

    public static void requestJSON(final int method, final Context context, final String url, final Map<String, String> params, final HttpListener httpListener) {
        StringRequest stringRequest = new StringRequest(method, url, (Response.Listener)new Response.Listener<String>(){

            public void onResponse(String response) {
                HttpTool.httpToolOnSuccessResponse(context, HttpTool.getSuccessLog(HttpTool.parseMethod(method) + " " + url, params, response), httpListener, response);
            }
        }, HttpTool.getErrorListener(context, httpListener, HttpTool.parseMethod(method) + " " + url, params)){

            protected Map<String, String> getParams() throws AuthFailureError {
                if (params != null) {
                    return params;
                }
                return super.getParams();
            }
        };
        stringRequest.setShouldCache(false);
        stringRequest.setRetryPolicy((RetryPolicy)HttpTool.getRetryPolicy());
        VolleySingleton.getInstance(context).addToRequestQueue(stringRequest);
    }

    public static void requestJSONWithFile(final Context context, final String url, final Map<String, String> params, final Map<String, DataPart> fileParams, final HttpListener httpListener) {
        VolleyMultipartRequest multipartRequest = new VolleyMultipartRequest(1, url, (Response.Listener)new Response.Listener<NetworkResponse>(){

            public void onResponse(NetworkResponse response) {
                String responseStr = new String(response.data);
                HttpTool.httpToolOnSuccessResponse(context, HttpTool.getSuccessLog("POST " + url, params, responseStr), httpListener, responseStr);
            }
        }, HttpTool.getErrorListener(context, httpListener, "POST " + url, params)){

            protected Map<String, String> getParams() {
                return params;
            }

            @Override
            protected Map<String, DataPart> getByteData() {
                return fileParams;
            }
        };
        multipartRequest.setShouldCache(false);
        multipartRequest.setRetryPolicy((RetryPolicy)HttpTool.getRetryPolicy());
        VolleySingleton.getInstance(context).addToRequestQueue(multipartRequest);
    }

    public static DataPart getDataPart(File file, String mimeType) throws IOException {
        return new DataPart(file.getAbsolutePath(), FileUtils.readFileToByteArray((File)file), mimeType);
    }

    private static String getSuccessLog(String url, Map<String, String> params, String response) {
        return "Url      : " + url + "\nParams   : " + HttpTool.parseParams(params) + "\nResponse : " + response;
    }

    private static void httpToolOnSuccessResponse(Context context, String log, HttpListener httpListener, String response) {
        if (response != null && (context == null || context instanceof Activity && !((Activity)context).isFinishing())) {
            if (httpListener != null) {
                httpListener.onSuccess(response, log);
                try {
                    httpListener.onSuccess(new JSONObject(response), log);
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
                httpListener.onFinished();
            }
            if (mStaticHttpListenerAdapter != null) {
                mStaticHttpListenerAdapter.onSuccess(response, log);
                try {
                    mStaticHttpListenerAdapter.onSuccess(new JSONObject(response), log);
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
                mStaticHttpListenerAdapter.onFinished();
            }
        }
    }

    private static Response.ErrorListener getErrorListener(final Context context, final HttpListener httpListener, final String url, final Map<String, String> params) {
        return new Response.ErrorListener(){

            public void onErrorResponse(VolleyError error) {
                HttpTool.httpToolOnErrorResponse(error, context, httpListener, url, params);
            }
        };
    }

    private static void httpToolOnErrorResponse(VolleyError error, Context context, HttpListener httpListener, String url, Map<String, String> params) {
        if (context == null || context instanceof Activity && !((Activity)context).isFinishing()) {
            int statusCode = error != null && error.networkResponse != null ? error.networkResponse.statusCode : -1;
            String message = error != null ? error.getMessage() : "";
            String body = error != null && error.networkResponse != null && error.networkResponse.data != null ? new String(error.networkResponse.data) : "";
            String log = "Status Code   : " + statusCode;
            log = log + "\nUrl           : " + url;
            log = log + "\nParams        : " + HttpTool.parseParams(params);
            log = log + "\nError message : " + message;
            log = log + "\nError body    : " + body;
            if (httpListener != null) {
                httpListener.onFailure(statusCode, body, log);
                httpListener.onFinished();
            }
            if (mStaticHttpListenerAdapter != null) {
                mStaticHttpListenerAdapter.onFailure(statusCode, body, log);
                mStaticHttpListenerAdapter.onFinished();
            }
        }
    }

    private static String parseMethod(int method) {
        switch (method) {
            default: {
                return "GET";
            }
            case 1: {
                return "POST";
            }
            case 2: {
                return "PUT";
            }
            case 7: {
                return "PATCH";
            }
            case 3: 
        }
        return "DELETE";
    }

    private static String parseParams(Map<String, String> params) {
        return params != null ? params.toString() : "";
    }

    public static void setRetryPolicy(int initialTimeoutMs, int maxNumRetries, float backoffMultiplier) {
        HttpTool.initialTimeoutMs = initialTimeoutMs;
        HttpTool.maxNumRetries = maxNumRetries;
        HttpTool.backoffMultiplier = backoffMultiplier;
        retryPolicy = new DefaultRetryPolicy(initialTimeoutMs, maxNumRetries, backoffMultiplier);
    }

    private static DefaultRetryPolicy getRetryPolicy() {
        if (retryPolicy == null) {
            retryPolicy = new DefaultRetryPolicy(initialTimeoutMs, maxNumRetries, backoffMultiplier);
        }
        return retryPolicy;
    }

    static {
        retryPolicy = new DefaultRetryPolicy();
        initialTimeoutMs = 2500;
        maxNumRetries = 1;
        backoffMultiplier = 1.0f;
    }
}

