/*
 * Decompiled with CFR 0.152.
 */
package tv.mycujoo.mcls.widgets.mlstimebar;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Color;
import android.graphics.ColorFilter;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.FrameLayout;
import android.widget.TextView;
import androidx.annotation.UiThread;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.constraintlayout.widget.ConstraintSet;
import androidx.core.content.ContextCompat;
import androidx.core.view.ViewCompat;
import androidx.test.espresso.idling.CountingIdlingResource;
import java.util.HashMap;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tv.mycujoo.mcls.R;
import tv.mycujoo.mcls.utils.ColorUtils;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0004\u0018\u00002\u00020\u0001B%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\fJ\b\u0010\u001a\u001a\u00020\u0018H\u0007J\u000e\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u0013\u001a\u00020\u0014J\u001c\u0010\u001c\u001a\u00020\u00182\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\f0\u001e2\u0006\u0010\u001f\u001a\u00020\u0007J\u0010\u0010 \u001a\u00020\u00182\u0006\u0010!\u001a\u00020\u0007H\u0003R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Ltv/mycujoo/mcls/widgets/mlstimebar/TimelineMarkerView;", "Landroidx/constraintlayout/widget/ConstraintLayout;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "anchorView", "Landroid/view/View;", "bgColor", "", "getBgColor", "()Ljava/lang/String;", "setBgColor", "(Ljava/lang/String;)V", "frameLayout", "Landroid/widget/FrameLayout;", "idlingResource", "Landroidx/test/espresso/idling/CountingIdlingResource;", "textView", "Landroid/widget/TextView;", "initialize", "", "color", "removeMarkerView", "setIdlingResource", "setMarkerTexts", "titles", "", "position", "setPosition", "relationalPosition", "mls_release"})
public final class TimelineMarkerView
extends ConstraintLayout {
    private final View anchorView;
    private final FrameLayout frameLayout;
    private final TextView textView;
    @NotNull
    private String bgColor;
    private CountingIdlingResource idlingResource;
    private HashMap _$_findViewCache;

    @NotNull
    public final String getBgColor() {
        return this.bgColor;
    }

    public final void setBgColor(@NotNull String string2) {
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"<set-?>");
        this.bgColor = string2;
    }

    public final void initialize(@NotNull String color2) {
        Intrinsics.checkParameterIsNotNull((Object)color2, (String)"color");
        this.bgColor = color2;
        View $this$doOnLayout$iv = (View)this.frameLayout;
        boolean $i$f$doOnLayout = false;
        if (ViewCompat.isLaidOut((View)$this$doOnLayout$iv) && !$this$doOnLayout$iv.isLayoutRequested()) {
            View it = $this$doOnLayout$iv;
            boolean bl = false;
            Drawable drawable2 = this.frameLayout.getBackground();
            Intrinsics.checkExpressionValueIsNotNull((Object)drawable2, (String)"frameLayout.background");
            drawable2.setColorFilter((ColorFilter)new PorterDuffColorFilter(Color.parseColor((String)color2), PorterDuff.Mode.SRC_ATOP));
        } else {
            View $this$doOnNextLayout$iv$iv = $this$doOnLayout$iv;
            boolean $i$f$doOnNextLayout = false;
            $this$doOnNextLayout$iv$iv.addOnLayoutChangeListener(new View.OnLayoutChangeListener(this, color2){
                final /* synthetic */ TimelineMarkerView this$0;
                final /* synthetic */ String $color$inlined;
                {
                    this.this$0 = timelineMarkerView;
                    this.$color$inlined = string2;
                }

                public void onLayoutChange(@NotNull View view, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
                    Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
                    view.removeOnLayoutChangeListener((View.OnLayoutChangeListener)this);
                    View it = view;
                    boolean bl = false;
                    View it2 = it;
                    boolean bl2 = false;
                    Drawable drawable2 = TimelineMarkerView.access$getFrameLayout$p(this.this$0).getBackground();
                    Intrinsics.checkExpressionValueIsNotNull((Object)drawable2, (String)"frameLayout.background");
                    drawable2.setColorFilter((ColorFilter)new PorterDuffColorFilter(Color.parseColor((String)this.$color$inlined), PorterDuff.Mode.SRC_ATOP));
                }
            });
        }
        this.setVisibility(8);
    }

    @UiThread
    private final void setPosition(int relationalPosition) {
        if (this.idlingResource != null) {
            CountingIdlingResource countingIdlingResource = this.idlingResource;
            if (countingIdlingResource == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"idlingResource");
            }
            countingIdlingResource.increment();
        }
        int relationalPosition2 = relationalPosition;
        if (this.textView.getWidth() / 2 > relationalPosition2) {
            relationalPosition2 += this.textView.getWidth() / 2;
        }
        ViewParent viewParent = this.getParent();
        if (viewParent == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.view.View");
        }
        if (((View)viewParent).getWidth() - this.textView.getWidth() / 2 < relationalPosition2) {
            relationalPosition2 -= this.textView.getWidth() / 2;
        }
        ConstraintSet constraintSet = new ConstraintSet();
        constraintSet.clone((ConstraintLayout)this);
        constraintSet.setMargin(this.anchorView.getId(), 6, relationalPosition2);
        constraintSet.applyTo((ConstraintLayout)this);
        TimelineMarkerView $this$doOnLayout$iv = this;
        boolean $i$f$doOnLayout = false;
        if (ViewCompat.isLaidOut((View)$this$doOnLayout$iv) && !$this$doOnLayout$iv.isLayoutRequested()) {
            View it = (View)$this$doOnLayout$iv;
            boolean bl = false;
            this.setVisibility(0);
            if (this.idlingResource != null && !TimelineMarkerView.access$getIdlingResource$p(this).isIdleNow()) {
                TimelineMarkerView.access$getIdlingResource$p(this).decrement();
            }
        } else {
            TimelineMarkerView $this$doOnNextLayout$iv$iv = $this$doOnLayout$iv;
            boolean $i$f$doOnNextLayout = false;
            $this$doOnNextLayout$iv$iv.addOnLayoutChangeListener(new View.OnLayoutChangeListener(this){
                final /* synthetic */ TimelineMarkerView this$0;
                {
                    this.this$0 = timelineMarkerView;
                }

                public void onLayoutChange(@NotNull View view, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
                    Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
                    view.removeOnLayoutChangeListener((View.OnLayoutChangeListener)this);
                    View it = view;
                    boolean bl = false;
                    View it2 = it;
                    boolean bl2 = false;
                    this.this$0.setVisibility(0);
                    if (TimelineMarkerView.access$getIdlingResource$li(this.this$0) != null && !TimelineMarkerView.access$getIdlingResource$p(this.this$0).isIdleNow()) {
                        TimelineMarkerView.access$getIdlingResource$p(this.this$0).decrement();
                    }
                }
            });
        }
    }

    @UiThread
    public final void removeMarkerView() {
        this.setVisibility(8);
    }

    /*
     * WARNING - void declaration
     */
    public final void setMarkerTexts(@NotNull List<String> titles, int position) {
        Intrinsics.checkParameterIsNotNull(titles, (String)"titles");
        if (titles.isEmpty()) {
            this.removeMarkerView();
        }
        this.setVisibility(0);
        this.textView.setVisibility(0);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append((String)CollectionsKt.first(titles));
        int n = 1;
        int n2 = titles.size();
        while (n < n2) {
            void i;
            stringBuilder.append("\n");
            stringBuilder.append(titles.get((int)i));
            ++i;
        }
        this.textView.setText((CharSequence)stringBuilder.toString());
        View $this$doOnLayout$iv = (View)this.textView;
        boolean $i$f$doOnLayout = false;
        if (ViewCompat.isLaidOut((View)$this$doOnLayout$iv) && !$this$doOnLayout$iv.isLayoutRequested()) {
            View it = $this$doOnLayout$iv;
            boolean bl = false;
            this.setPosition(position);
        } else {
            View $this$doOnNextLayout$iv$iv = $this$doOnLayout$iv;
            boolean $i$f$doOnNextLayout = false;
            $this$doOnNextLayout$iv$iv.addOnLayoutChangeListener(new View.OnLayoutChangeListener(this, position){
                final /* synthetic */ TimelineMarkerView this$0;
                final /* synthetic */ int $position$inlined;
                {
                    this.this$0 = timelineMarkerView;
                    this.$position$inlined = n;
                }

                public void onLayoutChange(@NotNull View view, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
                    Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
                    view.removeOnLayoutChangeListener((View.OnLayoutChangeListener)this);
                    View it = view;
                    boolean bl = false;
                    View it2 = it;
                    boolean bl2 = false;
                    TimelineMarkerView.access$setPosition(this.this$0, this.$position$inlined);
                }
            });
        }
        if (ColorUtils.Companion.isColorBright(this.bgColor)) {
            this.textView.setTextColor(Color.parseColor((String)"#000000"));
        } else {
            this.textView.setTextColor(Color.parseColor((String)"#FFFFFF"));
        }
    }

    public final void setIdlingResource(@NotNull CountingIdlingResource idlingResource) {
        Intrinsics.checkParameterIsNotNull((Object)idlingResource, (String)"idlingResource");
        this.idlingResource = idlingResource;
    }

    @JvmOverloads
    public TimelineMarkerView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.anchorView = new View(context);
        this.bgColor = "";
        this.anchorView.setId(View.generateViewId());
        ConstraintLayout.LayoutParams anchorLayoutParams = new ConstraintLayout.LayoutParams(1, 1);
        anchorLayoutParams.leftToLeft = this.getId();
        this.addView(this.anchorView, (ViewGroup.LayoutParams)anchorLayoutParams);
        this.frameLayout = new FrameLayout(context);
        this.frameLayout.setId(View.generateViewId());
        ConstraintLayout.LayoutParams frameLayoutLayoutParams = new ConstraintLayout.LayoutParams(-2, -2);
        frameLayoutLayoutParams.leftToLeft = this.anchorView.getId();
        frameLayoutLayoutParams.topToTop = this.getId();
        frameLayoutLayoutParams.rightToRight = this.anchorView.getId();
        this.addView((View)this.frameLayout, (ViewGroup.LayoutParams)frameLayoutLayoutParams);
        this.frameLayout.setBackground(ContextCompat.getDrawable((Context)context, (int)R.drawable.shape_highlight_marker_bg));
        Resources resources = this.getResources();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"resources");
        float density = resources.getDisplayMetrics().density;
        int verticalPadding = (int)((float)4 * density);
        int sidePadding = (int)((float)8 * density);
        this.frameLayout.setPadding(sidePadding, verticalPadding, sidePadding, verticalPadding);
        this.textView = new TextView(context);
        this.textView.setId(View.generateViewId());
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-2, -2);
        layoutParams.gravity = 17;
        this.frameLayout.addView((View)this.textView, (ViewGroup.LayoutParams)layoutParams);
    }

    public /* synthetic */ TimelineMarkerView(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    @JvmOverloads
    public TimelineMarkerView(@NotNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public TimelineMarkerView(@NotNull Context context) {
        this(context, null, 0, 6, null);
    }

    public static final /* synthetic */ CountingIdlingResource access$getIdlingResource$p(TimelineMarkerView $this) {
        CountingIdlingResource countingIdlingResource = $this.idlingResource;
        if (countingIdlingResource == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"idlingResource");
        }
        return countingIdlingResource;
    }

    public static final /* synthetic */ void access$setIdlingResource$p(TimelineMarkerView $this, CountingIdlingResource countingIdlingResource) {
        $this.idlingResource = countingIdlingResource;
    }

    public static final /* synthetic */ void access$setIdlingResource$li(TimelineMarkerView $this, CountingIdlingResource countingIdlingResource) {
        $this.idlingResource = countingIdlingResource;
    }

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }
}

