/*
 * Decompiled with CFR 0.152.
 */
package tv.mycujoo.mcls.widgets.mlstimebar;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewParent;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import androidx.annotation.ColorInt;
import androidx.annotation.RequiresApi;
import com.google.android.exoplayer2.ui.TimeBar;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Util;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Locale;
import java.util.concurrent.CopyOnWriteArraySet;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tv.mycujoo.mcls.R;
import tv.mycujoo.mcls.widgets.mlstimebar.PointOfInterest;
import tv.mycujoo.mcls.widgets.mlstimebar.PositionedPointOfInterest;
import tv.mycujoo.mcls.widgets.mlstimebar.TimelineMarkerPosition;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u00e6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0016\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u0018\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b*\u0018\u0000 \u00aa\u00012\u00020\u00012\u00020\u0002:\u0002\u00aa\u0001B1\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\nJ\u0010\u0010Q\u001a\u00020R2\u0006\u0010S\u001a\u00020&H\u0016J\u000e\u0010T\u001a\u00020R2\u0006\u0010U\u001a\u00020/J\u0006\u0010V\u001a\u00020RJ\u0010\u0010W\u001a\u00020R2\u0006\u0010X\u001a\u00020YH\u0002J\u0010\u0010Z\u001a\u00020R2\u0006\u0010X\u001a\u00020YH\u0002J\b\u0010[\u001a\u00020RH\u0014J\b\u0010\\\u001a\u00020\u0016H\u0016J\u0018\u0010]\u001a\u00020G2\u0006\u0010^\u001a\u00020\u00182\u0006\u0010_\u001a\u00020\u0018H\u0002J\b\u0010`\u001a\u00020RH\u0016J\u0010\u0010a\u001a\u00020R2\u0006\u0010b\u001a\u00020\u0018H\u0002J\u0010\u0010c\u001a\u00020R2\u0006\u0010X\u001a\u00020YH\u0016J\"\u0010d\u001a\u00020R2\u0006\u0010e\u001a\u00020G2\u0006\u0010f\u001a\u00020\b2\b\u0010g\u001a\u0004\u0018\u00010\u0013H\u0014J\u0010\u0010h\u001a\u00020R2\u0006\u0010i\u001a\u00020jH\u0016J\u0010\u0010k\u001a\u00020R2\u0006\u0010l\u001a\u00020mH\u0017J\u0018\u0010n\u001a\u00020G2\u0006\u0010o\u001a\u00020\b2\u0006\u0010i\u001a\u00020pH\u0016J0\u0010q\u001a\u00020R2\u0006\u0010r\u001a\u00020G2\u0006\u0010s\u001a\u00020\b2\u0006\u0010t\u001a\u00020\b2\u0006\u0010u\u001a\u00020\b2\u0006\u0010v\u001a\u00020\bH\u0014J\u0018\u0010w\u001a\u00020R2\u0006\u0010x\u001a\u00020\b2\u0006\u0010y\u001a\u00020\bH\u0014J\u0010\u0010z\u001a\u00020R2\u0006\u0010{\u001a\u00020\bH\u0016J\u0010\u0010|\u001a\u00020G2\u0006\u0010i\u001a\u00020}H\u0016J\u001c\u0010~\u001a\u00020G2\u0006\u0010\u007f\u001a\u00020\b2\n\u0010\u0080\u0001\u001a\u0005\u0018\u00010\u0081\u0001H\u0016J\u0011\u0010\u0082\u0001\u001a\u00020R2\u0006\u0010b\u001a\u00020\u0018H\u0002J\u0011\u0010\u0083\u0001\u001a\u00020R2\u0006\u0010S\u001a\u00020&H\u0016J\u0012\u0010\u0084\u0001\u001a\u00020N2\u0007\u0010\u0085\u0001\u001a\u00020}H\u0002J\u0012\u0010\u0086\u0001\u001a\u00020G2\u0007\u0010\u0087\u0001\u001a\u00020\u0016H\u0002J%\u0010\u0088\u0001\u001a\u00020R2\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010)\u001a\u0004\u0018\u00010*2\u0006\u0010\u000b\u001a\u00020\bH\u0016J\u0012\u0010\u0089\u0001\u001a\u00020R2\t\b\u0001\u0010\u008a\u0001\u001a\u00020\bJ\u0012\u0010\u008b\u0001\u001a\u00020R2\t\b\u0001\u0010\u008c\u0001\u001a\u00020\bJ\u0011\u0010\u008d\u0001\u001a\u00020R2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0012\u0010\u008e\u0001\u001a\u00020G2\u0007\u0010\u008f\u0001\u001a\u00020@H\u0002J\u0011\u0010\u0090\u0001\u001a\u00020R2\u0006\u0010\u0019\u001a\u00020\u0016H\u0016J\u0012\u0010\u0091\u0001\u001a\u00020R2\u0007\u0010\u0092\u0001\u001a\u00020GH\u0016J\u0012\u0010\u0093\u0001\u001a\u00020R2\u0007\u0010\u0094\u0001\u001a\u00020\bH\u0016J\u0012\u0010\u0095\u0001\u001a\u00020R2\u0007\u0010\u0096\u0001\u001a\u00020\u0016H\u0016J\u0012\u0010\u0097\u0001\u001a\u00020R2\t\b\u0001\u0010\u0098\u0001\u001a\u00020\bJ\u0012\u0010\u0099\u0001\u001a\u00020R2\t\b\u0001\u0010\u009a\u0001\u001a\u00020\bJ\u0011\u0010\u009b\u0001\u001a\u00020R2\u0006\u00102\u001a\u00020\u0016H\u0016J\u0012\u0010\u009c\u0001\u001a\u00020R2\t\b\u0001\u0010\u009d\u0001\u001a\u00020\bJ\u001b\u0010\u009e\u0001\u001a\u00020R2\u0007\u0010\u009f\u0001\u001a\u00020\b2\u0007\u0010\u00a0\u0001\u001a\u00020\bH\u0003J\u000f\u0010\u00a1\u0001\u001a\u00020R2\u0006\u0010S\u001a\u00020LJ\u0012\u0010\u00a2\u0001\u001a\u00020R2\t\b\u0001\u0010\u00a3\u0001\u001a\u00020\bJ\u0011\u0010\u00a4\u0001\u001a\u00020R2\u0006\u0010;\u001a\u00020\u0016H\u0002J\u0012\u0010\u00a5\u0001\u001a\u00020R2\u0007\u0010\u00a6\u0001\u001a\u00020GH\u0002J\t\u0010\u00a7\u0001\u001a\u00020RH\u0002J\t\u0010\u00a8\u0001\u001a\u00020RH\u0002J\u0011\u0010\u00a9\u0001\u001a\u00020R2\u0006\u0010;\u001a\u00020\u0016H\u0002R\u000e\u0010\u000b\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u001b\u001a\u00060\u001cj\u0002`\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010#\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020(X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010)\u001a\u0004\u0018\u00010*X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010-\u001a\b\u0012\u0004\u0012\u00020/0.X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u00100\u001a\b\u0012\u0004\u0012\u0002010.X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00102\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u00103\u001a\u00020\u00168BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b4\u00105R\u000e\u00106\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u00107\u001a\u0002088BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b9\u0010:R\u000e\u0010;\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010<\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010=\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010>\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010?\u001a\u0004\u0018\u00010@X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010A\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010B\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010C\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010D\u001a\u00020\u00168BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bE\u00105R\u000e\u0010F\u001a\u00020GX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010H\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010I\u001a\u00020JX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010K\u001a\u00020LX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010M\u001a\u00020NX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010O\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010P\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u00ab\u0001"}, d2={"Ltv/mycujoo/mcls/widgets/mlstimebar/MLSTimeBar;", "Landroid/view/View;", "Lcom/google/android/exoplayer2/ui/TimeBar;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "timebarAttrs", "(Landroid/content/Context;Landroid/util/AttributeSet;ILandroid/util/AttributeSet;)V", "adGroupCount", "adGroupTimesMs", "", "adMarkerPaint", "Landroid/graphics/Paint;", "adMarkerWidth", "barHeight", "bufferedBar", "Landroid/graphics/Rect;", "bufferedPaint", "bufferedPosition", "", "density", "", "duration", "fineScrubYThreshold", "formatBuilder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "formatter", "Ljava/util/Formatter;", "keyCountIncrement", "keyTimeIncrement", "lastCoarseScrubXPosition", "lastExclusionRectangle", "listeners", "Ljava/util/concurrent/CopyOnWriteArraySet;", "Lcom/google/android/exoplayer2/ui/TimeBar$OnScrubListener;", "locationOnScreen", "", "playedAdGroups", "", "playedAdMarkerPaint", "playedPaint", "poiArrayList", "Ljava/util/ArrayList;", "Ltv/mycujoo/mcls/widgets/mlstimebar/PointOfInterest;", "poiPositionsOnScreen", "Ltv/mycujoo/mcls/widgets/mlstimebar/PositionedPointOfInterest;", "position", "positionIncrement", "getPositionIncrement", "()J", "progressBar", "progressText", "", "getProgressText", "()Ljava/lang/String;", "scrubPosition", "scrubberBar", "scrubberDisabledSize", "scrubberDraggedSize", "scrubberDrawable", "Landroid/graphics/drawable/Drawable;", "scrubberEnabledSize", "scrubberPadding", "scrubberPaint", "scrubberPosition", "getScrubberPosition", "scrubbing", "", "seekBounds", "stopScrubbingRunnable", "Ljava/lang/Runnable;", "timelineMarkerPositionListener", "Ltv/mycujoo/mcls/widgets/mlstimebar/TimelineMarkerPosition;", "touchPosition", "Landroid/graphics/Point;", "touchTargetHeight", "unplayedPaint", "addListener", "", "listener", "addTimeLineHighlight", "poi", "clearTimeLineMarker", "drawPlayhead", "canvas", "Landroid/graphics/Canvas;", "drawTimeBar", "drawableStateChanged", "getPreferredUpdateDelay", "isInSeekBar", "x", "y", "jumpDrawablesToCurrentState", "notifyScrubbingUpdated", "xPosition", "onDraw", "onFocusChanged", "gainFocus", "direction", "previouslyFocusedRect", "onInitializeAccessibilityEvent", "event", "Landroid/view/accessibility/AccessibilityEvent;", "onInitializeAccessibilityNodeInfo", "info", "Landroid/view/accessibility/AccessibilityNodeInfo;", "onKeyDown", "keyCode", "Landroid/view/KeyEvent;", "onLayout", "changed", "left", "top", "right", "bottom", "onMeasure", "widthMeasureSpec", "heightMeasureSpec", "onRtlPropertiesChanged", "layoutDirection", "onTouchEvent", "Landroid/view/MotionEvent;", "performAccessibilityAction", "action", "args", "Landroid/os/Bundle;", "positionScrubber", "removeListener", "resolveRelativeTouchPosition", "motionEvent", "scrubIncrementally", "positionChange", "setAdGroupTimesMs", "setAdMarkerColor", "adMarkerColor", "setBufferedColor", "bufferedColor", "setBufferedPosition", "setDrawableLayoutDirection", "drawable", "setDuration", "setEnabled", "enabled", "setKeyCountIncrement", "count", "setKeyTimeIncrement", "time", "setPlayedAdMarkerColor", "playedAdMarkerColor", "setPlayedColor", "playedColor", "setPosition", "setScrubberColor", "scrubberColor", "setSystemGestureExclusionRectsV29", "width", "height", "setTimelineMarkerPositionListener", "setUnplayedColor", "unplayedColor", "startScrubbing", "stopScrubbing", "canceled", "update", "updateDrawableState", "updateScrubbing", "Companion", "mls_release"})
public final class MLSTimeBar
extends View
implements TimeBar {
    private final Rect seekBounds;
    private final Rect progressBar;
    private final Rect bufferedBar;
    private final Rect scrubberBar;
    private final Paint playedPaint;
    private final Paint bufferedPaint;
    private final Paint unplayedPaint;
    private final Paint adMarkerPaint;
    private final Paint playedAdMarkerPaint;
    private final Paint scrubberPaint;
    private Drawable scrubberDrawable;
    private int barHeight;
    private int touchTargetHeight;
    private int adMarkerWidth;
    private int scrubberEnabledSize;
    private int scrubberDisabledSize;
    private int scrubberDraggedSize;
    private int scrubberPadding;
    private final int fineScrubYThreshold;
    private final StringBuilder formatBuilder;
    private final Formatter formatter;
    private final Runnable stopScrubbingRunnable;
    private final CopyOnWriteArraySet<TimeBar.OnScrubListener> listeners;
    private final int[] locationOnScreen;
    private final Point touchPosition;
    private final float density;
    private int keyCountIncrement;
    private long keyTimeIncrement;
    private int lastCoarseScrubXPosition;
    private Rect lastExclusionRectangle;
    private boolean scrubbing;
    private long scrubPosition;
    private long duration;
    private long position;
    private long bufferedPosition;
    private int adGroupCount;
    private long[] adGroupTimesMs;
    private boolean[] playedAdGroups;
    private final ArrayList<PointOfInterest> poiArrayList;
    private final ArrayList<PositionedPointOfInterest> poiPositionsOnScreen;
    private TimelineMarkerPosition timelineMarkerPositionListener;
    public static final int DEFAULT_BAR_HEIGHT_DP = 4;
    public static final int DEFAULT_TOUCH_TARGET_HEIGHT_DP = 26;
    public static final int DEFAULT_AD_MARKER_WIDTH_DP = 4;
    public static final int DEFAULT_SCRUBBER_ENABLED_SIZE_DP = 12;
    public static final int DEFAULT_SCRUBBER_DISABLED_SIZE_DP = 0;
    public static final int DEFAULT_SCRUBBER_DRAGGED_SIZE_DP = 16;
    public static final int DEFAULT_PLAYED_COLOR = -1;
    public static final int DEFAULT_UNPLAYED_COLOR = 0x33FFFFFF;
    public static final int DEFAULT_BUFFERED_COLOR = -855638017;
    public static final int DEFAULT_SCRUBBER_COLOR = -1;
    public static final int DEFAULT_AD_MARKER_COLOR = -1291845888;
    public static final int DEFAULT_PLAYED_AD_MARKER_COLOR = 0x33FFFF00;
    private static final int FINE_SCRUB_Y_THRESHOLD_DP = -50;
    private static final int FINE_SCRUB_RATIO = 3;
    private static final long STOP_SCRUBBING_TIMEOUT_MS = 1000L;
    private static final int DEFAULT_INCREMENT_COUNT = 20;
    private static final String ACCESSIBILITY_CLASS_NAME = "android.widget.SeekBar";
    public static final Companion Companion = new Companion(null);
    private HashMap _$_findViewCache;

    public final void setPlayedColor(@ColorInt int playedColor) {
        this.playedPaint.setColor(playedColor);
        this.invalidate(this.seekBounds);
    }

    public final void setScrubberColor(@ColorInt int scrubberColor) {
        this.scrubberPaint.setColor(scrubberColor);
        this.invalidate(this.seekBounds);
    }

    public final void setBufferedColor(@ColorInt int bufferedColor) {
        this.bufferedPaint.setColor(bufferedColor);
        this.invalidate(this.seekBounds);
    }

    public final void setUnplayedColor(@ColorInt int unplayedColor) {
        this.unplayedPaint.setColor(unplayedColor);
        this.invalidate(this.seekBounds);
    }

    public final void setAdMarkerColor(@ColorInt int adMarkerColor) {
        this.adMarkerPaint.setColor(adMarkerColor);
        this.invalidate(this.seekBounds);
    }

    public final void setPlayedAdMarkerColor(@ColorInt int playedAdMarkerColor) {
        this.playedAdMarkerPaint.setColor(playedAdMarkerColor);
        this.invalidate(this.seekBounds);
    }

    public final void setTimelineMarkerPositionListener(@NotNull TimelineMarkerPosition listener) {
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        this.timelineMarkerPositionListener = listener;
    }

    public void addListener(@NotNull TimeBar.OnScrubListener listener) {
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        this.listeners.add(listener);
    }

    public void removeListener(@NotNull TimeBar.OnScrubListener listener) {
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        this.listeners.remove(listener);
    }

    public void setKeyTimeIncrement(long time) {
        Assertions.checkArgument((time > 0L ? 1 : 0) != 0);
        this.keyCountIncrement = -1;
        this.keyTimeIncrement = time;
    }

    public void setKeyCountIncrement(int count) {
        Assertions.checkArgument((count > 0 ? 1 : 0) != 0);
        this.keyCountIncrement = count;
        this.keyTimeIncrement = -9223372036854775807L;
    }

    public void setPosition(long position) {
        this.position = position;
        this.setContentDescription(this.getProgressText());
        this.update();
    }

    public void setBufferedPosition(long bufferedPosition) {
        this.bufferedPosition = bufferedPosition;
        this.update();
    }

    public void setDuration(long duration) {
        this.duration = duration;
        if (this.scrubbing && duration == -9223372036854775807L) {
            this.stopScrubbing(true);
        }
        this.update();
    }

    public long getPreferredUpdateDelay() {
        int timeBarWidthDp = MLSTimeBar.Companion.pxToDp(this.density, this.progressBar.width());
        return timeBarWidthDp == 0 || this.duration == 0L || this.duration == -9223372036854775807L ? Long.MAX_VALUE : this.duration / (long)timeBarWidthDp;
    }

    public void setAdGroupTimesMs(@Nullable long[] adGroupTimesMs, @Nullable boolean[] playedAdGroups, int adGroupCount) {
        Assertions.checkArgument((adGroupCount == 0 || adGroupTimesMs != null && playedAdGroups != null ? 1 : 0) != 0);
        this.adGroupCount = adGroupCount;
        this.adGroupTimesMs = adGroupTimesMs;
        this.playedAdGroups = playedAdGroups;
        this.update();
    }

    public final void addTimeLineHighlight(@NotNull PointOfInterest poi) {
        Intrinsics.checkParameterIsNotNull((Object)poi, (String)"poi");
        this.poiArrayList.add(poi);
        this.poiPositionsOnScreen.add(new PositionedPointOfInterest(-1, poi));
    }

    public final void clearTimeLineMarker() {
        this.poiArrayList.clear();
        this.poiPositionsOnScreen.clear();
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.scrubbing && !enabled) {
            this.stopScrubbing(true);
        }
    }

    public void onDraw(@NotNull Canvas canvas) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        canvas.save();
        this.drawTimeBar(canvas);
        this.drawPlayhead(canvas);
        canvas.restore();
    }

    public boolean onTouchEvent(@NotNull MotionEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        if (!this.isEnabled() || this.duration <= 0L) {
            return false;
        }
        Point touchPosition = this.resolveRelativeTouchPosition(event);
        int x = touchPosition.x;
        int y = touchPosition.y;
        switch (event.getAction()) {
            case 0: {
                if (!this.isInSeekBar(x, y)) break;
                this.positionScrubber(x);
                this.startScrubbing(this.getScrubberPosition());
                this.update();
                this.invalidate();
                return true;
            }
            case 2: {
                if (!this.scrubbing) break;
                if (y < this.fineScrubYThreshold) {
                    int relativeX = x - this.lastCoarseScrubXPosition;
                    this.positionScrubber((float)this.lastCoarseScrubXPosition + (float)relativeX / (float)3);
                    this.notifyScrubbingUpdated(x);
                } else {
                    this.lastCoarseScrubXPosition = x;
                    this.positionScrubber(x);
                    this.notifyScrubbingUpdated(x);
                }
                this.updateScrubbing(this.getScrubberPosition());
                this.update();
                this.invalidate();
                return true;
            }
            case 1: 
            case 3: {
                if (!this.scrubbing) break;
                this.stopScrubbing(event.getAction() == 3);
                return true;
            }
        }
        return false;
    }

    public boolean onKeyDown(int keyCode, @NotNull KeyEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        if (this.isEnabled()) {
            long positionIncrement = this.getPositionIncrement();
            switch (keyCode) {
                case 21: {
                    positionIncrement = -positionIncrement;
                    if (!this.scrubIncrementally(positionIncrement)) break;
                    this.removeCallbacks(this.stopScrubbingRunnable);
                    this.postDelayed(this.stopScrubbingRunnable, 1000L);
                    return true;
                }
                case 22: {
                    if (!this.scrubIncrementally(positionIncrement)) break;
                    this.removeCallbacks(this.stopScrubbingRunnable);
                    this.postDelayed(this.stopScrubbingRunnable, 1000L);
                    return true;
                }
                case 23: 
                case 66: {
                    if (!this.scrubbing) break;
                    this.stopScrubbing(false);
                    return true;
                }
            }
        }
        return super.onKeyDown(keyCode, event);
    }

    protected void onFocusChanged(boolean gainFocus, int direction, @Nullable Rect previouslyFocusedRect) {
        super.onFocusChanged(gainFocus, direction, previouslyFocusedRect);
        if (this.scrubbing && !gainFocus) {
            this.stopScrubbing(false);
        }
    }

    protected void drawableStateChanged() {
        super.drawableStateChanged();
        this.updateDrawableState();
    }

    public void jumpDrawablesToCurrentState() {
        block0: {
            super.jumpDrawablesToCurrentState();
            Drawable drawable2 = this.scrubberDrawable;
            if (drawable2 == null) break block0;
            drawable2.jumpToCurrentState();
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int height = heightMode == 0 ? this.touchTargetHeight : (heightMode == 0x40000000 ? heightSize : Math.min(this.touchTargetHeight, heightSize));
        this.setMeasuredDimension(View.MeasureSpec.getSize((int)widthMeasureSpec), height);
        this.updateDrawableState();
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        int width = right - left;
        int height = bottom - top;
        int barY = (height - this.touchTargetHeight) / 2;
        int seekLeft = this.getPaddingLeft();
        int seekRight = width - this.getPaddingRight();
        int progressY = barY + (this.touchTargetHeight - this.barHeight) / 2;
        this.seekBounds.set(seekLeft, barY, seekRight, barY + this.touchTargetHeight);
        this.progressBar.set(this.seekBounds.left + this.scrubberPadding, progressY, this.seekBounds.right - this.scrubberPadding, progressY + this.barHeight);
        if (Util.SDK_INT >= 29) {
            this.setSystemGestureExclusionRectsV29(width, height);
        }
        this.update();
    }

    public void onRtlPropertiesChanged(int layoutDirection) {
        if (this.scrubberDrawable != null) {
            Drawable drawable2 = this.scrubberDrawable;
            if (drawable2 == null) {
                Intrinsics.throwNpe();
            }
            if (MLSTimeBar.Companion.setDrawableLayoutDirection(drawable2, layoutDirection)) {
                this.invalidate();
            }
        }
    }

    public void onInitializeAccessibilityEvent(@NotNull AccessibilityEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        super.onInitializeAccessibilityEvent(event);
        if (event.getEventType() == 4) {
            event.getText().add(this.getProgressText());
        }
        event.setClassName((CharSequence)ACCESSIBILITY_CLASS_NAME);
    }

    @TargetApi(value=21)
    public void onInitializeAccessibilityNodeInfo(@NotNull AccessibilityNodeInfo info) {
        Intrinsics.checkParameterIsNotNull((Object)info, (String)"info");
        super.onInitializeAccessibilityNodeInfo(info);
        info.setClassName((CharSequence)ACCESSIBILITY_CLASS_NAME);
        info.setContentDescription((CharSequence)this.getProgressText());
        if (this.duration <= 0L) {
            return;
        }
        if (Util.SDK_INT >= 21) {
            info.addAction(AccessibilityNodeInfo.AccessibilityAction.ACTION_SCROLL_FORWARD);
            info.addAction(AccessibilityNodeInfo.AccessibilityAction.ACTION_SCROLL_BACKWARD);
        } else {
            info.addAction(4096);
            info.addAction(8192);
        }
    }

    public boolean performAccessibilityAction(int action, @Nullable Bundle args) {
        if (super.performAccessibilityAction(action, args)) {
            return true;
        }
        if (this.duration <= 0L) {
            return false;
        }
        if (action == 8192) {
            if (this.scrubIncrementally(-this.getPositionIncrement())) {
                this.stopScrubbing(false);
            }
        } else if (action == 4096) {
            if (this.scrubIncrementally(this.getPositionIncrement())) {
                this.stopScrubbing(false);
            }
        } else {
            return false;
        }
        this.sendAccessibilityEvent(4);
        return true;
    }

    private final void startScrubbing(long scrubPosition) {
        ViewParent parent;
        this.scrubPosition = scrubPosition;
        this.scrubbing = true;
        this.setPressed(true);
        ViewParent viewParent = parent = this.getParent();
        if (viewParent != null) {
            viewParent.requestDisallowInterceptTouchEvent(true);
        }
        for (TimeBar.OnScrubListener listener : this.listeners) {
            listener.onScrubStart((TimeBar)this, scrubPosition);
        }
    }

    private final void updateScrubbing(long scrubPosition) {
        if (this.scrubPosition == scrubPosition) {
            return;
        }
        this.scrubPosition = scrubPosition;
        for (TimeBar.OnScrubListener listener : this.listeners) {
            listener.onScrubMove((TimeBar)this, scrubPosition);
        }
    }

    private final void stopScrubbing(boolean canceled) {
        ViewParent parent;
        this.removeCallbacks(this.stopScrubbingRunnable);
        this.scrubbing = false;
        this.setPressed(false);
        ViewParent viewParent = parent = this.getParent();
        if (viewParent != null) {
            viewParent.requestDisallowInterceptTouchEvent(false);
        }
        this.invalidate();
        for (TimeBar.OnScrubListener listener : this.listeners) {
            listener.onScrubStop((TimeBar)this, this.scrubPosition, canceled);
        }
        if (this.timelineMarkerPositionListener != null) {
            TimelineMarkerPosition timelineMarkerPosition = this.timelineMarkerPositionListener;
            if (timelineMarkerPosition == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"timelineMarkerPositionListener");
            }
            timelineMarkerPosition.onScrubStop();
        }
    }

    private final boolean scrubIncrementally(long positionChange) {
        if (this.duration <= 0L) {
            return false;
        }
        long previousPosition = this.scrubbing ? this.scrubPosition : this.position;
        long scrubPosition = Util.constrainValue((long)(previousPosition + positionChange), (long)0L, (long)this.duration);
        if (scrubPosition == previousPosition) {
            return false;
        }
        if (!this.scrubbing) {
            this.startScrubbing(scrubPosition);
        } else {
            this.updateScrubbing(scrubPosition);
        }
        this.update();
        return true;
    }

    private final void notifyScrubbingUpdated(float xPosition) {
        if (this.timelineMarkerPositionListener != null) {
            TimelineMarkerPosition timelineMarkerPosition = this.timelineMarkerPositionListener;
            if (timelineMarkerPosition == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"timelineMarkerPositionListener");
            }
            timelineMarkerPosition.onScrubMove(xPosition, this.poiPositionsOnScreen);
        }
    }

    private final void update() {
        long newScrubberTime;
        this.bufferedBar.set(this.progressBar);
        this.scrubberBar.set(this.progressBar);
        long l = newScrubberTime = this.scrubbing ? this.scrubPosition : this.position;
        if (this.duration > 0L) {
            int bufferedPixelWidth = (int)((long)this.progressBar.width() * this.bufferedPosition / this.duration);
            this.bufferedBar.right = Math.min(this.progressBar.left + bufferedPixelWidth, this.progressBar.right);
            int scrubberPixelPosition = (int)((long)this.progressBar.width() * newScrubberTime / this.duration);
            this.scrubberBar.right = Math.min(this.progressBar.left + scrubberPixelPosition, this.progressBar.right);
        } else {
            this.bufferedBar.right = this.progressBar.left;
            this.scrubberBar.right = this.progressBar.left;
        }
        this.invalidate(this.seekBounds);
    }

    private final void positionScrubber(float xPosition) {
        this.scrubberBar.right = Util.constrainValue((int)((int)xPosition), (int)this.progressBar.left, (int)this.progressBar.right);
    }

    private final Point resolveRelativeTouchPosition(MotionEvent motionEvent) {
        this.getLocationOnScreen(this.locationOnScreen);
        this.touchPosition.set((int)motionEvent.getRawX() - this.locationOnScreen[0], (int)motionEvent.getRawY() - this.locationOnScreen[1]);
        return this.touchPosition;
    }

    private final long getScrubberPosition() {
        return this.progressBar.width() <= 0 || this.duration == -9223372036854775807L ? 0L : (long)this.scrubberBar.width() * this.duration / (long)this.progressBar.width();
    }

    private final boolean isInSeekBar(float x, float y) {
        return this.seekBounds.contains((int)x, (int)y);
    }

    /*
     * WARNING - void declaration
     */
    private final void drawTimeBar(Canvas canvas) {
        int progressBarHeight = this.progressBar.height();
        int barTop = this.progressBar.centerY() - progressBarHeight / 2;
        int barBottom = barTop + progressBarHeight;
        if (this.duration <= 0L) {
            canvas.drawRect((float)this.progressBar.left, (float)barTop, (float)this.progressBar.right, (float)barBottom, this.unplayedPaint);
            return;
        }
        int bufferedLeft = this.bufferedBar.left;
        int bufferedRight = this.bufferedBar.right;
        int progressLeft = Math.max(Math.max(this.progressBar.left, bufferedRight), this.scrubberBar.right);
        if (progressLeft < this.progressBar.right) {
            canvas.drawRect((float)progressLeft, (float)barTop, (float)this.progressBar.right, (float)barBottom, this.unplayedPaint);
        }
        if (bufferedRight > (bufferedLeft = Math.max(bufferedLeft, this.scrubberBar.right))) {
            canvas.drawRect((float)bufferedLeft, (float)barTop, (float)bufferedRight, (float)barBottom, this.bufferedPaint);
        }
        if (this.scrubberBar.width() > 0) {
            canvas.drawRect((float)this.scrubberBar.left, (float)barTop, (float)this.scrubberBar.right, (float)barBottom, this.playedPaint);
        }
        Paint paint = new Paint();
        int timelineMarkerWidth = this.adMarkerWidth / 2;
        Iterable $this$forEachIndexed$iv = this.poiArrayList;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void poi;
            int n = index$iv++;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            int n2 = n;
            PointOfInterest pointOfInterest = (PointOfInterest)item$iv;
            int index = n2;
            boolean bl2 = false;
            long poiOffsetAdjusted = 0L;
            long l = poi.getOffset() + poi.getSeekOffset();
            if (0L > l || this.duration < l) {
                this.poiPositionsOnScreen.get(index).setPositionOnScreen(-1);
                return;
            }
            poiOffsetAdjusted = poi.getOffset() + poi.getSeekOffset();
            paint.setColor(Color.parseColor((String)poi.getPoiType().getColor()));
            long poiTimeMs = Util.constrainValue((long)poiOffsetAdjusted, (long)0L, (long)this.duration);
            int markerPositionOffset = (int)((long)this.progressBar.width() * poiTimeMs / this.duration) - timelineMarkerWidth;
            int markerLeft = this.progressBar.left + Math.min(this.progressBar.width() - this.adMarkerWidth, Math.max(0, markerPositionOffset));
            float markerRight = (float)markerLeft + (float)this.adMarkerWidth;
            canvas.drawRect((float)markerLeft, (float)(barTop - 6), markerRight, (float)(barBottom + 6), paint);
            this.poiPositionsOnScreen.get(index).setPositionOnScreen((int)(((float)markerLeft + markerRight) / (float)2));
        }
        if (this.adGroupCount == 0) {
            return;
        }
        Object object = Assertions.checkNotNull((Object)this.adGroupTimesMs);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"Assertions.checkNotNull(adGroupTimesMs)");
        long[] adGroupTimesMs = (long[])object;
        Object object2 = Assertions.checkNotNull((Object)this.playedAdGroups);
        Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"Assertions.checkNotNull(playedAdGroups)");
        boolean[] playedAdGroups = (boolean[])object2;
        int adMarkerOffset = this.adMarkerWidth / 2;
        int n = 0;
        int n3 = this.adGroupCount;
        while (n < n3) {
            void i;
            long adGroupTimeMs = Util.constrainValue((long)adGroupTimesMs[i], (long)0L, (long)this.duration);
            int markerPositionOffset = (int)((long)this.progressBar.width() * adGroupTimeMs / this.duration) - adMarkerOffset;
            int markerLeft = this.progressBar.left + Math.min(this.progressBar.width() - this.adMarkerWidth, Math.max(0, markerPositionOffset));
            Paint paint2 = playedAdGroups[i] ? this.playedAdMarkerPaint : this.adMarkerPaint;
            canvas.drawRect((float)markerLeft, (float)barTop, (float)markerLeft + (float)this.adMarkerWidth, (float)barBottom, paint2);
            ++i;
        }
    }

    private final void drawPlayhead(Canvas canvas) {
        block2: {
            int playheadY;
            int playheadX;
            block1: {
                if (this.duration <= 0L) {
                    return;
                }
                playheadX = Util.constrainValue((int)this.scrubberBar.right, (int)this.scrubberBar.left, (int)this.progressBar.right);
                playheadY = this.scrubberBar.centerY();
                if (this.scrubberDrawable != null) break block1;
                int scrubberSize = this.scrubbing || this.isFocused() ? this.scrubberDraggedSize : (this.isEnabled() ? this.scrubberEnabledSize : this.scrubberDisabledSize);
                int playheadRadius = scrubberSize / 2;
                canvas.drawCircle((float)playheadX, (float)playheadY, (float)playheadRadius, this.scrubberPaint);
                break block2;
            }
            Drawable drawable2 = this.scrubberDrawable;
            if (drawable2 == null) break block2;
            Drawable drawable3 = drawable2;
            boolean bl = false;
            boolean bl2 = false;
            Drawable it = drawable3;
            boolean bl3 = false;
            int scrubberDrawableWidth = it.getIntrinsicWidth();
            int scrubberDrawableHeight = it.getIntrinsicHeight();
            it.setBounds(playheadX - scrubberDrawableWidth / 2, playheadY - scrubberDrawableHeight / 2, playheadX + scrubberDrawableWidth / 2, playheadY + scrubberDrawableHeight / 2);
            it.draw(canvas);
        }
    }

    private final void updateDrawableState() {
        if (this.scrubberDrawable != null) {
            Drawable drawable2 = this.scrubberDrawable;
            if (drawable2 == null) {
                Intrinsics.throwNpe();
            }
            if (drawable2.isStateful()) {
                Drawable drawable3 = this.scrubberDrawable;
                if (drawable3 == null) {
                    Intrinsics.throwNpe();
                }
                if (drawable3.setState(this.getDrawableState())) {
                    this.invalidate();
                }
            }
        }
    }

    @RequiresApi(value=29)
    private final void setSystemGestureExclusionRectsV29(int width, int height) {
        if (this.lastExclusionRectangle != null) {
            Rect rect = this.lastExclusionRectangle;
            if (rect == null) {
                Intrinsics.throwNpe();
            }
            if (rect.width() == width) {
                Rect rect2 = this.lastExclusionRectangle;
                if (rect2 == null) {
                    Intrinsics.throwNpe();
                }
                if (rect2.height() == height) {
                    return;
                }
            }
        }
        Rect rect = this.lastExclusionRectangle = new Rect(0, 0, width, height);
        if (rect == null) {
            Intrinsics.throwNpe();
        }
        this.setSystemGestureExclusionRects(CollectionsKt.listOf((Object)rect));
    }

    private final String getProgressText() {
        String string2 = Util.getStringForTime((StringBuilder)this.formatBuilder, (Formatter)this.formatter, (long)this.position);
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"Util.getStringForTime(\n \u2026       position\n        )");
        return string2;
    }

    private final long getPositionIncrement() {
        return this.keyTimeIncrement == -9223372036854775807L ? (this.duration == -9223372036854775807L ? 0L : this.duration / (long)this.keyCountIncrement) : this.keyTimeIncrement;
    }

    private final boolean setDrawableLayoutDirection(Drawable drawable2) {
        return Util.SDK_INT >= 23 && MLSTimeBar.Companion.setDrawableLayoutDirection(drawable2, this.getLayoutDirection());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmOverloads
    public MLSTimeBar(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr, @Nullable AttributeSet timebarAttrs) {
        int n;
        Resources res;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.poiArrayList = new ArrayList();
        this.poiPositionsOnScreen = new ArrayList();
        this.seekBounds = new Rect();
        this.progressBar = new Rect();
        this.bufferedBar = new Rect();
        this.scrubberBar = new Rect();
        this.playedPaint = new Paint();
        this.bufferedPaint = new Paint();
        this.unplayedPaint = new Paint();
        this.adMarkerPaint = new Paint();
        this.playedAdMarkerPaint = new Paint();
        this.scrubberPaint = new Paint();
        this.scrubberPaint.setAntiAlias(true);
        this.listeners = new CopyOnWriteArraySet();
        this.locationOnScreen = new int[2];
        this.touchPosition = new Point();
        Resources resources = res = context.getResources();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"res");
        DisplayMetrics displayMetrics = resources.getDisplayMetrics();
        this.density = displayMetrics.density;
        this.fineScrubYThreshold = MLSTimeBar.Companion.dpToPx(this.density, -50);
        int defaultBarHeight = MLSTimeBar.Companion.dpToPx(this.density, 4);
        int defaultTouchTargetHeight = MLSTimeBar.Companion.dpToPx(this.density, 26);
        int defaultAdMarkerWidth = MLSTimeBar.Companion.dpToPx(this.density, 4);
        int defaultScrubberEnabledSize = MLSTimeBar.Companion.dpToPx(this.density, 12);
        int defaultScrubberDisabledSize = MLSTimeBar.Companion.dpToPx(this.density, 0);
        int defaultScrubberDraggedSize = MLSTimeBar.Companion.dpToPx(this.density, 16);
        if (timebarAttrs != null) {
            TypedArray a = context.getTheme().obtainStyledAttributes(timebarAttrs, R.styleable.DefaultTimeBar, 0, 0);
            try {
                Drawable drawable2 = this.scrubberDrawable = a.getDrawable(R.styleable.DefaultTimeBar_scrubber_drawable);
                if (drawable2 != null) {
                    Drawable drawable3 = drawable2;
                    boolean bl = false;
                    boolean bl2 = false;
                    Drawable it = drawable3;
                    boolean bl3 = false;
                    this.setDrawableLayoutDirection(it);
                    defaultTouchTargetHeight = Math.max(it.getMinimumHeight(), defaultTouchTargetHeight);
                }
                this.barHeight = a.getDimensionPixelSize(R.styleable.DefaultTimeBar_bar_height, defaultBarHeight);
                this.touchTargetHeight = a.getDimensionPixelSize(R.styleable.DefaultTimeBar_touch_target_height, defaultTouchTargetHeight);
                this.adMarkerWidth = a.getDimensionPixelSize(R.styleable.DefaultTimeBar_ad_marker_width, defaultAdMarkerWidth);
                this.scrubberEnabledSize = a.getDimensionPixelSize(R.styleable.DefaultTimeBar_scrubber_enabled_size, defaultScrubberEnabledSize);
                this.scrubberDisabledSize = a.getDimensionPixelSize(R.styleable.DefaultTimeBar_scrubber_disabled_size, defaultScrubberDisabledSize);
                this.scrubberDraggedSize = a.getDimensionPixelSize(R.styleable.DefaultTimeBar_scrubber_dragged_size, defaultScrubberDraggedSize);
                int playedColor = a.getInt(R.styleable.DefaultTimeBar_played_color, -1);
                int scrubberColor = a.getInt(R.styleable.DefaultTimeBar_scrubber_color, -1);
                int bufferedColor = a.getInt(R.styleable.DefaultTimeBar_buffered_color, -855638017);
                int unplayedColor = a.getInt(R.styleable.DefaultTimeBar_unplayed_color, 0x33FFFFFF);
                int adMarkerColor = a.getInt(R.styleable.DefaultTimeBar_ad_marker_color, -1291845888);
                int playedAdMarkerColor = a.getInt(R.styleable.DefaultTimeBar_played_ad_marker_color, 0x33FFFF00);
                this.playedPaint.setColor(playedColor);
                this.scrubberPaint.setColor(scrubberColor);
                this.bufferedPaint.setColor(bufferedColor);
                this.unplayedPaint.setColor(unplayedColor);
                this.adMarkerPaint.setColor(adMarkerColor);
                this.playedAdMarkerPaint.setColor(playedAdMarkerColor);
            }
            finally {
                a.recycle();
            }
        } else {
            this.barHeight = defaultBarHeight;
            this.touchTargetHeight = defaultTouchTargetHeight;
            this.adMarkerWidth = defaultAdMarkerWidth;
            this.scrubberEnabledSize = defaultScrubberEnabledSize;
            this.scrubberDisabledSize = defaultScrubberDisabledSize;
            this.scrubberDraggedSize = defaultScrubberDraggedSize;
            this.playedPaint.setColor(-1);
            this.scrubberPaint.setColor(-1);
            this.bufferedPaint.setColor(-855638017);
            this.unplayedPaint.setColor(0x33FFFFFF);
            this.adMarkerPaint.setColor(-1291845888);
            this.playedAdMarkerPaint.setColor(0x33FFFF00);
            this.scrubberDrawable = null;
        }
        this.formatBuilder = new StringBuilder();
        this.formatter = new Formatter(this.formatBuilder, Locale.getDefault());
        this.stopScrubbingRunnable = new Runnable(){

            @Override
            public final void run() {
                this.stopScrubbing(false);
            }
        };
        if (this.scrubberDrawable != null) {
            Drawable drawable4 = this.scrubberDrawable;
            if (drawable4 == null) {
                Intrinsics.throwNpe();
            }
            n = (drawable4.getMinimumWidth() + 1) / 2;
        } else {
            n = (Math.max(this.scrubberDisabledSize, Math.max(this.scrubberEnabledSize, this.scrubberDraggedSize)) + 1) / 2;
        }
        this.scrubberPadding = n;
        this.duration = -9223372036854775807L;
        this.keyTimeIncrement = -9223372036854775807L;
        this.keyCountIncrement = 20;
        this.setFocusable(true);
        if (this.getImportantForAccessibility() == 0) {
            this.setImportantForAccessibility(1);
        }
    }

    public /* synthetic */ MLSTimeBar(Context context, AttributeSet attributeSet, int n, AttributeSet attributeSet2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        if ((n2 & 8) != 0) {
            attributeSet2 = attributeSet;
        }
        this(context, attributeSet, n, attributeSet2);
    }

    @JvmOverloads
    public MLSTimeBar(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, null, 8, null);
    }

    @JvmOverloads
    public MLSTimeBar(@NotNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0, null, 12, null);
    }

    @JvmOverloads
    public MLSTimeBar(@NotNull Context context) {
        this(context, null, 0, null, 14, null);
    }

    public static final /* synthetic */ TimelineMarkerPosition access$getTimelineMarkerPositionListener$p(MLSTimeBar $this) {
        TimelineMarkerPosition timelineMarkerPosition = $this.timelineMarkerPositionListener;
        if (timelineMarkerPosition == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"timelineMarkerPositionListener");
        }
        return timelineMarkerPosition;
    }

    public static final /* synthetic */ void access$setTimelineMarkerPositionListener$p(MLSTimeBar $this, TimelineMarkerPosition timelineMarkerPosition) {
        $this.timelineMarkerPositionListener = timelineMarkerPosition;
    }

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u000f\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0006H\u0002J\u0018\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u0006H\u0002J\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0006H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Ltv/mycujoo/mcls/widgets/mlstimebar/MLSTimeBar$Companion;", "", "()V", "ACCESSIBILITY_CLASS_NAME", "", "DEFAULT_AD_MARKER_COLOR", "", "DEFAULT_AD_MARKER_WIDTH_DP", "DEFAULT_BAR_HEIGHT_DP", "DEFAULT_BUFFERED_COLOR", "DEFAULT_INCREMENT_COUNT", "DEFAULT_PLAYED_AD_MARKER_COLOR", "DEFAULT_PLAYED_COLOR", "DEFAULT_SCRUBBER_COLOR", "DEFAULT_SCRUBBER_DISABLED_SIZE_DP", "DEFAULT_SCRUBBER_DRAGGED_SIZE_DP", "DEFAULT_SCRUBBER_ENABLED_SIZE_DP", "DEFAULT_TOUCH_TARGET_HEIGHT_DP", "DEFAULT_UNPLAYED_COLOR", "FINE_SCRUB_RATIO", "FINE_SCRUB_Y_THRESHOLD_DP", "STOP_SCRUBBING_TIMEOUT_MS", "", "dpToPx", "density", "", "dps", "pxToDp", "px", "setDrawableLayoutDirection", "", "drawable", "Landroid/graphics/drawable/Drawable;", "layoutDirection", "mls_release"})
    public static final class Companion {
        private final boolean setDrawableLayoutDirection(Drawable drawable2, int layoutDirection) {
            return Util.SDK_INT >= 23 && drawable2.setLayoutDirection(layoutDirection);
        }

        private final int dpToPx(float density, int dps) {
            return (int)((float)dps * density + 0.5f);
        }

        private final int pxToDp(float density, int px) {
            return (int)((float)px / density);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

