/*
 * Decompiled with CFR 0.152.
 */
package tv.mycujoo.mcls.tv.widgets;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.os.Bundle;
import android.util.AttributeSet;
import android.view.View;
import android.widget.SeekBar;
import java.util.ArrayList;
import java.util.HashMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tv.mycujoo.mcls.R;
import tv.mycujoo.mcls.manager.SeekBarListener;
import tv.mycujoo.mcls.widgets.mlstimebar.PointOfInterest;
import tv.mycujoo.mcls.widgets.mlstimebar.PositionedPointOfInterest;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0012\u0018\u00002\u00020\u0001:\u0001YB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020!J\b\u00102\u001a\u000200H\u0002J\u0006\u00103\u001a\u000200J\b\u00104\u001a\u000205H\u0016J\u0006\u00106\u001a\u00020\nJ\u0010\u00107\u001a\u0002002\u0006\u00108\u001a\u000209H\u0014J\"\u0010:\u001a\u0002002\u0006\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020\n2\b\u0010>\u001a\u0004\u0018\u00010?H\u0014J(\u0010@\u001a\u0002002\u0006\u0010A\u001a\u00020\n2\u0006\u0010B\u001a\u00020\n2\u0006\u0010C\u001a\u00020\n2\u0006\u0010D\u001a\u00020\nH\u0014J\u0018\u0010E\u001a\u00020<2\u0006\u0010F\u001a\u00020\n2\u0006\u0010G\u001a\u00020HH\u0016J\u0010\u0010I\u001a\u0002002\b\u0010J\u001a\u0004\u0018\u00010\bJ\u000e\u0010K\u001a\u0002002\u0006\u0010L\u001a\u00020\nJ\u000e\u0010M\u001a\u0002002\u0006\u0010N\u001a\u00020\nJ\u000e\u0010O\u001a\u0002002\u0006\u0010P\u001a\u00020\nJ\u000e\u0010Q\u001a\u0002002\u0006\u0010R\u001a\u00020.J\u000e\u0010S\u001a\u0002002\u0006\u0010T\u001a\u00020\nJ\u000e\u0010U\u001a\u0002002\u0006\u0010'\u001a\u00020\nJ\u000e\u0010V\u001a\u0002002\u0006\u0010T\u001a\u00020\nJ\u000e\u0010W\u001a\u0002002\u0006\u0010+\u001a\u00020,J\u000e\u0010X\u001a\u0002002\u0006\u0010-\u001a\u00020.R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u001a\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\n8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u0014\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010%\u001a\u00020\n2\u0006\u0010$\u001a\u00020\n@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010\u001cR$\u0010(\u001a\u00020\n2\u0006\u0010'\u001a\u00020\n8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b)\u0010\u001c\"\u0004\b*\u0010\u001eR\u000e\u0010+\u001a\u00020,X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020.X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006Z"}, d2={"Ltv/mycujoo/mcls/tv/widgets/MLSSeekBar;", "Landroid/view/View;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "mAccessibilitySeekListener", "Ltv/mycujoo/mcls/tv/widgets/MLSSeekBar$AccessibilitySeekListener;", "mActiveBarHeight", "", "mActiveRadius", "mBackgroundPaint", "Landroid/graphics/Paint;", "mBackgroundRect", "Landroid/graphics/RectF;", "mBarHeight", "mKnobPaint", "mKnobx", "mMarkerPaint", "mMax", "mProgress", "mProgressPaint", "mProgressRect", "mSecondProgressPaint", "mSecondProgressRect", "max", "getMax", "()I", "setMax", "(I)V", "poiArrayList", "Ljava/util/ArrayList;", "Ltv/mycujoo/mcls/widgets/mlstimebar/PointOfInterest;", "poiPositionsOnScreen", "Ltv/mycujoo/mcls/widgets/mlstimebar/PositionedPointOfInterest;", "<set-?>", "secondProgress", "getSecondProgress", "color", "secondaryProgressColor", "getSecondaryProgressColor", "setSecondaryProgressColor", "seekBarListener", "Ltv/mycujoo/mcls/manager/SeekBarListener;", "totalTime", "", "addTimeLineHighlight", "", "poi", "calculate", "clearTimeLineMarker", "getAccessibilityClassName", "", "getProgress", "onDraw", "canvas", "Landroid/graphics/Canvas;", "onFocusChanged", "gainFocus", "", "direction", "previouslyFocusedRect", "Landroid/graphics/Rect;", "onSizeChanged", "w", "h", "oldw", "oldh", "performAccessibilityAction", "action", "arguments", "Landroid/os/Bundle;", "setAccessibilitySeekListener", "listener", "setActiveBarHeight", "activeBarHeight", "setActiveRadius", "radius", "setBarHeight", "barHeight", "setCurrentTimeBySeek", "pos", "setProgress", "progress", "setProgressColor", "setSecondaryProgress", "setSeekbarListener", "setTotalTime", "AccessibilitySeekListener", "mls_release"})
public final class MLSSeekBar
extends View {
    private final RectF mProgressRect;
    private final RectF mSecondProgressRect;
    private final RectF mBackgroundRect;
    private final Paint mSecondProgressPaint;
    private final Paint mProgressPaint;
    private final Paint mBackgroundPaint;
    private final Paint mKnobPaint;
    private final Paint mMarkerPaint;
    private int mProgress;
    private int secondProgress;
    private int mMax;
    private int mKnobx;
    private int mActiveRadius;
    private int mBarHeight;
    private int mActiveBarHeight;
    private AccessibilitySeekListener mAccessibilitySeekListener;
    private SeekBarListener seekBarListener;
    private final ArrayList<PointOfInterest> poiArrayList;
    private final ArrayList<PositionedPointOfInterest> poiPositionsOnScreen;
    private long totalTime;
    private HashMap _$_findViewCache;

    public final int getSecondProgress() {
        return this.secondProgress;
    }

    public final void addTimeLineHighlight(@NotNull PointOfInterest poi) {
        Intrinsics.checkParameterIsNotNull((Object)poi, (String)"poi");
        this.poiArrayList.add(poi);
        this.poiPositionsOnScreen.add(new PositionedPointOfInterest(-1, poi));
    }

    public final void clearTimeLineMarker() {
        this.poiArrayList.clear();
        this.poiPositionsOnScreen.clear();
    }

    public final void setSeekbarListener(@NotNull SeekBarListener seekBarListener) {
        Intrinsics.checkParameterIsNotNull((Object)seekBarListener, (String)"seekBarListener");
        this.seekBarListener = seekBarListener;
    }

    public final void setActiveRadius(int radius) {
        this.mActiveRadius = radius;
        this.calculate();
    }

    public final void setBarHeight(int barHeight) {
        this.mBarHeight = barHeight;
        this.calculate();
    }

    public final void setActiveBarHeight(int activeBarHeight) {
        this.mActiveBarHeight = activeBarHeight;
        this.calculate();
    }

    protected void onFocusChanged(boolean gainFocus, int direction, @Nullable Rect previouslyFocusedRect) {
        super.onFocusChanged(gainFocus, direction, previouslyFocusedRect);
        this.calculate();
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.calculate();
    }

    /*
     * WARNING - void declaration
     */
    protected void onDraw(@NotNull Canvas canvas) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        super.onDraw(canvas);
        int radius = this.isFocused() ? this.mActiveRadius : this.mBarHeight / 2;
        canvas.drawRoundRect(this.mBackgroundRect, (float)radius, (float)radius, this.mBackgroundPaint);
        if (this.mSecondProgressRect.right > this.mSecondProgressRect.left) {
            canvas.drawRoundRect(this.mSecondProgressRect, (float)radius, (float)radius, this.mSecondProgressPaint);
        }
        canvas.drawRoundRect(this.mProgressRect, (float)radius, (float)radius, this.mProgressPaint);
        Iterable $this$forEachIndexed$iv = this.poiArrayList;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void poi;
            int n = index$iv++;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            int n2 = n;
            PointOfInterest pointOfInterest = (PointOfInterest)item$iv;
            int index = n2;
            boolean bl2 = false;
            long poiOffsetAdjusted = 0L;
            long l = poi.getOffset() + poi.getSeekOffset();
            if (0L > l || this.totalTime < l) {
                this.poiPositionsOnScreen.get(index).setPositionOnScreen(-1);
                return;
            }
            poiOffsetAdjusted = poi.getOffset() + poi.getSeekOffset();
            this.mMarkerPaint.setColor(Color.parseColor((String)poi.getPoiType().getColor()));
            int markerPositionOffset = (int)((long)this.getWidth() * poiOffsetAdjusted / this.totalTime);
            float markerLeft = this.mProgressRect.left + (float)Math.min((int)this.mBackgroundRect.width() - 4, Math.max(0, markerPositionOffset));
            float markerRight = markerLeft + (float)4;
            canvas.drawRect(markerLeft, this.mSecondProgressRect.top, markerRight, this.mSecondProgressRect.bottom, this.mMarkerPaint);
            this.poiPositionsOnScreen.get(index).setPositionOnScreen((int)((markerLeft + markerRight) / (float)2));
        }
        canvas.drawCircle((float)this.mKnobx, (float)this.getHeight() / (float)2, (float)radius, this.mKnobPaint);
    }

    public final void setSecondaryProgress(int progress) {
        int progress2 = progress;
        if (progress2 > this.mMax) {
            progress2 = this.mMax;
        } else if (progress2 < 0) {
            progress2 = 0;
        }
        this.secondProgress = progress2;
        this.calculate();
    }

    public final int getProgress() {
        return this.mProgress;
    }

    public final void setProgress(int progress) {
        int progress2 = progress;
        if (progress2 > this.mMax) {
            progress2 = this.mMax;
        } else if (progress2 < 0) {
            progress2 = 0;
        }
        this.mProgress = progress2;
        this.calculate();
    }

    public final void setCurrentTimeBySeek(long pos) {
        double ratio = (double)pos / (double)this.totalTime;
        SeekBarListener seekBarListener = this.seekBarListener;
        if (seekBarListener == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"seekBarListener");
        }
        seekBarListener.onSeekTo((int)(ratio * (double)this.mBackgroundRect.width()), this.poiPositionsOnScreen);
    }

    public final int getMax() {
        return this.mMax;
    }

    public final void setMax(int max) {
        this.mMax = max;
        this.calculate();
    }

    public final void setTotalTime(long totalTime) {
        this.totalTime = totalTime;
    }

    public final void setProgressColor(int color2) {
        this.mProgressPaint.setColor(color2);
    }

    public final int getSecondaryProgressColor() {
        return this.mSecondProgressPaint.getColor();
    }

    public final void setSecondaryProgressColor(int color2) {
        this.mSecondProgressPaint.setColor(color2);
    }

    private final void calculate() {
        int barHeight = this.isFocused() ? this.mActiveBarHeight : this.mBarHeight;
        int width = this.getWidth();
        int height = this.getHeight();
        int verticalPadding = (height - barHeight) / 2;
        this.mBackgroundRect.set((float)this.mBarHeight / (float)2, (float)verticalPadding, (float)width - (float)this.mBarHeight / (float)2, (float)height - (float)verticalPadding);
        int radius = this.isFocused() ? this.mActiveRadius : this.mBarHeight / 2;
        int progressWidth = width - radius * 2;
        float progressPixels = (float)this.mProgress / (float)this.mMax * (float)progressWidth;
        this.mProgressRect.set((float)this.mBarHeight / (float)2, (float)verticalPadding, (float)(this.mBarHeight / 2) + progressPixels, (float)height - (float)verticalPadding);
        float secondProgressPixels = (float)this.secondProgress / (float)this.mMax * (float)progressWidth;
        this.mSecondProgressRect.set(this.mProgressRect.right, (float)verticalPadding, (float)(this.mBarHeight / 2) + secondProgressPixels, (float)height - (float)verticalPadding);
        this.mKnobx = radius + (int)progressPixels;
        this.invalidate();
    }

    @NotNull
    public CharSequence getAccessibilityClassName() {
        String string2 = SeekBar.class.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"SeekBar::class.java.name");
        return string2;
    }

    public final void setAccessibilitySeekListener(@Nullable AccessibilitySeekListener listener) {
        this.mAccessibilitySeekListener = listener;
    }

    public boolean performAccessibilityAction(int action, @NotNull Bundle arguments) {
        Intrinsics.checkParameterIsNotNull((Object)arguments, (String)"arguments");
        if (this.mAccessibilitySeekListener != null) {
            switch (action) {
                case 4096: {
                    AccessibilitySeekListener accessibilitySeekListener = this.mAccessibilitySeekListener;
                    if (accessibilitySeekListener == null) {
                        Intrinsics.throwNpe();
                    }
                    return accessibilitySeekListener.onAccessibilitySeekForward();
                }
                case 8192: {
                    AccessibilitySeekListener accessibilitySeekListener = this.mAccessibilitySeekListener;
                    if (accessibilitySeekListener == null) {
                        Intrinsics.throwNpe();
                    }
                    return accessibilitySeekListener.onAccessibilitySeekBackward();
                }
            }
        }
        return super.performAccessibilityAction(action, arguments);
    }

    public MLSSeekBar(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context, attrs);
        this.mProgressRect = new RectF();
        this.mSecondProgressRect = new RectF();
        this.mBackgroundRect = new RectF();
        this.mSecondProgressPaint = new Paint(1);
        this.mProgressPaint = new Paint(1);
        this.mBackgroundPaint = new Paint(1);
        this.mKnobPaint = new Paint(1);
        this.mMarkerPaint = new Paint(1);
        this.poiArrayList = new ArrayList();
        this.poiPositionsOnScreen = new ArrayList();
        this.setWillNotDraw(false);
        this.mBackgroundPaint.setColor(-7829368);
        this.mSecondProgressPaint.setColor(-3355444);
        this.mProgressPaint.setColor(-65536);
        this.mKnobPaint.setColor(-1);
        this.mMarkerPaint.setColor(-65536);
        this.mBarHeight = context.getResources().getDimensionPixelSize(R.dimen.lb_playback_transport_progressbar_bar_height);
        this.mActiveBarHeight = context.getResources().getDimensionPixelSize(R.dimen.lb_playback_transport_progressbar_active_bar_height);
        this.mActiveRadius = context.getResources().getDimensionPixelSize(R.dimen.lb_playback_transport_progressbar_active_radius);
    }

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H&J\b\u0010\u0005\u001a\u00020\u0004H&\u00a8\u0006\u0006"}, d2={"Ltv/mycujoo/mcls/tv/widgets/MLSSeekBar$AccessibilitySeekListener;", "", "()V", "onAccessibilitySeekBackward", "", "onAccessibilitySeekForward", "mls_release"})
    public static abstract class AccessibilitySeekListener {
        public abstract boolean onAccessibilitySeekForward();

        public abstract boolean onAccessibilitySeekBackward();
    }
}

