/*
 * Decompiled with CFR 0.152.
 */
package tv.mycujoo.mcls.network.socket;

import android.util.Log;
import kotlin.Metadata;
import kotlin.UninitializedPropertyAccessException;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import org.jetbrains.annotations.NotNull;
import tv.mycujoo.mcls.model.JoinTimelineParam;
import tv.mycujoo.mcls.network.socket.IReactorSocket;
import tv.mycujoo.mcls.network.socket.MainWebSocketListener;
import tv.mycujoo.mcls.network.socket.ReactorCallback;
import tv.mycujoo.mcls.network.socket.ReactorListener;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0013H\u0002J\b\u0010\u0017\u001a\u00020\u0013H\u0002J\u0010\u0010\u0018\u001a\u00020\u00132\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\bH\u0016J\u0006\u0010\u001e\u001a\u00020\u0013J\u0010\u0010\u001f\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u000bH\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Ltv/mycujoo/mcls/network/socket/ReactorSocket;", "Ltv/mycujoo/mcls/network/socket/IReactorSocket;", "okHttpClient", "Lokhttp3/OkHttpClient;", "mainSocketListener", "Ltv/mycujoo/mcls/network/socket/MainWebSocketListener;", "(Lokhttp3/OkHttpClient;Ltv/mycujoo/mcls/network/socket/MainWebSocketListener;)V", "connected", "", "created", "eventId", "", "joinedTimeline", "timelineId", "updateId", "uuid", "webSocket", "Lokhttp3/WebSocket;", "addListener", "", "reactorCallback", "Ltv/mycujoo/mcls/network/socket/ReactorCallback;", "createSocket", "destroySocket", "joinEvent", "joinTimeline", "param", "Ltv/mycujoo/mcls/model/JoinTimelineParam;", "leave", "destroyAfter", "leaveTimeline", "setUUID", "mls_release"})
public final class ReactorSocket
implements IReactorSocket {
    private WebSocket webSocket;
    private String uuid;
    private boolean created;
    private boolean connected;
    private boolean joinedTimeline;
    private String eventId;
    private String timelineId;
    private String updateId;
    private final OkHttpClient okHttpClient;
    private final MainWebSocketListener mainSocketListener;

    @Override
    public void addListener(@NotNull ReactorCallback reactorCallback) {
        Intrinsics.checkParameterIsNotNull((Object)reactorCallback, (String)"reactorCallback");
        this.mainSocketListener.addListener(new ReactorListener(reactorCallback));
    }

    @Override
    public void setUUID(@NotNull String uuid) {
        Intrinsics.checkParameterIsNotNull((Object)uuid, (String)"uuid");
        this.uuid = uuid;
    }

    @Override
    public void joinEvent(@NotNull String eventId) {
        Intrinsics.checkParameterIsNotNull((Object)eventId, (String)"eventId");
        if (!(this.uuid != null)) {
            throw (Throwable)new UninitializedPropertyAccessException("uuid must be initialized");
        }
        if (this.connected) {
            this.leave(false);
        }
        if (!this.created) {
            this.createSocket();
        }
        this.eventId = eventId;
        if (!(this.webSocket != null)) {
            Log.e((String)ReactorSocket.class.getCanonicalName(), (String)"webSocket must be initialized");
            return;
        }
        WebSocket webSocket = this.webSocket;
        if (webSocket == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"webSocket");
        }
        webSocket.send("joinEvent;" + eventId);
        this.connected = true;
    }

    @Override
    public void leave(boolean destroyAfter) {
        if (this.created && this.connected) {
            if (this.timelineId != null && this.joinedTimeline) {
                WebSocket webSocket = this.webSocket;
                if (webSocket == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"webSocket");
                }
                StringBuilder stringBuilder = new StringBuilder().append("leaveTimeline;");
                String string2 = this.timelineId;
                if (string2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"timelineId");
                }
                webSocket.send(stringBuilder.append(string2).toString());
                this.joinedTimeline = false;
            }
            WebSocket webSocket = this.webSocket;
            if (webSocket == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"webSocket");
            }
            StringBuilder stringBuilder = new StringBuilder().append("leaveEvent;");
            String string3 = this.eventId;
            if (string3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"eventId");
            }
            webSocket.send(stringBuilder.append(string3).toString());
            this.connected = false;
            if (destroyAfter) {
                this.destroySocket();
            }
        }
    }

    @Override
    public void joinTimeline(@NotNull JoinTimelineParam param) {
        Intrinsics.checkParameterIsNotNull((Object)param, (String)"param");
        if (!this.created || !this.connected) {
            return;
        }
        if (this.timelineId != null) {
            String string2 = this.timelineId;
            if (string2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"timelineId");
            }
            if (Intrinsics.areEqual((Object)string2, (Object)param.getTimelineId()) ^ true) {
                this.leaveTimeline();
            }
        }
        if (param.getLastActionId() != null) {
            this.timelineId = param.getTimelineId();
            this.updateId = param.getLastActionId();
            WebSocket webSocket = this.webSocket;
            if (webSocket == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"webSocket");
            }
            webSocket.send("joinTimeline;" + param.getTimelineId() + ';' + param.getLastActionId());
        } else {
            this.timelineId = param.getTimelineId();
            WebSocket webSocket = this.webSocket;
            if (webSocket == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"webSocket");
            }
            webSocket.send("joinTimeline;" + param.getTimelineId() + ';');
        }
        this.joinedTimeline = true;
    }

    public final void leaveTimeline() {
        if (this.timelineId != null && this.joinedTimeline) {
            WebSocket webSocket = this.webSocket;
            if (webSocket == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"webSocket");
            }
            StringBuilder stringBuilder = new StringBuilder().append("leaveTimeline;");
            String string2 = this.timelineId;
            if (string2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"timelineId");
            }
            webSocket.send(stringBuilder.append(string2).toString());
            this.joinedTimeline = false;
        }
    }

    private final void createSocket() {
        Request request = new Request.Builder().url("wss://mls-rt.mycujoo.tv").build();
        WebSocket webSocket = this.okHttpClient.newWebSocket(request, (WebSocketListener)this.mainSocketListener);
        Intrinsics.checkExpressionValueIsNotNull((Object)webSocket, (String)"okHttpClient.newWebSocke\u2026uest, mainSocketListener)");
        this.webSocket = webSocket;
        this.created = true;
        WebSocket webSocket2 = this.webSocket;
        if (webSocket2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"webSocket");
        }
        StringBuilder stringBuilder = new StringBuilder().append("sessionId;");
        String string2 = this.uuid;
        if (string2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"uuid");
        }
        webSocket2.send(stringBuilder.append(string2).toString());
    }

    private final void destroySocket() {
        WebSocket webSocket = this.webSocket;
        if (webSocket == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"webSocket");
        }
        webSocket.close(1000, null);
        this.created = false;
    }

    public ReactorSocket(@NotNull OkHttpClient okHttpClient, @NotNull MainWebSocketListener mainSocketListener) {
        Intrinsics.checkParameterIsNotNull((Object)okHttpClient, (String)"okHttpClient");
        Intrinsics.checkParameterIsNotNull((Object)((Object)mainSocketListener), (String)"mainSocketListener");
        this.okHttpClient = okHttpClient;
        this.mainSocketListener = mainSocketListener;
    }

    public static final /* synthetic */ String access$getUuid$p(ReactorSocket $this) {
        String string2 = $this.uuid;
        if (string2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"uuid");
        }
        return string2;
    }

    public static final /* synthetic */ void access$setUuid$p(ReactorSocket $this, String string2) {
        $this.uuid = string2;
    }

    public static final /* synthetic */ WebSocket access$getWebSocket$p(ReactorSocket $this) {
        WebSocket webSocket = $this.webSocket;
        if (webSocket == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"webSocket");
        }
        return webSocket;
    }

    public static final /* synthetic */ void access$setWebSocket$p(ReactorSocket $this, WebSocket webSocket) {
        $this.webSocket = webSocket;
    }

    public static final /* synthetic */ String access$getTimelineId$p(ReactorSocket $this) {
        String string2 = $this.timelineId;
        if (string2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"timelineId");
        }
        return string2;
    }

    public static final /* synthetic */ void access$setTimelineId$p(ReactorSocket $this, String string2) {
        $this.timelineId = string2;
    }
}

