/*
 * Decompiled with CFR 0.152.
 */
package tv.mycujoo.mcls.network.socket;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tv.mycujoo.mcls.network.socket.ReactorCallback;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\rB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Ltv/mycujoo/mcls/network/socket/ReactorListener;", "Lokhttp3/WebSocketListener;", "reactorCallback", "Ltv/mycujoo/mcls/network/socket/ReactorCallback;", "(Ltv/mycujoo/mcls/network/socket/ReactorCallback;)V", "onMessage", "", "webSocket", "Lokhttp3/WebSocket;", "text", "", "parseMessage", "Ltv/mycujoo/mcls/network/socket/ReactorListener$ReactorMessage;", "ReactorMessage", "mls_release"})
public final class ReactorListener
extends WebSocketListener {
    private final ReactorCallback reactorCallback;

    public void onMessage(@NotNull WebSocket webSocket, @NotNull String text) {
        Intrinsics.checkParameterIsNotNull((Object)webSocket, (String)"webSocket");
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        super.onMessage(webSocket, text);
        ReactorMessage reactorMessage = this.parseMessage(text);
        if (reactorMessage instanceof ReactorMessage.EventUpdate) {
            this.reactorCallback.onEventUpdate(((ReactorMessage.EventUpdate)reactorMessage).getEventId(), ((ReactorMessage.EventUpdate)reactorMessage).getUpdatedEventId());
        } else if (reactorMessage instanceof ReactorMessage.CounterUpdate) {
            this.reactorCallback.onCounterUpdate(((ReactorMessage.CounterUpdate)reactorMessage).getCounts());
        } else if (reactorMessage instanceof ReactorMessage.TimelineUpdate) {
            this.reactorCallback.onTimelineUpdate(((ReactorMessage.TimelineUpdate)reactorMessage).getTimelineId(), ((ReactorMessage.TimelineUpdate)reactorMessage).getUpdatedEventId());
        } else if (!(reactorMessage instanceof ReactorMessage.Unsupported)) {
            // empty if block
        }
    }

    private final ReactorMessage parseMessage(String text) {
        List split = StringsKt.split$default((CharSequence)text, (String[])new String[]{";"}, (boolean)false, (int)0, (int)6, null);
        if (split.size() >= 3 && Intrinsics.areEqual((Object)((String)split.get(0)), (Object)"eventTotal")) {
            return new ReactorMessage.CounterUpdate((String)split.get(2));
        }
        if (split.size() >= 3 && Intrinsics.areEqual((Object)((String)split.get(0)), (Object)"eventUpdate")) {
            return new ReactorMessage.EventUpdate((String)split.get(1), (String)split.get(2));
        }
        if (split.size() >= 3 && Intrinsics.areEqual((Object)((String)split.get(0)), (Object)"timelineUpdate")) {
            return new ReactorMessage.TimelineUpdate((String)split.get(1), (String)split.get(2));
        }
        return new ReactorMessage.Unsupported(null, 1, null);
    }

    public ReactorListener(@NotNull ReactorCallback reactorCallback) {
        Intrinsics.checkParameterIsNotNull((Object)reactorCallback, (String)"reactorCallback");
        this.reactorCallback = reactorCallback;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0004\u0003\u0004\u0005\u0006B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0004\u0007\b\t\n\u00a8\u0006\u000b"}, d2={"Ltv/mycujoo/mcls/network/socket/ReactorListener$ReactorMessage;", "", "()V", "CounterUpdate", "EventUpdate", "TimelineUpdate", "Unsupported", "Ltv/mycujoo/mcls/network/socket/ReactorListener$ReactorMessage$EventUpdate;", "Ltv/mycujoo/mcls/network/socket/ReactorListener$ReactorMessage$CounterUpdate;", "Ltv/mycujoo/mcls/network/socket/ReactorListener$ReactorMessage$TimelineUpdate;", "Ltv/mycujoo/mcls/network/socket/ReactorListener$ReactorMessage$Unsupported;", "mls_release"})
    public static abstract class ReactorMessage {
        private ReactorMessage() {
        }

        public /* synthetic */ ReactorMessage(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0013"}, d2={"Ltv/mycujoo/mcls/network/socket/ReactorListener$ReactorMessage$EventUpdate;", "Ltv/mycujoo/mcls/network/socket/ReactorListener$ReactorMessage;", "eventId", "", "updatedEventId", "(Ljava/lang/String;Ljava/lang/String;)V", "getEventId", "()Ljava/lang/String;", "getUpdatedEventId", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "mls_release"})
        public static final class EventUpdate
        extends ReactorMessage {
            @NotNull
            private final String eventId;
            @NotNull
            private final String updatedEventId;

            @NotNull
            public final String getEventId() {
                return this.eventId;
            }

            @NotNull
            public final String getUpdatedEventId() {
                return this.updatedEventId;
            }

            public EventUpdate(@NotNull String eventId, @NotNull String updatedEventId) {
                Intrinsics.checkParameterIsNotNull((Object)eventId, (String)"eventId");
                Intrinsics.checkParameterIsNotNull((Object)updatedEventId, (String)"updatedEventId");
                super(null);
                this.eventId = eventId;
                this.updatedEventId = updatedEventId;
            }

            @NotNull
            public final String component1() {
                return this.eventId;
            }

            @NotNull
            public final String component2() {
                return this.updatedEventId;
            }

            @NotNull
            public final EventUpdate copy(@NotNull String eventId, @NotNull String updatedEventId) {
                Intrinsics.checkParameterIsNotNull((Object)eventId, (String)"eventId");
                Intrinsics.checkParameterIsNotNull((Object)updatedEventId, (String)"updatedEventId");
                return new EventUpdate(eventId, updatedEventId);
            }

            public static /* synthetic */ EventUpdate copy$default(EventUpdate eventUpdate, String string2, String string3, int n, Object object) {
                if ((n & 1) != 0) {
                    string2 = eventUpdate.eventId;
                }
                if ((n & 2) != 0) {
                    string3 = eventUpdate.updatedEventId;
                }
                return eventUpdate.copy(string2, string3);
            }

            @NotNull
            public String toString() {
                return "EventUpdate(eventId=" + this.eventId + ", updatedEventId=" + this.updatedEventId + ")";
            }

            public int hashCode() {
                String string2 = this.eventId;
                String string3 = this.updatedEventId;
                return (string2 != null ? string2.hashCode() : 0) * 31 + (string3 != null ? string3.hashCode() : 0);
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof EventUpdate)) break block3;
                        EventUpdate eventUpdate = (EventUpdate)object;
                        if (!Intrinsics.areEqual((Object)this.eventId, (Object)eventUpdate.eventId) || !Intrinsics.areEqual((Object)this.updatedEventId, (Object)eventUpdate.updatedEventId)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Ltv/mycujoo/mcls/network/socket/ReactorListener$ReactorMessage$CounterUpdate;", "Ltv/mycujoo/mcls/network/socket/ReactorListener$ReactorMessage;", "counts", "", "(Ljava/lang/String;)V", "getCounts", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "mls_release"})
        public static final class CounterUpdate
        extends ReactorMessage {
            @NotNull
            private final String counts;

            @NotNull
            public final String getCounts() {
                return this.counts;
            }

            public CounterUpdate(@NotNull String counts) {
                Intrinsics.checkParameterIsNotNull((Object)counts, (String)"counts");
                super(null);
                this.counts = counts;
            }

            @NotNull
            public final String component1() {
                return this.counts;
            }

            @NotNull
            public final CounterUpdate copy(@NotNull String counts) {
                Intrinsics.checkParameterIsNotNull((Object)counts, (String)"counts");
                return new CounterUpdate(counts);
            }

            public static /* synthetic */ CounterUpdate copy$default(CounterUpdate counterUpdate, String string2, int n, Object object) {
                if ((n & 1) != 0) {
                    string2 = counterUpdate.counts;
                }
                return counterUpdate.copy(string2);
            }

            @NotNull
            public String toString() {
                return "CounterUpdate(counts=" + this.counts + ")";
            }

            public int hashCode() {
                String string2 = this.counts;
                return string2 != null ? string2.hashCode() : 0;
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof CounterUpdate)) break block3;
                        CounterUpdate counterUpdate = (CounterUpdate)object;
                        if (!Intrinsics.areEqual((Object)this.counts, (Object)counterUpdate.counts)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0013"}, d2={"Ltv/mycujoo/mcls/network/socket/ReactorListener$ReactorMessage$TimelineUpdate;", "Ltv/mycujoo/mcls/network/socket/ReactorListener$ReactorMessage;", "timelineId", "", "updatedEventId", "(Ljava/lang/String;Ljava/lang/String;)V", "getTimelineId", "()Ljava/lang/String;", "getUpdatedEventId", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "mls_release"})
        public static final class TimelineUpdate
        extends ReactorMessage {
            @NotNull
            private final String timelineId;
            @NotNull
            private final String updatedEventId;

            @NotNull
            public final String getTimelineId() {
                return this.timelineId;
            }

            @NotNull
            public final String getUpdatedEventId() {
                return this.updatedEventId;
            }

            public TimelineUpdate(@NotNull String timelineId, @NotNull String updatedEventId) {
                Intrinsics.checkParameterIsNotNull((Object)timelineId, (String)"timelineId");
                Intrinsics.checkParameterIsNotNull((Object)updatedEventId, (String)"updatedEventId");
                super(null);
                this.timelineId = timelineId;
                this.updatedEventId = updatedEventId;
            }

            @NotNull
            public final String component1() {
                return this.timelineId;
            }

            @NotNull
            public final String component2() {
                return this.updatedEventId;
            }

            @NotNull
            public final TimelineUpdate copy(@NotNull String timelineId, @NotNull String updatedEventId) {
                Intrinsics.checkParameterIsNotNull((Object)timelineId, (String)"timelineId");
                Intrinsics.checkParameterIsNotNull((Object)updatedEventId, (String)"updatedEventId");
                return new TimelineUpdate(timelineId, updatedEventId);
            }

            public static /* synthetic */ TimelineUpdate copy$default(TimelineUpdate timelineUpdate, String string2, String string3, int n, Object object) {
                if ((n & 1) != 0) {
                    string2 = timelineUpdate.timelineId;
                }
                if ((n & 2) != 0) {
                    string3 = timelineUpdate.updatedEventId;
                }
                return timelineUpdate.copy(string2, string3);
            }

            @NotNull
            public String toString() {
                return "TimelineUpdate(timelineId=" + this.timelineId + ", updatedEventId=" + this.updatedEventId + ")";
            }

            public int hashCode() {
                String string2 = this.timelineId;
                String string3 = this.updatedEventId;
                return (string2 != null ? string2.hashCode() : 0) * 31 + (string3 != null ? string3.hashCode() : 0);
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof TimelineUpdate)) break block3;
                        TimelineUpdate timelineUpdate = (TimelineUpdate)object;
                        if (!Intrinsics.areEqual((Object)this.timelineId, (Object)timelineUpdate.timelineId) || !Intrinsics.areEqual((Object)this.updatedEventId, (Object)timelineUpdate.updatedEventId)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Ltv/mycujoo/mcls/network/socket/ReactorListener$ReactorMessage$Unsupported;", "Ltv/mycujoo/mcls/network/socket/ReactorListener$ReactorMessage;", "message", "", "(Ljava/lang/String;)V", "getMessage", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "mls_release"})
        public static final class Unsupported
        extends ReactorMessage {
            @NotNull
            private final String message;

            @NotNull
            public final String getMessage() {
                return this.message;
            }

            public Unsupported(@NotNull String message) {
                Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
                super(null);
                this.message = message;
            }

            public /* synthetic */ Unsupported(String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 1) != 0) {
                    string2 = "";
                }
                this(string2);
            }

            public Unsupported() {
                this(null, 1, null);
            }

            @NotNull
            public final String component1() {
                return this.message;
            }

            @NotNull
            public final Unsupported copy(@NotNull String message) {
                Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
                return new Unsupported(message);
            }

            public static /* synthetic */ Unsupported copy$default(Unsupported unsupported, String string2, int n, Object object) {
                if ((n & 1) != 0) {
                    string2 = unsupported.message;
                }
                return unsupported.copy(string2);
            }

            @NotNull
            public String toString() {
                return "Unsupported(message=" + this.message + ")";
            }

            public int hashCode() {
                String string2 = this.message;
                return string2 != null ? string2.hashCode() : 0;
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof Unsupported)) break block3;
                        Unsupported unsupported = (Unsupported)object;
                        if (!Intrinsics.areEqual((Object)this.message, (Object)unsupported.message)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
    }
}

