/*
 * Decompiled with CFR 0.152.
 */
package tv.mycujoo.mcls.manager;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import tv.mycujoo.mcls.manager.ITimer;
import tv.mycujoo.mcls.manager.TimerEntity;
import tv.mycujoo.mcls.manager.TimerVariable$WhenMappings;
import tv.mycujoo.mcls.model.ScreenTimerDirection;
import tv.mycujoo.mcls.model.ScreenTimerFormat;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0002\u0010\u000bJ\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\tH\u0016J\b\u0010\u0019\u001a\u00020\u0003H\u0016J\u0010\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\tH\u0002J\u0010\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\tH\u0002J\u0018\u0010\u001d\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0018\u001a\u00020\tH\u0016J\u0010\u0010 \u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\tH\u0002J\u0018\u0010!\u001a\u00020\u00152\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u0018\u001a\u00020\tH\u0016J\u0018\u0010$\u001a\u00020\u00152\u0006\u0010%\u001a\u00020&2\u0006\u0010\u0018\u001a\u00020\tH\u0016J\b\u0010'\u001a\u00020(H\u0002R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\f\u001a\u0012\u0012\u0004\u0012\u00020\u000e0\rj\b\u0012\u0004\u0012\u00020\u000e`\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Ltv/mycujoo/mcls/manager/TimerVariable;", "Ltv/mycujoo/mcls/manager/ITimer;", "name", "", "format", "Ltv/mycujoo/mcls/model/ScreenTimerFormat;", "direction", "Ltv/mycujoo/mcls/model/ScreenTimerDirection;", "startValue", "", "capValue", "(Ljava/lang/String;Ltv/mycujoo/mcls/model/ScreenTimerFormat;Ltv/mycujoo/mcls/model/ScreenTimerDirection;JJ)V", "commands", "Ljava/util/ArrayList;", "Ltv/mycujoo/mcls/manager/TimerEntity;", "Lkotlin/collections/ArrayList;", "currentTime", "getName", "()Ljava/lang/String;", "step", "adjust", "", "adjustTimer", "Ltv/mycujoo/mcls/manager/TimerEntity$AdjustTimer;", "now", "getTime", "getTimeInMinutesSecondFormat", "time", "getTimeInSecondFormat", "pause", "pauseTimer", "Ltv/mycujoo/mcls/manager/TimerEntity$PauseTimer;", "recalculate", "skip", "skipTimer", "Ltv/mycujoo/mcls/manager/TimerEntity$SkipTimer;", "start", "startTimer", "Ltv/mycujoo/mcls/manager/TimerEntity$StartTimer;", "timeIsWithinCapValue", "", "mls_release"})
public final class TimerVariable
implements ITimer {
    private long currentTime;
    private final long step;
    private final ArrayList<TimerEntity> commands;
    @NotNull
    private final String name;
    private final ScreenTimerFormat format;
    private final ScreenTimerDirection direction;
    private final long startValue;
    private final long capValue;

    @Override
    @NotNull
    public String getTime() {
        String string2;
        switch (TimerVariable$WhenMappings.$EnumSwitchMapping$0[this.format.ordinal()]) {
            case 1: {
                if (this.timeIsWithinCapValue()) {
                    string2 = this.getTimeInMinutesSecondFormat(this.currentTime);
                    break;
                }
                string2 = this.getTimeInMinutesSecondFormat(this.capValue);
                break;
            }
            case 2: {
                if (this.timeIsWithinCapValue()) {
                    string2 = this.getTimeInSecondFormat(this.currentTime);
                    break;
                }
                string2 = this.getTimeInSecondFormat(this.capValue);
                break;
            }
            case 3: {
                string2 = "";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string2;
    }

    @Override
    public void start(@NotNull TimerEntity.StartTimer startTimer, long now) {
        Intrinsics.checkParameterIsNotNull((Object)startTimer, (String)"startTimer");
        this.commands.add(startTimer);
        this.recalculate(now);
    }

    @Override
    public void pause(@NotNull TimerEntity.PauseTimer pauseTimer, long now) {
        Intrinsics.checkParameterIsNotNull((Object)pauseTimer, (String)"pauseTimer");
        this.commands.add(pauseTimer);
        this.recalculate(now);
    }

    @Override
    public void adjust(@NotNull TimerEntity.AdjustTimer adjustTimer, long now) {
        Intrinsics.checkParameterIsNotNull((Object)adjustTimer, (String)"adjustTimer");
        this.commands.add(adjustTimer);
        this.recalculate(now);
    }

    @Override
    public void skip(@NotNull TimerEntity.SkipTimer skipTimer, long now) {
        Intrinsics.checkParameterIsNotNull((Object)skipTimer, (String)"skipTimer");
        this.commands.add(skipTimer);
        this.recalculate(now);
    }

    private final void recalculate(long now) {
        Comparator comparator;
        Iterable iterable = this.commands;
        boolean bl = false;
        Comparator comparator2 = comparator = (Comparator)new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                TimerEntity it = (TimerEntity)a;
                boolean bl2 = false;
                Comparable comparable = Long.valueOf(it.getOffset());
                it = (TimerEntity)b;
                Comparable comparable2 = comparable;
                bl2 = false;
                Long l = it.getOffset();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)l);
            }
        };
        boolean bl2 = false;
        comparator = new Comparator<T>(comparator2){
            final /* synthetic */ Comparator $this_thenByDescending;
            {
                this.$this_thenByDescending = comparator;
            }

            public final int compare(T a, T b) {
                int n;
                int previousCompare = this.$this_thenByDescending.compare(a, b);
                if (previousCompare != 0) {
                    n = previousCompare;
                } else {
                    boolean bl = false;
                    TimerEntity it = (TimerEntity)b;
                    boolean bl2 = false;
                    Comparable comparable = Integer.valueOf(it.getPriority());
                    it = (TimerEntity)a;
                    Comparable comparable2 = comparable;
                    bl2 = false;
                    Integer n2 = it.getPriority();
                    n = ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)n2);
                }
                return n;
            }
        };
        List sorted = CollectionsKt.sortedWith((Iterable)iterable, (Comparator)comparator);
        long delta = this.startValue;
        boolean isTicking = false;
        Iterable $this$forEach$iv = sorted;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TimerEntity timerEntity = (TimerEntity)element$iv;
            boolean bl3 = false;
            TimerEntity timerEntity2 = timerEntity;
            if (timerEntity2 instanceof TimerEntity.StartTimer) {
                if (isTicking) continue;
                isTicking = true;
                if (this.direction == ScreenTimerDirection.UP) {
                    delta += now - timerEntity.getOffset();
                    continue;
                }
                delta -= now - timerEntity.getOffset();
                continue;
            }
            if (timerEntity2 instanceof TimerEntity.PauseTimer) {
                if (!isTicking) continue;
                isTicking = false;
                if (this.direction == ScreenTimerDirection.UP) {
                    delta -= now - timerEntity.getOffset();
                    continue;
                }
                delta += now - timerEntity.getOffset();
                continue;
            }
            if (timerEntity2 instanceof TimerEntity.AdjustTimer) {
                if (this.direction == ScreenTimerDirection.UP) {
                    delta = this.startValue + now - timerEntity.getOffset() + ((TimerEntity.AdjustTimer)timerEntity).getValue();
                    continue;
                }
                delta = this.startValue - (now - timerEntity.getOffset() + ((TimerEntity.AdjustTimer)timerEntity).getValue());
                continue;
            }
            if (!(timerEntity2 instanceof TimerEntity.SkipTimer)) continue;
            if (this.direction == ScreenTimerDirection.UP) {
                delta += ((TimerEntity.SkipTimer)timerEntity).getValue();
                continue;
            }
            delta -= ((TimerEntity.SkipTimer)timerEntity).getValue();
        }
        this.currentTime = delta;
    }

    private final String getTimeInMinutesSecondFormat(long time) {
        String string2;
        if (time >= 60000L) {
            long minutes = time / 60000L;
            String seconds = String.valueOf(time % 60000L / 1000L);
            string2 = "" + minutes + ':' + StringsKt.padStart((String)seconds, (int)2, (char)'0');
        } else {
            String seconds = String.valueOf(time / 1000L);
            string2 = "0:" + StringsKt.padStart((String)seconds, (int)2, (char)'0');
        }
        return string2;
    }

    private final String getTimeInSecondFormat(long time) {
        return String.valueOf(time / 1000L);
    }

    private final boolean timeIsWithinCapValue() {
        if (this.capValue == -1L) {
            return true;
        }
        if (this.direction == ScreenTimerDirection.UP && this.currentTime <= this.capValue) {
            return true;
        }
        return this.direction == ScreenTimerDirection.DOWN && this.currentTime >= this.capValue;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public TimerVariable(@NotNull String name, @NotNull ScreenTimerFormat format, @NotNull ScreenTimerDirection direction, long startValue, long capValue) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)((Object)format), (String)"format");
        Intrinsics.checkParameterIsNotNull((Object)((Object)direction), (String)"direction");
        this.name = name;
        this.format = format;
        this.direction = direction;
        this.startValue = startValue;
        this.capValue = capValue;
        this.currentTime = this.startValue;
        this.commands = new ArrayList();
        if (this.currentTime == -1L) {
            this.currentTime = 0L;
        }
        if (this.startValue != -1L) {
            this.currentTime = this.startValue;
        }
        this.step = this.direction == ScreenTimerDirection.UP ? 1000L : -1000L;
    }
}

