/*
 * Decompiled with CFR 0.152.
 */
package tv.mycujoo.mcls.di;

import android.content.Context;
import android.util.Log;
import dagger.Module;
import dagger.Provides;
import java.nio.charset.Charset;
import java.util.concurrent.TimeUnit;
import javax.inject.Named;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Cache;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okio.Buffer;
import okio.BufferedSink;
import org.jetbrains.annotations.NotNull;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;
import tv.mycujoo.mcls.manager.IPrefManager;
import tv.mycujoo.mcls.network.MlsApi;

@Module
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\f\u001a\u00020\u0003H\u0017J\u0012\u0010\r\u001a\u00020\u000e2\b\b\u0001\u0010\u000f\u001a\u00020\u0010H\u0017J\u0010\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0017J\u0010\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0017J\u0010\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0017R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Ltv/mycujoo/mcls/di/NetworkModule;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "getContext", "()Landroid/content/Context;", "maxAgeInSecond", "", "mlsApiBaseUrl", "", "publicBaseUrl", "provideContext", "provideMlsApi", "Ltv/mycujoo/mcls/network/MlsApi;", "retrofit", "Lretrofit2/Retrofit;", "provideMlsApiRetrofit", "okHttpClient", "Lokhttp3/OkHttpClient;", "provideOkHttp", "prefManager", "Ltv/mycujoo/mcls/manager/IPrefManager;", "provideRetrofit", "mls_release"})
public class NetworkModule {
    private final int maxAgeInSecond = 300;
    private final String publicBaseUrl = "https://mls.mycujoo.tv";
    private final String mlsApiBaseUrl = "https://mls-api.mycujoo.tv";
    @NotNull
    private final Context context;

    @Provides
    @Singleton
    @NotNull
    public Context provideContext() {
        return this.context;
    }

    @Provides
    @Singleton
    @NotNull
    public OkHttpClient provideOkHttp(@NotNull IPrefManager prefManager) {
        Intrinsics.checkParameterIsNotNull((Object)prefManager, (String)"prefManager");
        int cacheSize = 0xA00000;
        Cache cache = new Cache(this.context.getCacheDir(), (long)cacheSize);
        OkHttpClient.Builder okHttpBuilder2 = new OkHttpClient.Builder().readTimeout(30L, TimeUnit.SECONDS).writeTimeout(30L, TimeUnit.SECONDS).connectTimeout(30L, TimeUnit.SECONDS).addInterceptor(new Interceptor(this, prefManager){
            final /* synthetic */ NetworkModule this$0;
            final /* synthetic */ IPrefManager $prefManager;

            public final Response intercept(@NotNull Interceptor.Chain chain) {
                Intrinsics.checkParameterIsNotNull((Object)chain, (String)"chain");
                Request newRequest = chain.request().newBuilder().addHeader("Authorization", "Bearer " + this.$prefManager.get("PUBLIC_KEY")).removeHeader("Pragma").removeHeader("Cache-Control").addHeader("Cache-Control", "public, max-age=" + NetworkModule.access$getMaxAgeInSecond$p(this.this$0)).build();
                RequestBody requestBody = chain.request().body();
                if (requestBody != null) {
                    Log.d((String)"NetworkModule", (String)("intercept: " + chain.request().method() + " " + chain.request().url()));
                    Buffer buffer = new Buffer();
                    requestBody.writeTo((BufferedSink)buffer);
                    Charset charset = Charset.forName("UTF-8");
                    MediaType contentType = requestBody.contentType();
                    if (contentType != null) {
                        Log.d((String)"NetworkModule", (String)("intercept: " + buffer.readString(charset)));
                    }
                }
                return chain.proceed(newRequest);
            }
            {
                this.this$0 = networkModule;
                this.$prefManager = iPrefManager;
            }
        }).cache(cache);
        OkHttpClient okHttpClient = okHttpBuilder2.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)okHttpClient, (String)"okHttpBuilder.build()");
        return okHttpClient;
    }

    @Provides
    @Named(value="PUBLIC-API")
    @Singleton
    @NotNull
    public Retrofit provideRetrofit(@NotNull OkHttpClient okHttpClient) {
        Intrinsics.checkParameterIsNotNull((Object)okHttpClient, (String)"okHttpClient");
        Retrofit retrofit = new Retrofit.Builder().baseUrl(this.publicBaseUrl).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).client(okHttpClient).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)retrofit, (String)"Retrofit.Builder().baseU\u2026ent)\n            .build()");
        return retrofit;
    }

    @Provides
    @Named(value="MLS-API")
    @Singleton
    @NotNull
    public Retrofit provideMlsApiRetrofit(@NotNull OkHttpClient okHttpClient) {
        Intrinsics.checkParameterIsNotNull((Object)okHttpClient, (String)"okHttpClient");
        Retrofit retrofit = new Retrofit.Builder().baseUrl(this.mlsApiBaseUrl).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).client(okHttpClient).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)retrofit, (String)"Retrofit.Builder().baseU\u2026ent)\n            .build()");
        return retrofit;
    }

    @Provides
    @Singleton
    @NotNull
    public MlsApi provideMlsApi(@Named(value="MLS-API") @NotNull Retrofit retrofit) {
        Intrinsics.checkParameterIsNotNull((Object)retrofit, (String)"retrofit");
        Object object = retrofit.create(MlsApi.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"retrofit.create(MlsApi::class.java)");
        return (MlsApi)object;
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    public NetworkModule(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.context = context;
        this.maxAgeInSecond = 300;
        this.publicBaseUrl = "https://mls.mycujoo.tv";
        this.mlsApiBaseUrl = "https://mls-api.mycujoo.tv";
    }

    public static final /* synthetic */ int access$getMaxAgeInSecond$p(NetworkModule $this) {
        return $this.maxAgeInSecond;
    }
}

