/*
 * Decompiled with CFR 0.152.
 */
package tv.mycujoo.mcls.di;

import android.content.Context;
import android.content.SharedPreferences;
import dagger.Module;
import dagger.Provides;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CompletableJob;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.ObsoleteCoroutinesApi;
import kotlinx.coroutines.SupervisorKt;
import kotlinx.coroutines.ThreadPoolDispatcherKt;
import org.jetbrains.annotations.NotNull;
import tv.mycujoo.domain.repository.EventsRepository;
import tv.mycujoo.mcls.api.DataManager;
import tv.mycujoo.mcls.data.IDataManager;
import tv.mycujoo.mcls.enum.LogLevel;
import tv.mycujoo.mcls.manager.IPrefManager;
import tv.mycujoo.mcls.manager.Logger;
import tv.mycujoo.mcls.manager.PrefManager;
import tv.mycujoo.mcls.network.MlsApi;

@Module
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0017J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0017J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0017\u00a8\u0006\u0010"}, d2={"Ltv/mycujoo/mcls/di/AppModule;", "", "()V", "provideCoroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "provideDataManager", "Ltv/mycujoo/mcls/data/IDataManager;", "scope", "repository", "Ltv/mycujoo/domain/repository/EventsRepository;", "mlsApi", "Ltv/mycujoo/mcls/network/MlsApi;", "providePrefManager", "Ltv/mycujoo/mcls/manager/IPrefManager;", "context", "Landroid/content/Context;", "mls_release"})
public class AppModule {
    @Provides
    @Singleton
    @NotNull
    public IPrefManager providePrefManager(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        SharedPreferences sharedPreferences = context.getSharedPreferences("MLS", 0);
        Intrinsics.checkExpressionValueIsNotNull((Object)sharedPreferences, (String)"context.getSharedPrefere\u2026S\", Context.MODE_PRIVATE)");
        return new PrefManager(sharedPreferences);
    }

    @Provides
    @Singleton
    @ObsoleteCoroutinesApi
    @NotNull
    public CoroutineScope provideCoroutineScope() {
        CompletableJob job = SupervisorKt.SupervisorJob$default(null, (int)1, null);
        return CoroutineScopeKt.CoroutineScope((CoroutineContext)ThreadPoolDispatcherKt.newSingleThreadContext((String)"tv.mycujoo.mcls").plus((CoroutineContext)job));
    }

    @Provides
    @Singleton
    @NotNull
    public IDataManager provideDataManager(@NotNull CoroutineScope scope, @NotNull EventsRepository repository, @NotNull MlsApi mlsApi) {
        Intrinsics.checkParameterIsNotNull((Object)scope, (String)"scope");
        Intrinsics.checkParameterIsNotNull((Object)repository, (String)"repository");
        Intrinsics.checkParameterIsNotNull((Object)mlsApi, (String)"mlsApi");
        return new DataManager(scope, repository, mlsApi, new Logger(LogLevel.MINIMAL));
    }
}

