/*
 * Decompiled with CFR 0.152.
 */
package tv.mycujoo.mcls.widgets;

import android.animation.ObjectAnimator;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Color;
import android.graphics.PorterDuff;
import android.util.AttributeSet;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageButton;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.TextView;
import androidx.annotation.MainThread;
import androidx.annotation.Nullable;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.core.view.ViewGroupKt;
import androidx.test.espresso.idling.CountingIdlingResource;
import com.google.android.exoplayer2.Player;
import com.google.android.exoplayer2.ui.AspectRatioFrameLayout;
import com.google.android.exoplayer2.ui.PlayerControlView;
import com.google.android.exoplayer2.ui.PlayerView;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import tv.mycujoo.domain.entity.TimelineMarkerEntity;
import tv.mycujoo.mcls.R;
import tv.mycujoo.mcls.core.UIEventListener;
import tv.mycujoo.mcls.entity.msc.VideoPlayerConfig;
import tv.mycujoo.mcls.helper.OverlayViewHelper;
import tv.mycujoo.mcls.manager.TimelineMarkerManager;
import tv.mycujoo.mcls.manager.contracts.IViewHandler;
import tv.mycujoo.mcls.utils.ColorUtils;
import tv.mycujoo.mcls.utils.StringUtils;
import tv.mycujoo.mcls.widgets.CustomInformationDialog;
import tv.mycujoo.mcls.widgets.IPlayerView;
import tv.mycujoo.mcls.widgets.LiveBadgeView;
import tv.mycujoo.mcls.widgets.MLSPlayerView;
import tv.mycujoo.mcls.widgets.MLSPlayerView$WhenMappings;
import tv.mycujoo.mcls.widgets.PlayerControllerMode;
import tv.mycujoo.mcls.widgets.PreEventInformationDialog;
import tv.mycujoo.mcls.widgets.RemotePlayerControllerView;
import tv.mycujoo.mcls.widgets.ScaffoldView;
import tv.mycujoo.mcls.widgets.StartedEventInformationDialog;
import tv.mycujoo.mcls.widgets.UiEvent;
import tv.mycujoo.mcls.widgets.mlstimebar.MLSTimeBar;
import tv.mycujoo.mcls.widgets.mlstimebar.PointOfInterest;
import tv.mycujoo.mcls.widgets.mlstimebar.PointOfInterestType;
import tv.mycujoo.mcls.widgets.mlstimebar.TimelineMarkerView;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u00f4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0016\n\u0000\n\u0002\u0010\u0018\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\t\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u00002\u00020\u00012\u00020\u0002:\u0004\u009d\u0001\u009e\u0001B%\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0016\u0010D\u001a\u00020 2\u0006\u0010E\u001a\u00020F2\u0006\u0010G\u001a\u00020HJ\u0010\u0010I\u001a\u00020 2\u0006\u0010J\u001a\u00020\u000eH\u0016J\u0010\u0010K\u001a\u00020 2\u0006\u0010J\u001a\u00020\u000eH\u0016J\u0014\u0010L\u001a\u00020 2\f\u0010M\u001a\b\u0012\u0004\u0012\u00020O0NJ\u0010\u0010P\u001a\u00020 2\u0006\u0010P\u001a\u00020QH\u0016J\b\u0010R\u001a\u00020 H\u0016J\b\u0010S\u001a\u00020 H\u0016J\b\u0010T\u001a\u00020/H\u0016J\u0006\u0010U\u001a\u00020VJ\b\u0010W\u001a\u00020 H\u0016J\b\u0010X\u001a\u00020 H\u0016J\b\u0010Y\u001a\u00020 H\u0007J\b\u0010Z\u001a\u00020 H\u0016J\b\u0010[\u001a\u00020 H\u0016J\u001a\u0010\\\u001a\u00020 2\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0003\u001a\u00020\u0004H\u0002J\u0016\u0010]\u001a\u00020 2\f\u0010^\u001a\b\u0012\u0004\u0012\u00020_0NH\u0002J(\u0010`\u001a\u00020 2\u0006\u0010a\u001a\u00020\b2\u0006\u0010b\u001a\u00020\b2\u0006\u0010c\u001a\u00020\b2\u0006\u0010d\u001a\u00020\bH\u0014J$\u0010e\u001a\u00020 2\u0006\u0010&\u001a\u00020'2\u0006\u0010B\u001a\u00020C2\f\u0010f\u001a\b\u0012\u0004\u0012\u00020_0NJ\u0010\u0010g\u001a\u00020 2\u0006\u0010J\u001a\u00020\u000eH\u0016J\u0010\u0010h\u001a\u00020 2\u0006\u0010J\u001a\u00020\u000eH\u0016J\b\u0010i\u001a\u00020 H\u0002J\u000e\u0010j\u001a\u00020 2\u0006\u0010k\u001a\u00020lJ\u000e\u0010m\u001a\u00020 2\u0006\u0010k\u001a\u00020lJ\u000e\u0010n\u001a\u00020 2\u0006\u0010k\u001a\u00020lJ\u0010\u0010o\u001a\u00020 2\u0006\u0010p\u001a\u00020\bH\u0002J\u001e\u0010q\u001a\u00020 2\u0006\u0010r\u001a\u00020O2\u0006\u0010s\u001a\u00020O2\u0006\u0010t\u001a\u00020OJ\u000e\u0010u\u001a\u00020 2\u0006\u0010v\u001a\u00020\u0011J\u0010\u0010w\u001a\u00020 2\u0006\u0010x\u001a\u00020yH\u0016J\u0014\u0010z\u001a\u00020 2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001fJ\u0010\u0010{\u001a\u00020 2\u0006\u0010p\u001a\u00020\bH\u0002J\u0010\u0010|\u001a\u00020 2\b\u0010}\u001a\u0004\u0018\u00010OJ\u000f\u0010~\u001a\u00020 2\u0007\u0010\u007f\u001a\u00030\u0080\u0001J\u0011\u0010\u0081\u0001\u001a\u00020 2\u0006\u0010p\u001a\u00020\bH\u0002J\u0015\u0010\u0082\u0001\u001a\u00020 2\f\u0010^\u001a\b\u0012\u0004\u0012\u00020_0NJ\u0011\u0010\u0083\u0001\u001a\u00020 2\u0006\u0010P\u001a\u00020QH\u0002J\u0012\u0010\u0084\u0001\u001a\u00020 2\u0007\u0010\u0084\u0001\u001a\u00020\u0011H\u0002J\t\u0010\u0085\u0001\u001a\u00020 H\u0016J\u0012\u0010\u0086\u0001\u001a\u00020 2\u0007\u0010\u0087\u0001\u001a\u00020\u0011H\u0002J\u0012\u0010\u0088\u0001\u001a\u00020 2\u0007\u0010\u0089\u0001\u001a\u00020OH\u0016J\t\u0010\u008a\u0001\u001a\u00020 H\u0016J\t\u0010\u008b\u0001\u001a\u00020 H\u0007J\u0012\u0010\u008c\u0001\u001a\u00020 2\u0007\u0010\u008c\u0001\u001a\u00020\u0011H\u0002J\u0012\u0010\u008d\u0001\u001a\u00020 2\u0007\u0010\u008d\u0001\u001a\u00020\u0011H\u0002J\t\u0010\u008e\u0001\u001a\u00020 H\u0016J\u0012\u0010\u008f\u0001\u001a\u00020 2\u0007\u0010\u008f\u0001\u001a\u00020\u0011H\u0002J\t\u0010\u0090\u0001\u001a\u00020 H\u0016J\u0012\u0010\u0091\u0001\u001a\u00020 2\u0007\u0010\u0091\u0001\u001a\u00020\u0011H\u0002J\u0013\u0010\u0092\u0001\u001a\u00020 2\b\u0010\u0093\u0001\u001a\u00030\u0094\u0001H\u0016J\u0012\u0010\u0095\u0001\u001a\u00020 2\u0007\u0010\u0096\u0001\u001a\u00020\u0011H\u0016J\t\u0010\u0097\u0001\u001a\u00020 H\u0002J\u0019\u0010\u0098\u0001\u001a\u00020 2\u0007\u0010\u0099\u0001\u001a\u00020l2\u0007\u0010\u009a\u0001\u001a\u00020lJ\u0012\u0010\u009b\u0001\u001a\u00020 2\u0007\u0010\u009c\u0001\u001a\u00020OH\u0016R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\f\u001a\u0012\u0012\u0004\u0012\u00020\u000e0\rj\b\u0012\u0004\u0012\u00020\u000e`\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0016\u001a\u00020\u00178\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u000e\u0010\u001c\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010!\u001a\u00020\u0001X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\u000e\u0010&\u001a\u00020'X\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010(\u001a\u00020)X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010+\"\u0004\b,\u0010-R\u000e\u0010.\u001a\u00020/X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u00100\u001a\u000601j\u0002`2X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00103\u001a\u000204X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00105\u001a\u000206X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u00107\u001a\u000208X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00109\u001a\u000208X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010:\u001a\u00020;X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010<\u001a\u00020=X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b>\u0010?\"\u0004\b@\u0010AR\u000e\u0010B\u001a\u00020CX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u009f\u0001"}, d2={"Ltv/mycujoo/mcls/widgets/MLSPlayerView;", "Landroidx/constraintlayout/widget/ConstraintLayout;", "Ltv/mycujoo/mcls/widgets/IPlayerView;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "bufferingProgressBar", "Landroid/widget/ProgressBar;", "dialogs", "Ljava/util/ArrayList;", "Landroid/view/View;", "Lkotlin/collections/ArrayList;", "enableControls", "", "externalInformationButtonLayout", "Landroid/widget/FrameLayout;", "fullScreenButton", "Landroid/widget/ImageButton;", "idlingResource", "Landroidx/test/espresso/idling/CountingIdlingResource;", "getIdlingResource", "()Landroidx/test/espresso/idling/CountingIdlingResource;", "setIdlingResource", "(Landroidx/test/espresso/idling/CountingIdlingResource;)V", "isFullScreen", "isScrubbing", "onSizeChangedCallback", "Lkotlin/Function0;", "", "overlayHost", "getOverlayHost", "()Landroidx/constraintlayout/widget/ConstraintLayout;", "setOverlayHost", "(Landroidx/constraintlayout/widget/ConstraintLayout;)V", "overlayViewHelper", "Ltv/mycujoo/mcls/helper/OverlayViewHelper;", "playerView", "Lcom/google/android/exoplayer2/ui/PlayerView;", "getPlayerView", "()Lcom/google/android/exoplayer2/ui/PlayerView;", "setPlayerView", "(Lcom/google/android/exoplayer2/ui/PlayerView;)V", "remotePlayerControllerView", "Ltv/mycujoo/mcls/widgets/RemotePlayerControllerView;", "timeFormatBuilder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "timeFormatter", "Ljava/util/Formatter;", "timelineMarkerManager", "Ltv/mycujoo/mcls/manager/TimelineMarkerManager;", "topLeftContainer", "Landroid/widget/LinearLayout;", "topRightContainer", "uiEvent", "Ltv/mycujoo/mcls/widgets/UiEvent;", "uiEventListener", "Ltv/mycujoo/mcls/core/UIEventListener;", "getUiEventListener", "()Ltv/mycujoo/mcls/core/UIEventListener;", "setUiEventListener", "(Ltv/mycujoo/mcls/core/UIEventListener;)V", "viewHandler", "Ltv/mycujoo/mcls/manager/contracts/IViewHandler;", "addMarker", "longArray", "", "booleanArray", "", "addToTopLeftContainer", "view", "addToTopRightContainer", "clearScreen", "idList", "", "", "config", "Ltv/mycujoo/mcls/entity/msc/VideoPlayerConfig;", "continueOverlayAnimations", "freezeOverlayAnimations", "getRemotePlayerControllerView", "getTimeBar", "Ltv/mycujoo/mcls/widgets/mlstimebar/MLSTimeBar;", "hideBuffering", "hideEventInfoButton", "hideEventInfoButtonInstantly", "hideInfoDialogs", "hideViewersCounter", "initAttributes", "initMlsTimeBar", "list", "Ltv/mycujoo/domain/entity/TimelineMarkerEntity;", "onSizeChanged", "w", "h", "oldw", "oldh", "prepare", "timelineMarkers", "removeFromTopLeftContainer", "removeFromTopRightContainer", "removeFullscreenButton", "scrubStartedAt", "position", "", "scrubStopAt", "scrubbedTo", "setBufferingProgressBarsColor", "primaryColor", "setEventInfo", "title", "description", "startTime", "setFullscreen", "isFullscreen", "setLiveMode", "liveState", "Ltv/mycujoo/mcls/widgets/MLSPlayerView$LiveState;", "setOnSizeChangedCallback", "setPlayerMainButtonsColor", "setPosterInfo", "posterUrl", "setScreenResizeMode", "resizeMode", "Ltv/mycujoo/mcls/widgets/MLSPlayerView$ResizeMode;", "setTimeBarsColor", "setTimelineMarker", "setTimelineMarkerColor", "showBackForwardsButtons", "showBuffering", "showControlsContainer", "show", "showCustomInformationDialog", "message", "showEventInfoButton", "showEventInfoButtonInstantly", "showFullScreenButton", "showPlayPauseButtons", "showPreEventInformationDialog", "showSeekBar", "showStartedEventInformationDialog", "showTimers", "switchMode", "mode", "Ltv/mycujoo/mcls/widgets/PlayerControllerMode;", "updateControllerVisibility", "isPlaying", "updateFullscreenButtonImage", "updateTime", "time", "duration", "updateViewersCounter", "count", "LiveState", "ResizeMode", "mls_release"})
public final class MLSPlayerView
extends ConstraintLayout
implements IPlayerView {
    @NotNull
    private PlayerView playerView;
    @NotNull
    private ConstraintLayout overlayHost;
    private final LinearLayout topRightContainer;
    private final LinearLayout topLeftContainer;
    private ProgressBar bufferingProgressBar;
    private ImageButton fullScreenButton;
    private final RemotePlayerControllerView remotePlayerControllerView;
    private final FrameLayout externalInformationButtonLayout;
    @NotNull
    public UIEventListener uiEventListener;
    private boolean isFullScreen;
    private boolean enableControls;
    private IViewHandler viewHandler;
    private final ArrayList<View> dialogs;
    private UiEvent uiEvent;
    private Function0<Unit> onSizeChangedCallback;
    private OverlayViewHelper overlayViewHelper;
    private StringBuilder timeFormatBuilder;
    private Formatter timeFormatter;
    private boolean isScrubbing;
    private TimelineMarkerManager timelineMarkerManager;
    @Nullable
    @NotNull
    public CountingIdlingResource idlingResource;
    private HashMap _$_findViewCache;

    @NotNull
    public final PlayerView getPlayerView() {
        return this.playerView;
    }

    public final void setPlayerView(@NotNull PlayerView playerView) {
        Intrinsics.checkParameterIsNotNull((Object)playerView, (String)"<set-?>");
        this.playerView = playerView;
    }

    @NotNull
    public final ConstraintLayout getOverlayHost() {
        return this.overlayHost;
    }

    public final void setOverlayHost(@NotNull ConstraintLayout constraintLayout) {
        Intrinsics.checkParameterIsNotNull((Object)constraintLayout, (String)"<set-?>");
        this.overlayHost = constraintLayout;
    }

    @NotNull
    public final UIEventListener getUiEventListener() {
        UIEventListener uIEventListener = this.uiEventListener;
        if (uIEventListener == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"uiEventListener");
        }
        return uIEventListener;
    }

    public final void setUiEventListener(@NotNull UIEventListener uIEventListener) {
        Intrinsics.checkParameterIsNotNull((Object)uIEventListener, (String)"<set-?>");
        this.uiEventListener = uIEventListener;
    }

    @NotNull
    public final CountingIdlingResource getIdlingResource() {
        CountingIdlingResource countingIdlingResource = this.idlingResource;
        if (countingIdlingResource == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"idlingResource");
        }
        return countingIdlingResource;
    }

    public final void setIdlingResource(@NotNull CountingIdlingResource countingIdlingResource) {
        Intrinsics.checkParameterIsNotNull((Object)countingIdlingResource, (String)"<set-?>");
        this.idlingResource = countingIdlingResource;
    }

    public final void prepare(@NotNull OverlayViewHelper overlayViewHelper, @NotNull IViewHandler viewHandler, @NotNull List<TimelineMarkerEntity> timelineMarkers) {
        Intrinsics.checkParameterIsNotNull((Object)overlayViewHelper, (String)"overlayViewHelper");
        Intrinsics.checkParameterIsNotNull((Object)viewHandler, (String)"viewHandler");
        Intrinsics.checkParameterIsNotNull(timelineMarkers, (String)"timelineMarkers");
        this.overlayViewHelper = overlayViewHelper;
        this.viewHandler = viewHandler;
        this.initMlsTimeBar(timelineMarkers);
    }

    private final void initAttributes(AttributeSet attrs, Context context) {
        block1: {
            AttributeSet attributeSet = attrs;
            if (attributeSet == null) break block1;
            AttributeSet attributeSet2 = attributeSet;
            boolean bl = false;
            boolean bl2 = false;
            AttributeSet it = attributeSet2;
            boolean bl3 = false;
            TypedArray obtainAttrs = context.obtainStyledAttributes(it, R.styleable.MLSPlayerView);
            if (obtainAttrs.hasValue(R.styleable.MLSPlayerView_has_fullscreen_button) && !obtainAttrs.getBoolean(R.styleable.MLSPlayerView_has_fullscreen_button, true)) {
                this.removeFullscreenButton();
            }
            obtainAttrs.recycle();
        }
    }

    private final void initMlsTimeBar(List<TimelineMarkerEntity> list) {
        MLSTimeBar mlsTimeBar = (MLSTimeBar)this.findViewById(R.id.exo_progress);
        mlsTimeBar.setPlayedColor(-16776961);
        TimelineMarkerView timelineMarkerView = (TimelineMarkerView)this.findViewById(R.id.exo_timelineMarkerView);
        MLSTimeBar mLSTimeBar = mlsTimeBar;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)mLSTimeBar), (String)"mlsTimeBar");
        TimelineMarkerView timelineMarkerView2 = timelineMarkerView;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)timelineMarkerView2), (String)"timelineMarkerView");
        this.timelineMarkerManager = new TimelineMarkerManager(mLSTimeBar, timelineMarkerView2);
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TimelineMarkerEntity showTimelineMarkerEntity = (TimelineMarkerEntity)element$iv;
            boolean bl = false;
            TimelineMarkerManager timelineMarkerManager = this.timelineMarkerManager;
            if (timelineMarkerManager == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"timelineMarkerManager");
            }
            timelineMarkerManager.addTimeLineHighlight(new PointOfInterest(showTimelineMarkerEntity.getOffset(), showTimelineMarkerEntity.getSeekOffset(), showTimelineMarkerEntity.getLabel(), new PointOfInterestType(showTimelineMarkerEntity.getColor())));
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void setTimelineMarker(@NotNull List<TimelineMarkerEntity> list) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkParameterIsNotNull(list, (String)"list");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            TimelineMarkerEntity timelineMarkerEntity = (TimelineMarkerEntity)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            PointOfInterest pointOfInterest = new PointOfInterest(it.getOffset(), it.getSeekOffset(), it.getLabel(), new PointOfInterestType(ColorUtils.Companion.toARGB(it.getColor())));
            collection.add(pointOfInterest);
        }
        List list2 = (List)destination$iv$iv;
        boolean bl = false;
        boolean bl2 = false;
        List it = list2;
        boolean bl3 = false;
        TimelineMarkerManager timelineMarkerManager = this.timelineMarkerManager;
        if (timelineMarkerManager == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"timelineMarkerManager");
        }
        timelineMarkerManager.setTimeLineHighlight(it);
    }

    public final void setScreenResizeMode(@NotNull ResizeMode resizeMode) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)resizeMode), (String)"resizeMode");
        this.playerView.setResizeMode(resizeMode.getValue());
    }

    public final void setFullscreen(boolean isFullscreen) {
        this.isFullScreen = isFullscreen;
        this.updateFullscreenButtonImage();
    }

    public final void setOnSizeChangedCallback(@NotNull Function0<Unit> onSizeChangedCallback2) {
        Intrinsics.checkParameterIsNotNull(onSizeChangedCallback2, (String)"onSizeChangedCallback");
        this.onSizeChangedCallback = onSizeChangedCallback2;
    }

    private final void updateFullscreenButtonImage() {
        if (this.isFullScreen) {
            this.fullScreenButton.setImageResource(R.drawable.ic_fullscreen_exit_24dp);
        } else {
            this.fullScreenButton.setImageResource(R.drawable.ic_fullscreen_24dp);
        }
    }

    private final void removeFullscreenButton() {
        View view = this.findViewById(R.id.controller_fullscreenImageButton);
        Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"findViewById<ImageButton\u2026er_fullscreenImageButton)");
        ((ImageButton)view).setVisibility(8);
    }

    public final void addMarker(@NotNull long[] longArray, @NotNull boolean[] booleanArray) {
        Intrinsics.checkParameterIsNotNull((Object)longArray, (String)"longArray");
        Intrinsics.checkParameterIsNotNull((Object)booleanArray, (String)"booleanArray");
        this.playerView.setExtraAdGroupMarkers(longArray, booleanArray);
    }

    @Override
    @NotNull
    public RemotePlayerControllerView getRemotePlayerControllerView() {
        View view = this.findViewById(R.id.remotePlayerControllerView);
        Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"findViewById(R.id.remotePlayerControllerView)");
        return (RemotePlayerControllerView)view;
    }

    @Override
    public void switchMode(@NotNull PlayerControllerMode mode) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)mode), (String)"mode");
        switch (MLSPlayerView$WhenMappings.$EnumSwitchMapping$0[mode.ordinal()]) {
            case 1: {
                this.playerView.setVisibility(0);
                this.remotePlayerControllerView.setVisibility(8);
                break;
            }
            case 2: {
                this.playerView.setVisibility(8);
                this.remotePlayerControllerView.setVisibility(0);
                break;
            }
        }
    }

    @Override
    public void showBuffering() {
        this.bufferingProgressBar.setVisibility(0);
    }

    @Override
    public void hideBuffering() {
        this.bufferingProgressBar.setVisibility(8);
    }

    @Override
    public void config(@NotNull VideoPlayerConfig config2) {
        Intrinsics.checkParameterIsNotNull((Object)config2, (String)"config");
        try {
            int primaryColor = Color.parseColor((String)config2.getPrimaryColor());
            int secondaryColor = Color.parseColor((String)config2.getSecondaryColor());
            this.setTimeBarsColor(primaryColor);
            this.setTimelineMarkerColor(config2);
            this.setBufferingProgressBarsColor(primaryColor);
            this.setPlayerMainButtonsColor(primaryColor);
            Player player = this.playerView.getPlayer();
            if (player != null) {
                player.setPlayWhenReady(config2.getAutoPlay());
            }
            this.showPlayPauseButtons(config2.getShowPlayPauseButtons());
            this.showBackForwardsButtons(config2.getShowBackForwardsButtons());
            this.showSeekBar(config2.getShowSeekBar());
            this.showFullScreenButton(config2.getShowFullScreenButton());
            this.showTimers(config2.getShowTimers());
            if (config2.getShowEventInfoButton()) {
                this.showEventInfoButton();
            } else {
                this.hideEventInfoButton();
            }
            this.enableControls = config2.getEnableControls();
            if (!this.enableControls) {
                this.playerView.setControllerAutoShow(false);
                this.playerView.hideController();
                this.showPlayPauseButtons(false);
                this.showBackForwardsButtons(false);
                this.showSeekBar(false);
                this.showFullScreenButton(false);
                this.showTimers(false);
                this.hideEventInfoButton();
                this.showControlsContainer(false);
            }
        }
        catch (Exception e) {
            String string2 = e.getMessage();
            if (string2 == null) {
                string2 = "Error in configuring";
            }
            Log.e((String)"PlayerViewWrapper", (String)string2);
        }
    }

    @Override
    public void updateControllerVisibility(boolean isPlaying) {
        if (this.enableControls && isPlaying) {
            this.showControlsContainer(true);
            this.playerView.setControllerAutoShow(true);
            this.playerView.setUseController(true);
            this.playerView.showController();
        } else {
            this.showControlsContainer(false);
            this.playerView.hideController();
            this.playerView.setControllerAutoShow(false);
            this.playerView.setUseController(false);
        }
    }

    private final void setPlayerMainButtonsColor(int primaryColor) {
        ((ImageButton)this.findViewById(R.id.exo_play)).setColorFilter(primaryColor, PorterDuff.Mode.SRC_ATOP);
        ((ImageButton)this.findViewById(R.id.exo_pause)).setColorFilter(primaryColor, PorterDuff.Mode.SRC_ATOP);
        ((ImageButton)this.findViewById(R.id.exo_rew)).setColorFilter(primaryColor, PorterDuff.Mode.SRC_ATOP);
        ((ImageButton)this.findViewById(R.id.exo_ffwd)).setColorFilter(primaryColor, PorterDuff.Mode.SRC_ATOP);
        this.remotePlayerControllerView.setPlayerMainButtonsColor(primaryColor);
    }

    private final void setTimeBarsColor(int primaryColor) {
        MLSTimeBar mlsTimeBar = (MLSTimeBar)this.findViewById(R.id.exo_progress);
        mlsTimeBar.setPlayedColor(primaryColor);
        this.remotePlayerControllerView.setTimeBarPlayedColor(primaryColor);
    }

    private final void setTimelineMarkerColor(VideoPlayerConfig config2) {
        TimelineMarkerView timelineMarkerView = (TimelineMarkerView)this.findViewById(R.id.exo_timelineMarkerView);
        timelineMarkerView.initialize(config2.getSecondaryColor());
    }

    private final void setBufferingProgressBarsColor(int primaryColor) {
        this.bufferingProgressBar.setIndeterminateTintList(ColorStateList.valueOf((int)primaryColor));
        this.remotePlayerControllerView.setBufferingProgressBarsColor(primaryColor);
    }

    private final void showControlsContainer(boolean show) {
        if (show) {
            View view = this.findViewById(R.id.controlsLayoutContainer);
            Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"findViewById<ConstraintL\u2026.controlsLayoutContainer)");
            ((ConstraintLayout)view).setVisibility(0);
        } else {
            View view = this.findViewById(R.id.controlsLayoutContainer);
            Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"findViewById<ConstraintL\u2026.controlsLayoutContainer)");
            ((ConstraintLayout)view).setVisibility(8);
        }
    }

    private final void showTimers(boolean showTimers) {
        if (showTimers) {
            View view = this.findViewById(R.id.controller_timersContainer);
            Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"findViewById<ConstraintL\u2026ntroller_timersContainer)");
            ((ConstraintLayout)view).setVisibility(0);
        } else {
            View view = this.findViewById(R.id.controller_timersContainer);
            Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"findViewById<ConstraintL\u2026ntroller_timersContainer)");
            ((ConstraintLayout)view).setVisibility(8);
        }
    }

    private final void showFullScreenButton(boolean showFullScreenButton) {
        if (showFullScreenButton) {
            View view = this.findViewById(R.id.controller_fullscreenImageButtonContainer);
            Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"findViewById<FrameLayout\u2026reenImageButtonContainer)");
            ((FrameLayout)view).setVisibility(0);
        } else {
            View view = this.findViewById(R.id.controller_fullscreenImageButtonContainer);
            Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"findViewById<FrameLayout\u2026reenImageButtonContainer)");
            ((FrameLayout)view).setVisibility(8);
        }
    }

    private final void showSeekBar(boolean showSeekBar) {
        if (showSeekBar) {
            View view = this.findViewById(R.id.controller_timeBarLayoutContainer);
            Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"findViewById<FrameLayout\u2026r_timeBarLayoutContainer)");
            ((FrameLayout)view).setVisibility(0);
        } else {
            View view = this.findViewById(R.id.controller_timeBarLayoutContainer);
            Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"findViewById<FrameLayout\u2026r_timeBarLayoutContainer)");
            ((FrameLayout)view).setVisibility(8);
        }
    }

    private final void showBackForwardsButtons(boolean showBackForwardsButtons) {
        if (showBackForwardsButtons) {
            View view = this.findViewById(R.id.exo_rew);
            Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"findViewById<ImageButton>(R.id.exo_rew)");
            ((ImageButton)view).setVisibility(0);
            View view2 = this.findViewById(R.id.controller_rewButtonContainerLayout);
            Intrinsics.checkExpressionValueIsNotNull((Object)view2, (String)"findViewById<FrameLayout\u2026rewButtonContainerLayout)");
            ((FrameLayout)view2).setVisibility(0);
            View view3 = this.findViewById(R.id.controller_ffwdButtonContainerLayout);
            Intrinsics.checkExpressionValueIsNotNull((Object)view3, (String)"findViewById<FrameLayout\u2026fwdButtonContainerLayout)");
            ((FrameLayout)view3).setVisibility(0);
            View view4 = this.findViewById(R.id.exo_ffwd);
            Intrinsics.checkExpressionValueIsNotNull((Object)view4, (String)"findViewById<ImageButton>(R.id.exo_ffwd)");
            ((ImageButton)view4).setVisibility(0);
        } else {
            View view = this.findViewById(R.id.exo_rew);
            Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"findViewById<ImageButton>(R.id.exo_rew)");
            ((ImageButton)view).setVisibility(8);
            View view5 = this.findViewById(R.id.controller_rewButtonContainerLayout);
            Intrinsics.checkExpressionValueIsNotNull((Object)view5, (String)"findViewById<FrameLayout\u2026rewButtonContainerLayout)");
            ((FrameLayout)view5).setVisibility(8);
            View view6 = this.findViewById(R.id.controller_ffwdButtonContainerLayout);
            Intrinsics.checkExpressionValueIsNotNull((Object)view6, (String)"findViewById<FrameLayout\u2026fwdButtonContainerLayout)");
            ((FrameLayout)view6).setVisibility(8);
            View view7 = this.findViewById(R.id.exo_ffwd);
            Intrinsics.checkExpressionValueIsNotNull((Object)view7, (String)"findViewById<ImageButton>(R.id.exo_ffwd)");
            ((ImageButton)view7).setVisibility(8);
        }
    }

    private final void showPlayPauseButtons(boolean showPlayPauseButtons) {
        if (showPlayPauseButtons) {
            View view = this.findViewById(R.id.controller_playPauseButtonContainerLayout);
            Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"findViewById<FrameLayout\u2026useButtonContainerLayout)");
            ((FrameLayout)view).setVisibility(0);
        } else {
            View view = this.findViewById(R.id.controller_playPauseButtonContainerLayout);
            Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"findViewById<FrameLayout\u2026useButtonContainerLayout)");
            ((FrameLayout)view).setVisibility(8);
        }
    }

    @Override
    public void setLiveMode(@NotNull LiveState liveState) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)liveState), (String)"liveState");
        ((LiveBadgeView)this._$_findCachedViewById(R.id.controller_liveBadgeView)).setLiveMode(liveState);
    }

    @Override
    public void updateViewersCounter(@NotNull String count) {
        Intrinsics.checkParameterIsNotNull((Object)count, (String)"count");
        ConstraintLayout constraintLayout = (ConstraintLayout)this._$_findCachedViewById(R.id.controller_viewersCountLayout);
        Intrinsics.checkExpressionValueIsNotNull((Object)constraintLayout, (String)"controller_viewersCountLayout");
        constraintLayout.setVisibility(0);
        TextView textView = (TextView)this._$_findCachedViewById(R.id.controller_viewersCountTextView);
        Intrinsics.checkExpressionValueIsNotNull((Object)textView, (String)"controller_viewersCountTextView");
        textView.setText((CharSequence)count);
    }

    @Override
    public void hideViewersCounter() {
        ConstraintLayout constraintLayout = (ConstraintLayout)this._$_findCachedViewById(R.id.controller_viewersCountLayout);
        Intrinsics.checkExpressionValueIsNotNull((Object)constraintLayout, (String)"controller_viewersCountLayout");
        constraintLayout.setVisibility(8);
    }

    @NotNull
    public final MLSTimeBar getTimeBar() {
        View view = this.findViewById(R.id.exo_progress);
        Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"findViewById(R.id.exo_progress)");
        return (MLSTimeBar)view;
    }

    public final void updateTime(long time, long duration) {
        if (this.isScrubbing) {
            return;
        }
        TextView textView = (TextView)this._$_findCachedViewById(R.id.positionTextView);
        Intrinsics.checkExpressionValueIsNotNull((Object)textView, (String)"positionTextView");
        textView.setText((CharSequence)StringUtils.Companion.getFormattedTime(time, this.timeFormatBuilder, this.timeFormatter));
        TextView textView2 = (TextView)this._$_findCachedViewById(R.id.durationTextView);
        Intrinsics.checkExpressionValueIsNotNull((Object)textView2, (String)"durationTextView");
        textView2.setText((CharSequence)StringUtils.Companion.getFormattedTime(duration, this.timeFormatBuilder, this.timeFormatter));
    }

    public final void scrubStopAt(long position) {
        this.isScrubbing = false;
        this.scrubbedTo(position);
    }

    public final void scrubStartedAt(long position) {
        this.isScrubbing = true;
        this.scrubbedTo(position);
    }

    public final void scrubbedTo(long position) {
        TextView textView = (TextView)this._$_findCachedViewById(R.id.positionTextView);
        Intrinsics.checkExpressionValueIsNotNull((Object)textView, (String)"positionTextView");
        textView.setText((CharSequence)StringUtils.Companion.getFormattedTime(position, this.timeFormatBuilder, this.timeFormatter));
    }

    @Override
    public void continueOverlayAnimations() {
        IViewHandler iViewHandler = this.viewHandler;
        if (iViewHandler == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"viewHandler");
        }
        Iterable $this$forEach$iv = iViewHandler.getAnimations();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ObjectAnimator it = (ObjectAnimator)element$iv;
            boolean bl = false;
            it.resume();
        }
    }

    @Override
    public void freezeOverlayAnimations() {
        IViewHandler iViewHandler = this.viewHandler;
        if (iViewHandler == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"viewHandler");
        }
        Iterable $this$forEach$iv = iViewHandler.getAnimations();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ObjectAnimator it = (ObjectAnimator)element$iv;
            boolean bl = false;
            it.pause();
        }
    }

    public final void clearScreen(@NotNull List<String> idList) {
        Intrinsics.checkParameterIsNotNull(idList, (String)"idList");
        Sequence $this$forEach$iv = ViewGroupKt.getChildren((ViewGroup)((ViewGroup)this.overlayHost));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            View it = (View)element$iv;
            boolean bl = false;
            if (!CollectionsKt.contains((Iterable)idList, (Object)it.getTag()) || this.viewHandler == null) continue;
            IViewHandler iViewHandler = this.viewHandler;
            if (iViewHandler == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"viewHandler");
            }
            View view = it;
            if (view == null) {
                throw new TypeCastException("null cannot be cast to non-null type tv.mycujoo.mcls.widgets.ScaffoldView");
            }
            iViewHandler.detachOverlayView((ScaffoldView)view);
            IViewHandler iViewHandler2 = this.viewHandler;
            if (iViewHandler2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"viewHandler");
            }
            Object object = ((ScaffoldView)it).getTag();
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
            }
            iViewHandler2.removeAnimation((String)object);
        }
        IViewHandler iViewHandler = this.viewHandler;
        if (iViewHandler == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"viewHandler");
        }
        iViewHandler.clearAll();
    }

    public final void setPosterInfo(@org.jetbrains.annotations.Nullable String posterUrl) {
        this.uiEvent = UiEvent.copy$default(this.uiEvent, null, null, null, posterUrl, 7, null);
    }

    public final void setEventInfo(@NotNull String title, @NotNull String description, @NotNull String startTime) {
        Intrinsics.checkParameterIsNotNull((Object)title, (String)"title");
        Intrinsics.checkParameterIsNotNull((Object)description, (String)"description");
        Intrinsics.checkParameterIsNotNull((Object)startTime, (String)"startTime");
        this.uiEvent = new UiEvent(title, description, startTime, null, 8, null);
    }

    @Override
    public void showCustomInformationDialog(@NotNull String message) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        this.post(new Runnable(this, message){
            final /* synthetic */ MLSPlayerView this$0;
            final /* synthetic */ String $message;

            public final void run() {
                this.this$0.getPlayerView().hideController();
                FrameLayout frameLayout = (FrameLayout)this.this$0._$_findCachedViewById(R.id.infoDialogContainerLayout);
                Intrinsics.checkExpressionValueIsNotNull((Object)frameLayout, (String)"infoDialogContainerLayout");
                CustomInformationDialog dialog = new CustomInformationDialog((ViewGroup)frameLayout, MLSPlayerView.access$getUiEvent$p(this.this$0), this.$message);
                MLSPlayerView.access$getDialogs$p(this.this$0).add(dialog);
            }
            {
                this.this$0 = mLSPlayerView;
                this.$message = string2;
            }
        });
    }

    @Override
    public void showPreEventInformationDialog() {
        this.post(new Runnable(this){
            final /* synthetic */ MLSPlayerView this$0;

            public final void run() {
                this.this$0.getPlayerView().hideController();
                FrameLayout frameLayout = (FrameLayout)this.this$0._$_findCachedViewById(R.id.infoDialogContainerLayout);
                Intrinsics.checkExpressionValueIsNotNull((Object)frameLayout, (String)"infoDialogContainerLayout");
                PreEventInformationDialog dialog = new PreEventInformationDialog((ViewGroup)frameLayout, MLSPlayerView.access$getUiEvent$p(this.this$0));
                MLSPlayerView.access$getDialogs$p(this.this$0).add(dialog);
            }
            {
                this.this$0 = mLSPlayerView;
            }
        });
    }

    @Override
    public void showStartedEventInformationDialog() {
        this.post(new Runnable(this){
            final /* synthetic */ MLSPlayerView this$0;

            public final void run() {
                StartedEventInformationDialog dialog = new StartedEventInformationDialog(this.this$0, MLSPlayerView.access$getUiEvent$p(this.this$0));
                MLSPlayerView.access$getDialogs$p(this.this$0).add(dialog);
            }
            {
                this.this$0 = mLSPlayerView;
            }
        });
    }

    @Override
    public void hideInfoDialogs() {
        if ((FrameLayout)this._$_findCachedViewById(R.id.infoDialogContainerLayout) == null) {
            return;
        }
        this.post(new Runnable(this){
            final /* synthetic */ MLSPlayerView this$0;

            public final void run() {
                Iterable $this$forEach$iv = MLSPlayerView.access$getDialogs$p(this.this$0);
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    View dialog = (View)element$iv;
                    boolean bl = false;
                    ((FrameLayout)this.this$0._$_findCachedViewById(R.id.infoDialogContainerLayout)).removeView(dialog);
                }
                MLSPlayerView.access$getDialogs$p(this.this$0).clear();
            }
            {
                this.this$0 = mLSPlayerView;
            }
        });
    }

    @Override
    public void showEventInfoButton() {
        this.post(new Runnable(this){
            final /* synthetic */ MLSPlayerView this$0;

            public final void run() {
                this.this$0.showEventInfoButtonInstantly();
            }
            {
                this.this$0 = mLSPlayerView;
            }
        });
    }

    @MainThread
    public final void showEventInfoButtonInstantly() {
        View view = this.findViewById(R.id.controller_informationButtonLayout);
        Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"findViewById<FrameLayout\u2026_informationButtonLayout)");
        ((FrameLayout)view).setVisibility(0);
    }

    @Override
    public void hideEventInfoButton() {
        this.post(new Runnable(this){
            final /* synthetic */ MLSPlayerView this$0;

            public final void run() {
                this.this$0.hideEventInfoButtonInstantly();
            }
            {
                this.this$0 = mLSPlayerView;
            }
        });
    }

    @MainThread
    public final void hideEventInfoButtonInstantly() {
        this.post(new Runnable(this){
            final /* synthetic */ MLSPlayerView this$0;

            public final void run() {
                View view = this.this$0.findViewById(R.id.controller_informationButtonLayout);
                Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"findViewById<FrameLayout\u2026_informationButtonLayout)");
                ((FrameLayout)view).setVisibility(8);
            }
            {
                this.this$0 = mLSPlayerView;
            }
        });
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        if (w != 0 && h != 0) {
            this.onSizeChangedCallback.invoke();
        }
    }

    @Override
    public void addToTopRightContainer(@NotNull View view) {
        Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
        this.topRightContainer.addView(view);
    }

    @Override
    public void removeFromTopRightContainer(@NotNull View view) {
        boolean bl;
        block1: {
            Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
            Sequence $this$any$iv = ViewGroupKt.getChildren((ViewGroup)((ViewGroup)this.topRightContainer));
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                View it = (View)element$iv;
                boolean bl2 = false;
                if (!Intrinsics.areEqual((Object)it, (Object)view)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        boolean bl3 = bl;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean it = bl3;
        boolean bl6 = false;
        this.topRightContainer.removeView(view);
    }

    @Override
    public void addToTopLeftContainer(@NotNull View view) {
        Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
        this.topLeftContainer.addView(view);
    }

    @Override
    public void removeFromTopLeftContainer(@NotNull View view) {
        boolean bl;
        block1: {
            Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
            Sequence $this$any$iv = ViewGroupKt.getChildren((ViewGroup)((ViewGroup)this.topLeftContainer));
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                View it = (View)element$iv;
                boolean bl2 = false;
                if (!Intrinsics.areEqual((Object)it, (Object)view)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        boolean bl3 = bl;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean it = bl3;
        boolean bl6 = false;
        this.topLeftContainer.removeView(view);
    }

    @JvmOverloads
    public MLSPlayerView(@NotNull Context context, @org.jetbrains.annotations.Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.dialogs = new ArrayList();
        this.uiEvent = new UiEvent(null, null, null, null, 15, null);
        this.onSizeChangedCallback = onSizeChangedCallback.1.INSTANCE;
        this.timeFormatBuilder = new StringBuilder();
        this.timeFormatter = new Formatter(this.timeFormatBuilder, Locale.getDefault());
        LayoutInflater.from((Context)context).inflate(R.layout.player_view_wrapper, (ViewGroup)this, true);
        this.initAttributes(attrs, context);
        View view = this.findViewById(R.id.exoPlayerView);
        Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"findViewById(R.id.exoPlayerView)");
        this.playerView = (PlayerView)view;
        this.overlayHost = new ConstraintLayout(context);
        ((AspectRatioFrameLayout)this.playerView.findViewById(R.id.exo_content_frame)).addView((View)this.overlayHost);
        View view2 = this.findViewById(R.id.controller_topRightContainer);
        Intrinsics.checkExpressionValueIsNotNull((Object)view2, (String)"findViewById(R.id.controller_topRightContainer)");
        this.topRightContainer = (LinearLayout)view2;
        View view3 = this.findViewById(R.id.controller_topLeftContainer);
        Intrinsics.checkExpressionValueIsNotNull((Object)view3, (String)"findViewById(R.id.controller_topLeftContainer)");
        this.topLeftContainer = (LinearLayout)view3;
        this.playerView.setControllerVisibilityListener(new PlayerControlView.VisibilityListener(){

            public final void onVisibilityChange(int visibility) {
                topRightContainer.setVisibility(visibility);
                topLeftContainer.setVisibility(visibility);
            }
        });
        View view4 = this.findViewById(R.id.informationButtonLayout);
        Intrinsics.checkExpressionValueIsNotNull((Object)view4, (String)"findViewById(R.id.informationButtonLayout)");
        this.externalInformationButtonLayout = (FrameLayout)view4;
        View view5 = this.findViewById(R.id.controller_buffering);
        Intrinsics.checkExpressionValueIsNotNull((Object)view5, (String)"findViewById(R.id.controller_buffering)");
        this.bufferingProgressBar = (ProgressBar)view5;
        this.playerView.setResizeMode(0);
        ((FrameLayout)this.findViewById(R.id.controller_informationButtonLayout)).setOnClickListener(new View.OnClickListener(){

            public final void onClick(View it) {
                this.showStartedEventInformationDialog();
            }
        });
        ((ImageButton)this.findViewById(R.id.controller_informationButton)).setOnClickListener(new View.OnClickListener(){

            public final void onClick(View it) {
                this.showStartedEventInformationDialog();
            }
        });
        ((FrameLayout)this.findViewById(R.id.informationButtonLayout)).setOnClickListener(new View.OnClickListener(){

            public final void onClick(View it) {
                this.showPreEventInformationDialog();
            }
        });
        ((ImageButton)this.findViewById(R.id.informationButton)).setOnClickListener(new View.OnClickListener(){

            public final void onClick(View it) {
                this.showPreEventInformationDialog();
            }
        });
        LiveBadgeView liveBadgeTextView = (LiveBadgeView)this.findViewById(R.id.controller_liveBadgeView);
        liveBadgeTextView.setOnClickListener(new View.OnClickListener(){

            public final void onClick(View it) {
                Player player = this.getPlayerView().getPlayer();
                if (player != null) {
                    player.seekTo(-9223372036854775807L);
                }
                View view = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"it");
                view.setEnabled(false);
            }
        });
        View view6 = this.findViewById(R.id.controller_fullscreenImageButton);
        Intrinsics.checkExpressionValueIsNotNull((Object)view6, (String)"findViewById(R.id.contro\u2026er_fullscreenImageButton)");
        this.fullScreenButton = (ImageButton)view6;
        this.fullScreenButton.setOnClickListener(new View.OnClickListener(){

            public final void onClick(View it) {
                if (uiEventListener != null) {
                    isFullScreen = !isFullScreen;
                    this.updateFullscreenButtonImage();
                    this.getUiEventListener().onFullScreenButtonClicked(isFullScreen);
                }
            }
        });
        this.updateFullscreenButtonImage();
        View view7 = this.findViewById(R.id.remotePlayerControllerView);
        Intrinsics.checkExpressionValueIsNotNull((Object)view7, (String)"findViewById(R.id.remotePlayerControllerView)");
        this.remotePlayerControllerView = (RemotePlayerControllerView)view7;
        this.playerView.hideController();
        this.playerView.setControllerAutoShow(false);
        this.playerView.setUseController(false);
    }

    public /* synthetic */ MLSPlayerView(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    @JvmOverloads
    public MLSPlayerView(@NotNull Context context, @org.jetbrains.annotations.Nullable AttributeSet attrs) {
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public MLSPlayerView(@NotNull Context context) {
        this(context, null, 0, 6, null);
    }

    public static final /* synthetic */ IViewHandler access$getViewHandler$p(MLSPlayerView $this) {
        IViewHandler iViewHandler = $this.viewHandler;
        if (iViewHandler == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"viewHandler");
        }
        return iViewHandler;
    }

    public static final /* synthetic */ void access$setViewHandler$p(MLSPlayerView $this, IViewHandler iViewHandler) {
        $this.viewHandler = iViewHandler;
    }

    public static final /* synthetic */ IViewHandler access$getViewHandler$li(MLSPlayerView $this) {
        return $this.viewHandler;
    }

    public static final /* synthetic */ void access$setViewHandler$li(MLSPlayerView $this, IViewHandler iViewHandler) {
        $this.viewHandler = iViewHandler;
    }

    public static final /* synthetic */ UiEvent access$getUiEvent$p(MLSPlayerView $this) {
        return $this.uiEvent;
    }

    public static final /* synthetic */ void access$setUiEvent$p(MLSPlayerView $this, UiEvent uiEvent) {
        $this.uiEvent = uiEvent;
    }

    public static final /* synthetic */ ArrayList access$getDialogs$p(MLSPlayerView $this) {
        return $this.dialogs;
    }

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Ltv/mycujoo/mcls/widgets/MLSPlayerView$LiveState;", "", "(Ljava/lang/String;I)V", "LIVE_ON_THE_EDGE", "LIVE_TRAILING", "VOD", "mls_release"})
    public static final class LiveState
    extends Enum<LiveState> {
        public static final /* enum */ LiveState LIVE_ON_THE_EDGE;
        public static final /* enum */ LiveState LIVE_TRAILING;
        public static final /* enum */ LiveState VOD;
        private static final /* synthetic */ LiveState[] $VALUES;

        static {
            LiveState[] liveStateArray = new LiveState[3];
            LiveState[] liveStateArray2 = liveStateArray;
            liveStateArray[0] = LIVE_ON_THE_EDGE = new LiveState();
            liveStateArray[1] = LIVE_TRAILING = new LiveState();
            liveStateArray[2] = VOD = new LiveState();
            $VALUES = liveStateArray;
        }

        public static LiveState[] values() {
            return (LiveState[])$VALUES.clone();
        }

        public static LiveState valueOf(String string2) {
            return Enum.valueOf(LiveState.class, string2);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\b\n\u0002\b\b\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Ltv/mycujoo/mcls/widgets/MLSPlayerView$ResizeMode;", "", "value", "", "(Ljava/lang/String;II)V", "getValue", "()I", "RESIZE_MODE_FIT", "RESIZE_MODE_FIXED_WIDTH", "RESIZE_MODE_FIXED_HEIGHT", "RESIZE_MODE_FILL", "mls_release"})
    public static final class ResizeMode
    extends Enum<ResizeMode> {
        public static final /* enum */ ResizeMode RESIZE_MODE_FIT;
        public static final /* enum */ ResizeMode RESIZE_MODE_FIXED_WIDTH;
        public static final /* enum */ ResizeMode RESIZE_MODE_FIXED_HEIGHT;
        public static final /* enum */ ResizeMode RESIZE_MODE_FILL;
        private static final /* synthetic */ ResizeMode[] $VALUES;
        private final int value;

        static {
            ResizeMode[] resizeModeArray = new ResizeMode[4];
            ResizeMode[] resizeModeArray2 = resizeModeArray;
            resizeModeArray[0] = RESIZE_MODE_FIT = new ResizeMode(0);
            resizeModeArray[1] = RESIZE_MODE_FIXED_WIDTH = new ResizeMode(1);
            resizeModeArray[2] = RESIZE_MODE_FIXED_HEIGHT = new ResizeMode(2);
            resizeModeArray[3] = RESIZE_MODE_FILL = new ResizeMode(3);
            $VALUES = resizeModeArray;
        }

        public final int getValue() {
            return this.value;
        }

        private ResizeMode(int value) {
            this.value = value;
        }

        public static ResizeMode[] values() {
            return (ResizeMode[])$VALUES.clone();
        }

        public static ResizeMode valueOf(String string2) {
            return Enum.valueOf(ResizeMode.class, string2);
        }
    }
}

