/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.authkit.mod.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import tv.hd3g.authkit.mod.dto.Password;
import tv.hd3g.authkit.mod.exception.PasswordComplexityException;
import tv.hd3g.authkit.mod.service.ValidPasswordPolicyService;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class ValidPasswordPolicyServiceImpl
implements ValidPasswordPolicyService {
    public static final List<String> stupidPasswordWords = List.of("password", "admin", "administrator", "root");
    public static final List<String> stupidLettersNumbers = Collections.unmodifiableList(Stream.concat(IntStream.range(0, 10).mapToObj(i -> {
        char[] array = new char[4];
        Arrays.fill(array, String.valueOf(i).charAt(0));
        return new String(array);
    }), IntStream.range(97, 123).mapToObj(i -> {
        char[] array = new char[4];
        Arrays.fill(array, (char)i);
        return new String(array);
    })).collect(Collectors.toList()));
    @Value(value="${authkit.password_policy.min_size:8}")
    private int minSize;
    @Value(value="${authkit.password_policy.must_have_special_chars:false}")
    private boolean mustHaveSpecialChars;
    @Value(value="${authkit.password_policy.ignore_generic_terms:}")
    private String[] ignoreGenericTerms;
    @Value(value="${authkit.password_policy.strong.min_size:20}")
    private int strongMinSize;
    @Value(value="${authkit.password_policy.strong.must_have_special_chars:true}")
    private boolean strongMustHaveSpecialChars;

    public void checkPasswordValidation(String username, Password password, ValidPasswordPolicyService.PasswordValidationLevel level) throws PasswordComplexityException {
        Stream sUsernameParts = Stream.empty();
        if (level == ValidPasswordPolicyService.PasswordValidationLevel.DEFAULT) {
            password.checkComplexity(this.minSize, this.mustHaveSpecialChars);
            sUsernameParts = ValidPasswordPolicyServiceImpl.splitAll((String)username.toLowerCase(), (String[])new String[]{"@", "\\", "%"});
        } else if (level == ValidPasswordPolicyService.PasswordValidationLevel.STRONG) {
            password.checkComplexity(this.strongMinSize, this.strongMustHaveSpecialChars);
            sUsernameParts = ValidPasswordPolicyServiceImpl.splitAll((String)username.toLowerCase(), (String[])new String[]{"@", "\\", "%", "."});
        }
        Stream<String> sGenericTerms = Arrays.stream(Optional.ofNullable(this.ignoreGenericTerms).orElse(new String[0])).map(String::toLowerCase);
        List ignoreTermList = Stream.of(sGenericTerms, sUsernameParts, stupidPasswordWords.stream(), stupidLettersNumbers.stream()).reduce(Stream::concat).orElseGet(Stream::empty).distinct().collect(Collectors.toUnmodifiableList());
        for (String term : ignoreTermList) {
            if (!password.contain(term)) continue;
            if (level == ValidPasswordPolicyService.PasswordValidationLevel.DEFAULT) {
                password.checkComplexity(this.minSize, this.mustHaveSpecialChars, term);
                continue;
            }
            if (level != ValidPasswordPolicyService.PasswordValidationLevel.STRONG) continue;
            password.checkComplexity(this.strongMinSize, this.strongMustHaveSpecialChars, term);
        }
    }

    public static List<String> split(String text, String what) {
        ArrayList<String> list = new ArrayList<String>();
        String value = text;
        int p = -1;
        list.add(value);
        while (value.indexOf(what) > -1 && value.indexOf(what) < value.length() - 1) {
            p = value.indexOf(what);
            list.add(value.substring(0, p));
            value = value.substring(p + 1, value.length());
        }
        if (p > -1) {
            list.add(value);
        }
        return list;
    }

    public static Stream<String> splitAll(String text, String ... what) {
        ArrayList<String> list1 = new ArrayList<String>();
        list1.add(text);
        for (String w : what) {
            list1.addAll(ValidPasswordPolicyServiceImpl.split((String)text, (String)w));
        }
        ArrayList list2 = new ArrayList();
        for (String w : what) {
            list1.forEach(t -> list2.addAll(ValidPasswordPolicyServiceImpl.split((String)t, (String)w)));
        }
        return Stream.concat(list1.stream(), list2.stream()).distinct();
    }
}

