/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.authkit.mod.service;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.WriterException;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.QRCodeWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.GeneralSecurityException;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base32;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.owasp.encoder.Encode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tv.hd3g.authkit.mod.dto.SetupTOTPTokenDto;
import tv.hd3g.authkit.mod.dto.validated.ValidationSetupTOTPDto;
import tv.hd3g.authkit.mod.dto.validated.ValidationTOTPDto;
import tv.hd3g.authkit.mod.entity.Credential;
import tv.hd3g.authkit.mod.entity.Totpbackupcode;
import tv.hd3g.authkit.mod.entity.User;
import tv.hd3g.authkit.mod.exception.AuthKitException;
import tv.hd3g.authkit.mod.exception.NotAcceptableSecuredTokenException;
import tv.hd3g.authkit.mod.exception.UserCantLoginException;
import tv.hd3g.authkit.mod.repository.CredentialRepository;
import tv.hd3g.authkit.mod.repository.TotpbackupcodeRepository;
import tv.hd3g.authkit.mod.service.AuditReportService;
import tv.hd3g.authkit.mod.service.AuthenticationService;
import tv.hd3g.authkit.mod.service.SecuredTokenService;
import tv.hd3g.authkit.mod.service.TOTPService;
import tv.hd3g.commons.authkit.CipherService;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class TOTPServiceImpl
implements TOTPService {
    private static Logger log = LogManager.getLogger();
    public static final Base32 base32 = new Base32(false);
    @Autowired
    private CipherService cipherService;
    @Autowired
    private CredentialRepository credentialRepository;
    @Autowired
    private TotpbackupcodeRepository totpbackupcodeRepository;
    @Autowired
    private AuthenticationService authenticationService;
    @Autowired
    private SecuredTokenService securedTokenService;
    @Value(value="${authkit.backupCodeQuantity:6}")
    private int backupCodeQuantity;
    @Value(value="${authkit.totpTimeStepSeconds:30}")
    private int timeStepSeconds;
    @Value(value="${authkit.totpWindowMillis:5000}")
    private long windowMillis;

    public String makeSecret() {
        byte[] secret = new byte[64];
        Random random = this.cipherService.getSecureRandom();
        random.nextBytes(secret);
        return base32.encodeAsString(secret);
    }

    public URI makeURI(String secret, User user, String totpDomain) {
        Credential credential = user.getCredential();
        Objects.requireNonNull(credential, "Can't found Credential for user " + user.getUuid());
        String login = credential.getLogin();
        try {
            return new URI("otpauth://totp/" + login + "@" + Encode.forJavaScript((String)totpDomain) + "?secret=" + secret);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid URI parameters", e);
        }
    }

    public String makeQRCode(URI url) {
        try {
            int size = 400;
            BitMatrix bitMatrix = new QRCodeWriter().encode(url.toString(), BarcodeFormat.QR_CODE, 400, 400);
            ByteArrayOutputStream byteArrayQRCodePNG = new ByteArrayOutputStream(4095);
            MatrixToImageWriter.writeToStream((BitMatrix)bitMatrix, (String)"png", (OutputStream)byteArrayQRCodePNG);
            return Base64.getEncoder().encodeToString(byteArrayQRCodePNG.toByteArray());
        }
        catch (WriterException | IOException e) {
            throw new IllegalArgumentException("Problem with QRcode generation", e);
        }
    }

    public List<String> makeBackupCodes() {
        return this.cipherService.getSecureRandom().ints(this.backupCodeQuantity, 0, 1000000).mapToObj(i -> StringUtils.leftPad((String)String.valueOf(i), (int)6, (String)"0")).collect(Collectors.toUnmodifiableList());
    }

    @Transactional(readOnly=false)
    public void setupTOTP(String base32Secret, Collection<String> backupCodes, String userUUID) {
        byte[] secret = base32.decode(base32Secret);
        Credential credential = this.credentialRepository.getByUserUUID(userUUID);
        credential.getTotpBackupCodes().clear();
        Set newCodes = backupCodes.stream().map(code -> new Totpbackupcode(credential, code)).collect(Collectors.toUnmodifiableSet());
        credential.getTotpBackupCodes().addAll(newCodes);
        credential.setTotpkey(this.cipherService.cipherFromData(secret));
    }

    @Transactional(readOnly=false)
    public void setupTOTPWithChecks(ValidationSetupTOTPDto setupDto, String expectedUserUUID) {
        SetupTOTPTokenDto validatedToken;
        try {
            validatedToken = this.securedTokenService.setupTOTPExtractToken(setupDto.getControlToken());
        }
        catch (NotAcceptableSecuredTokenException e) {
            log.error("Invalid token", (Throwable)e);
            throw new AuthKitException("You can't use this token");
        }
        if (!expectedUserUUID.equalsIgnoreCase(validatedToken.getUserUUID())) {
            throw new AuthKitException("You can't use this token for this user");
        }
        byte[] secret = base32.decode(validatedToken.getSecret());
        if (!this.isCodeIsValid(secret, setupDto.getTwoauthcode())) {
            throw new AuthKitException("Invalid code");
        }
        Credential credential = this.credentialRepository.getByUserUUID(expectedUserUUID);
        Optional rejected = this.authenticationService.checkPassword(setupDto.getCurrentpassword(), credential);
        if (rejected.isPresent()) {
            throw new AuthKitException(401, "Can't accept demand, bad password ; " + ((AuditReportService.RejectLoginCause)rejected.get()).toString());
        }
        this.setupTOTP(validatedToken.getSecret(), (Collection)validatedToken.getBackupCodes(), expectedUserUUID);
    }

    private boolean isCodeIsValid(byte[] secret, String code) {
        try {
            long now = System.currentTimeMillis();
            String actualCode = TOTPServiceImpl.makeCodeAtTime((byte[])secret, (long)now, (int)this.timeStepSeconds);
            if (actualCode.equals(code)) {
                return true;
            }
            String previousCode = TOTPServiceImpl.makeCodeAtTime((byte[])secret, (long)(now - this.windowMillis), (int)this.timeStepSeconds);
            if (previousCode.equals(code)) {
                return true;
            }
            String nextCode = TOTPServiceImpl.makeCodeAtTime((byte[])secret, (long)(now + this.windowMillis), (int)this.timeStepSeconds);
            if (nextCode.equals(code)) {
                return true;
            }
        }
        catch (GeneralSecurityException e) {
            throw new AuthKitException(500, "Can't manage cipher tools");
        }
        return false;
    }

    @Transactional(readOnly=true)
    public void checkCodeAndPassword(Credential credential, ValidationTOTPDto validationDto) {
        Optional optPassword = this.authenticationService.checkPassword(validationDto.getCurrentpassword(), credential);
        if (optPassword.isPresent()) {
            throw new AuthKitException(401, "Invalid password: " + optPassword.get());
        }
        try {
            this.checkCode(credential, validationDto.getTwoauthcode());
        }
        catch (UserCantLoginException.BadTOTPCodeCantLoginException e) {
            throw new AuthKitException(401, "Invalid 2auth code");
        }
    }

    @Transactional(readOnly=false)
    public void checkCode(Credential credential, String stringCode) throws UserCantLoginException.BadTOTPCodeCantLoginException {
        byte[] secret = this.cipherService.unCipherToData(credential.getTotpkey());
        if (!this.isCodeIsValid(secret, stringCode)) {
            Totpbackupcode bcpCode = this.totpbackupcodeRepository.getByCredential(credential).stream().filter(bcp -> bcp.getCode().equals(stringCode)).findFirst().orElseThrow(UserCantLoginException.BadTOTPCodeCantLoginException::new);
            this.totpbackupcodeRepository.delete((Object)bcpCode);
        }
    }

    @Transactional(readOnly=false)
    public void removeTOTP(Credential credential) {
        credential.setTotpkey(null);
        this.credentialRepository.save((Object)credential);
        this.totpbackupcodeRepository.getByCredential(credential).forEach(bcp -> this.totpbackupcodeRepository.delete(bcp));
    }

    public static String makeCodeAtTime(byte[] secret, long timeMillis, int timeStepSeconds) throws GeneralSecurityException {
        byte[] data = new byte[8];
        long value = timeMillis / 1000L / (long)timeStepSeconds;
        int i = 7;
        while (value > 0L) {
            data[i] = (byte)(value & 0xFFL);
            value >>= 8;
            --i;
        }
        SecretKeySpec signKey = new SecretKeySpec(secret, "HmacSHA1");
        Mac mac = Mac.getInstance("HmacSHA1");
        mac.init(signKey);
        byte[] hash = mac.doFinal(data);
        int offset = hash[hash.length - 1] & 0xF;
        long truncatedHash = 0L;
        for (int i2 = offset; i2 < offset + 4; ++i2) {
            truncatedHash <<= 8;
            truncatedHash |= (long)(hash[i2] & 0xFF);
        }
        truncatedHash &= Integer.MAX_VALUE;
        return StringUtils.leftPad((String)String.valueOf((int)(truncatedHash %= 1000000L)), (int)6, (String)"0");
    }
}

