/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.authkit.mod.service;

import java.net.InetAddress;
import java.util.Optional;
import tv.hd3g.authkit.mod.dto.ExternalAuthUserDto;
import tv.hd3g.authkit.mod.dto.Password;
import tv.hd3g.authkit.mod.exception.UserCantLoginException;

public interface ExternalAuthClientService {
    public boolean isAvailable();

    public Optional<String> getDefaultDomainName();

    public ExternalAuthUserDto logonUser(String var1, Password var2, String var3) throws UserCantLoginException;

    public boolean isIPAllowedToCreateUserAccount(InetAddress var1, String var2);

    default public ExternalAuthUserDto logonUser(String login, Password password) throws UserCantLoginException {
        Optional oDefaultDomain = this.getDefaultDomainName();
        if (oDefaultDomain.isEmpty()) {
            throw new UserCantLoginException.ExternalAuthErrorCantLoginException();
        }
        return this.logonUser(login, password, (String)oDefaultDomain.get());
    }

    default public boolean isIPAllowedToCreateUserAccount(InetAddress address) {
        Optional oDefaultDomain = this.getDefaultDomainName();
        if (oDefaultDomain.isEmpty()) {
            return false;
        }
        return this.isIPAllowedToCreateUserAccount(address, (String)oDefaultDomain.get());
    }
}

