/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.authkit.mod.service;

import java.util.Arrays;
import javax.transaction.Transactional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import tv.hd3g.authkit.mod.controller.RestControllerUser;
import tv.hd3g.authkit.mod.dto.Password;
import tv.hd3g.authkit.mod.dto.validated.AddGroupOrRoleDto;
import tv.hd3g.authkit.mod.dto.validated.AddUserDto;
import tv.hd3g.authkit.mod.entity.Credential;
import tv.hd3g.authkit.mod.exception.BlockedUserException;
import tv.hd3g.authkit.mod.exception.ResetWithSamePasswordException;
import tv.hd3g.authkit.mod.repository.CredentialRepository;
import tv.hd3g.authkit.mod.service.AuthenticationService;
import tv.hd3g.authkit.mod.service.CmdLineService;
import tv.hd3g.commons.authkit.CheckBefore;

@Service
public class CmdLineServiceImpl
implements CmdLineService {
    private static Logger log = LogManager.getLogger();
    @Autowired
    private CredentialRepository credentialRepository;
    @Autowired
    private AuthenticationService authenticationService;
    @Value(value="${authkit.realm:default}")
    private String realm;

    @Transactional(value=Transactional.TxType.REQUIRES_NEW)
    public void addOrUpdateSecurityAdminUser(String login, Password password) throws ResetWithSamePasswordException {
        String userUUID;
        Credential previousUser = this.credentialRepository.getFromRealmLogin(this.realm, login);
        if (previousUser != null) {
            userUUID = previousUser.getUser().getUuid();
            this.authenticationService.resetUserLogonTrials(userUUID);
            try {
                this.authenticationService.changeUserPassword(previousUser.getUser().getUuid(), password);
            }
            catch (BlockedUserException e) {
                log.error("Unexpected error", (Throwable)e);
            }
            this.authenticationService.enableUser(userUUID);
        } else {
            AddUserDto addUserDto = new AddUserDto();
            addUserDto.setUserLogin(login);
            addUserDto.setUserPassword(password);
            userUUID = this.authenticationService.addUser(addUserDto);
        }
        AddGroupOrRoleDto g = new AddGroupOrRoleDto();
        g.setName("SecurityAdmins");
        g.setDescription("Autogenerated group for " + login);
        this.authenticationService.addGroup(g);
        this.authenticationService.addUserInGroup(userUUID, g.getName());
        AddGroupOrRoleDto r = new AddGroupOrRoleDto();
        r.setName("SecurityOnly");
        r.setName("Autogenerated role for " + login);
        this.authenticationService.addRole(r);
        this.authenticationService.addGroupInRole(g.getName(), r.getName());
        Arrays.stream((CheckBefore[])RestControllerUser.class.getAnnotationsByType(CheckBefore.class)).findFirst().map(cb -> Arrays.stream(cb.value())).ifPresent(cb -> cb.forEach(rightName -> this.authenticationService.addRightInRole(r.getName(), rightName)));
    }
}

