/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.authkit.mod.service;

import de.mkammerer.argon2.Argon2;
import de.mkammerer.argon2.Argon2Factory;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.time.Duration;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tv.hd3g.authkit.mod.component.EndpointsListener;
import tv.hd3g.authkit.mod.dto.ExternalAuthUserDto;
import tv.hd3g.authkit.mod.dto.Password;
import tv.hd3g.authkit.mod.dto.ressource.GroupOrRoleDto;
import tv.hd3g.authkit.mod.dto.ressource.UserDto;
import tv.hd3g.authkit.mod.dto.ressource.UserPrivacyDto;
import tv.hd3g.authkit.mod.dto.validated.AddGroupOrRoleDto;
import tv.hd3g.authkit.mod.dto.validated.AddUserDto;
import tv.hd3g.authkit.mod.dto.validated.LoginFormDto;
import tv.hd3g.authkit.mod.dto.validated.RenameGroupOrRoleDto;
import tv.hd3g.authkit.mod.dto.validated.TOTPLogonCodeFormDto;
import tv.hd3g.authkit.mod.entity.Credential;
import tv.hd3g.authkit.mod.entity.Group;
import tv.hd3g.authkit.mod.entity.Role;
import tv.hd3g.authkit.mod.entity.RoleRight;
import tv.hd3g.authkit.mod.entity.RoleRightContext;
import tv.hd3g.authkit.mod.entity.User;
import tv.hd3g.authkit.mod.entity.Userprivacy;
import tv.hd3g.authkit.mod.exception.AuthKitException;
import tv.hd3g.authkit.mod.exception.BlockedUserException;
import tv.hd3g.authkit.mod.exception.NotAcceptableSecuredTokenException;
import tv.hd3g.authkit.mod.exception.PasswordComplexityException;
import tv.hd3g.authkit.mod.exception.ResetWithSamePasswordException;
import tv.hd3g.authkit.mod.exception.UserCantLoginException;
import tv.hd3g.authkit.mod.repository.CredentialRepository;
import tv.hd3g.authkit.mod.repository.GroupRepository;
import tv.hd3g.authkit.mod.repository.RoleRepository;
import tv.hd3g.authkit.mod.repository.RoleRightContextRepository;
import tv.hd3g.authkit.mod.repository.RoleRightRepository;
import tv.hd3g.authkit.mod.repository.UserDao;
import tv.hd3g.authkit.mod.repository.UserPrivacyRepository;
import tv.hd3g.authkit.mod.repository.UserRepository;
import tv.hd3g.authkit.mod.service.AuditReportService;
import tv.hd3g.authkit.mod.service.AuditReportServiceImpl;
import tv.hd3g.authkit.mod.service.AuthenticationService;
import tv.hd3g.authkit.mod.service.AuthenticationServiceImpl;
import tv.hd3g.authkit.mod.service.ExternalAuthClientService;
import tv.hd3g.authkit.mod.service.SecuredTokenService;
import tv.hd3g.authkit.mod.service.TOTPService;
import tv.hd3g.authkit.mod.service.ValidPasswordPolicyService;
import tv.hd3g.commons.authkit.CipherService;

@Service
@Transactional(readOnly=false)
public class AuthenticationServiceImpl
implements AuthenticationService {
    private static final Argon2 ARGON2 = Argon2Factory.create();
    private static final String MSG_CANT_FOUND_CREDENTIAL_FOR_USER = "Can't found Credential for user ";
    private static Logger log = LogManager.getLogger();
    @Autowired
    private SecuredTokenService tokenService;
    @Autowired
    private CredentialRepository credentialRepository;
    @Autowired
    private AuditReportService auditReportService;
    @Autowired
    private CipherService cipherService;
    @Autowired
    private TOTPService totpService;
    @Autowired
    private EndpointsListener endpointsListener;
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private GroupRepository groupRepository;
    @Autowired
    private RoleRepository roleRepository;
    @Autowired
    private RoleRightRepository roleRightRepository;
    @Autowired
    private RoleRightContextRepository roleRightContextRepository;
    @Autowired
    private UserDao userDao;
    @Autowired
    private UserPrivacyRepository userPrivacyRepository;
    @Autowired
    private ValidPasswordPolicyService validPasswordPolicy;
    @Autowired
    private ExternalAuthClientService externalAuthClientService;
    @Value(value="${authkit.realm:default}")
    private String realm;
    @Value(value="${authkit.longSessionDuration:24h}")
    private Duration longSessionDuration;
    @Value(value="${authkit.shortSessionDuration:10m}")
    private Duration shortSessionDuration;
    @Value(value="${authkit.maxLogonTrial:10}")
    private short maxLogonTrial;
    @Value(value="${authkit.argon2.iterations:10}")
    private int iterations;
    @Value(value="${authkit.argon2.memory:2048}")
    private int memory;
    @Value(value="${authkit.argon2.parallelism:2}")
    private int parallelism;

    private User getUserByUUID(String userUUID) {
        return Optional.ofNullable(this.userRepository.getByUUID(userUUID)).orElseThrow(() -> new AuthKitException("Can't found User " + userUUID));
    }

    private Group getGroupByName(String name) {
        return Optional.ofNullable(this.groupRepository.getByName(name)).orElseThrow(() -> new AuthKitException("Can't found group \"" + name + "\""));
    }

    private Role getRoleByName(String name) {
        return Optional.ofNullable(this.roleRepository.getByName(name)).orElseThrow(() -> new AuthKitException("Can't found role \"" + name + "\""));
    }

    private RoleRight getRoleRight(String roleName, String rightName) {
        return Optional.ofNullable(this.roleRightRepository.getRoleRight(roleName, rightName)).orElseThrow(() -> new AuthKitException("Can't found role right \"" + roleName + ":" + rightName + "\""));
    }

    public Optional<AuditReportService.RejectLoginCause> checkPassword(Password userEnterPassword, Credential credential) {
        if (userEnterPassword == null) {
            return Optional.of(AuditReportService.RejectLoginCause.MISSING_PASSWORD);
        }
        if (userEnterPassword.length() == 0) {
            return Optional.of(AuditReportService.RejectLoginCause.EMPTY_PASSWORD);
        }
        if (credential.getLdapdomain() != null) {
            try {
                this.externalAuthClientService.logonUser(credential.getLogin(), userEnterPassword, credential.getLdapdomain());
            }
            catch (UserCantLoginException e) {
                return Optional.of(AuditReportService.RejectLoginCause.INVALID_PASSWORD);
            }
        } else {
            String passwordHash = this.cipherService.unCipherToString(credential.getPasswordhash());
            if (!userEnterPassword.verify(ARGON2, passwordHash)) {
                return Optional.of(AuditReportService.RejectLoginCause.INVALID_PASSWORD);
            }
        }
        return Optional.empty();
    }

    private void checkLoginUserIsEnabled(HttpServletRequest request, Credential credential, String what) throws UserCantLoginException.DisabledUserCantLoginException {
        if (!credential.isEnabled()) {
            this.auditReportService.onRejectLogin(request, AuditReportService.RejectLoginCause.DISABLED_LOGIN, this.realm, what);
            throw new UserCantLoginException.DisabledUserCantLoginException();
        }
    }

    private void checkLoginUserMustchangepassword(Credential credential, String userUUID) throws UserCantLoginException.UserMustChangePasswordException {
        if (credential.isMustchangepassword()) {
            throw new UserCantLoginException.UserMustChangePasswordException(userUUID);
        }
    }

    private void checkLoginUserBlocked(Credential credential) throws UserCantLoginException.BlockedUserCantLoginException {
        if (credential.getLogontrial() >= this.maxLogonTrial) {
            throw new UserCantLoginException.BlockedUserCantLoginException();
        }
    }

    private void checkLoginUserNoCredential(HttpServletRequest request, Credential credential, String what) throws UserCantLoginException.UnknownUserCantLoginException {
        if (credential == null) {
            this.auditReportService.onRejectLogin(request, AuditReportService.RejectLoginCause.USER_NOT_FOUND, this.realm, what);
            throw new UserCantLoginException.UnknownUserCantLoginException();
        }
    }

    private void checkPasswordDuringLogin(HttpServletRequest request, LoginFormDto form, Credential credential) throws UserCantLoginException.NoPasswordUserCantLoginException, UserCantLoginException.BadPasswordUserCantLoginException {
        Optional checkPasswordBadResult = this.checkPassword(form.getUserpassword(), credential);
        if (checkPasswordBadResult.isPresent()) {
            this.auditReportService.onRejectLogin(request, (AuditReportService.RejectLoginCause)checkPasswordBadResult.get(), this.realm, form.getUserlogin());
            switch (1.$SwitchMap$tv$hd3g$authkit$mod$service$AuditReportService$RejectLoginCause[((AuditReportService.RejectLoginCause)checkPasswordBadResult.get()).ordinal()]) {
                case 1: 
                case 2: {
                    throw new UserCantLoginException.NoPasswordUserCantLoginException();
                }
            }
            credential.setLogontrial(credential.getLogontrial() + 1);
            this.credentialRepository.save((Object)credential);
            throw new UserCantLoginException.BadPasswordUserCantLoginException();
        }
    }

    private Credential importLDAPUserFirstTime(HttpServletRequest request, LoginFormDto form) throws UserCantLoginException.UnknownUserCantLoginException {
        try {
            InetAddress clientAddr = InetAddress.getByName(AuditReportServiceImpl.getOriginalRemoteAddr((HttpServletRequest)request));
            if (!this.externalAuthClientService.isIPAllowedToCreateUserAccount(clientAddr)) {
                throw new UserCantLoginException.UnknownUserCantLoginException();
            }
            ExternalAuthUserDto ldapUser = this.externalAuthClientService.logonUser(form.getUserlogin(), form.getUserpassword());
            String userUUID = this.userDao.addLDAPUserCredential(ldapUser.getLogin(), ldapUser.getDomain(), this.realm).toString();
            return this.credentialRepository.getByUserUUID(userUUID);
        }
        catch (UnknownHostException | UserCantLoginException e) {
            this.auditReportService.onRejectLogin(request, AuditReportService.RejectLoginCause.USER_NOT_FOUND, this.realm, form.getUserlogin());
            throw new UserCantLoginException.UnknownUserCantLoginException();
        }
    }

    private void ldapLogon(HttpServletRequest request, LoginFormDto form, Credential credential, User user) throws UserCantLoginException.UnknownUserCantLoginException {
        try {
            ExternalAuthUserDto ldapUser = this.externalAuthClientService.logonUser(credential.getLogin(), form.getUserpassword(), credential.getLdapdomain());
            this.setUserPrivacy(user.getUuid(), new UserPrivacyDto(ldapUser));
            Set groupNames = user.getGroups().stream().map(Group::getName).distinct().collect(Collectors.toUnmodifiableSet());
            ldapUser.getGroups().forEach(ldapGroupName -> {
                if (groupNames.contains(ldapGroupName)) {
                    return;
                }
                Group group = this.groupRepository.getByName(ldapGroupName);
                if (group == null) {
                    group = new Group(ldapGroupName);
                    group.setDescription("Imported from LDAP");
                    group = (Group)this.groupRepository.save((Object)group);
                    log.info("Create group \"{}\" from LDAP query", ldapGroupName);
                }
                user.getGroups().add(group);
            });
        }
        catch (UserCantLoginException e) {
            this.auditReportService.onRejectLogin(request, AuditReportService.RejectLoginCause.USER_NOT_FOUND, this.realm, credential.getLogin());
            throw new UserCantLoginException.UnknownUserCantLoginException();
        }
    }

    public String userLoginRequest(HttpServletRequest request, LoginFormDto form) throws UserCantLoginException {
        Credential credential = this.credentialRepository.getFromRealmLogin(this.realm, form.getUserlogin());
        if (credential == null && this.externalAuthClientService.isAvailable()) {
            credential = this.importLDAPUserFirstTime(request, form);
        }
        this.checkLoginUserNoCredential(request, credential, form.getUserlogin());
        this.checkLoginUserBlocked(credential);
        User user = credential.getUser();
        this.checkLoginUserIsEnabled(request, credential, form.getUserlogin());
        if (credential.getLdapdomain() != null) {
            this.ldapLogon(request, form, credential, user);
        } else {
            this.checkPasswordDuringLogin(request, form, credential);
        }
        String userUUID = user.getUuid();
        this.checkLoginUserMustchangepassword(credential, userUUID);
        byte[] totpKey = credential.getTotpkey();
        if (totpKey != null) {
            throw new UserCantLoginException.TOTPUserCantLoginException(userUUID);
        }
        return this.prepareSessionToken(request, form.isShortSessionTime(), credential, userUUID);
    }

    private String prepareSessionToken(HttpServletRequest request, boolean shortSessionTime, Credential credential, String userUUID) {
        String clientAddr = AuditReportServiceImpl.getOriginalRemoteAddr((HttpServletRequest)request);
        Set tags = Set.copyOf(this.userDao.getRightsForUser(userUUID, clientAddr));
        credential.setLastlogin(new Date());
        credential.setLogontrial(0);
        Duration sessionDuration = shortSessionTime ? this.shortSessionDuration : this.longSessionDuration;
        String host = this.userDao.haveRightsForUserWithOnlyIP(userUUID, clientAddr) ? clientAddr : null;
        String userSessionToken = this.tokenService.loggedUserRightsGenerateToken(userUUID, sessionDuration, tags, host);
        this.auditReportService.onLogin(request, this.longSessionDuration, tags);
        return userSessionToken;
    }

    public String userLoginRequest(HttpServletRequest request, TOTPLogonCodeFormDto form) throws UserCantLoginException, NotAcceptableSecuredTokenException {
        String userUUID = this.tokenService.userFormExtractTokenUUID("totp-code", form.getSecuretoken());
        Credential credential = this.credentialRepository.getByUserUUID(userUUID);
        this.checkLoginUserNoCredential(request, credential, userUUID);
        this.checkLoginUserBlocked(credential);
        this.checkLoginUserIsEnabled(request, credential, userUUID);
        this.checkLoginUserMustchangepassword(credential, userUUID);
        try {
            this.totpService.checkCode(credential, form.getCode());
        }
        catch (UserCantLoginException.BadTOTPCodeCantLoginException e) {
            credential.setLogontrial(credential.getLogontrial() + 1);
            this.credentialRepository.save((Object)credential);
            throw e;
        }
        return this.prepareSessionToken(request, form.getShorttime().booleanValue(), credential, userUUID);
    }

    public String addUser(AddUserDto addUser) {
        String userLogin = addUser.getUserLogin();
        try {
            this.validPasswordPolicy.checkPasswordValidation(addUser, ValidPasswordPolicyService.PasswordValidationLevel.DEFAULT);
        }
        catch (PasswordComplexityException e) {
            throw new AuthKitException("Invalid new password: " + e.getMessage());
        }
        Credential previousUser = this.credentialRepository.getFromRealmLogin(this.realm, userLogin);
        if (previousUser != null) {
            throw new AuthKitException("User \"" + addUser.getUserLogin() + "\" actually exists");
        }
        String hashedPassword = addUser.getUserPassword().hash(userPassword -> ARGON2.hash(this.iterations, this.memory, this.parallelism, userPassword));
        byte[] cipherHashedPassword = this.cipherService.cipherFromString(hashedPassword);
        String userUUID = this.userDao.addUserCredential(userLogin, cipherHashedPassword, this.realm).toString();
        log.info("Add user {} [{}]", (Object)userLogin, (Object)userUUID);
        return userUUID;
    }

    public void removeUser(String userUUID) {
        this.getUserByUUID(userUUID);
        log.info("Remove user {}", (Object)userUUID);
        this.userDao.deleteUser(UUID.fromString(userUUID));
    }

    public void disableUser(String userUUID) {
        User user = this.getUserByUUID(userUUID);
        log.info("Disable user {}", (Object)userUUID);
        Credential credential = user.getCredential();
        Objects.requireNonNull(credential, MSG_CANT_FOUND_CREDENTIAL_FOR_USER + userUUID);
        credential.setEnabled(false);
        this.credentialRepository.save((Object)credential);
    }

    public void enableUser(String userUUID) {
        User user = this.getUserByUUID(userUUID);
        log.info("Enable user {}", (Object)userUUID);
        Credential credential = user.getCredential();
        Objects.requireNonNull(credential, MSG_CANT_FOUND_CREDENTIAL_FOR_USER + userUUID);
        credential.setEnabled(true);
        this.credentialRepository.save((Object)credential);
    }

    public void resetUserLogonTrials(String userUUID) {
        User user = this.getUserByUUID(userUUID);
        log.info("Reset user logon trials {}", (Object)userUUID);
        Credential credential = user.getCredential();
        Objects.requireNonNull(credential, MSG_CANT_FOUND_CREDENTIAL_FOR_USER + userUUID);
        credential.setLogontrial(0);
        this.credentialRepository.save((Object)credential);
    }

    public void setUserMustChangePassword(String userUUID) {
        User user = this.getUserByUUID(userUUID);
        log.info("Switch user must change password {}", (Object)userUUID);
        Credential credential = user.getCredential();
        Objects.requireNonNull(credential, MSG_CANT_FOUND_CREDENTIAL_FOR_USER + userUUID);
        credential.setMustchangepassword(true);
        this.credentialRepository.save((Object)credential);
    }

    public void changeUserPassword(String userUUID, Password newPassword) throws ResetWithSamePasswordException, BlockedUserException {
        Objects.requireNonNull(newPassword, "No password enter");
        User user = this.getUserByUUID(userUUID);
        Credential credential = user.getCredential();
        Objects.requireNonNull(credential, MSG_CANT_FOUND_CREDENTIAL_FOR_USER + userUUID);
        if (credential.getLogontrial() >= this.maxLogonTrial) {
            throw new BlockedUserException();
        }
        try {
            this.validPasswordPolicy.checkPasswordValidation(credential.getLogin(), newPassword, ValidPasswordPolicyService.PasswordValidationLevel.DEFAULT);
        }
        catch (PasswordComplexityException e) {
            throw new AuthKitException("Invalid new password: " + e.getMessage());
        }
        Password newPasswordForChecks = newPassword.duplicate();
        String passwordHashCheck = this.cipherService.unCipherToString(credential.getPasswordhash());
        if (newPasswordForChecks.verify(ARGON2, passwordHashCheck)) {
            throw new ResetWithSamePasswordException();
        }
        String newHashedPassword = newPassword.hash(userPassword -> ARGON2.hash(this.iterations, this.memory, this.parallelism, userPassword));
        byte[] newCipherHashedPassword = this.cipherService.cipherFromString(newHashedPassword);
        credential.setPasswordhash(newCipherHashedPassword);
        credential.setMustchangepassword(false);
        log.info("User change password {}", (Object)userUUID);
        this.credentialRepository.save((Object)credential);
    }

    public List<String> getRightsForUser(String userUUID, String clientAddr) {
        return this.userDao.getRightsForUser(userUUID, clientAddr);
    }

    public List<String> getContextRightsForUser(String userUUID, String clientAddr, String rightName) {
        return this.userDao.getContextRightsForUser(userUUID, clientAddr, rightName);
    }

    public boolean isUserEnabledAndNonBlocked(String userUUID) {
        Credential credential = this.credentialRepository.getByUserUUID(userUUID);
        return !(credential == null || !credential.isEnabled() || credential.isMustchangepassword() || credential.getLogontrial() >= this.maxLogonTrial);
    }

    public void addGroup(AddGroupOrRoleDto newGroup) {
        String name = newGroup.getName();
        if (this.groupRepository.getByName(name) != null) {
            return;
        }
        Group group = new Group(name);
        group.setDescription(newGroup.getDescription());
        this.groupRepository.save((Object)group);
        log.info("Create group \"{}\"", (Object)name);
    }

    public void renameGroup(RenameGroupOrRoleDto renameGroup) {
        String name = renameGroup.getName();
        this.getGroupByName(name).setName(renameGroup.getNewname());
        log.info("Rename group \"{}\" to \"{}\"", (Object)name, (Object)renameGroup.getNewname());
    }

    public void setGroupDescription(AddGroupOrRoleDto changeGroup) {
        String name = changeGroup.getName();
        this.getGroupByName(name).setDescription(changeGroup.getDescription());
        log.info("Change role \"{}\" description to \"{}\"", (Object)name, (Object)changeGroup.getDescription());
    }

    public void addUserInGroup(String userUUID, String groupName) {
        this.getUserByUUID(userUUID).getGroups().add(this.getGroupByName(groupName));
        log.info("Add user {} in group \"{}\"", (Object)userUUID, (Object)groupName);
    }

    public void removeUserInGroup(String userUUID, String groupName) {
        this.getUserByUUID(userUUID).getGroups().remove(this.getGroupByName(groupName));
        log.info("Remove user {} from group \"{}\"", (Object)userUUID, (Object)groupName);
    }

    public void removeGroup(String groupName) {
        this.groupRepository.delete((Object)this.getGroupByName(groupName));
        log.info("Remove group \"{}\"", (Object)groupName);
    }

    public List<GroupOrRoleDto> listAllGroups() {
        return this.groupRepository.findAll().stream().map(GroupOrRoleDto::new).collect(Collectors.toUnmodifiableList());
    }

    public List<GroupOrRoleDto> listGroupsForUser(String userUUID) {
        return this.groupRepository.getByUserUUID(userUUID).stream().map(GroupOrRoleDto::new).collect(Collectors.toUnmodifiableList());
    }

    public void addRole(AddGroupOrRoleDto newRole) {
        String name = newRole.getName();
        if (this.roleRepository.getByName(name) != null) {
            return;
        }
        Role role = new Role(name);
        role.setDescription(newRole.getDescription());
        this.roleRepository.save((Object)role);
        log.info("Create role \"{}\"", (Object)name);
    }

    public void renameRole(RenameGroupOrRoleDto renameRole) {
        String name = renameRole.getName();
        this.getRoleByName(name).setName(renameRole.getNewname());
        log.info("Rename role \"{}\" to \"{}\"", (Object)name, (Object)renameRole.getNewname());
    }

    public void setRoleDescription(AddGroupOrRoleDto changeRole) {
        String name = changeRole.getName();
        Role role = this.getRoleByName(name);
        role.setDescription(changeRole.getDescription());
        log.info("Change role \"{}\" description to \"{}\"", (Object)name, (Object)changeRole.getDescription());
    }

    public void setRoleOnlyForClient(String roleName, String ipAddr) {
        try {
            String addr = InetAddress.getByName(ipAddr).getHostAddress().toLowerCase();
            this.roleRepository.getByName(roleName).setOnlyforclient(addr);
            log.info("Change role \"{}\" IP restriction to \"{}\"", (Object)roleName, (Object)addr);
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException("Invalid IP Addr", e);
        }
    }

    public void addGroupInRole(String groupName, String roleName) {
        this.getGroupByName(groupName).getRoles().add(this.getRoleByName(roleName));
        log.info("Add role {} in group \"{}\"", (Object)roleName, (Object)groupName);
    }

    public void removeGroupInRole(String groupName, String roleName) {
        this.getGroupByName(groupName).getRoles().remove(this.getRoleByName(roleName));
        log.info("Remove role {} from group \"{}\"", (Object)roleName, (Object)groupName);
    }

    public void removeRole(String roleName) {
        this.roleRepository.delete((Object)this.getRoleByName(roleName));
        log.info("Remove role \"{}\"", (Object)roleName);
    }

    public List<GroupOrRoleDto> listAllRoles() {
        return this.roleRepository.findAll().stream().map(GroupOrRoleDto::new).collect(Collectors.toUnmodifiableList());
    }

    public List<GroupOrRoleDto> listRolesForGroup(String groupName) {
        return this.roleRepository.getByGroupName(groupName).stream().map(GroupOrRoleDto::new).collect(Collectors.toUnmodifiableList());
    }

    public void addRightInRole(String roleName, String rightName) {
        Role role = this.getRoleByName(roleName);
        if (role.getRoleRights().stream().anyMatch(r -> r.getName().equals(rightName))) {
            return;
        }
        RoleRight rr = new RoleRight(rightName, role);
        this.roleRightRepository.save((Object)rr);
        log.info("Add right \"{}\" in role \"{}\"", (Object)rightName, (Object)roleName);
    }

    public void removeRightInRole(String roleName, String rightName) {
        Role role = this.getRoleByName(roleName);
        role.getRoleRights().removeIf(r -> r.getName().equals(rightName));
        log.info("Remove right \"{}\" from role \"{}\"", (Object)rightName, (Object)roleName);
    }

    public Set<String> getAllRights() {
        return this.endpointsListener.getAllRights();
    }

    public List<String> listRightsForRole(String roleName) {
        return this.roleRightRepository.getRoleRightNamesByRoleName(roleName);
    }

    public void addContextInRight(String roleName, String rightName, String context) {
        if (this.roleRightContextRepository.countContextPresenceForRightRole(roleName, rightName, context) > 0L) {
            return;
        }
        RoleRightContext rrc = new RoleRightContext(context, this.getRoleRight(roleName, rightName));
        this.roleRightContextRepository.save((Object)rrc);
        log.info("Add right context {} for right \"{}\" in role \"{}\"", (Object)context, (Object)rightName, (Object)roleName);
    }

    public void removeContextInRight(String roleName, String rightName, String context) {
        if (this.roleRightContextRepository.countContextPresenceForRightRole(roleName, rightName, context) == 0L) {
            return;
        }
        this.getRoleRight(roleName, rightName).getRoleRightContexts().removeIf(rrc -> rrc.getName().equals(context));
        log.info("Remove right context {} from right \"{}\" in role \"{}\"", (Object)context, (Object)rightName, (Object)roleName);
    }

    public List<String> listContextsForRight(String roleName, String rightName) {
        return this.roleRightContextRepository.listContextsForRightRole(roleName, rightName);
    }

    public List<UserDto> listLinkedUsersForGroup(String groupName) {
        return this.getGroupByName(groupName).getUsers().stream().map(UserDto::new).collect(Collectors.toUnmodifiableList());
    }

    public List<GroupOrRoleDto> listLinkedGroupsForRole(String roleName) {
        return this.getRoleByName(roleName).getGroups().stream().map(GroupOrRoleDto::new).collect(Collectors.toUnmodifiableList());
    }

    public List<UserPrivacyDto> getUserPrivacyList(Collection<String> userUUIDList) {
        Function<byte[], String> unCipher = ciphered -> {
            if (ciphered == null) {
                return null;
            }
            return this.cipherService.unCipherToString(ciphered);
        };
        return this.userPrivacyRepository.getByUserUUID(userUUIDList).stream().map(up -> new UserPrivacyDto(up, unCipher)).collect(Collectors.toUnmodifiableList());
    }

    public void setUserPrivacy(String userUUID, UserPrivacyDto userPrivacyDto) {
        Userprivacy currentItem = this.userPrivacyRepository.getByUserUUID(userUUID);
        if (currentItem == null) {
            currentItem = new Userprivacy(userUUID);
        }
        userPrivacyDto.mergue(currentItem, noncipher -> this.cipherService.cipherFromString(noncipher));
        if (userPrivacyDto.getEmail() != null) {
            currentItem.setHashedEmail(this.cipherService.computeSHA3FromString(userPrivacyDto.getEmail()));
        }
        this.userPrivacyRepository.save((Object)currentItem);
    }
}

