/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.authkit.mod.service;

import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tv.hd3g.authkit.mod.ControllerInterceptor;
import tv.hd3g.authkit.mod.entity.Audit;
import tv.hd3g.authkit.mod.repository.AuditRepository;
import tv.hd3g.authkit.mod.service.AuditReportService;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
@Transactional(readOnly=false)
public class AuditReportServiceImpl
implements AuditReportService {
    private static Logger log = LogManager.getLogger();
    public static final String EVENTNAME_REPORT = "Report";
    public static final String EVENTNAME_LOGIN = "Login";
    public static final String EVENTNAME_REJECT_LOGIN = "RejectLogin";
    public static final String EVENTNAME_SIMPLE_EVENT = "SimpleEvent";
    public static final String EVENTNAME_USE_SECURITY = "UseSecurity";
    public static final String EVENTNAME_CHANGE_SECURITY = "ChangeSecurity";
    public static final String EVENTNAME_ERROR = "Error";
    public static final String EVENTNAME_FORBIDDEN_REQUEST = "ForbiddenRequest";
    public static final String EVENTNAME_UNAUTHORIZED_REQUEST = "UnauthorizedRequest";
    @Autowired
    private AuditRepository auditRepository;
    @Value(value="${authkit.audit.appname:authkit}")
    private String appname;

    public static String getOriginalRemoteAddr(HttpServletRequest request) {
        return Optional.ofNullable(request.getHeader("X-Forwarded-For")).map(proxyReturn -> Arrays.stream(proxyReturn.split(",")).findFirst().get().trim()).orElse(request.getRemoteAddr());
    }

    private static String getFullURLQuery(HttpServletRequest request) {
        String queryString = Optional.ofNullable(request.getQueryString()).map(qs -> "?" + qs).orElse("");
        return request.getContextPath() + request.getPathInfo() + queryString;
    }

    private Audit prepareAudit(HttpServletRequest request, String eventName) {
        String clientsourcehost = AuditReportServiceImpl.getOriginalRemoteAddr((HttpServletRequest)request);
        String requestcontenttype = Optional.ofNullable(request.getContentType()).orElse("null/null");
        long requestlength = request.getContentLengthLong();
        return new Audit(this.appname, UUID.randomUUID().toString(), clientsourcehost, Integer.valueOf(request.getRemotePort()), request.getLocalAddr(), Integer.valueOf(request.getLocalPort()), eventName, request.getScheme(), request.getMethod(), AuditReportServiceImpl.getFullURLQuery((HttpServletRequest)request), requestcontenttype, requestlength);
    }

    public String interceptUnauthorizedRequest(HttpServletRequest request) {
        log.warn("Unauthorized from {} in {}", (Object)AuditReportServiceImpl.getOriginalRemoteAddr((HttpServletRequest)request), (Object)AuditReportServiceImpl.getFullURLQuery((HttpServletRequest)request));
        return ((Audit)this.auditRepository.save((Object)this.prepareAudit(request, "UnauthorizedRequest"))).getEventref();
    }

    public String interceptForbiddenRequest(HttpServletRequest request) {
        String userUUID = ControllerInterceptor.getRequestUserUUID((HttpServletRequest)request).orElse(null);
        log.warn("Forbidden from {} in {} by {}", (Object)AuditReportServiceImpl.getOriginalRemoteAddr((HttpServletRequest)request), (Object)AuditReportServiceImpl.getFullURLQuery((HttpServletRequest)request), (Object)userUUID);
        Audit audit = this.prepareAudit(request, "ForbiddenRequest");
        audit.setUseruuid(userUUID);
        return ((Audit)this.auditRepository.save((Object)audit)).getEventref();
    }

    private static void setAuditNames(Audit audit, List<String> names) {
        audit.setContext(names.stream().collect(Collectors.joining(", ")));
    }

    public String onImportantError(HttpServletRequest request, List<String> names, Exception e) {
        String userUUID = ControllerInterceptor.getRequestUserUUID((HttpServletRequest)request).orElse(null);
        log.error("Error from {} in {} by {} [{}]", (Object)AuditReportServiceImpl.getOriginalRemoteAddr((HttpServletRequest)request), (Object)AuditReportServiceImpl.getFullURLQuery((HttpServletRequest)request), (Object)userUUID, names, (Object)e);
        Audit audit = this.prepareAudit(request, "Error");
        audit.setUseruuid(userUUID);
        String fullStack = ExceptionUtils.getStackTrace((Throwable)e);
        if (fullStack.length() > 255) {
            audit.setTriggeredexception(fullStack.substring(0, 252) + "...");
        } else {
            audit.setTriggeredexception(fullStack);
        }
        AuditReportServiceImpl.setAuditNames((Audit)audit, names);
        return ((Audit)this.auditRepository.save((Object)audit)).getEventref();
    }

    public String onChangeSecurity(HttpServletRequest request, List<String> names) {
        String userUUID = ControllerInterceptor.getRequestUserUUID((HttpServletRequest)request).orElse(null);
        log.info("Change security from {} in {} by {} [{}]", (Object)AuditReportServiceImpl.getOriginalRemoteAddr((HttpServletRequest)request), (Object)AuditReportServiceImpl.getFullURLQuery((HttpServletRequest)request), (Object)userUUID, names);
        Audit audit = this.prepareAudit(request, "ChangeSecurity");
        audit.setUseruuid(userUUID);
        AuditReportServiceImpl.setAuditNames((Audit)audit, names);
        return ((Audit)this.auditRepository.save((Object)audit)).getEventref();
    }

    public String onUseSecurity(HttpServletRequest request, List<String> names) {
        String userUUID = ControllerInterceptor.getRequestUserUUID((HttpServletRequest)request).orElse(null);
        log.info("Use security from {} in {} by {} [{}]", (Object)AuditReportServiceImpl.getOriginalRemoteAddr((HttpServletRequest)request), (Object)AuditReportServiceImpl.getFullURLQuery((HttpServletRequest)request), (Object)userUUID, names);
        Audit audit = this.prepareAudit(request, "UseSecurity");
        audit.setUseruuid(userUUID);
        AuditReportServiceImpl.setAuditNames((Audit)audit, names);
        return ((Audit)this.auditRepository.save((Object)audit)).getEventref();
    }

    public String onSimpleEvent(HttpServletRequest request, List<String> names) {
        String userUUID = ControllerInterceptor.getRequestUserUUID((HttpServletRequest)request).orElse(null);
        log.info("Simple event from {} in {} by {} [{}]", (Object)AuditReportServiceImpl.getOriginalRemoteAddr((HttpServletRequest)request), (Object)AuditReportServiceImpl.getFullURLQuery((HttpServletRequest)request), (Object)userUUID, names);
        Audit audit = this.prepareAudit(request, "SimpleEvent");
        audit.setUseruuid(userUUID);
        AuditReportServiceImpl.setAuditNames((Audit)audit, names);
        return ((Audit)this.auditRepository.save((Object)audit)).getEventref();
    }

    public String onRejectLogin(HttpServletRequest request, AuditReportService.RejectLoginCause cause, String realm, String what) {
        String userUUID = ControllerInterceptor.getRequestUserUUID((HttpServletRequest)request).orElse(null);
        log.info("Rejeted login from {} in {} by {}/{} {}", (Object)AuditReportServiceImpl.getOriginalRemoteAddr((HttpServletRequest)request), (Object)AuditReportServiceImpl.getFullURLQuery((HttpServletRequest)request), (Object)userUUID, (Object)realm, (Object)what);
        Audit audit = this.prepareAudit(request, "RejectLogin");
        audit.setUseruuid(userUUID);
        audit.setContext(cause.toString() + ": " + what + " (realm: " + realm + ")");
        return ((Audit)this.auditRepository.save((Object)audit)).getEventref();
    }

    public String onLogin(HttpServletRequest request, Duration longSessionDuration, Set<String> tags) {
        String userUUID = ControllerInterceptor.getRequestUserUUID((HttpServletRequest)request).orElse(null);
        log.info("Login from {} in {} by {}, with rights {}, during {}", (Object)AuditReportServiceImpl.getOriginalRemoteAddr((HttpServletRequest)request), (Object)AuditReportServiceImpl.getFullURLQuery((HttpServletRequest)request), (Object)userUUID, tags, (Object)longSessionDuration);
        Audit audit = this.prepareAudit(request, "Login");
        audit.setUseruuid(userUUID);
        audit.setContext(" during " + longSessionDuration + " with tags: " + tags.stream().collect(Collectors.joining(", ")));
        return ((Audit)this.auditRepository.save((Object)audit)).getEventref();
    }

    public String onReport(HttpServletRequest request, String reportName, String subject, Duration sinceTime) {
        String userUUID = ControllerInterceptor.getRequestUserUUID((HttpServletRequest)request).orElse(null);
        Audit audit = this.prepareAudit(request, "Report");
        audit.setUseruuid(userUUID);
        audit.setContext("Make report " + reportName + " on: " + subject + " last events, since " + sinceTime);
        return ((Audit)this.auditRepository.save((Object)audit)).getEventref();
    }

    private static final Date getDateFromTimeAgo(Duration sinceTime) {
        return new Date(System.currentTimeMillis() - sinceTime.toMillis());
    }

    public Collection<Audit> reportLastUserActivities(HttpServletRequest originalRequest, String userUUID, Duration sinceTime) {
        List result = this.auditRepository.getByUserUUID(userUUID, AuditReportServiceImpl.getDateFromTimeAgo((Duration)sinceTime));
        this.onReport(originalRequest, "ReportLastUserActivities", userUUID, sinceTime);
        return result;
    }

    public Collection<Audit> reportLastRemoteIPActivity(HttpServletRequest originalRequest, String address, Duration sinceTime) {
        List result = this.auditRepository.getByClientsourcehost(address, AuditReportServiceImpl.getDateFromTimeAgo((Duration)sinceTime));
        this.onReport(originalRequest, "ReportLastRemoteIPActivity", address, sinceTime);
        return result;
    }

    public Collection<Audit> reportLastEventActivity(HttpServletRequest originalRequest, String eventName, Duration sinceTime) {
        List result = this.auditRepository.getByEventname(eventName, AuditReportServiceImpl.getDateFromTimeAgo((Duration)sinceTime));
        this.onReport(originalRequest, "ReportLastEventActivity", eventName, sinceTime);
        return result;
    }

    public Collection<String> reportAllEventNames(HttpServletRequest originalRequest) {
        List result = this.auditRepository.getAllEventnames();
        this.onReport(originalRequest, "ReportAllEventNames", "", Duration.ZERO);
        return result;
    }

    public Collection<String> reportLastClientsourcehosts(HttpServletRequest originalRequest, Duration sinceTime) {
        List result = this.auditRepository.getLastClientsourcehosts(AuditReportServiceImpl.getDateFromTimeAgo((Duration)sinceTime));
        this.onReport(originalRequest, "ReportLastEventsInetAddress", "", sinceTime);
        return result;
    }
}

