/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.authkit.mod.entity;

import java.util.HashSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.UUID;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.OrderBy;
import javax.persistence.Table;
import javax.validation.constraints.NotEmpty;
import tv.hd3g.authkit.mod.entity.Audit;
import tv.hd3g.authkit.mod.entity.BaseEntity;
import tv.hd3g.authkit.mod.entity.Credential;
import tv.hd3g.authkit.mod.entity.Group;

@Entity
@Table(name="user")
public class User
extends BaseEntity {
    @NotEmpty
    private String uuid;
    @OneToMany(mappedBy="useruuid", fetch=FetchType.LAZY, orphanRemoval=false, cascade={CascadeType.DETACH})
    @OrderBy(value="eventdate")
    private final SortedSet<Audit> userAudits = new TreeSet();
    @OneToOne(mappedBy="user", optional=true, fetch=FetchType.LAZY, orphanRemoval=true, cascade={CascadeType.ALL})
    private Credential credential;
    @ManyToMany(cascade={CascadeType.DETACH, CascadeType.MERGE, CascadeType.REFRESH, CascadeType.PERSIST})
    @JoinTable(name="usergroup", joinColumns={@JoinColumn(name="user_id")}, inverseJoinColumns={@JoinColumn(name="group_id")})
    private final Set<Group> groups = new HashSet();

    public User() {
    }

    public User(UUID uuid) {
        this.initCreate();
        this.uuid = uuid.toString();
    }

    public SortedSet<Audit> getUserAudits() {
        return this.userAudits;
    }

    public Set<Group> getGroups() {
        return this.groups;
    }

    public Credential getCredential() {
        return this.credential;
    }

    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public void setCredential(Credential credential) {
        this.credential = credential;
    }
}

