/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.authkit.mod.controller;

import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.function.Function;
import javax.validation.constraints.NotEmpty;
import org.owasp.encoder.Encode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.ResourceSupport;
import org.springframework.hateoas.mvc.ControllerLinkBuilder;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import tv.hd3g.authkit.mod.dto.ressource.CreatedUserDto;
import tv.hd3g.authkit.mod.dto.ressource.GroupOrRoleDto;
import tv.hd3g.authkit.mod.dto.ressource.ItemListDto;
import tv.hd3g.authkit.mod.dto.ressource.UserDto;
import tv.hd3g.authkit.mod.dto.ressource.UserPrivacyDto;
import tv.hd3g.authkit.mod.dto.ressource.WsDtoLink;
import tv.hd3g.authkit.mod.dto.validated.AddGroupOrRoleDto;
import tv.hd3g.authkit.mod.dto.validated.AddUserDto;
import tv.hd3g.authkit.mod.dto.validated.ChangeIPDto;
import tv.hd3g.authkit.mod.dto.validated.ListStringDto;
import tv.hd3g.authkit.mod.dto.validated.RenameGroupOrRoleDto;
import tv.hd3g.authkit.mod.exception.AuthKitException;
import tv.hd3g.authkit.mod.repository.UserDao;
import tv.hd3g.authkit.mod.repository.UserRepository;
import tv.hd3g.authkit.mod.service.AuthenticationService;
import tv.hd3g.commons.authkit.AuditAfter;
import tv.hd3g.commons.authkit.CheckBefore;

@RestController
@RequestMapping(value={"/v1/authkit"}, produces={"application/json;charset=UTF-8"})
@CheckBefore(value={"SecurityAdmin"})
public class RestControllerUser {
    private static final String HATEOAS_REMOVE = "remove";
    private static final String HATEOAS_DEFAULT_GROUP_NAME = "group-name";
    @Autowired
    private AuthenticationService authenticationService;
    @Autowired
    private UserDao userDao;
    @Autowired
    private UserRepository userRepository;
    @Value(value="${authkit.dbMaxFetchSize:50}")
    private int dbMaxFetchSize;
    @Value(value="${authkit.realm:default}")
    private String realm;

    @Transactional(readOnly=false)
    @PostMapping(value={"users"})
    @AuditAfter(value="addUser", changeSecurity=true)
    public ResponseEntity<CreatedUserDto> addUser(@RequestBody @Validated AddUserDto addUser) {
        String uuid = this.authenticationService.addUser(addUser);
        CreatedUserDto result = new CreatedUserDto(Encode.forJavaScript((String)addUser.getUserLogin()), uuid, this.realm);
        this.createHateoasLinksForUser(uuid, (ResourceSupport)result);
        return new ResponseEntity((Object)result, HttpStatus.CREATED);
    }

    @Transactional(readOnly=true)
    @GetMapping(value={"users/{uuid}"})
    @AuditAfter(value="getUser", changeSecurity=false)
    public ResponseEntity<UserDto> getUser(@PathVariable(value="uuid") @NotEmpty String uuid) {
        UserDto result = (UserDto)this.userDao.getUserByUUID(UUID.fromString(uuid)).orElseThrow(() -> new AuthKitException(404, "Can't found user " + uuid));
        this.createHateoasLinksForUser(uuid, (ResourceSupport)result);
        return new ResponseEntity((Object)result, HttpStatus.OK);
    }

    @Transactional(readOnly=true)
    @GetMapping(value={"users"})
    @AuditAfter(value="listUser", changeSecurity=false)
    public ResponseEntity<ItemListDto<UserDto>> listUsers(@RequestParam(defaultValue="0") int pos, @RequestParam(defaultValue="0") int size) {
        List list;
        int selectedPos;
        int limit;
        int total = (int)this.userRepository.count();
        if (total == 0) {
            limit = 0;
            selectedPos = 0;
            list = List.of();
        } else {
            limit = size < 1 ? this.dbMaxFetchSize : Math.min(total, Math.min(this.dbMaxFetchSize, size));
            selectedPos = Math.min(total - 1, Math.max(0, pos));
            list = this.userDao.getUserList(selectedPos, limit);
        }
        ItemListDto result = new ItemListDto(list);
        this.createHateoasLinksForUser("<UUID>", (ResourceSupport)result);
        LinkedMultiValueMap headers = new LinkedMultiValueMap();
        headers.add((Object)"Content-Range", (Object)(selectedPos + "-" + limit + "/" + total));
        headers.add((Object)"Accept-Range", (Object)("user " + this.dbMaxFetchSize));
        if (list.size() == total) {
            return new ResponseEntity((Object)result, (MultiValueMap)headers, HttpStatus.OK);
        }
        return new ResponseEntity((Object)result, (MultiValueMap)headers, HttpStatus.PARTIAL_CONTENT);
    }

    @Transactional(readOnly=false)
    @PutMapping(value={"users/{uuid}/disable"})
    @AuditAfter(value="disableUser", changeSecurity=true)
    public ResponseEntity<ResourceSupport> disableUser(@PathVariable(value="uuid") @NotEmpty String uuid) {
        this.authenticationService.disableUser(uuid);
        ResourceSupport result = new ResourceSupport();
        this.createHateoasLinksForUser(uuid, result);
        return new ResponseEntity((Object)result, HttpStatus.OK);
    }

    @Transactional(readOnly=false)
    @PutMapping(value={"users/{uuid}/enable"})
    @AuditAfter(value="enableUser", changeSecurity=true)
    public ResponseEntity<ResourceSupport> enableUser(@PathVariable(value="uuid") @NotEmpty String uuid) {
        this.authenticationService.enableUser(uuid);
        ResourceSupport result = new ResourceSupport();
        this.createHateoasLinksForUser(uuid, result);
        return new ResponseEntity((Object)result, HttpStatus.OK);
    }

    @Transactional(readOnly=false)
    @PutMapping(value={"users/{uuid}/switchresetpassword"})
    @AuditAfter(value="switchUserMustResetPassword", changeSecurity=true)
    public ResponseEntity<ResourceSupport> switchUserMustResetPassword(@PathVariable(value="uuid") @NotEmpty String uuid) {
        this.authenticationService.setUserMustChangePassword(uuid);
        ResourceSupport result = new ResourceSupport();
        this.createHateoasLinksForUser(uuid, result);
        return new ResponseEntity((Object)result, HttpStatus.OK);
    }

    @Transactional(readOnly=false)
    @PutMapping(value={"users/{uuid}/resetlogontrials"})
    @AuditAfter(value="resetUserLogonTrials", changeSecurity=true)
    public ResponseEntity<ResourceSupport> resetUserLogonTrials(@PathVariable(value="uuid") @NotEmpty String uuid) {
        this.authenticationService.resetUserLogonTrials(uuid);
        ResourceSupport result = new ResourceSupport();
        this.createHateoasLinksForUser(uuid, result);
        return new ResponseEntity((Object)result, HttpStatus.OK);
    }

    @Transactional(readOnly=false)
    @DeleteMapping(value={"users/{uuid}"})
    @AuditAfter(value="removeUser", changeSecurity=true)
    public ResponseEntity<ResourceSupport> removeUser(@PathVariable(value="uuid") @NotEmpty String uuid) {
        this.authenticationService.removeUser(uuid);
        ResourceSupport result = new ResourceSupport();
        this.createHateoasLinksForUser(uuid, result);
        return new ResponseEntity((Object)result, HttpStatus.OK);
    }

    @Transactional(readOnly=false)
    @AuditAfter(value="addGroup", changeSecurity=true)
    @PostMapping(value={"groups"})
    public ResponseEntity<ResourceSupport> addGroup(@RequestBody @Validated AddGroupOrRoleDto newGroup) {
        this.authenticationService.addGroup(newGroup);
        ResourceSupport result = new ResourceSupport();
        this.createHateoasLinksForGroup(newGroup.getName(), result);
        return new ResponseEntity((Object)result, HttpStatus.CREATED);
    }

    @Transactional(readOnly=false)
    @AuditAfter(value="renameGroup", changeSecurity=true)
    @PostMapping(value={"groups/rename"})
    public ResponseEntity<ResourceSupport> renameGroup(@RequestBody @Validated RenameGroupOrRoleDto renameGroup) {
        this.authenticationService.renameGroup(renameGroup);
        ResourceSupport result = new ResourceSupport();
        this.createHateoasLinksForGroup(renameGroup.getNewname(), result);
        return new ResponseEntity((Object)result, HttpStatus.OK);
    }

    @Transactional(readOnly=false)
    @AuditAfter(value="setGroupDescription", changeSecurity=true)
    @PutMapping(value={"groups/description"})
    public ResponseEntity<ResourceSupport> setGroupDescription(@RequestBody @Validated AddGroupOrRoleDto changeGroup) {
        this.authenticationService.setGroupDescription(changeGroup);
        ResourceSupport result = new ResourceSupport();
        this.createHateoasLinksForGroup(changeGroup.getName(), result);
        return new ResponseEntity((Object)result, HttpStatus.OK);
    }

    @Transactional(readOnly=false)
    @AuditAfter(value="addUserInGroup", changeSecurity=true)
    @PostMapping(value={"users/{uuid}/ingroup/{name}"})
    public ResponseEntity<ResourceSupport> addUserInGroup(@PathVariable(value="uuid") @NotEmpty String userUUID, @PathVariable(value="name") @NotEmpty String groupName) {
        this.authenticationService.addUserInGroup(userUUID, groupName);
        ResourceSupport result = new ResourceSupport();
        this.createHateoasLinksForUser(userUUID, result);
        return new ResponseEntity((Object)result, HttpStatus.CREATED);
    }

    @Transactional(readOnly=false)
    @AuditAfter(value="removeUserInGroup", changeSecurity=true)
    @DeleteMapping(value={"users/{uuid}/ingroup/{name}"})
    public ResponseEntity<ResourceSupport> removeUserInGroup(@PathVariable(value="uuid") @NotEmpty String userUUID, @PathVariable(value="name") @NotEmpty String groupName) {
        this.authenticationService.removeUserInGroup(userUUID, groupName);
        ResourceSupport result = new ResourceSupport();
        this.createHateoasLinksForUser(userUUID, result);
        return new ResponseEntity((Object)result, HttpStatus.OK);
    }

    @Transactional(readOnly=false)
    @AuditAfter(value="removeGroup", changeSecurity=true)
    @DeleteMapping(value={"groups/{name}"})
    public ResponseEntity<ResourceSupport> removeGroup(@PathVariable(value="name") @NotEmpty String groupName) {
        this.authenticationService.removeGroup(groupName);
        ResourceSupport result = new ResourceSupport();
        this.createHateoasLinksForGroup(groupName, result);
        return new ResponseEntity((Object)result, HttpStatus.OK);
    }

    @Transactional(readOnly=false)
    @AuditAfter(value="listAllGroups", changeSecurity=false)
    @GetMapping(value={"groups"})
    public ResponseEntity<ItemListDto<GroupOrRoleDto>> listAllGroups() {
        ItemListDto result = new ItemListDto((Collection)this.authenticationService.listAllGroups());
        this.createHateoasLinksForGroup(HATEOAS_DEFAULT_GROUP_NAME, (ResourceSupport)result);
        return new ResponseEntity((Object)result, HttpStatus.OK);
    }

    @Transactional(readOnly=false)
    @AuditAfter(value="listGroupsForUser", changeSecurity=false)
    @GetMapping(value={"users/{uuid}/groups"})
    public ResponseEntity<ItemListDto<GroupOrRoleDto>> listGroupsForUser(@PathVariable(value="uuid") @NotEmpty String userUUID) {
        ItemListDto result = new ItemListDto((Collection)this.authenticationService.listGroupsForUser(userUUID));
        this.createHateoasLinksForUser(userUUID, (ResourceSupport)result);
        return new ResponseEntity((Object)result, HttpStatus.OK);
    }

    @Transactional(readOnly=false)
    @AuditAfter(value="addRole", changeSecurity=true)
    @PostMapping(value={"roles"})
    public ResponseEntity<ResourceSupport> addRole(@RequestBody @Validated AddGroupOrRoleDto newRole) {
        this.authenticationService.addRole(newRole);
        ResourceSupport result = new ResourceSupport();
        this.createHateoasLinksForRoles(newRole.getName(), result);
        return new ResponseEntity((Object)result, HttpStatus.CREATED);
    }

    @Transactional(readOnly=false)
    @AuditAfter(value="renameRole", changeSecurity=true)
    @PostMapping(value={"roles/rename"})
    public ResponseEntity<ResourceSupport> renameRole(@RequestBody @Validated RenameGroupOrRoleDto renameRole) {
        this.authenticationService.renameRole(renameRole);
        ResourceSupport result = new ResourceSupport();
        this.createHateoasLinksForRoles(renameRole.getName(), result);
        return new ResponseEntity((Object)result, HttpStatus.OK);
    }

    @Transactional(readOnly=false)
    @AuditAfter(value="setRoleDescription", changeSecurity=true)
    @PutMapping(value={"roles/description"})
    public ResponseEntity<ResourceSupport> setRoleDescription(@RequestBody @Validated AddGroupOrRoleDto changeRole) {
        this.authenticationService.setRoleDescription(changeRole);
        ResourceSupport result = new ResourceSupport();
        this.createHateoasLinksForRoles(changeRole.getName(), result);
        return new ResponseEntity((Object)result, HttpStatus.OK);
    }

    @Transactional(readOnly=false)
    @AuditAfter(value="setRoleOnlyForClients", changeSecurity=true)
    @PutMapping(value={"roles/{rolename}/setOnlyForClient"})
    public ResponseEntity<ResourceSupport> setRoleOnlyForClient(@PathVariable(value="rolename") @NotEmpty String roleName, @RequestBody @Validated ChangeIPDto setIp) {
        this.authenticationService.setRoleOnlyForClient(roleName, setIp.getIp());
        ResourceSupport result = new ResourceSupport();
        this.createHateoasLinksForRoles(roleName, result);
        return new ResponseEntity((Object)result, HttpStatus.OK);
    }

    @Transactional(readOnly=false)
    @AuditAfter(value="addGroupInRole", changeSecurity=true)
    @PostMapping(value={"groups/{groupname}/inrole/{rolename}"})
    public ResponseEntity<ResourceSupport> addGroupInRole(@PathVariable(value="groupname") @NotEmpty String groupName, @PathVariable(value="rolename") @NotEmpty String roleName) {
        this.authenticationService.addGroupInRole(groupName, roleName);
        ResourceSupport result = new ResourceSupport();
        this.createHateoasLinksForRoles(roleName, result);
        return new ResponseEntity((Object)result, HttpStatus.CREATED);
    }

    @Transactional(readOnly=false)
    @AuditAfter(value="removeGroupInRole", changeSecurity=true)
    @DeleteMapping(value={"groups/{groupname}/inrole/{rolename}"})
    public ResponseEntity<ResourceSupport> removeGroupInRole(@PathVariable(value="groupname") @NotEmpty String groupName, @PathVariable(value="rolename") @NotEmpty String roleName) {
        this.authenticationService.removeGroupInRole(groupName, roleName);
        ResourceSupport result = new ResourceSupport();
        this.createHateoasLinksForRoles(roleName, result);
        return new ResponseEntity((Object)result, HttpStatus.OK);
    }

    @Transactional(readOnly=false)
    @AuditAfter(value="removeRole", changeSecurity=true)
    @DeleteMapping(value={"roles/{rolename}"})
    public ResponseEntity<ResourceSupport> removeRole(@PathVariable(value="rolename") @NotEmpty String roleName) {
        this.authenticationService.removeRole(roleName);
        ResourceSupport result = new ResourceSupport();
        this.createHateoasLinksForRoles(roleName, result);
        return new ResponseEntity((Object)result, HttpStatus.OK);
    }

    @Transactional(readOnly=false)
    @AuditAfter(value="listAllRoles", changeSecurity=false)
    @GetMapping(value={"roles"})
    public ResponseEntity<ItemListDto<GroupOrRoleDto>> listAllRoles() {
        ItemListDto result = new ItemListDto((Collection)this.authenticationService.listAllRoles());
        this.createHateoasLinksForRoles("role-name", (ResourceSupport)result);
        return new ResponseEntity((Object)result, HttpStatus.OK);
    }

    @Transactional(readOnly=false)
    @AuditAfter(value="listRolesForGroup", changeSecurity=false)
    @GetMapping(value={"groups/{groupname}/roles"})
    public ResponseEntity<ItemListDto<GroupOrRoleDto>> listRolesForGroup(@PathVariable(value="groupname") @NotEmpty String groupName) {
        ItemListDto result = new ItemListDto((Collection)this.authenticationService.listRolesForGroup(groupName));
        this.createHateoasLinksForGroup(groupName, (ResourceSupport)result);
        return new ResponseEntity((Object)result, HttpStatus.OK);
    }

    @Transactional(readOnly=false)
    @AuditAfter(value="addRightInRole", changeSecurity=true)
    @PostMapping(value={"roles/{rolename}/rights/{rightname}"})
    public ResponseEntity<ResourceSupport> addRightInRole(@PathVariable(value="rolename") @NotEmpty String roleName, @PathVariable(value="rightname") @NotEmpty String rightName) {
        this.authenticationService.addRightInRole(roleName, rightName);
        ResourceSupport result = new ResourceSupport();
        this.createHateoasLinksForRights(roleName, rightName, result);
        return new ResponseEntity((Object)result, HttpStatus.CREATED);
    }

    @Transactional(readOnly=false)
    @AuditAfter(value="removeRightInRole", changeSecurity=true)
    @DeleteMapping(value={"roles/{rolename}/rights/{rightname}"})
    public ResponseEntity<ResourceSupport> removeRightInRole(@PathVariable(value="rolename") @NotEmpty String roleName, @PathVariable(value="rightname") @NotEmpty String rightName) {
        this.authenticationService.removeRightInRole(roleName, rightName);
        ResourceSupport result = new ResourceSupport();
        this.createHateoasLinksForRights(roleName, rightName, result);
        return new ResponseEntity((Object)result, HttpStatus.OK);
    }

    @Transactional(readOnly=false)
    @AuditAfter(value="getAllRights", changeSecurity=false)
    @GetMapping(value={"rights"})
    public ResponseEntity<ItemListDto<String>> getAllRights() {
        ItemListDto result = new ItemListDto((Collection)this.authenticationService.getAllRights());
        this.createHateoasLinksForRights("role-name", "right-name", (ResourceSupport)result);
        return new ResponseEntity((Object)result, HttpStatus.OK);
    }

    @Transactional(readOnly=false)
    @AuditAfter(value="listRightsForRole", changeSecurity=false)
    @GetMapping(value={"roles/{rolename}/rights"})
    public ResponseEntity<ItemListDto<String>> listRightsForRole(@PathVariable(value="rolename") @NotEmpty String roleName) {
        ItemListDto result = new ItemListDto((Collection)this.authenticationService.listRightsForRole(roleName));
        this.createHateoasLinksForRights(roleName, "right-name", (ResourceSupport)result);
        return new ResponseEntity((Object)result, HttpStatus.OK);
    }

    @Transactional(readOnly=false)
    @AuditAfter(value="addContextInRight", changeSecurity=true)
    @PostMapping(value={"roles/{rolename}/rights/{rightname}/contexts/{context}"})
    public ResponseEntity<ResourceSupport> addContextInRight(@PathVariable(value="rolename") @NotEmpty String roleName, @PathVariable(value="rightname") @NotEmpty String rightName, @PathVariable(value="context") @NotEmpty String context) {
        this.authenticationService.addContextInRight(roleName, rightName, context);
        ResourceSupport result = new ResourceSupport();
        this.createHateoasLinksForContextsRights(roleName, rightName, context, result);
        return new ResponseEntity((Object)result, HttpStatus.CREATED);
    }

    @Transactional(readOnly=false)
    @AuditAfter(value="removeContextInRight", changeSecurity=true)
    @DeleteMapping(value={"roles/{rolename}/rights/{rightname}/contexts/{context}"})
    public ResponseEntity<ResourceSupport> removeContextInRight(@PathVariable(value="rolename") @NotEmpty String roleName, @PathVariable(value="rightname") @NotEmpty String rightName, @PathVariable(value="context") @NotEmpty String context) {
        this.authenticationService.removeContextInRight(roleName, rightName, context);
        ResourceSupport result = new ResourceSupport();
        this.createHateoasLinksForContextsRights(roleName, rightName, context, result);
        return new ResponseEntity((Object)result, HttpStatus.OK);
    }

    @Transactional(readOnly=false)
    @AuditAfter(value="listContextsForRight", changeSecurity=false)
    @GetMapping(value={"roles/{rolename}/rights/{rightname}/contexts"})
    public ResponseEntity<ItemListDto<String>> listContextsForRight(@PathVariable(value="rolename") @NotEmpty String roleName, @PathVariable(value="rightname") @NotEmpty String rightName) {
        ItemListDto result = new ItemListDto((Collection)this.authenticationService.listContextsForRight(roleName, rightName));
        this.createHateoasLinksForContextsRights(roleName, rightName, "context-name", (ResourceSupport)result);
        return new ResponseEntity((Object)result, HttpStatus.OK);
    }

    @Transactional(readOnly=false)
    @AuditAfter(value="listLinkedUsersForGroup", changeSecurity=false)
    @GetMapping(value={"groups/{name}/users"})
    public ResponseEntity<ItemListDto<UserDto>> listLinkedUsersForGroup(@PathVariable(value="name") @NotEmpty String groupName) {
        ItemListDto result = new ItemListDto((Collection)this.authenticationService.listLinkedUsersForGroup(groupName));
        this.createHateoasLinksForGroup(groupName, (ResourceSupport)result);
        return new ResponseEntity((Object)result, HttpStatus.OK);
    }

    @Transactional(readOnly=false)
    @AuditAfter(value="listLinkedGroupsForRole", changeSecurity=false)
    @GetMapping(value={"roles/{name}/groups"})
    public ResponseEntity<ItemListDto<GroupOrRoleDto>> listLinkedGroupsForRole(@PathVariable(value="name") @NotEmpty String roleName) {
        ItemListDto result = new ItemListDto((Collection)this.authenticationService.listLinkedGroupsForRole(roleName));
        this.createHateoasLinksForRoles(roleName, (ResourceSupport)result);
        return new ResponseEntity((Object)result, HttpStatus.OK);
    }

    @Transactional(readOnly=true)
    @GetMapping(value={"users/{uuid}/privacy"})
    @AuditAfter(value="getUserPrivacy", changeSecurity=false)
    public ResponseEntity<UserPrivacyDto> getUserPrivacy(@PathVariable(value="uuid") @NotEmpty String uuid) {
        List list = this.authenticationService.getUserPrivacyList(List.of(uuid));
        UserPrivacyDto result = list.isEmpty() ? new UserPrivacyDto() : (UserPrivacyDto)list.get(0);
        this.createHateoasLinksForUser(uuid, (ResourceSupport)result);
        return new ResponseEntity((Object)result, HttpStatus.OK);
    }

    @Transactional(readOnly=true)
    @GetMapping(value={"users/privacy"})
    @AuditAfter(value="getUsersPrivacy", changeSecurity=false)
    public ResponseEntity<ItemListDto<UserPrivacyDto>> getUsersPrivacy(@RequestBody @Validated ListStringDto userUUIDList) {
        List list = this.authenticationService.getUserPrivacyList((Collection)userUUIDList.getList());
        ItemListDto result = new ItemListDto((Collection)list);
        this.createHateoasLinksForUser("<uuid>", (ResourceSupport)result);
        return new ResponseEntity((Object)result, HttpStatus.OK);
    }

    @Transactional(readOnly=false)
    @PutMapping(value={"users/{uuid}/privacy"})
    @AuditAfter(value="setUserPrivacy", changeSecurity=true)
    public ResponseEntity<ResourceSupport> setUserPrivacy(@RequestBody @Validated UserPrivacyDto userPrivacyDto, @PathVariable(value="uuid") @NotEmpty String userUUID) {
        this.authenticationService.setUserPrivacy(userUUID, userPrivacyDto);
        ResourceSupport result = new ResourceSupport();
        this.createHateoasLinksForUser(userUUID, result);
        return new ResponseEntity((Object)result, HttpStatus.OK);
    }

    private void prepHLink(ResourceSupport ressource, Function<RestControllerUser, Object> linkTo, String rel, RequestMethod method) {
        Class<RestControllerUser> c = RestControllerUser.class;
        Object link = linkTo.apply((RestControllerUser)ControllerLinkBuilder.methodOn(c, (Object[])new Object[0]));
        ressource.add((Link)new WsDtoLink(ControllerLinkBuilder.linkTo((Object)link).withRel(rel), method));
    }

    private void createHateoasLinksForUser(String userUUID, ResourceSupport res) {
        this.prepHLink(res, c -> c.addUser(new AddUserDto()), "add", RequestMethod.POST);
        this.prepHLink(res, c -> c.listUsers(0, this.dbMaxFetchSize), "list", RequestMethod.GET);
        this.prepHLink(res, c -> c.getUser(userUUID), "show", RequestMethod.GET);
        this.prepHLink(res, c -> c.disableUser(userUUID), "disable", RequestMethod.PUT);
        this.prepHLink(res, c -> c.enableUser(userUUID), "enable", RequestMethod.PUT);
        this.prepHLink(res, c -> c.switchUserMustResetPassword(userUUID), "switchresetpassword", RequestMethod.PUT);
        this.prepHLink(res, c -> c.resetUserLogonTrials(userUUID), "resetlogontrials", RequestMethod.PUT);
        this.prepHLink(res, c -> c.removeUser(userUUID), HATEOAS_REMOVE, RequestMethod.DELETE);
        this.prepHLink(res, c -> c.listGroupsForUser(userUUID), "list-group", RequestMethod.GET);
        this.prepHLink(res, c -> c.addUserInGroup(userUUID, HATEOAS_DEFAULT_GROUP_NAME), "add-user-in-group", RequestMethod.POST);
        this.prepHLink(res, c -> c.removeUserInGroup("user-uuid", HATEOAS_DEFAULT_GROUP_NAME), "remove-user-in-group", RequestMethod.DELETE);
        this.prepHLink(res, c -> c.getUserPrivacy(userUUID), "get-user-privacy", RequestMethod.GET);
        this.prepHLink(res, c -> c.getUsersPrivacy(new ListStringDto()), "get-users-privacy", RequestMethod.GET);
        this.prepHLink(res, c -> c.setUserPrivacy(new UserPrivacyDto(), userUUID), "set-user-privacy", RequestMethod.PUT);
    }

    private void createHateoasLinksForGroup(String groupName, ResourceSupport res) {
        this.prepHLink(res, c -> c.addGroup(new AddGroupOrRoleDto()), "add", RequestMethod.POST);
        this.prepHLink(res, RestControllerUser::listAllGroups, "list", RequestMethod.GET);
        this.prepHLink(res, c -> c.renameGroup(new RenameGroupOrRoleDto()), "rename", RequestMethod.POST);
        this.prepHLink(res, c -> c.setGroupDescription(new AddGroupOrRoleDto()), "set-description", RequestMethod.PUT);
        this.prepHLink(res, c -> c.removeGroup(groupName), HATEOAS_REMOVE, RequestMethod.DELETE);
        this.prepHLink(res, c -> c.listLinkedUsersForGroup(groupName), "list-users-by-group", RequestMethod.GET);
        this.prepHLink(res, c -> c.listRolesForGroup(groupName), "list-roles-for-group", RequestMethod.GET);
    }

    private void createHateoasLinksForRoles(String roleName, ResourceSupport res) {
        this.prepHLink(res, c -> c.addRole(new AddGroupOrRoleDto()), "add", RequestMethod.POST);
        this.prepHLink(res, RestControllerUser::listAllRoles, "list", RequestMethod.GET);
        this.prepHLink(res, c -> c.renameRole(new RenameGroupOrRoleDto()), "rename", RequestMethod.POST);
        this.prepHLink(res, c -> c.setRoleDescription(new AddGroupOrRoleDto()), "set-description", RequestMethod.PUT);
        this.prepHLink(res, c -> c.setRoleOnlyForClient(roleName, new ChangeIPDto()), "set-only-for-clients", RequestMethod.PUT);
        this.prepHLink(res, c -> c.addGroupInRole(HATEOAS_DEFAULT_GROUP_NAME, roleName), "add-group-in-role", RequestMethod.POST);
        this.prepHLink(res, c -> c.removeRole(roleName), HATEOAS_REMOVE, RequestMethod.DELETE);
        this.prepHLink(res, c -> c.listLinkedGroupsForRole(roleName), "list-groups-by-role", RequestMethod.GET);
        this.prepHLink(res, c -> c.removeGroupInRole(HATEOAS_DEFAULT_GROUP_NAME, roleName), "remove-group-in-role", RequestMethod.DELETE);
    }

    private void createHateoasLinksForRights(String roleName, String rightName, ResourceSupport res) {
        this.prepHLink(res, c -> c.addRightInRole(roleName, rightName), "add", RequestMethod.POST);
        this.prepHLink(res, RestControllerUser::getAllRights, "list", RequestMethod.GET);
        this.prepHLink(res, c -> c.listRightsForRole(roleName), "list-rights", RequestMethod.GET);
        this.prepHLink(res, c -> c.removeRightInRole(roleName, rightName), HATEOAS_REMOVE, RequestMethod.DELETE);
    }

    private void createHateoasLinksForContextsRights(String roleName, String rightName, String context, ResourceSupport res) {
        this.prepHLink(res, c -> c.addContextInRight(roleName, rightName, context), "add", RequestMethod.POST);
        this.prepHLink(res, c -> c.listContextsForRight(roleName, rightName), "list", RequestMethod.GET);
        this.prepHLink(res, c -> c.removeContextInRight(roleName, rightName, context), HATEOAS_REMOVE, RequestMethod.DELETE);
    }
}

