/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.authkit.mod.component;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.stereotype.Component;
import tv.hd3g.authkit.mod.component.SqlFileResourceHelper;

@Component
public class SqlFileResourceHelper {
    private final Map<String, String> sqlFiles;

    public SqlFileResourceHelper() throws IOException {
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        this.sqlFiles = Arrays.stream(resolver.getResources("classpath*:sql/*.sql")).map(r -> {
            SqlFile sqlFile;
            SqlFile sqlFile2 = new SqlFile(this);
            sqlFile2.name = r.getFilename();
            BufferedReader br = new BufferedReader(new InputStreamReader(r.getInputStream(), StandardCharsets.UTF_8));
            try {
                sqlFile2.content = br.lines().filter(line -> {
                    String l = line.trim();
                    return !l.startsWith("--") && !l.startsWith("//") && !l.startsWith("#");
                }).collect(Collectors.joining(System.lineSeparator()));
                sqlFile = sqlFile2;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        br.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException("Can't load ressource file " + r.getDescription(), e);
                }
            }
            br.close();
            return sqlFile;
        }).collect(Collectors.toUnmodifiableMap(SqlFile::getName, SqlFile::getContent));
    }

    public String getSql(String filename) {
        return Objects.requireNonNull((String)this.sqlFiles.get(filename), "Can't found " + filename + " file");
    }
}

