/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.authkit.mod.component;

import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.stereotype.Component;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;
import tv.hd3g.authkit.mod.component.EndpointsListener;

@Component
public class EndpointsListener
implements ApplicationListener<ApplicationEvent> {
    private final ConcurrentHashMap<Class<?>, AnnotatedClass> annotationCache = new ConcurrentHashMap();

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof ContextRefreshedEvent) {
            ((RequestMappingHandlerMapping)((ContextRefreshedEvent)event).getApplicationContext().getBean(RequestMappingHandlerMapping.class)).getHandlerMethods().values().stream().map(HandlerMethod::getBeanType).forEach(arg_0 -> this.getAnnotatedClass(arg_0));
        }
    }

    public Set<String> getAllRights() {
        return this.annotationCache.values().stream().flatMap(ac -> {
            Stream cl = ac.allClassCheckBefore.stream();
            Stream mc = ac.allMethodsCheckBefore.values().stream().flatMap(Collection::stream);
            return Stream.concat(cl, mc);
        }).flatMap(cb -> Arrays.stream(cb.value())).distinct().collect(Collectors.toUnmodifiableSet());
    }

    public AnnotatedClass getAnnotatedClass(Class<?> controllerClass) {
        return this.annotationCache.computeIfAbsent(controllerClass, x$0 -> new AnnotatedClass(this, x$0));
    }
}

