/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.authkit.mod;

import java.util.List;
import java.util.Optional;
import javax.annotation.PostConstruct;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import tv.hd3g.authkit.mod.ExternalLDAP;

@Configuration
@ConfigurationProperties(prefix="authkit.ldap")
public class ExternalLDAP {
    private List<LDAPEntry> servers;

    public boolean isAvailable() {
        return this.servers != null && !this.servers.isEmpty();
    }

    @PostConstruct
    public void init() {
        if (this.isAvailable()) {
            this.servers.forEach(LDAPEntry::init);
        }
    }

    public Optional<LDAPEntry> getByDomainName(String domain) {
        if (!this.isAvailable()) {
            return Optional.empty();
        }
        return this.getServers().stream().filter(server -> server.getDomain().equalsIgnoreCase(domain)).findFirst();
    }

    public List<LDAPEntry> getServers() {
        return this.servers;
    }

    public void setServers(List<LDAPEntry> servers) {
        this.servers = servers;
    }
}

