/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.authkit.mod;

import java.io.IOException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.resource.ResourceHttpRequestHandler;
import tv.hd3g.authkit.mod.ControllerInterceptor;
import tv.hd3g.authkit.mod.component.EndpointsListener;
import tv.hd3g.authkit.mod.dto.LoggedUserTagsTokenDto;
import tv.hd3g.authkit.mod.exception.NotAcceptableSecuredTokenException;
import tv.hd3g.authkit.mod.service.AuditReportService;
import tv.hd3g.authkit.mod.service.AuditReportServiceImpl;
import tv.hd3g.authkit.mod.service.AuthenticationService;
import tv.hd3g.authkit.mod.service.SecuredTokenService;
import tv.hd3g.commons.authkit.AuditAfter;

public class ControllerInterceptor
implements HandlerInterceptor {
    private static Logger log = LogManager.getLogger();
    public static final String USER_UUID_ATTRIBUTE_NAME = ControllerInterceptor.class.getPackageName() + ".userUUID";
    private final AuditReportService auditService;
    private final SecuredTokenService securedTokenService;
    private final EndpointsListener endpointsListener;
    private final AuthenticationService authenticationService;

    public ControllerInterceptor(AuditReportService auditService, SecuredTokenService securedTokenService, EndpointsListener endpointsListener, AuthenticationService authenticationService) {
        this.auditService = auditService;
        this.securedTokenService = securedTokenService;
        this.endpointsListener = endpointsListener;
        this.authenticationService = authenticationService;
    }

    private boolean isRequestIsHandle(HttpServletRequest request, Object handler) {
        if (handler instanceof ResourceHttpRequestHandler) {
            ResourceHttpRequestHandler httpHandler = (ResourceHttpRequestHandler)handler;
            Optional.ofNullable(httpHandler.getUrlPathHelper()).map(uph -> uph.getLookupPathForRequest(request)).ifPresent(h -> log.trace("HandlerH: {}", h));
            return false;
        }
        if (!(handler instanceof HandlerMethod)) {
            log.info("Unknown handler: {}", handler.getClass());
            return false;
        }
        return true;
    }

    private Optional<LoggedUserTagsTokenDto> extractAndCheckAuthToken(HttpServletRequest request) throws Unauthorized {
        LoggedUserTagsTokenDto loggedDto;
        Optional<String> oBearer = Optional.ofNullable(request.getHeader("Authorization")).filter(content -> content.toLowerCase().startsWith("bearer")).map(content -> content.substring("bearer".length()).trim());
        if (oBearer.isEmpty()) {
            return Optional.empty();
        }
        try {
            loggedDto = this.securedTokenService.loggedUserRightsExtractToken(oBearer.get());
        }
        catch (NotAcceptableSecuredTokenException e) {
            throw new Unauthorized(this, "Invalid JWT in auth request from {}", new Object[]{AuditReportServiceImpl.getOriginalRemoteAddr((HttpServletRequest)request)});
        }
        Objects.requireNonNull(loggedDto);
        if (loggedDto.getOnlyForHost() != null) {
            InetAddress addr2;
            InetAddress addr1;
            try {
                addr1 = InetAddress.getByName(loggedDto.getOnlyForHost());
                addr2 = InetAddress.getByName(AuditReportServiceImpl.getOriginalRemoteAddr((HttpServletRequest)request));
            }
            catch (UnknownHostException e) {
                addr1 = null;
                addr2 = null;
            }
            if (addr1 == null || !addr1.equals(addr2)) {
                throw new Unauthorized(this, "Reject request for {} from {} because the actual token contain a IP restriction on {} only", new Object[]{loggedDto.getUserUUID(), AuditReportServiceImpl.getOriginalRemoteAddr((HttpServletRequest)request), loggedDto.getOnlyForHost()});
            }
        }
        return Optional.of(loggedDto);
    }

    private void compareUserRightsAndRequestMandatories(HttpServletRequest request, LoggedUserTagsTokenDto loggedUserTagsTokenDto, Method classMethod, EndpointsListener.AnnotatedClass annotatedClass) throws BaseInternalException {
        List requireAuthList = annotatedClass.requireAuthList(classMethod);
        if (requireAuthList.isEmpty()) {
            return;
        }
        String userUUID = loggedUserTagsTokenDto.getUserUUID();
        if (userUUID == null) {
            throw new Unauthorized(this, "Unauthorized user from {}", new Object[]{AuditReportServiceImpl.getOriginalRemoteAddr((HttpServletRequest)request)});
        }
        if (requireAuthList.stream().noneMatch(annotation -> Arrays.stream(annotation.value()).allMatch(loggedUserTagsTokenDto.getTags()::contains))) {
            throw new Forbidden(this, "Forbidden user {} from {} to go to {}", new Object[]{userUUID, AuditReportServiceImpl.getOriginalRemoteAddr((HttpServletRequest)request), request.getRequestURI()});
        }
    }

    private void checkRenforcedRightsChecks(HttpServletRequest request, EndpointsListener.AnnotatedClass annotatedClass, Method classMethod, LoggedUserTagsTokenDto tokenPayload) throws BaseInternalException {
        if (!annotatedClass.isRequireRenforceCheckBefore(classMethod)) {
            return;
        }
        String userUUID = tokenPayload.getUserUUID();
        if (!this.authenticationService.isUserEnabledAndNonBlocked(userUUID)) {
            throw new Unauthorized(this, "User {} is now disabled/blocked before last login", new Object[]{userUUID});
        }
        String clientAddr = AuditReportServiceImpl.getOriginalRemoteAddr((HttpServletRequest)request);
        Set actualTags = this.authenticationService.getRightsForUser(userUUID, clientAddr).stream().distinct().collect(Collectors.toUnmodifiableSet());
        for (String tag : tokenPayload.getTags()) {
            if (actualTags.contains(tag)) continue;
            throw new Forbidden(this, "User {} has lost some rights (like {}) before last login from {}", new Object[]{userUUID, tag, AuditReportServiceImpl.getOriginalRemoteAddr((HttpServletRequest)request)});
        }
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws IOException {
        if (!this.isRequestIsHandle(request, handler)) {
            return true;
        }
        try {
            LoggedUserTagsTokenDto tokenPayload = this.extractAndCheckAuthToken(request).orElse(new LoggedUserTagsTokenDto(null, Set.of(), null));
            String userUUID = tokenPayload.getUserUUID();
            request.setAttribute(USER_UUID_ATTRIBUTE_NAME, (Object)userUUID);
            HandlerMethod handlerMethod = (HandlerMethod)handler;
            Class controllerClass = handlerMethod.getBeanType();
            EndpointsListener.AnnotatedClass annotatedClass = this.endpointsListener.getAnnotatedClass(controllerClass);
            Method classMethod = handlerMethod.getMethod();
            this.checkRenforcedRightsChecks(request, annotatedClass, classMethod, tokenPayload);
            this.compareUserRightsAndRequestMandatories(request, tokenPayload, classMethod, annotatedClass);
            if (userUUID == null) {
                log.info("Request {} {}:{}()", (Object)controllerClass.getSimpleName(), (Object)request.getMethod(), (Object)handlerMethod.getMethod().getName());
            } else {
                log.info("Request {} {}:{}() {}", (Object)controllerClass.getSimpleName(), (Object)request.getMethod(), (Object)handlerMethod.getMethod().getName(), (Object)userUUID);
            }
            return true;
        }
        catch (BaseInternalException e) {
            e.pushAudit(request);
            response.reset();
            response.sendError(e.statusCode);
            log.error(e.logMessage, e.logContent);
            return false;
        }
    }

    public static final Optional<String> getRequestUserUUID(HttpServletRequest request) {
        return Optional.ofNullable(request.getAttribute(USER_UUID_ATTRIBUTE_NAME)).map(o -> (String)o);
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception exception) throws Exception {
        List namesSimpleAudit;
        List namesUseSecurity;
        Method classMethod;
        if (!(handler instanceof HandlerMethod)) {
            return;
        }
        HandlerMethod handlerMethod = (HandlerMethod)handler;
        Class controllerClass = handlerMethod.getBeanType();
        EndpointsListener.AnnotatedClass annotatedClass = this.endpointsListener.getAnnotatedClass(controllerClass);
        List auditList = annotatedClass.getAudits(classMethod = handlerMethod.getMethod());
        if (auditList.isEmpty()) {
            return;
        }
        Optional.ofNullable(exception).ifPresent(e -> {
            List names = auditList.stream().filter(AuditAfter::cantDoErrors).map(AuditAfter::value).collect(Collectors.toUnmodifiableList());
            if (!names.isEmpty()) {
                this.auditService.onImportantError(request, names, e);
            }
        });
        List namesChangeSecurity = auditList.stream().filter(AuditAfter::changeSecurity).map(AuditAfter::value).collect(Collectors.toUnmodifiableList());
        if (!namesChangeSecurity.isEmpty()) {
            this.auditService.onChangeSecurity(request, namesChangeSecurity);
        }
        if (!(namesUseSecurity = auditList.stream().filter(AuditAfter::useSecurity).map(AuditAfter::value).collect(Collectors.toUnmodifiableList())).isEmpty()) {
            this.auditService.onUseSecurity(request, namesUseSecurity);
        }
        if (!(namesSimpleAudit = auditList.stream().filter(audit -> !audit.cantDoErrors() && !audit.changeSecurity() && !audit.useSecurity()).map(AuditAfter::value).collect(Collectors.toUnmodifiableList())).isEmpty()) {
            this.auditService.onSimpleEvent(request, namesSimpleAudit);
        }
    }
}

