/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.authkit.mod;

import java.math.BigInteger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.ArrayList;

public class CIDRUtils {
    private final InetAddress inetAddress;
    private final InetAddress startAddress;
    private final InetAddress endAddress;
    private final int prefixLength;

    public CIDRUtils(String cidr) throws UnknownHostException {
        int targetSize;
        ByteBuffer maskBuffer;
        if (!cidr.contains("/")) {
            throw new IllegalArgumentException("Missing CIDR: " + cidr);
        }
        int index = cidr.indexOf(47);
        if (cidr.lastIndexOf(47) != index) {
            throw new IllegalArgumentException("Invalid IP/CIDR format: " + cidr);
        }
        this.inetAddress = InetAddress.getByName(cidr.substring(0, index));
        this.prefixLength = Integer.parseInt(cidr.substring(index + 1));
        if (this.prefixLength < 0) {
            throw new IllegalArgumentException("Negative CIDR: " + cidr);
        }
        if (this.inetAddress.getAddress().length == 4) {
            maskBuffer = ByteBuffer.allocate(4).putInt(-1);
            targetSize = 4;
        } else {
            maskBuffer = ByteBuffer.allocate(16).putLong(-1L).putLong(-1L);
            targetSize = 16;
        }
        if (this.prefixLength > targetSize * 8) {
            throw new IllegalArgumentException("Too big CIDR: " + cidr);
        }
        BigInteger mask = new BigInteger(1, maskBuffer.array()).not().shiftRight(this.prefixLength);
        ByteBuffer buffer = ByteBuffer.wrap(this.inetAddress.getAddress());
        BigInteger ipVal = new BigInteger(1, buffer.array());
        BigInteger startIp = ipVal.and(mask);
        BigInteger endIp = startIp.add(mask.not());
        byte[] startIpArr = this.toBytes(startIp.toByteArray(), targetSize);
        byte[] endIpArr = this.toBytes(endIp.toByteArray(), targetSize);
        this.startAddress = InetAddress.getByAddress(startIpArr);
        this.endAddress = InetAddress.getByAddress(endIpArr);
    }

    public CIDRUtils(InetAddress addr, int cidr) throws UnknownHostException {
        this(addr.getHostAddress() + "/" + cidr);
    }

    private byte[] toBytes(byte[] array, int targetSize) {
        ArrayList<Byte> newArr = new ArrayList<Byte>();
        for (int counter = 0; counter < targetSize && array.length - 1 - counter >= 0; ++counter) {
            newArr.add(0, array[array.length - 1 - counter]);
        }
        int size = newArr.size();
        for (int i = 0; i < targetSize - size; ++i) {
            newArr.add(0, (byte)0);
        }
        byte[] ret = new byte[newArr.size()];
        for (int i = 0; i < newArr.size(); ++i) {
            ret[i] = (Byte)newArr.get(i);
        }
        return ret;
    }

    public String getNetworkAddress() {
        return this.startAddress.getHostAddress();
    }

    public String getBroadcastAddress() {
        return this.endAddress.getHostAddress();
    }

    public boolean isInRange(String ipAddress) throws UnknownHostException {
        return this.isInRange(InetAddress.getByName(ipAddress));
    }

    public boolean isInRange(InetAddress address) {
        BigInteger start = new BigInteger(1, this.startAddress.getAddress());
        BigInteger end = new BigInteger(1, this.endAddress.getAddress());
        BigInteger target = new BigInteger(1, address.getAddress());
        return start.compareTo(target) <= 0 && target.compareTo(end) <= 0;
    }

    public String toString() {
        if (this.startAddress.equals(this.endAddress)) {
            return this.startAddress.getHostAddress();
        }
        return this.startAddress.getHostAddress() + "/" + this.endAddress.getHostAddress();
    }
}

