/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.authkit.mod;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.converter.Converter;
import org.springframework.format.FormatterRegistry;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import tv.hd3g.authkit.mod.ControllerInterceptor;
import tv.hd3g.authkit.mod.StringToPasswordConvertor;
import tv.hd3g.authkit.mod.component.EndpointsListener;
import tv.hd3g.authkit.mod.service.AuditReportService;
import tv.hd3g.authkit.mod.service.AuthenticationService;
import tv.hd3g.authkit.mod.service.SecuredTokenService;

@Configuration
public class AuthKitSetupWebConfig
implements WebMvcConfigurer {
    private final AuditReportService auditService;
    private final SecuredTokenService securedTokenService;
    private final EndpointsListener endpointsListener;
    private final AuthenticationService authenticationService;

    @Autowired
    public AuthKitSetupWebConfig(AuditReportService auditService, SecuredTokenService securedTokenService, EndpointsListener endpointsListener, AuthenticationService authenticationService) {
        this.auditService = auditService;
        this.securedTokenService = securedTokenService;
        this.endpointsListener = endpointsListener;
        this.authenticationService = authenticationService;
    }

    public void addFormatters(FormatterRegistry registry) {
        registry.addConverter((Converter)new StringToPasswordConvertor());
    }

    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor((HandlerInterceptor)new ControllerInterceptor(this.auditService, this.securedTokenService, this.endpointsListener, this.authenticationService));
    }
}

