/*
 * Decompiled with CFR 0.152.
 */
package tv.brid.sdk.player.drm;

import android.content.Context;
import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import android.util.Pair;
import androidx.annotation.OptIn;
import androidx.media3.common.Format;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.datasource.DataSource;
import androidx.media3.datasource.HttpDataSource;
import androidx.media3.exoplayer.dash.DashUtil;
import androidx.media3.exoplayer.dash.manifest.DashManifest;
import androidx.media3.exoplayer.dash.manifest.Period;
import androidx.media3.exoplayer.drm.DrmSession;
import androidx.media3.exoplayer.drm.DrmSessionEventListener;
import androidx.media3.exoplayer.drm.OfflineLicenseHelper;
import java.io.IOException;
import tv.brid.sdk.player.drm.DRMPlayer;
import tv.brid.sdk.player.drm.store.BaseKeyStore;
import tv.brid.sdk.player.drm.store.DrmKeyVO;

public class OfflineRemoteLicenceFetcher {
    private static final long INTERVAL_HOUR = 3600000L;
    private static final long INTERVAL_TEST = 30000L;
    private DRMPlayer drmPlayer;
    private HttpDataSource.Factory factory;
    private Context context;

    public OfflineRemoteLicenceFetcher(DRMPlayer drmPlayer, Context context, HttpDataSource.Factory factory) {
        this.drmPlayer = drmPlayer;
        this.context = context;
        this.factory = factory;
    }

    @OptIn(markerClass={UnstableApi.class})
    public Pair downloadLicense(String drmLicenseUrl, Uri videoPath, int videoId) {
        byte[] licenseData = null;
        Long licenseExpiration = null;
        Format drmInitData = null;
        OfflineLicenseHelper offlineLicenseHelper = OfflineLicenseHelper.newWidevineInstance((String)drmLicenseUrl, (DataSource.Factory)this.factory, (DrmSessionEventListener.EventDispatcher)new DrmSessionEventListener.EventDispatcher());
        HttpDataSource dataSource = this.factory.createDataSource();
        DashManifest dashManifest = null;
        try {
            dashManifest = DashUtil.loadManifest((DataSource)dataSource, (Uri)videoPath);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (dashManifest == null) {
            return null;
        }
        try {
            drmInitData = DashUtil.loadFormatWithDrmInitData((DataSource)dataSource, (Period)dashManifest.getPeriod(0));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (drmInitData == null) {
            return null;
        }
        try {
            licenseData = offlineLicenseHelper.downloadLicense(drmInitData);
        }
        catch (DrmSession.DrmSessionException e) {
            e.printStackTrace();
        }
        if (licenseData != null) {
            try {
                licenseExpiration = System.currentTimeMillis() + (Long)offlineLicenseHelper.getLicenseDurationRemainingSec((byte[])licenseData).first * 1000L;
                DrmKeyVO drmKeyVO = new DrmKeyVO();
                drmKeyVO.setKey(licenseData);
                drmKeyVO.setExpirationTime(System.currentTimeMillis() + 3600000L);
                drmKeyVO.setVideoid(videoId);
                BaseKeyStore baseKeyStore = BaseKeyStore.INSTANCE(this.context);
                baseKeyStore.store(drmKeyVO);
                Handler handler = new Handler(Looper.getMainLooper());
                handler.post(() -> this.drmPlayer.playDRMVideo());
            }
            catch (DrmSession.DrmSessionException e) {
                e.printStackTrace();
            }
        } else {
            licenseExpiration = 0L;
        }
        return new Pair((Object)licenseData, (Object)licenseExpiration);
    }
}

