/*
 * Decompiled with CFR 0.152.
 */
package tv.brid.sdk.engine;

import androidx.annotation.OptIn;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.exoplayer.ExoPlayer;
import androidx.media3.exoplayer.hls.HlsManifest;
import androidx.media3.exoplayer.hls.playlist.HlsMultivariantPlaylist;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import tv.brid.sdk.engine.IRenditionProvider;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\bH\u0016J\u0016\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\b0\u000bH\u0017R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\f"}, d2={"Ltv/brid/sdk/engine/HlsRenditionProvider;", "Ltv/brid/sdk/engine/IRenditionProvider;", "exoPlayer", "Landroidx/media3/exoplayer/ExoPlayer;", "(Landroidx/media3/exoplayer/ExoPlayer;)V", "getExoPlayer", "()Landroidx/media3/exoplayer/ExoPlayer;", "provideDefaultRenditionTag", "", "provideDefaultRenditionUrl", "provideRenditionsList", "", "bridsdk_release"})
public final class HlsRenditionProvider
implements IRenditionProvider {
    @NotNull
    private final ExoPlayer exoPlayer;

    public HlsRenditionProvider(@NotNull ExoPlayer exoPlayer) {
        Intrinsics.checkNotNullParameter((Object)exoPlayer, (String)"exoPlayer");
        this.exoPlayer = exoPlayer;
    }

    @NotNull
    public final ExoPlayer getExoPlayer() {
        return this.exoPlayer;
    }

    @Override
    @NotNull
    public String provideDefaultRenditionUrl() {
        return "";
    }

    @Override
    @NotNull
    public String provideDefaultRenditionTag() {
        return "Auto";
    }

    @Override
    @OptIn(markerClass={UnstableApi.class})
    @NotNull
    public Map<String, String> provideRenditionsList() {
        Object manifest;
        if (this.exoPlayer.getCurrentManifest() != null && (manifest = this.exoPlayer.getCurrentManifest()) instanceof HlsManifest) {
            int n = ((HlsManifest)manifest).multivariantPlaylist.variants.size();
            for (int i = 0; i < n; ++i) {
                Object e = ((HlsManifest)manifest).multivariantPlaylist.variants.get(i);
                Intrinsics.checkNotNullExpressionValue(e, (String)"manifest.multivariantPlaylist.variants[i]");
                HlsMultivariantPlaylist.Variant variant = (HlsMultivariantPlaylist.Variant)e;
            }
        }
        return MapsKt.emptyMap();
    }
}

