/*
 * Decompiled with CFR 0.152.
 */
package tv.brid.sdk.engine;

import android.content.Context;
import androidx.annotation.OptIn;
import androidx.annotation.RequiresApi;
import androidx.media3.common.Format;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.exoplayer.ExoPlayer;
import androidx.media3.exoplayer.hls.HlsManifest;
import androidx.media3.exoplayer.hls.playlist.HlsMultivariantPlaylist;
import androidx.media3.ui.DefaultTrackNameProvider;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.Delegates;
import kotlin.properties.ObservableProperty;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tv.brid.common.BridPlayerException;
import tv.brid.domain.Partner;
import tv.brid.domain.Player;
import tv.brid.domain.Video;
import tv.brid.sdk.AutoplayMode;
import tv.brid.sdk.Utils;
import tv.brid.sdk.api.BridPlayer;
import tv.brid.sdk.api.BridPlayerImpl;
import tv.brid.sdk.api.SdkContainer;
import tv.brid.sdk.brid_network.domain.AdSchedule;
import tv.brid.sdk.brid_network.domain.AdSlot;
import tv.brid.sdk.brid_network.domain.Data;
import tv.brid.sdk.brid_network.domain.MidrollData;
import tv.brid.sdk.engine.AnalyticData;
import tv.brid.sdk.engine.AnalyticsSender;
import tv.brid.sdk.engine.ControllsUiStatesManager;
import tv.brid.sdk.engine.IBridPlayerEngine;
import tv.brid.sdk.engine.RenditionProvider;
import tv.brid.sdk.engine.SendAnalyticReceiver;
import tv.brid.sdk.engine.VideoEndedReason;
import tv.brid.sdk.engine.VideoLoader;
import tv.brid.sdk.engine.ads.AdProvider;
import tv.brid.sdk.engine.ads.AdScheduler;
import tv.brid.sdk.engine.ads.AnalyticSenderScheduler;
import tv.brid.sdk.hls.HlsAds;
import tv.brid.sdk.player.playback.PlaylistEndStrategy;
import tv.brid.sdk.player.playback.playlist.ContinuePlaylistEndStrategy;
import tv.brid.sdk.player.playback.playlist.StopPlaylistEndStrategy;
import tv.brid.sdk.player.ui.ResolutionView;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00b6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b&\n\u0002\u0010$\n\u0002\b\u0004\b\u0001\u0018\u00002\u00020\u0001Bq\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u0012\u0016\u0010\n\u001a\u0012\u0012\u0004\u0012\u00020\f0\u000bj\b\u0012\u0004\u0012\u00020\f`\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u0012\u0006\u0010\u0016\u001a\u00020\u0017\u0012\u0006\u0010\u0018\u001a\u00020\u0019\u00a2\u0006\u0002\u0010\u001aJ\u0018\u0010Q\u001a\u00020R2\u0006\u0010S\u001a\u00020,2\u0006\u0010T\u001a\u00020.H\u0016J\b\u0010U\u001a\u00020RH\u0002J\b\u0010V\u001a\u00020RH\u0016J\b\u0010+\u001a\u00020,H\u0016J\b\u0010W\u001a\u00020\u001eH\u0016J\b\u0010X\u001a\u00020\u001eH\u0002J\b\u0010Y\u001a\u00020\u001eH\u0002J\b\u0010Z\u001a\u00020\u001eH\u0002J\u001f\u0010[\u001a\u00020R2\u0006\u0010\\\u001a\u0002012\b\u0010]\u001a\u0004\u0018\u00010\u001eH\u0016\u00a2\u0006\u0002\u0010^J\b\u0010_\u001a\u00020RH\u0016J\b\u0010`\u001a\u00020RH\u0016J\b\u0010a\u001a\u00020RH\u0016J\b\u0010b\u001a\u00020RH\u0017J\b\u0010c\u001a\u00020RH\u0016J\b\u0010d\u001a\u00020RH\u0016J\b\u0010e\u001a\u00020RH\u0016J\u0010\u0010f\u001a\u00020R2\u0006\u0010g\u001a\u00020.H\u0016J\b\u0010h\u001a\u00020RH\u0016J\u0010\u0010i\u001a\u00020R2\u0006\u0010j\u001a\u00020.H\u0016J\u0010\u0010k\u001a\u00020R2\u0006\u0010l\u001a\u000201H\u0016J\b\u0010m\u001a\u00020RH\u0016J\b\u0010n\u001a\u00020RH\u0016J\u0010\u0010o\u001a\u00020R2\u0006\u0010l\u001a\u000201H\u0016J\b\u0010p\u001a\u00020RH\u0002J\b\u0010q\u001a\u00020,H\u0002J\u0010\u0010r\u001a\u00020,2\u0006\u0010s\u001a\u00020,H\u0016J\b\u0010t\u001a\u00020RH\u0016J\b\u0010u\u001a\u00020RH\u0016J\u000e\u0010v\u001a\u00020R2\u0006\u0010w\u001a\u00020\u001eJ\u0016\u0010x\u001a\u0010\u0012\u0004\u0012\u00020,\u0012\u0006\u0012\u0004\u0018\u00010,0yH\u0016J\u0006\u0010z\u001a\u00020RJ\b\u0010{\u001a\u00020RH\u0016J\b\u0010|\u001a\u00020RH\u0016R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0018\u001a\u00020\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0011\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u001c\u0010%\u001a\u0004\u0018\u00010&X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*R\u000e\u0010+\u001a\u00020,X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010-\u001a\u0004\u0018\u00010.X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010/R+\u00102\u001a\u0002012\u0006\u00100\u001a\u0002018F@BX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b7\u00108\u001a\u0004\b3\u00104\"\u0004\b5\u00106R\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b9\u0010:R\u0010\u0010;\u001a\u0004\u0018\u00010<X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010=\u001a\u00020\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010>\u001a\u00020\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010?\u001a\u00020\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b@\u0010AR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010B\u001a\u0004\u0018\u00010CX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bD\u0010E\"\u0004\bF\u0010GR\u000e\u0010H\u001a\u00020.X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010I\u001a\u00020\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010J\u001a\u00020KX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010L\u001a\u0004\u0018\u00010MX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010N\u001a\u0004\u0018\u00010OX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010P\u001a\u000201X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\n\u001a\u0012\u0012\u0004\u0012\u00020\f0\u000bj\b\u0012\u0004\u0012\u00020\f`\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006}"}, d2={"Ltv/brid/sdk/engine/BridPlayerEngineNew;", "Ltv/brid/sdk/engine/IBridPlayerEngine;", "sdkContainer", "Ltv/brid/sdk/api/SdkContainer;", "playerVO", "Ltv/brid/domain/Player;", "partnerVO", "Ltv/brid/domain/Partner;", "adSchedule", "Ltv/brid/sdk/brid_network/domain/AdSchedule;", "videoVOS", "Ljava/util/ArrayList;", "Ltv/brid/domain/Video;", "Lkotlin/collections/ArrayList;", "bridPlayer", "Ltv/brid/sdk/api/BridPlayerImpl;", "exoPlayer", "Landroidx/media3/exoplayer/ExoPlayer;", "adProvider", "Ltv/brid/sdk/engine/ads/AdProvider;", "analyticsSender", "Ltv/brid/sdk/engine/AnalyticsSender;", "context", "Landroid/content/Context;", "autoplayMode", "Ltv/brid/sdk/AutoplayMode;", "(Ltv/brid/sdk/api/SdkContainer;Ltv/brid/domain/Player;Ltv/brid/domain/Partner;Ltv/brid/sdk/brid_network/domain/AdSchedule;Ljava/util/ArrayList;Ltv/brid/sdk/api/BridPlayerImpl;Landroidx/media3/exoplayer/ExoPlayer;Ltv/brid/sdk/engine/ads/AdProvider;Ltv/brid/sdk/engine/AnalyticsSender;Landroid/content/Context;Ltv/brid/sdk/AutoplayMode;)V", "adScheduler", "Ltv/brid/sdk/engine/ads/AdScheduler;", "adsCheckedOnStart", "", "getAutoplayMode", "()Ltv/brid/sdk/AutoplayMode;", "getBridPlayer", "()Ltv/brid/sdk/api/BridPlayerImpl;", "getContext", "()Landroid/content/Context;", "controllerUiStatesManager", "Ltv/brid/sdk/engine/ControllsUiStatesManager;", "getControllerUiStatesManager", "()Ltv/brid/sdk/engine/ControllsUiStatesManager;", "setControllerUiStatesManager", "(Ltv/brid/sdk/engine/ControllsUiStatesManager;)V", "currentRendition", "", "currentVideoDuration", "", "Ljava/lang/Long;", "<set-?>", "", "currentVideoIndex", "getCurrentVideoIndex", "()I", "setCurrentVideoIndex", "(I)V", "currentVideoIndex$delegate", "Lkotlin/properties/ReadWriteProperty;", "getExoPlayer", "()Landroidx/media3/exoplayer/ExoPlayer;", "hlsAds", "Ltv/brid/sdk/hls/HlsAds;", "isFirstPlay", "isFirstVideo", "midrollsScheduled", "getPartnerVO", "()Ltv/brid/domain/Partner;", "playlistPlaybackEndStrategy", "Ltv/brid/sdk/player/playback/PlaylistEndStrategy;", "getPlaylistPlaybackEndStrategy", "()Ltv/brid/sdk/player/playback/PlaylistEndStrategy;", "setPlaylistPlaybackEndStrategy", "(Ltv/brid/sdk/player/playback/PlaylistEndStrategy;)V", "positionInterrupted", "prerollChecked", "renditionProvider", "Ltv/brid/sdk/engine/RenditionProvider;", "videoEndReason", "Ltv/brid/sdk/engine/VideoEndedReason;", "videoLoader", "Ltv/brid/sdk/engine/VideoLoader;", "videoPlayCount", "changeRendition", "", "option", "currentPosition", "createVideoLoader", "createVideoLoaderAfterVerification", "isFirstTimePlaying", "isHlsVideo", "isLastVideo", "isLiveStreamVideo", "onAdsCompleted", "adType", "isError", "(ILjava/lang/Boolean;)V", "onContextPause", "onContextResume", "onFirstFrameRendered", "onNetworkConnectionLost", "onNetworkConnectionSuccess", "onNextVideoCalled", "onPlayPauseStatusChanged", "onPositionSeeked", "position", "onPreviousVideoCalled", "onVideoEnded", "videoDuration", "onVideoSeeked", "videoIndex", "playAds", "playCurrentVideo", "playVideoWithIndex", "prepareAds", "provideRenditionDefaultField", "provideRenditionUrlForSelectedRendition", "rendition", "renditionChangeCalled", "restart", "resumeLivestreamVideo", "playWhenReady", "returnRenditionMap", "", "scheduleMidrolls", "start", "startPlay", "bridsdk_release"})
@OptIn(markerClass={UnstableApi.class})
@SourceDebugExtension(value={"SMAP\nBridPlayerEngineNew.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BridPlayerEngineNew.kt\ntv/brid/sdk/engine/BridPlayerEngineNew\n+ 2 Delegates.kt\nkotlin/properties/Delegates\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,748:1\n33#2,3:749\n1045#3:752\n1045#3:753\n1940#3,14:754\n*S KotlinDebug\n*F\n+ 1 BridPlayerEngineNew.kt\ntv/brid/sdk/engine/BridPlayerEngineNew\n*L\n69#1:749,3\n524#1:752\n539#1:753\n569#1:754,14\n*E\n"})
public final class BridPlayerEngineNew
implements IBridPlayerEngine {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final SdkContainer sdkContainer;
    @NotNull
    private final Player playerVO;
    @NotNull
    private final Partner partnerVO;
    @Nullable
    private final AdSchedule adSchedule;
    @NotNull
    private final ArrayList<Video> videoVOS;
    @NotNull
    private final BridPlayerImpl bridPlayer;
    @NotNull
    private final ExoPlayer exoPlayer;
    @NotNull
    private final AdProvider adProvider;
    @NotNull
    private final AnalyticsSender analyticsSender;
    @NotNull
    private final Context context;
    @NotNull
    private final AutoplayMode autoplayMode;
    @Nullable
    private HlsAds hlsAds;
    private boolean midrollsScheduled;
    @NotNull
    private String currentRendition;
    @Nullable
    private VideoEndedReason videoEndReason;
    @Nullable
    private ControllsUiStatesManager controllerUiStatesManager;
    @NotNull
    private final ReadWriteProperty currentVideoIndex$delegate;
    @Nullable
    private Long currentVideoDuration;
    @Nullable
    private AdScheduler adScheduler;
    private boolean adsCheckedOnStart;
    private boolean prerollChecked;
    private boolean isFirstVideo;
    private int videoPlayCount;
    @NotNull
    private RenditionProvider renditionProvider;
    @Nullable
    private VideoLoader videoLoader;
    private boolean isFirstPlay;
    @Nullable
    private PlaylistEndStrategy playlistPlaybackEndStrategy;
    private long positionInterrupted;

    public BridPlayerEngineNew(@NotNull SdkContainer sdkContainer, @NotNull Player playerVO, @NotNull Partner partnerVO, @Nullable AdSchedule adSchedule, @NotNull ArrayList<Video> videoVOS, @NotNull BridPlayerImpl bridPlayer, @NotNull ExoPlayer exoPlayer, @NotNull AdProvider adProvider, @NotNull AnalyticsSender analyticsSender, @NotNull Context context, @NotNull AutoplayMode autoplayMode) {
        Intrinsics.checkNotNullParameter((Object)sdkContainer, (String)"sdkContainer");
        Intrinsics.checkNotNullParameter((Object)playerVO, (String)"playerVO");
        Intrinsics.checkNotNullParameter((Object)partnerVO, (String)"partnerVO");
        Intrinsics.checkNotNullParameter(videoVOS, (String)"videoVOS");
        Intrinsics.checkNotNullParameter((Object)bridPlayer, (String)"bridPlayer");
        Intrinsics.checkNotNullParameter((Object)exoPlayer, (String)"exoPlayer");
        Intrinsics.checkNotNullParameter((Object)adProvider, (String)"adProvider");
        Intrinsics.checkNotNullParameter((Object)analyticsSender, (String)"analyticsSender");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)((Object)autoplayMode), (String)"autoplayMode");
        this.sdkContainer = sdkContainer;
        this.playerVO = playerVO;
        this.partnerVO = partnerVO;
        this.adSchedule = adSchedule;
        this.videoVOS = videoVOS;
        this.bridPlayer = bridPlayer;
        this.exoPlayer = exoPlayer;
        this.adProvider = adProvider;
        this.analyticsSender = analyticsSender;
        this.context = context;
        this.autoplayMode = autoplayMode;
        this.currentRendition = "";
        Delegates delegates = Delegates.INSTANCE;
        Integer initialValue$iv = -1;
        boolean $i$f$observable = false;
        this.currentVideoIndex$delegate = (ReadWriteProperty)new ObservableProperty<Integer>((Object)initialValue$iv, this){
            final /* synthetic */ BridPlayerEngineNew this$0;
            {
                this.this$0 = bridPlayerEngineNew;
                super($initialValue);
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             * WARNING - void declaration
             */
            protected void afterChange(@NotNull KProperty property, Object oldValue, Object newValue) {
                block1: {
                    void newValue2;
                    Intrinsics.checkNotNullParameter((Object)property, (String)"property");
                    int n = ((Number)newValue).intValue();
                    int n2 = ((Number)oldValue).intValue();
                    KProperty property2 = property;
                    boolean bl = false;
                    BridPlayerEngineNew.access$getRenditionProvider$p(this.this$0).setVideo((Video)BridPlayerEngineNew.access$getVideoVOS$p(this.this$0).get((int)newValue2));
                    ControllsUiStatesManager controllsUiStatesManager = this.this$0.getControllerUiStatesManager();
                    if (controllsUiStatesManager != null) {
                        controllsUiStatesManager.update((int)newValue2);
                    }
                    ControllsUiStatesManager controllsUiStatesManager2 = this.this$0.getControllerUiStatesManager();
                    if (controllsUiStatesManager2 == null) break block1;
                    controllsUiStatesManager2.updateUI();
                }
            }
        };
        this.isFirstVideo = true;
        this.renditionProvider = new RenditionProvider();
        this.positionInterrupted = -1L;
        if (this.videoVOS.size() > 0) {
            int n = this.getCurrentVideoIndex();
            this.setCurrentVideoIndex(n + 1);
        }
        this.currentVideoDuration = this.exoPlayer.getDuration();
        this.controllerUiStatesManager = new ControllsUiStatesManager(this.bridPlayer, this.getCurrentVideoIndex(), this.videoVOS.size());
    }

    public /* synthetic */ BridPlayerEngineNew(SdkContainer sdkContainer, Player player, Partner partner, AdSchedule adSchedule, ArrayList arrayList, BridPlayerImpl bridPlayerImpl, ExoPlayer exoPlayer, AdProvider adProvider, AnalyticsSender analyticsSender, Context context, AutoplayMode autoplayMode, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            adSchedule = null;
        }
        this(sdkContainer, player, partner, adSchedule, arrayList, bridPlayerImpl, exoPlayer, adProvider, analyticsSender, context, autoplayMode);
    }

    @NotNull
    public final Partner getPartnerVO() {
        return this.partnerVO;
    }

    @NotNull
    public final BridPlayerImpl getBridPlayer() {
        return this.bridPlayer;
    }

    @NotNull
    public final ExoPlayer getExoPlayer() {
        return this.exoPlayer;
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    @NotNull
    public final AutoplayMode getAutoplayMode() {
        return this.autoplayMode;
    }

    @Nullable
    public final ControllsUiStatesManager getControllerUiStatesManager() {
        return this.controllerUiStatesManager;
    }

    public final void setControllerUiStatesManager(@Nullable ControllsUiStatesManager controllsUiStatesManager) {
        this.controllerUiStatesManager = controllsUiStatesManager;
    }

    public final int getCurrentVideoIndex() {
        return ((Number)this.currentVideoIndex$delegate.getValue((Object)this, $$delegatedProperties[0])).intValue();
    }

    private final void setCurrentVideoIndex(int n) {
        this.currentVideoIndex$delegate.setValue((Object)this, $$delegatedProperties[0], (Object)n);
    }

    @Nullable
    public final PlaylistEndStrategy getPlaylistPlaybackEndStrategy() {
        return this.playlistPlaybackEndStrategy;
    }

    public final void setPlaylistPlaybackEndStrategy(@Nullable PlaylistEndStrategy playlistEndStrategy) {
        this.playlistPlaybackEndStrategy = playlistEndStrategy;
    }

    private final void createVideoLoader() {
        if (!this.bridPlayer.isAgeDialogNeeded()) {
            this.bridPlayer.log(this.getClass().getSimpleName() + " createVideoLoader");
            this.prerollChecked = false;
            this.midrollsScheduled = false;
            this.videoEndReason = null;
            Video video = this.videoVOS.get(this.getCurrentVideoIndex());
            Intrinsics.checkNotNullExpressionValue((Object)video, (String)"videoVOS[currentVideoIndex]");
            int n = this.getCurrentVideoIndex();
            IBridPlayerEngine iBridPlayerEngine = this;
            Object object = this.adSchedule;
            if (object == null || (object = ((AdSchedule)object).getPrerolls()) == null) {
                object = CollectionsKt.emptyList();
            }
            BridPlayer bridPlayer = this.bridPlayer;
            boolean bl = this.getCurrentVideoIndex() == 0 && !this.isFirstPlay;
            ControllsUiStatesManager controllsUiStatesManager = this.controllerUiStatesManager;
            Intrinsics.checkNotNull((Object)controllsUiStatesManager);
            this.videoLoader = new VideoLoader(video, n, this.playerVO, iBridPlayerEngine, (List<AdSlot>)object, bridPlayer, bl, controllsUiStatesManager, this.context, this.autoplayMode);
        } else {
            this.bridPlayer.showAgeRestrictedDialog();
        }
    }

    @Override
    public /* synthetic */ void start() {
        String[] stringArray = new String[]{null};
        Utils.log(this.getClass(), "start", stringArray);
        this.bridPlayer.hidePoster();
        this.createVideoLoader();
    }

    @Override
    public /* synthetic */ void startPlay() {
        block0: {
            String[] stringArray = new String[]{null};
            Utils.log(this.getClass(), "startPlay", stringArray);
            this.bridPlayer.hidePoster();
            VideoLoader videoLoader = this.videoLoader;
            if (videoLoader == null) break block0;
            videoLoader.start();
        }
    }

    @Override
    public void restart() {
        block0: {
            Utils.log(this.getClass(), "restart", new String[0]);
            this.prerollChecked = false;
            this.midrollsScheduled = false;
            this.bridPlayer.setRepeated(true);
            VideoLoader videoLoader = this.videoLoader;
            if (videoLoader == null) break block0;
            videoLoader.restart();
        }
    }

    @Override
    public void onContextPause() {
        this.bridPlayer.pause();
    }

    @Override
    public void onContextResume() {
        this.bridPlayer.play();
        this.bridPlayer.dismissNetworkErrorView();
    }

    @Override
    public /* synthetic */ void onPlayPauseStatusChanged() {
        boolean videoEnded;
        String[] stringArray = new String[]{null};
        Utils.log(this.getClass(), "onPlayPauseChanged", stringArray);
        this.exoPlayer.setPlayWhenReady(!this.exoPlayer.getPlayWhenReady());
        if (!this.exoPlayer.getPlayWhenReady()) {
            this.analyticsSender.sendAnalytics(new AnalyticData("pa", null, 2, null));
            this.bridPlayer.onPauseEvent();
        } else {
            this.bridPlayer.resumeEventSend();
            this.analyticsSender.sendAnalytics(new AnalyticData("re", null, 2, null));
        }
        if (!this.isFirstPlay && this.exoPlayer.getPlayWhenReady()) {
            this.isFirstPlay = true;
            BridPlayerImpl $this$onPlayPauseStatusChanged_u24lambda_u241 = this.bridPlayer;
            boolean bl = false;
            $this$onPlayPauseStatusChanged_u24lambda_u241.setPlayButtonVisiblity(true);
            $this$onPlayPauseStatusChanged_u24lambda_u241.setStartButtonVisibility(false);
            ControllsUiStatesManager controllsUiStatesManager = this.controllerUiStatesManager;
            if (controllsUiStatesManager != null) {
                controllsUiStatesManager.updateUI();
            }
            if (this.hlsAds != null) {
                HlsAds hlsAds = this.hlsAds;
                if (hlsAds != null) {
                    hlsAds.start();
                }
            }
        }
        this.resumeLivestreamVideo(this.exoPlayer.getPlayWhenReady());
        if (this.exoPlayer.getPlayWhenReady() && (this.videoPlayCount == 0 || this.videoPlayCount == 1)) {
            int n = this.videoPlayCount;
            this.videoPlayCount = n + 1;
        }
        if (this.exoPlayer.getPlayWhenReady() && this.videoPlayCount == 1 && !this.prerollChecked) {
            this.adsCheckedOnStart = true;
            VideoLoader videoLoader = this.videoLoader;
            if (videoLoader != null) {
                videoLoader.start();
            }
        }
        boolean bl = videoEnded = this.exoPlayer.getPlaybackState() == 4;
        if (this.exoPlayer.getPlayWhenReady() && videoEnded) {
            this.createVideoLoader();
        }
    }

    public final void resumeLivestreamVideo(boolean playWhenReady) {
        block1: {
            block0: {
                if (playWhenReady) break block0;
                HlsAds hlsAds = this.hlsAds;
                if (hlsAds == null) break block1;
                hlsAds.onPauseEvent();
                break block1;
            }
            HlsAds hlsAds = this.hlsAds;
            if (hlsAds == null) break block1;
            hlsAds.onResumeEvent(1);
        }
    }

    @Override
    public /* synthetic */ void onVideoEnded(long videoDuration) {
        String[] stringArray = new String[]{String.valueOf(videoDuration)};
        Utils.log(this.getClass(), "onVideoEnded", stringArray);
        if (this.videoEndReason == null) {
            this.videoEndReason = VideoEndedReason.REASON_VIDEO_DURATION_EXCEEDED;
        }
        this.exoPlayer.setPlayWhenReady(false);
        if (this.getCurrentVideoIndex() < 0 || !this.prerollChecked) {
            stringArray = new String[]{"return"};
            Utils.log(this.getClass(), "onVideoEnded", stringArray);
            return;
        }
        this.isFirstPlay = false;
        if (this.videoEndReason == VideoEndedReason.REASON_VIDEO_DURATION_EXCEEDED) {
            stringArray = new String[]{"checkPostrollAds"};
            Utils.log(this.getClass(), "onVideoEnded", stringArray);
            this.analyticsSender.sendAnalytics(new AnalyticData("lq", null, 2, null));
            if (Intrinsics.areEqual((Object)this.videoVOS.get(this.getCurrentVideoIndex()).getMonetize(), (Object)true)) {
                long l = this.exoPlayer.getCurrentPosition();
                Object object = this.adSchedule;
                if (object == null || (object = ((AdSchedule)object).getPostrolls()) == null) {
                    object = CollectionsKt.emptyList();
                }
                this.adProvider.checkPostrollAds(l, (List)object);
            } else {
                this.onAdsCompleted(2, false);
            }
        }
    }

    @Override
    public void onPositionSeeked(long position) {
        Utils.log(this.getClass(), "onPositionSeeked", new String[0]);
        if (this.bridPlayer.getCurrentPosition() != position) {
            this.bridPlayer.onSeeked(position);
        } else if (!this.bridPlayer.dontStackMidrolls()) {
            this.adProvider.checkAdForParams(position);
        } else {
            this.adProvider.checkAdForParamsSinglePlay(position);
        }
    }

    @Override
    public void onVideoSeeked(int videoIndex) {
        block0: {
            String[] stringArray = new String[]{String.valueOf(videoIndex)};
            Utils.log(this.getClass(), "onVideoSeeked", stringArray);
            this.bridPlayer.log(this.getClass().getSimpleName() + " onVideoSeeked: " + videoIndex);
            this.videoEndReason = VideoEndedReason.REASON_PLAYLIST_VIDEO_CALLED;
            this.bridPlayer.releaseAdPlayer();
            this.setCurrentVideoIndex(videoIndex);
            this.createVideoLoader();
            VideoLoader videoLoader = this.videoLoader;
            if (videoLoader == null) break block0;
            videoLoader.start();
        }
    }

    @Override
    public void onNextVideoCalled() {
        block3: {
            String[] stringArray = new String[]{null};
            Utils.log(this.getClass(), "onNextVideoCalled", stringArray);
            if (this.getCurrentVideoIndex() + 1 == this.videoVOS.size()) {
                return;
            }
            this.exoPlayer.setPlayWhenReady(false);
            this.videoEndReason = VideoEndedReason.REASON_VIDEO_NEXT_CALLED;
            int n = this.getCurrentVideoIndex();
            this.setCurrentVideoIndex(n + 1);
            this.bridPlayer.reinitializePoster(this.videoVOS, this.getCurrentVideoIndex());
            this.bridPlayer.reinitializePlayReplayButton();
            BridPlayerImpl $this$onNextVideoCalled_u24lambda_u242 = this.bridPlayer;
            boolean bl = false;
            ControllsUiStatesManager controllsUiStatesManager = this.controllerUiStatesManager;
            if (controllsUiStatesManager != null) {
                controllsUiStatesManager.updateUI();
            }
            $this$onNextVideoCalled_u24lambda_u242.setRenditionText(this.provideRenditionDefaultField());
            this.createVideoLoader();
            VideoLoader videoLoader = this.videoLoader;
            if (videoLoader != null) {
                videoLoader.start();
            }
            AnalyticsSender analyticsSender = this.analyticsSender;
            if (analyticsSender == null) break block3;
            analyticsSender.sendAnalytics(new AnalyticData("n", null));
        }
    }

    @Override
    public void playVideoWithIndex(int videoIndex) {
        block3: {
            String[] stringArray = new String[]{null};
            Utils.log(this.getClass(), "playVideoWithIndex", stringArray);
            if (videoIndex + 1 == this.videoVOS.size()) {
                return;
            }
            this.exoPlayer.setPlayWhenReady(false);
            this.videoEndReason = VideoEndedReason.REASON_VIDEO_NEXT_CALLED;
            this.setCurrentVideoIndex(videoIndex);
            this.bridPlayer.reinitializePoster(this.videoVOS, this.getCurrentVideoIndex());
            this.bridPlayer.reinitializePlayReplayButton();
            BridPlayerImpl $this$playVideoWithIndex_u24lambda_u243 = this.bridPlayer;
            boolean bl = false;
            ControllsUiStatesManager controllsUiStatesManager = this.controllerUiStatesManager;
            if (controllsUiStatesManager != null) {
                controllsUiStatesManager.updateUI();
            }
            $this$playVideoWithIndex_u24lambda_u243.setRenditionText(this.provideRenditionDefaultField());
            this.createVideoLoader();
            VideoLoader videoLoader = this.videoLoader;
            if (videoLoader != null) {
                videoLoader.start();
            }
            AnalyticsSender analyticsSender = this.analyticsSender;
            if (analyticsSender == null) break block3;
            analyticsSender.sendAnalytics(new AnalyticData("n", null));
        }
    }

    @Override
    public void onPreviousVideoCalled() {
        block3: {
            String[] stringArray = new String[]{null};
            Utils.log(this.getClass(), "onPreviousVideoCalled", stringArray);
            this.bridPlayer.log(this.getClass().getSimpleName() + " onPreviousVideoCalled");
            this.exoPlayer.setPlayWhenReady(false);
            this.videoEndReason = VideoEndedReason.REASON_VIDEO_PREVIOUS_CALLED;
            if (this.getCurrentVideoIndex() == 0) {
                throw new BridPlayerException(1, "Illegal state - how did this happen");
            }
            int n = this.getCurrentVideoIndex();
            this.setCurrentVideoIndex(n + -1);
            this.bridPlayer.reinitializePoster(this.videoVOS, this.getCurrentVideoIndex());
            this.bridPlayer.reinitializePlayReplayButton();
            BridPlayerImpl $this$onPreviousVideoCalled_u24lambda_u244 = this.bridPlayer;
            boolean bl = false;
            ControllsUiStatesManager controllsUiStatesManager = this.controllerUiStatesManager;
            if (controllsUiStatesManager != null) {
                controllsUiStatesManager.updateUI();
            }
            $this$onPreviousVideoCalled_u24lambda_u244.setRenditionText(this.provideRenditionDefaultField());
            this.createVideoLoader();
            VideoLoader videoLoader = this.videoLoader;
            if (videoLoader != null) {
                videoLoader.start();
            }
            AnalyticsSender analyticsSender = this.analyticsSender;
            if (analyticsSender == null) break block3;
            analyticsSender.sendAnalytics(new AnalyticData("p", null));
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void onAdsCompleted(int adType, @Nullable Boolean isError) {
        Utils.log(this.getClass(), "onAdsCompleted-FromEngine", new String[0]);
        switch (adType) {
            case 0: {
                this.bridPlayer.play();
                BridPlayerImpl $this$onAdsCompleted_u24lambda_u245 = this.bridPlayer;
                boolean bl = false;
                $this$onAdsCompleted_u24lambda_u245.setStartButtonVisibility(false);
                $this$onAdsCompleted_u24lambda_u245.setPlayButtonVisiblity(true);
                ControllsUiStatesManager controllsUiStatesManager = this.controllerUiStatesManager;
                if (controllsUiStatesManager != null) {
                    controllsUiStatesManager.updateUI();
                }
            }
            this.analyticsSender.sendAnalytics(new AnalyticData("s", null, 2, null));
            return;
            case 1: {
                String[] stringArray = new String[]{"TYPE_MIDROLL"};
                Utils.log(this.getClass(), "onAdsCompleted", stringArray);
                this.bridPlayer.getNativePlayer().setPlayWhenReady(!this.bridPlayer.getNativePlayer().getPlayWhenReady());
                Object object = this.adSchedule;
                if (!StringsKt.equals$default((String)(object != null && (object = ((AdSchedule)object).getData()) != null && (object = ((Data)object).getMidrollData()) != null ? ((MidrollData)object).getAdTimeType() : null), (String)"i", (boolean)false, (int)2, null)) return;
                if (!this.isLiveStreamVideo()) return;
                stringArray = new String[]{"Schedule interval for HLS"};
                Utils.log(this.getClass(), "onAdsCompleted", stringArray);
                Object object2 = this.adSchedule;
                Integer n = object2 != null && (object2 = ((AdSchedule)object2).getData()) != null && (object2 = ((Data)object2).getMidrollData()) != null && (object2 = ((MidrollData)object2).getCuepoints()) != null ? Integer.valueOf(Integer.parseInt((String)object2)) : null;
                Intrinsics.checkNotNull(n);
                int n2 = n;
                List list = this.adSchedule.getMidrolls();
                if (list == null) {
                    list = CollectionsKt.emptyList();
                }
                HlsAds hlsAds = this.hlsAds = new HlsAds(n2, this.adProvider, list);
                if (hlsAds == null) return;
                hlsAds.start();
                return;
            }
            case 2: {
                String playlistPlayback = this.playerVO.getPlaylistPlayback();
                Object $this$onAdsCompleted_u24lambda_u245 = new String[]{playlistPlayback};
                Utils.log(this.getClass(), "onAdsCompleted", (String[])$this$onAdsCompleted_u24lambda_u245);
                $this$onAdsCompleted_u24lambda_u245 = playlistPlayback;
                if ($this$onAdsCompleted_u24lambda_u245 != null) {
                    int n = -1;
                    switch (((String)$this$onAdsCompleted_u24lambda_u245).hashCode()) {
                        case -902265784: {
                            if (!((String)$this$onAdsCompleted_u24lambda_u245).equals("single")) break;
                            n = 1;
                            break;
                        }
                        case 3540994: {
                            if (!((String)$this$onAdsCompleted_u24lambda_u245).equals("stop")) break;
                            n = 2;
                            break;
                        }
                        case 379114255: {
                            if (!((String)$this$onAdsCompleted_u24lambda_u245).equals("continuous")) break;
                            n = 3;
                            break;
                        }
                    }
                    switch (n) {
                        case 2: {
                            this.playlistPlaybackEndStrategy = new StopPlaylistEndStrategy(this.sdkContainer, this.videoVOS.get(this.getCurrentVideoIndex()), this.playerVO, this.bridPlayer, this);
                            break;
                        }
                        case 3: {
                            this.playlistPlaybackEndStrategy = new ContinuePlaylistEndStrategy(this.sdkContainer, this.videoVOS.get(this.getCurrentVideoIndex()), this.playerVO, this.bridPlayer, this, this.isLastVideo());
                            break;
                        }
                        case 1: {
                            this.playlistPlaybackEndStrategy = new StopPlaylistEndStrategy(this.sdkContainer, this.videoVOS.get(this.getCurrentVideoIndex()), this.playerVO, this.bridPlayer, this);
                            break;
                        }
                    }
                }
                PlaylistEndStrategy playlistEndStrategy = this.playlistPlaybackEndStrategy;
                if (playlistEndStrategy == null) return;
                playlistEndStrategy.onPlaylistEnded();
                return;
            }
            case -1: {
                if (this.getCurrentVideoIndex() != this.videoVOS.size() - 1) return;
                if (this.videoEndReason == null) return;
                BridPlayerImpl $this$onAdsCompleted_u24lambda_u246 = this.bridPlayer;
                boolean bl = false;
                $this$onAdsCompleted_u24lambda_u246.setPlayButtonVisiblity(false);
                $this$onAdsCompleted_u24lambda_u246.setStartButtonVisibility(false);
                $this$onAdsCompleted_u24lambda_u246.setNextButtonVisibility(false);
                $this$onAdsCompleted_u24lambda_u246.setPreviousButtonVisibility(false);
                $this$onAdsCompleted_u24lambda_u246.setControllerVisibility(false);
                $this$onAdsCompleted_u24lambda_u246.setTimelineVisibility(false);
                this.exoPlayer.setPlayWhenReady(false);
                this.bridPlayer.setShareOptionsVisibility(true);
                return;
            }
        }
    }

    @Override
    public void playCurrentVideo() {
        BridPlayerImpl $this$playCurrentVideo_u24lambda_u247 = this.bridPlayer;
        boolean bl = false;
        $this$playCurrentVideo_u24lambda_u247.setPlayButtonVisiblity(true);
        $this$playCurrentVideo_u24lambda_u247.setStartButtonVisibility(false);
        ControllsUiStatesManager controllsUiStatesManager = this.controllerUiStatesManager;
        if (controllsUiStatesManager != null) {
            controllsUiStatesManager.updateUI();
        }
        if (this.exoPlayer.getCurrentManifest() != null && this.exoPlayer.getCurrentManifest() instanceof HlsManifest) {
            this.bridPlayer.setRenditionText("Auto");
        } else {
            this.bridPlayer.setRenditionText(this.provideRenditionDefaultField());
        }
        String[] stringArray = new String[]{null};
        Utils.log(this.getClass(), "playCurrentVideo", stringArray);
        this.prerollChecked = true;
        this.bridPlayer.play();
        this.analyticsSender.sendAnalytics(new AnalyticData("s", null, 2, null));
        this.bridPlayer.log(this.getClass().getSimpleName() + " playCurrentVideo");
        String string2 = this.videoVOS.get(this.getCurrentVideoIndex()).getDuration();
        AnalyticSenderScheduler analyticSenderScheduler = new AnalyticSenderScheduler(this.exoPlayer, string2 != null ? Long.parseLong(string2) : 0L, new SendAnalyticReceiver(this.analyticsSender));
        if (this.isLastVideo()) {
            // empty if block
        }
    }

    @Override
    public void playAds() {
        Utils.log(this.getClass(), "PlayAds-FromEngine", new String[0]);
        this.prepareAds();
    }

    @Override
    public void renditionChangeCalled() {
        if (this.exoPlayer.getCurrentManifest() != null && this.exoPlayer.getCurrentManifest() instanceof HlsManifest) {
            Map renditions = new LinkedHashMap();
            Object object = this.exoPlayer.getCurrentManifest();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type androidx.media3.exoplayer.hls.HlsManifest");
            HlsManifest manifest = (HlsManifest)object;
            DefaultTrackNameProvider defaultTrackNameProvider = new DefaultTrackNameProvider(this.bridPlayer.getPlayerView(true).getResources());
            renditions.put("Auto", "");
            List list = manifest.multivariantPlaylist.variants;
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"manifest.multivariantPlaylist.variants");
            Iterable $this$sortedBy$iv = list;
            boolean $i$f$sortedBy = false;
            for (HlsMultivariantPlaylist.Variant variant : CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    HlsMultivariantPlaylist.Variant it = (HlsMultivariantPlaylist.Variant)a;
                    boolean bl = false;
                    it = (HlsMultivariantPlaylist.Variant)b;
                    Comparable comparable = Integer.valueOf(it.format.height);
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)Integer.valueOf(it.format.height));
                }
            })) {
                String string2;
                Map map = renditions;
                String string3 = variant.format.height + "p";
                Intrinsics.checkNotNullExpressionValue((Object)defaultTrackNameProvider.getTrackName(variant.format), (String)"defaultTrackNameProvider\u2026TrackName(variant.format)");
                map.put(string3, string2);
            }
            this.bridPlayer.showRenditionOptions(renditions, "");
        } else {
            this.bridPlayer.showRenditionOptions(this.renditionProvider.provideRenditionsList(), "");
        }
    }

    @Override
    @NotNull
    public Map<String, String> returnRenditionMap() {
        Map map;
        Map renditions = new LinkedHashMap();
        Object currentManifest = this.exoPlayer.getCurrentManifest();
        if (currentManifest instanceof HlsManifest) {
            DefaultTrackNameProvider defaultTrackNameProvider = new DefaultTrackNameProvider(this.bridPlayer.getPlayerView(true).getResources());
            renditions.put("Auto", "");
            List list = ((HlsManifest)currentManifest).multivariantPlaylist.variants;
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"currentManifest.multivariantPlaylist.variants");
            Iterable $this$sortedBy$iv = list;
            boolean $i$f$sortedBy = false;
            for (HlsMultivariantPlaylist.Variant variant : CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    HlsMultivariantPlaylist.Variant it = (HlsMultivariantPlaylist.Variant)a;
                    boolean bl = false;
                    it = (HlsMultivariantPlaylist.Variant)b;
                    Comparable comparable = Integer.valueOf(it.format.height);
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)Integer.valueOf(it.format.height));
                }
            })) {
                String trackName;
                Intrinsics.checkNotNullExpressionValue((Object)defaultTrackNameProvider.getTrackName(variant.format), (String)"defaultTrackNameProvider\u2026TrackName(variant.format)");
                renditions.put(variant.format.height + "p", trackName);
            }
            map = renditions;
        } else {
            map = this.renditionProvider.provideRenditionsList();
        }
        return map;
    }

    @Override
    @NotNull
    public String provideRenditionUrlForSelectedRendition(@NotNull String rendition) {
        Intrinsics.checkNotNullParameter((Object)rendition, (String)"rendition");
        String string2 = this.videoVOS.get(this.getCurrentVideoIndex()).getDefaultVideoUrl(rendition);
        Intrinsics.checkNotNull((Object)string2);
        String res = string2;
        String[] stringArray = new String[]{res};
        Utils.log(this.getClass(), "provideRenditionUrlForSelectedRendition", stringArray);
        return res;
    }

    private final String provideRenditionDefaultField() {
        return this.renditionProvider.provideDefaultRenditionTag();
    }

    private final boolean isHlsVideo() {
        return this.exoPlayer.getCurrentManifest() != null && this.exoPlayer.getCurrentManifest() instanceof HlsManifest;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isLiveStreamVideo() {
        if (!this.isHlsVideo()) return false;
        Object object = this.exoPlayer.getCurrentManifest();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type androidx.media3.exoplayer.hls.HlsManifest");
        if (((HlsManifest)object).mediaPlaylist.hasEndTag) return false;
        return true;
    }

    @Override
    public void changeRendition(@NotNull String option, long currentPosition) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        this.bridPlayer.showBigLoading();
        String string2 = option.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
        if (string2.equals("AUTO")) {
            Object object2 = this.exoPlayer.getCurrentManifest();
            if (object2 != null) {
                Object t;
                Object it = object2;
                boolean bl = false;
                List list = ((HlsManifest)it).multivariantPlaylist.variants;
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"it as HlsManifest).multivariantPlaylist.variants");
                Iterable $this$maxBy$iv = list;
                boolean $i$f$maxByOrThrow = false;
                Iterator iterator$iv = $this$maxBy$iv.iterator();
                if (!iterator$iv.hasNext()) {
                    throw new NoSuchElementException();
                }
                Object maxElem$iv = iterator$iv.next();
                if (!iterator$iv.hasNext()) {
                    t = maxElem$iv;
                } else {
                    HlsMultivariantPlaylist.Variant it2 = (HlsMultivariantPlaylist.Variant)maxElem$iv;
                    boolean bl2 = false;
                    int maxValue$iv = it2.format.height;
                    do {
                        Object e$iv = iterator$iv.next();
                        HlsMultivariantPlaylist.Variant it3 = (HlsMultivariantPlaylist.Variant)e$iv;
                        $i$a$-maxByOrThrow-BridPlayerEngineNew$changeRendition$height$1$1 = false;
                        int v$iv = it3.format.height;
                        if (maxValue$iv >= v$iv) continue;
                        maxElem$iv = e$iv;
                        maxValue$iv = v$iv;
                    } while (iterator$iv.hasNext());
                    t = maxElem$iv;
                }
                object = ((HlsMultivariantPlaylist.Variant)t).format.height;
            } else {
                boolean bl = false;
                object = "";
            }
        } else {
            String[] stringArray = new String[]{"p"};
            object = StringsKt.toIntOrNull((String)((String)StringsKt.split$default((CharSequence)option, (String[])stringArray, (boolean)false, (int)0, (int)6, null).get(0)));
        }
        String height = object;
        this.videoEndReason = VideoEndedReason.REASON_RENDITION_CHANGED;
        this.bridPlayer.setRenditionText(ResolutionView.getRenditionOptionToNameSelected(option));
        this.currentRendition = option;
        if (this.isLiveStreamVideo()) {
            Object object3 = this.exoPlayer.getCurrentManifest();
            Intrinsics.checkNotNull((Object)object3, (String)"null cannot be cast to non-null type androidx.media3.exoplayer.hls.HlsManifest");
            manifest = (HlsManifest)object3;
            int n = manifest.multivariantPlaylist.variants.size();
            for (int i = 0; i < n; ++i) {
                Object e = manifest.multivariantPlaylist.variants.get(i);
                Intrinsics.checkNotNullExpressionValue(e, (String)"manifest.multivariantPlaylist.variants[i]");
                HlsMultivariantPlaylist.Variant variant = (HlsMultivariantPlaylist.Variant)e;
                String string3 = height;
                if (!(string3 instanceof Integer) || variant.format.height != ((Number)((Object)string3)).intValue()) continue;
                Format format = variant.format;
                Intrinsics.checkNotNullExpressionValue((Object)format, (String)"variant.format");
                Format format2 = format;
                this.bridPlayer.playTrack(this.getCurrentVideoIndex(), format2.width, format2.height, format2.width, format2.height);
                return;
            }
        } else {
            manifest = new HlsManifest[]{option, String.valueOf(currentPosition)};
            Utils.log(this.getClass(), "changeRendition", (String[])manifest);
            try {
                this.bridPlayer.setSuppressSeekDiscontinuity(2);
                int n = this.getCurrentVideoIndex();
                String string4 = ResolutionView.getRenditionOptionToNameSelected(option);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getRenditionOptionToName\u2026                        )");
                this.bridPlayer.prepareVideo(this.videoVOS.get(this.getCurrentVideoIndex()), n, this.provideRenditionUrlForSelectedRendition(string4));
            }
            catch (Exception e) {
                this.bridPlayer.hideBigLoading();
                System.out.println((Object)("xxxxxx AOAHOOFAHAOHAOHAO " + e.getMessage()));
            }
        }
        this.bridPlayer.seekToPosition(currentPosition);
    }

    @Override
    @NotNull
    public String currentRendition() {
        return Intrinsics.areEqual((Object)this.currentRendition, (Object)"") ? (this.exoPlayer.getCurrentManifest() != null && this.exoPlayer.getCurrentManifest() instanceof HlsManifest ? "Auto" : this.videoVOS.get(this.getCurrentVideoIndex()).getDefaultRendition()) : this.currentRendition;
    }

    @Override
    public void onFirstFrameRendered() {
        String[] stringArray = new String[]{this.currentRendition};
        Utils.log(this.getClass(), "onFirstFrameRendered", stringArray);
        this.isFirstPlay = true;
        if (!this.midrollsScheduled && Intrinsics.areEqual((Object)this.videoVOS.get(this.getCurrentVideoIndex()).getMonetize(), (Object)true)) {
            Utils.log(this.getClass(), "midrollsScheduled", new String[0]);
            this.midrollsScheduled = true;
            this.scheduleMidrolls();
        }
        this.bridPlayer.setRenditionText(this.currentRendition());
        this.videoEndReason = null;
    }

    @Override
    @RequiresApi(value=23)
    public void onNetworkConnectionLost() {
        this.bridPlayer.hideControlsOnNetworkError();
        if (this.bridPlayer.isPlayingAd()) {
            this.bridPlayer.releaseAdPlayer();
            this.bridPlayer.getNativePlayerControler().setUseController(true);
        }
    }

    @Override
    public void onNetworkConnectionSuccess() {
        System.out.println((Object)("hhhhhhh onNetworkConnectionSuccess " + this.bridPlayer.isPlayingAd()));
        this.bridPlayer.dismissNetworkErrorView();
        this.bridPlayer.showControlsOnNetworkError();
        this.positionInterrupted = this.bridPlayer.getCurrentPosition();
        if (this.bridPlayer.isPlayingAd()) {
            this.bridPlayer.releaseAdPlayer();
            this.bridPlayer.hideOverlayForAd();
        }
        if (this.isLiveStreamVideo()) {
            this.bridPlayer.restartStream();
        } else if (this.bridPlayer.getNativePlayer() != null) {
            this.bridPlayer.getNativePlayer().prepare();
            this.bridPlayer.getNativePlayer().seekTo(this.positionInterrupted);
            this.bridPlayer.getNativePlayer().setPlayWhenReady(this.bridPlayer.getNativePlayer().getPlayWhenReady());
            this.bridPlayer.getNativePlayerControler().setUseController(true);
        }
    }

    private final boolean isLastVideo() {
        return this.getCurrentVideoIndex() == this.videoVOS.size() - 1;
    }

    private final void prepareAds() {
        Utils.log(this.getClass(), "prepareAds", new String[0]);
        String string2 = this.videoVOS.get(this.getCurrentVideoIndex()).getDuration();
        AnalyticSenderScheduler analyticSenderScheduler = new AnalyticSenderScheduler(this.exoPlayer, string2 != null ? Long.parseLong(string2) : 0L, new SendAnalyticReceiver(this.analyticsSender));
        ControllsUiStatesManager controllsUiStatesManager = this.controllerUiStatesManager;
        if (controllsUiStatesManager != null) {
            controllsUiStatesManager.updateUI();
        }
        if (!this.prerollChecked) {
            this.prerollChecked = true;
            Object object = this.adSchedule;
            if (object == null || (object = ((AdSchedule)object).getPrerolls()) == null) {
                object = CollectionsKt.emptyList();
            }
            this.adProvider.checkPrerollAds((List)object);
        } else if (Intrinsics.areEqual((Object)this.playerVO.getAutoplay_on_ad(), (Object)true)) {
            this.bridPlayer.play();
        }
    }

    public final void scheduleMidrolls() {
        block4: {
            Object object;
            block3: {
                Object object2;
                if (this.isLiveStreamVideo()) break block3;
                Object object3 = this.videoVOS.get(this.getCurrentVideoIndex()).getDuration();
                long l = object3 != null ? Long.parseLong((String)object3) : 0L;
                object3 = this.adSchedule;
                Object object4 = object3 != null && (object2 = ((AdSchedule)object3).getMidrolls()) != null ? object2 : CollectionsKt.emptyList();
                object3 = this.adSchedule;
                AdScheduler adScheduler = this.adScheduler = new AdScheduler(this.adProvider, l, this.exoPlayer, (List<? extends Object>)object4, object3 != null && (object2 = ((AdSchedule)object3).getData()) != null ? ((Data)object2).getMidrollData() : null);
                Intrinsics.checkNotNull((Object)adScheduler);
                adScheduler.go();
                break block4;
            }
            Object object5 = this.adSchedule;
            if (!StringsKt.equals$default((String)(object5 != null && (object5 = ((AdSchedule)object5).getData()) != null && (object5 = ((Data)object5).getMidrollData()) != null ? ((MidrollData)object5).getAdTimeType() : null), (String)"i", (boolean)false, (int)2, null) && !StringsKt.equals$default((String)((object = this.adSchedule) != null && (object = ((AdSchedule)object).getData()) != null && (object = ((Data)object).getMidrollData()) != null ? ((MidrollData)object).getAdTimeType() : null), (String)"s", (boolean)false, (int)2, null)) break block4;
            Object object6 = this.adSchedule;
            Integer n = object6 != null && (object6 = ((AdSchedule)object6).getData()) != null && (object6 = ((Data)object6).getMidrollData()) != null && (object6 = ((MidrollData)object6).getCuepoints()) != null ? Integer.valueOf(Integer.parseInt((String)object6)) : null;
            Intrinsics.checkNotNull(n);
            int n2 = n;
            List list = this.adSchedule.getMidrolls();
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
            this.hlsAds = new HlsAds(n2, this.adProvider, list);
            if (this.isFirstPlay) {
                HlsAds hlsAds = this.hlsAds;
                if (hlsAds != null) {
                    hlsAds.start();
                }
            }
        }
    }

    @Override
    public boolean isFirstTimePlaying() {
        return this.isFirstPlay;
    }

    @Override
    public void createVideoLoaderAfterVerification() {
        this.createVideoLoader();
    }

    public static final /* synthetic */ RenditionProvider access$getRenditionProvider$p(BridPlayerEngineNew $this) {
        return $this.renditionProvider;
    }

    public static final /* synthetic */ ArrayList access$getVideoVOS$p(BridPlayerEngineNew $this) {
        return $this.videoVOS;
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(BridPlayerEngineNew.class, "currentVideoIndex", "getCurrentVideoIndex()I", 0)))};
        $$delegatedProperties = kPropertyArray;
    }
}

