/*
 * Decompiled with CFR 0.152.
 */
package tv.brid.sdk.brid_network.network;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.net.NetworkRequest;
import android.os.Build;
import androidx.annotation.MainThread;
import androidx.annotation.RequiresApi;
import androidx.lifecycle.LiveData;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.SupervisorKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tv.brid.sdk.brid_network.network.NetworkConnection;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000G\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t*\u0001\u0007\b\u0007\u0018\u0000 \u001e2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001eB\u000f\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0015\u001a\u00020\u0016H\u0002J\b\u0010\u0017\u001a\u00020\u0002H\u0002J\b\u0010\u0018\u001a\u00020\u0016H\u0014J\b\u0010\u0019\u001a\u00020\u0016H\u0014J\b\u0010\u001a\u001a\u00020\u0016H\u0002J\u0012\u0010\u001b\u001a\u00020\u00162\b\b\u0002\u0010\u001c\u001a\u00020\u0002H\u0003J\b\u0010\u001d\u001a\u00020\u0016H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\n\u0002\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u000f\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\u001f"}, d2={"Ltv/brid/sdk/brid_network/network/NetworkConnection;", "Landroidx/lifecycle/LiveData;", "", "appContext", "Landroid/content/Context;", "(Landroid/content/Context;)V", "callback", "tv/brid/sdk/brid_network/network/NetworkConnection$callback$1", "Ltv/brid/sdk/brid_network/network/NetworkConnection$callback$1;", "cm", "Landroid/net/ConnectivityManager;", "debounceWindow", "Lkotlin/time/Duration;", "J", "lastEmitted", "Ljava/util/concurrent/atomic/AtomicBoolean;", "pendingJob", "Lkotlinx/coroutines/Job;", "registered", "scope", "Lkotlinx/coroutines/CoroutineScope;", "cancelPending", "", "isActiveNetworkValidated", "onActive", "onInactive", "register", "scheduleReevaluate", "immediateIfOnline", "unregister", "Companion", "bridsdk_release"})
@RequiresApi(value=23)
public final class NetworkConnection
extends LiveData<Boolean> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context appContext;
    private final long debounceWindow;
    @NotNull
    private final ConnectivityManager cm;
    @NotNull
    private final CoroutineScope scope;
    @Nullable
    private Job pendingJob;
    @NotNull
    private final AtomicBoolean lastEmitted;
    private boolean registered;
    @NotNull
    private final callback.1 callback;
    @Nullable
    private static volatile NetworkConnection INSTANCE;

    private NetworkConnection(Context appContext) {
        this.appContext = appContext;
        this.debounceWindow = DurationKt.toDuration((int)400, (DurationUnit)DurationUnit.MILLISECONDS);
        Object object = this.appContext.getSystemService("connectivity");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.net.ConnectivityManager");
        this.cm = (ConnectivityManager)object;
        this.scope = CoroutineScopeKt.CoroutineScope((CoroutineContext)SupervisorKt.SupervisorJob$default(null, (int)1, null).plus((CoroutineContext)Dispatchers.getDefault()));
        this.lastEmitted = new AtomicBoolean(false);
        this.callback = new ConnectivityManager.NetworkCallback(this){
            final /* synthetic */ NetworkConnection this$0;
            {
                this.this$0 = $receiver;
            }

            public void onAvailable(@NotNull Network network) {
                Intrinsics.checkNotNullParameter((Object)network, (String)"network");
                NetworkConnection.scheduleReevaluate$default(this.this$0, false, 1, null);
            }

            public void onLost(@NotNull Network network) {
                Intrinsics.checkNotNullParameter((Object)network, (String)"network");
                NetworkConnection.scheduleReevaluate$default(this.this$0, false, 1, null);
            }

            public void onCapabilitiesChanged(@NotNull Network network, @NotNull NetworkCapabilities caps) {
                Intrinsics.checkNotNullParameter((Object)network, (String)"network");
                Intrinsics.checkNotNullParameter((Object)caps, (String)"caps");
                if (Intrinsics.areEqual((Object)network, (Object)NetworkConnection.access$getCm$p(this.this$0).getActiveNetwork())) {
                    NetworkConnection.scheduleReevaluate$default(this.this$0, false, 1, null);
                }
            }
        };
        this.setValue(false);
    }

    protected void onActive() {
        super.onActive();
        this.register();
        this.scheduleReevaluate(true);
    }

    protected void onInactive() {
        super.onInactive();
        this.unregister();
        this.cancelPending();
    }

    private final void register() {
        if (this.registered) {
            return;
        }
        if (Build.VERSION.SDK_INT >= 24) {
            this.cm.registerDefaultNetworkCallback((ConnectivityManager.NetworkCallback)this.callback);
        } else {
            NetworkRequest req = new NetworkRequest.Builder().addCapability(12).build();
            this.cm.registerNetworkCallback(req, (ConnectivityManager.NetworkCallback)this.callback);
        }
        this.registered = true;
    }

    private final void unregister() {
        if (!this.registered) {
            return;
        }
        try {
            this.cm.unregisterNetworkCallback((ConnectivityManager.NetworkCallback)this.callback);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.registered = false;
    }

    private final boolean isActiveNetworkValidated() {
        Network network = this.cm.getActiveNetwork();
        if (network == null) {
            return false;
        }
        Network active = network;
        NetworkCapabilities networkCapabilities = this.cm.getNetworkCapabilities(active);
        if (networkCapabilities == null) {
            return false;
        }
        NetworkCapabilities caps = networkCapabilities;
        boolean hasInternet = caps.hasCapability(12);
        boolean validated = caps.hasCapability(16);
        return hasInternet && validated;
    }

    @MainThread
    private final void scheduleReevaluate(boolean immediateIfOnline) {
        boolean candidate = this.isActiveNetworkValidated();
        Job job = this.pendingJob;
        if (job != null) {
            Job.DefaultImpls.cancel$default((Job)job, null, (int)1, null);
        }
        long delayMs = candidate && immediateIfOnline ? 0L : (candidate ? Duration.getInWholeMilliseconds-impl((long)this.debounceWindow) / (long)2 : Duration.getInWholeMilliseconds-impl((long)this.debounceWindow));
        this.pendingJob = BuildersKt.launch$default((CoroutineScope)this.scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(delayMs, this, candidate, null){
            int label;
            final /* synthetic */ long $delayMs;
            final /* synthetic */ NetworkConnection this$0;
            final /* synthetic */ boolean $candidate;
            {
                this.$delayMs = $delayMs;
                this.this$0 = $receiver;
                this.$candidate = $candidate;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        this.label = 1;
                        v0 = DelayKt.delay((long)this.$delayMs, (Continuation)((Continuation)this));
                        if (v0 == var2_2) {
                            return var2_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        if (NetworkConnection.access$getLastEmitted$p(this.this$0).getAndSet(this.$candidate) != this.$candidate) {
                            NetworkConnection.access$postValue(this.this$0, Boxing.boxBoolean((boolean)this.$candidate));
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    static /* synthetic */ void scheduleReevaluate$default(NetworkConnection networkConnection, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        networkConnection.scheduleReevaluate(bl);
    }

    private final void cancelPending() {
        Job job = this.pendingJob;
        if (job != null) {
            Job.DefaultImpls.cancel$default((Job)job, null, (int)1, null);
        }
        this.pendingJob = null;
    }

    @JvmStatic
    @NotNull
    public static final NetworkConnection getInstance(@NotNull Context context) {
        return Companion.getInstance(context);
    }

    public static final /* synthetic */ AtomicBoolean access$getLastEmitted$p(NetworkConnection $this) {
        return $this.lastEmitted;
    }

    public static final /* synthetic */ void access$postValue(NetworkConnection $this, Boolean p0) {
        $this.postValue(p0);
    }

    public /* synthetic */ NetworkConnection(Context appContext, DefaultConstructorMarker $constructor_marker) {
        this(appContext);
    }

    public static final /* synthetic */ ConnectivityManager access$getCm$p(NetworkConnection $this) {
        return $this.cm;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0007R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Ltv/brid/sdk/brid_network/network/NetworkConnection$Companion;", "", "()V", "INSTANCE", "Ltv/brid/sdk/brid_network/network/NetworkConnection;", "getInstance", "context", "Landroid/content/Context;", "bridsdk_release"})
    @SourceDebugExtension(value={"SMAP\nNetworkConnection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NetworkConnection.kt\ntv/brid/sdk/brid_network/network/NetworkConnection$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,149:1\n1#2:150\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JvmStatic
        @NotNull
        public final NetworkConnection getInstance(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Context app = context.getApplicationContext();
            NetworkConnection networkConnection = INSTANCE;
            if (networkConnection == null) {
                Companion companion = this;
                synchronized (companion) {
                    boolean bl = false;
                    NetworkConnection networkConnection2 = INSTANCE;
                    if (networkConnection2 == null) {
                        NetworkConnection networkConnection3;
                        Intrinsics.checkNotNullExpressionValue((Object)app, (String)"app");
                        NetworkConnection it = networkConnection3 = new NetworkConnection(app, null);
                        boolean bl2 = false;
                        INSTANCE = it;
                        networkConnection2 = networkConnection3;
                    }
                    NetworkConnection networkConnection4 = networkConnection2;
                    // MONITOREXIT @DISABLED, blocks:[0, 1, 4] lbl20 : MonitorExitStatement: MONITOREXIT : var3_3
                    networkConnection = networkConnection4;
                }
            }
            return networkConnection;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

